/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLValuesTableSource
extends SQLTableSourceImpl
implements SQLSelectQuery,
SQLReplaceable {
    private boolean bracket;
    private List<SQLListExpr> values = new ArrayList<SQLListExpr>();
    private List<SQLName> columns = new ArrayList<SQLName>();

    public List<SQLListExpr> getValues() {
        return this.values;
    }

    public void addValue(SQLListExpr row) {
        if (row != null) {
            row.setParent(this);
            this.values.add(row);
        }
    }

    public List<SQLName> getColumns() {
        return this.columns;
    }

    public void addColumn(SQLName column) {
        column.setParent(this);
        this.columns.add(column);
    }

    public void addColumn(String column) {
        this.addColumn(new SQLIdentifierExpr(column));
    }

    @Override
    public void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.values);
            this.acceptChild(visitor, this.columns);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean isBracket() {
        return this.bracket;
    }

    @Override
    public void setBracket(boolean bracket) {
        this.bracket = bracket;
    }

    @Override
    public SQLValuesTableSource clone() {
        SQLObject e2;
        SQLValuesTableSource x = new SQLValuesTableSource();
        x.setAlias(this.alias);
        for (SQLListExpr sQLListExpr : this.values) {
            e2 = sQLListExpr.clone();
            ((SQLObjectImpl)e2).setParent(x);
            x.getValues().add((SQLListExpr)e2);
        }
        for (SQLName sQLName : this.columns) {
            e2 = sQLName.clone();
            e2.setParent(x);
            x.getColumns().add((SQLName)e2);
        }
        if (this.flashback != null) {
            x.setFlashback(this.flashback.clone());
        }
        if (this.hints != null) {
            for (SQLHint sQLHint : this.hints) {
                e2 = sQLHint.clone();
                e2.setParent(x);
                x.getHints().add((SQLHint)e2);
            }
        }
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        int i;
        for (i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i) != expr) continue;
            target.setParent(this);
            this.values.set(i, (SQLListExpr)expr);
            return true;
        }
        for (i = 0; i < this.columns.size(); ++i) {
            if (this.columns.get(i) != expr) continue;
            target.setParent(this);
            this.columns.set(i, (SQLName)expr);
            return true;
        }
        return false;
    }
}

