/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.es.test;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.es.ast.EsLexer;
import com.alibaba.druid.sql.dialect.es.ast.EsParser;
import com.alibaba.druid.sql.dialect.es.visitor.ESOutputVisitor;
import com.alibaba.druid.sql.dialect.es.visitor.Printer;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import util.JdbcUtil;
import util.sqlparse.visitor.es.visitor.ElasticSchemaVisitor;

public class ParseTest {
    public static void main(String[] args) {
        ParseTest.test1();
    }

    static void test2() {
        String content = "{\n      \"ip_port\": \"192.168.2.229:9200\",\n      \"url\": \"http://192.168.2.229:9200\",\n      \"username\": \"test1\",\n      \"password\": \"123456\",\n      \"dbType\": \"es\",\n      \"excludeSchema\": []\n    }";
        JdbcUtil.initData(content);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String query = "GET /emp/_search\n{}\n";
        String dbType = "es";
        List<SQLStatement> statements = SQLUtils.parseStatements(query, "es");
        SQLStatement st = statements.get(0);
        SchemaStatVisitor visitor = SQLUtils.createSchemaStatVisitor(DbType.of(dbType));
        ElasticSchemaVisitor esVisitor = (ElasticSchemaVisitor)visitor;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sql", query);
        params.put("url", "http://192.168.2.229:9200");
        params.put("dbType", "es");
        esVisitor.setParams(params);
        st.accept(visitor);
        Map<TableStat.Name, TableStat> tables = visitor.getTables();
        Collection<TableStat.Column> columns = visitor.getColumns();
        System.out.println("over");
    }

    static void test1() {
        String query = "GET /_search\n{\n  \"query\": {\n    \"span_near\": {\n      \"clauses\": [\n        { \"span_term\": { \"field\": \"value1\" } },\n        { \"span_term\": { \"field\": \"value2\" } },\n        { \"span_term\": { \"field\": \"value3\" } }\n      ],\n      \"slop\": 12,\n      \"in_order\": false\n    }\n  }\n}\n";
        ANTLRInputStream stream = new ANTLRInputStream(query);
        EsLexer lexer = new EsLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        EsParser parser = new EsParser((TokenStream)tokenStream);
        EsParser.StatementContext context = parser.statement();
        ESOutputVisitor visitor = new ESOutputVisitor();
        Printer printer = visitor.visit((ParseTree)context);
        System.out.println(printer);
    }
}

