/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.gauss.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class GaussLexer
extends Lexer {
    public static final Keywords DEFAULT_GP_KEYWORDS;

    public GaussLexer(String input, SQLParserFeature ... features) {
        super(input, true);
        this.keepComments = true;
        this.keywords = DEFAULT_GP_KEYWORDS;
        this.dbType = DbType.gauss;
        for (SQLParserFeature feature : features) {
            this.config(feature, true);
        }
    }

    @Override
    protected void scanString() {
        this.mark = this.pos;
        boolean hasSpecial = false;
        while (!this.isEOF()) {
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\\');
                switch (this.ch) {
                    case '\u0000': {
                        this.putChar('\u0000');
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        break;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        break;
                    }
                    case 'b': {
                        this.putChar('b');
                        break;
                    }
                    case 'n': {
                        this.putChar('n');
                        break;
                    }
                    case 'r': {
                        this.putChar('r');
                        break;
                    }
                    case 't': {
                        this.putChar('t');
                        break;
                    }
                    default: {
                        this.putChar(this.ch);
                    }
                }
                this.scanChar();
            }
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') {
                    this.token = Token.LITERAL_CHARS;
                    this.stringVal = !hasSpecial ? this.subString(this.mark + 1, this.bufPos) : new String(this.buf, 0, this.bufPos);
                    return;
                }
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.lexError("unclosed.str.lit", new Object[0]);
    }

    @Override
    public void scanSharp() {
        this.scanChar();
        if (this.ch == '>') {
            this.scanChar();
            if (this.ch == '>') {
                this.scanChar();
                this.token = Token.POUNDGTGT;
            } else {
                this.token = Token.POUNDGT;
            }
        } else {
            this.token = Token.POUND;
        }
    }

    @Override
    protected void scanVariable_at() {
        if (this.ch != '@') {
            throw new ParserException("illegal variable. " + this.info());
        }
        this.mark = this.pos;
        this.bufPos = 1;
        char c1 = this.charAt(this.pos + 1);
        if (c1 == '@') {
            this.pos += 2;
            this.token = Token.MONKEYS_AT_AT;
            this.ch = this.charAt(++this.pos);
        } else if (c1 == '>') {
            this.pos += 2;
            this.token = Token.MONKEYS_AT_GT;
            this.ch = this.charAt(++this.pos);
        } else {
            while (true) {
                char ch;
                if (!CharTypes.isIdentifierChar(ch = this.charAt(++this.pos))) {
                    this.ch = this.charAt(this.pos);
                    this.stringVal = this.addSymbol();
                    this.token = Token.VARIANT;
                    return;
                }
                ++this.bufPos;
            }
        }
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("BEGIN", Token.BEGIN);
        map.put("CASCADE", Token.CASCADE);
        map.put("CONTINUE", Token.CONTINUE);
        map.put("CURRENT", Token.CURRENT);
        map.put("FETCH", Token.FETCH);
        map.put("FIRST", Token.FIRST);
        map.put("IDENTITY", Token.IDENTITY);
        map.put("LIMIT", Token.LIMIT);
        map.put("NEXT", Token.NEXT);
        map.put("NOWAIT", Token.NOWAIT);
        map.put("OF", Token.OF);
        map.put("OFFSET", Token.OFFSET);
        map.put("ONLY", Token.ONLY);
        map.put("RECURSIVE", Token.RECURSIVE);
        map.put("RESTART", Token.RESTART);
        map.put("RESTRICT", Token.RESTRICT);
        map.put("RETURNING", Token.RETURNING);
        map.put("ROW", Token.ROW);
        map.put("ROWS", Token.ROWS);
        map.put("SHARE", Token.SHARE);
        map.put("SHOW", Token.SHOW);
        map.put("START", Token.START);
        map.put("USING", Token.USING);
        map.put("WINDOW", Token.WINDOW);
        map.put("TRUE", Token.TRUE);
        map.put("FALSE", Token.FALSE);
        map.put("ARRAY", Token.ARRAY);
        map.put("IF", Token.IF);
        map.put("TYPE", Token.TYPE);
        map.put("ILIKE", Token.ILIKE);
        map.put("MERGE", Token.MERGE);
        map.put("MATCHED", Token.MATCHED);
        map.put("PARTITION", Token.PARTITION);
        map.put("RESET", Token.RESET);
        map.put("BY", Token.BY);
        map.put("CACHE", Token.CACHE);
        map.put("TEMPORARY", Token.TEMPORARY);
        map.put("TEMP", Token.TEMP);
        map.put("UNLOGGED", Token.UNLOGGED);
        map.put("CONSTRAINT", Token.CONSTRAINT);
        map.put("PURGE", Token.PURGE);
        map.put("SESSION", Token.SESSION);
        map.put("VACUUM", Token.VACUUM);
        map.put("DOMAIN", Token.DOMAIN);
        map.put("COMMIT", Token.COMMIT);
        map.put("ROLE", Token.ROLE);
        map.put("EXECUTE", Token.EXECUTE);
        map.put("PROCEDURE", Token.PROCEDURE);
        DEFAULT_GP_KEYWORDS = new Keywords(map);
    }
}

