/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLSubPartitionBy;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.dialect.mariadb.ast.MariadbObject;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MariadbSubPartitionByValue
extends SQLSubPartitionBy
implements MariadbObject {
    private List<SQLExpr> columns = new ArrayList<SQLExpr>();

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (!(visitor instanceof MariadbASTVisitor)) {
            throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
        }
        this.accept0((MariadbASTVisitor)visitor);
    }

    @Override
    public void accept0(MariadbASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.columns);
            this.acceptChild((SQLASTVisitor)visitor, this.subPartitionsCount);
        }
        visitor.endVisit(this);
    }

    public List<SQLExpr> getColumns() {
        return this.columns;
    }

    public void addColumn(SQLExpr column) {
        if (column != null) {
            column.setParent(this);
        }
        this.columns.add(column);
    }

    public void cloneTo(MariadbSubPartitionByValue x) {
        super.cloneTo(x);
        for (SQLExpr column : this.columns) {
            SQLExpr c2 = column.clone();
            c2.setParent(x);
            x.columns.add(c2);
        }
    }

    @Override
    public MariadbSubPartitionByValue clone() {
        MariadbSubPartitionByValue x = new MariadbSubPartitionByValue();
        this.cloneTo(x);
        return x;
    }

    @Override
    public boolean isPartitionByColumn(long columnNameHashCode64) {
        for (SQLExpr column : this.columns) {
            if (!(column instanceof SQLName)) continue;
            if (((SQLName)column).nameHashCode64() == columnNameHashCode64) {
                return true;
            }
            if (!(column instanceof SQLMethodInvokeExpr)) continue;
            for (SQLExpr argument : ((SQLMethodInvokeExpr)column).getArguments()) {
                if (((SQLName)argument).nameHashCode64() != columnNameHashCode64) continue;
                return true;
            }
        }
        return false;
    }
}

