/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObject;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleJsonObjectExpr
extends SQLExprImpl
implements OracleSQLObject {
    public static final String VERSION = "12c";
    private List<OracleJsonObjectExprItem> items = new ArrayList<OracleJsonObjectExprItem>();
    private OracleJsonObjectOnNullClause nullClause;
    private OracleJsonObjectReturnClause returnClause;

    @Override
    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.addAll(this.items);
        if (this.nullClause != null) {
            children.add(this.nullClause);
        }
        if (this.returnClause != null) {
            children.add(this.returnClause);
        }
        return children;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return o == this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + (this.nullClause == null ? 0 : this.nullClause.hashCode());
        result = 31 * result + (this.returnClause == null ? 0 : this.returnClause.hashCode());
        return result;
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        this.accept0((OracleASTVisitor)v);
    }

    @Override
    public void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.items != null && this.items.size() > 0) {
                this.acceptChild((SQLASTVisitor)visitor, this.items);
            }
            if (this.nullClause != null) {
                this.acceptChild((SQLASTVisitor)visitor, this.nullClause);
            }
            if (this.returnClause != null) {
                this.acceptChild((SQLASTVisitor)visitor, this.returnClause);
            }
        }
    }

    @Override
    public SQLExpr clone() {
        OracleJsonObjectExpr expr = new OracleJsonObjectExpr();
        if (this.items != null) {
            ArrayList<OracleJsonObjectExprItem> list = new ArrayList<OracleJsonObjectExprItem>();
            for (int i = 0; i < this.items.size(); ++i) {
                OracleJsonObjectExprItem oracleJsonObjectExprItem = (OracleJsonObjectExprItem)this.items.get(i).clone();
                list.add(oracleJsonObjectExprItem);
            }
            expr.items = list;
        }
        if (this.nullClause != null) {
            expr.nullClause = (OracleJsonObjectOnNullClause)this.nullClause.clone();
        }
        if (this.returnClause != null) {
            expr.returnClause = (OracleJsonObjectReturnClause)this.returnClause.clone();
        }
        return expr;
    }

    public List<OracleJsonObjectExprItem> getItems() {
        return this.items;
    }

    public void setItems(List<OracleJsonObjectExprItem> items) {
        this.items = items;
    }

    public OracleJsonObjectOnNullClause getNullClause() {
        return this.nullClause;
    }

    public void setNullClause(OracleJsonObjectOnNullClause nullClause) {
        this.nullClause = nullClause;
    }

    public OracleJsonObjectReturnClause getReturnClause() {
        return this.returnClause;
    }

    public void setReturnClause(OracleJsonObjectReturnClause returnClause) {
        this.returnClause = returnClause;
    }

    public static class OracleJsonObjectReturnClause
    extends SQLExprImpl {
        private SQLExpr size;
        private SQLExpr byteOrChar;

        public SQLExpr getSize() {
            return this.size;
        }

        public void setSize(SQLExpr size) {
            this.size = size;
        }

        public SQLExpr getByteOrChar() {
            return this.byteOrChar;
        }

        public void setByteOrChar(SQLExpr byteOrChar) {
            this.byteOrChar = byteOrChar;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return o == this;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
            result = 31 * result + (this.byteOrChar == null ? 0 : this.byteOrChar.hashCode());
            return result;
        }

        @Override
        protected void accept0(SQLASTVisitor v) {
            OracleASTVisitor visitor = (OracleASTVisitor)v;
            if (visitor.visit(this)) {
                this.acceptChild(v, this.size);
                this.acceptChild(v, this.byteOrChar);
            }
        }

        @Override
        public SQLExpr clone() {
            OracleJsonObjectReturnClause clause = new OracleJsonObjectReturnClause();
            if (clause.size != null) {
                clause.size = this.size.clone();
            }
            if (clause.byteOrChar != null) {
                clause.byteOrChar = this.byteOrChar.clone();
            }
            return clause;
        }
    }

    public static class OracleJsonObjectOnNullClause
    extends SQLExprImpl {
        private SQLExpr nullOrAbsent;

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return o == this;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nullOrAbsent == null ? 0 : this.nullOrAbsent.hashCode());
            return result;
        }

        @Override
        protected void accept0(SQLASTVisitor v) {
            OracleASTVisitor visitor = (OracleASTVisitor)v;
            if (visitor.visit(this)) {
                this.acceptChild(v, this.nullOrAbsent);
            }
        }

        @Override
        public SQLExpr clone() {
            OracleJsonObjectOnNullClause clause = new OracleJsonObjectOnNullClause();
            clause.nullOrAbsent = this.nullOrAbsent.clone();
            return clause;
        }

        public SQLExpr getNullOrAbsent() {
            return this.nullOrAbsent;
        }

        public void setNullOrAbsent(SQLExpr nullOrAbsent) {
            this.nullOrAbsent = nullOrAbsent;
        }
    }

    public static class OracleJsonObjectExprItem
    extends SQLExprImpl
    implements OracleSQLObject {
        private boolean hasKey = false;
        private SQLExpr key;
        private SQLExpr value;
        private boolean formatJson = false;

        @Override
        public List<SQLObject> getChildren() {
            ArrayList<SQLObject> children = new ArrayList<SQLObject>();
            if (this.key != null) {
                children.add(this.key);
            }
            if (this.value != null) {
                children.add(this.value);
            }
            return children;
        }

        public SQLExpr getKey() {
            return this.key;
        }

        public void setKey(SQLExpr key) {
            this.key = key;
        }

        public SQLExpr getValue() {
            return this.value;
        }

        public void setValue(SQLExpr value) {
            this.value = value;
        }

        public boolean isFormatJson() {
            return this.formatJson;
        }

        public void setFormatJson(boolean formatJson) {
            this.formatJson = formatJson;
        }

        public boolean isHasKey() {
            return this.hasKey;
        }

        public void setHasKey(boolean hasKey) {
            this.hasKey = hasKey;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return o == this;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hasKey ? 1 : 2);
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.formatJson ? 1 : 2);
            return result;
        }

        @Override
        protected void accept0(SQLASTVisitor v) {
            this.accept0((OracleASTVisitor)v);
        }

        @Override
        public void accept0(OracleASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild((SQLASTVisitor)visitor, this.key);
                this.acceptChild((SQLASTVisitor)visitor, this.value);
            }
        }

        @Override
        public SQLExpr clone() {
            OracleJsonObjectExprItem item = new OracleJsonObjectExprItem();
            item.hasKey = this.hasKey;
            item.setKey(this.key.clone());
            item.setValue(this.value.clone());
            item.setFormatJson(this.formatJson);
            return item;
        }
    }
}

