/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivotBase;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableSource;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class OracleSelectJoin
extends SQLJoinTableSource
implements OracleSelectTableSource {
    protected OracleSelectPivotBase pivot;

    public OracleSelectJoin(String alias) {
        super(alias);
    }

    public OracleSelectJoin() {
    }

    public OracleSelectJoin(SQLTableSource left, SQLJoinTableSource.JoinType joinType, SQLTableSource right, SQLExpr condition) {
        super(left, joinType, right, condition);
    }

    @Override
    public OracleSelectPivotBase getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(OracleSelectPivotBase pivot) {
        this.pivot = pivot;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof OracleASTVisitor) {
            this.accept0((OracleASTVisitor)visitor);
        } else {
            super.accept0(visitor);
        }
    }

    protected void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.left);
            this.acceptChild((SQLASTVisitor)visitor, this.right);
            this.acceptChild((SQLASTVisitor)visitor, this.condition);
            this.acceptChild((SQLASTVisitor)visitor, this.using);
            this.acceptChild((SQLASTVisitor)visitor, this.flashback);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            if (!super.equals(o)) {
                return false;
            }
            OracleSelectJoin that = (OracleSelectJoin)o;
            if (this.pivot != null ? !this.pivot.equals(that.pivot) : that.pivot != null) {
                return false;
            }
            return this.flashback != null ? this.flashback.equals(that.flashback) : that.flashback == null;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.pivot != null ? this.pivot.hashCode() : 0;
        result = 31 * result + (this.flashback != null ? this.flashback.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return SQLUtils.toOracleString(this);
    }

    @Override
    public SQLJoinTableSource clone() {
        OracleSelectJoin x = new OracleSelectJoin();
        this.cloneTo(x);
        if (this.pivot != null) {
            x.setPivot(this.pivot.clone());
        }
        if (this.flashback != null) {
            x.setFlashback(this.flashback.clone());
        }
        return x;
    }

    public void setLeft(String tableName) {
        OracleSelectTableReference tableSource = tableName != null && tableName.length() != 0 ? new OracleSelectTableReference(new SQLIdentifierExpr(tableName)) : null;
        this.setLeft(tableSource);
    }

    public void setRight(String tableName) {
        OracleSelectTableReference tableSource = tableName != null && tableName.length() != 0 ? new OracleSelectTableReference(new SQLIdentifierExpr(tableName)) : null;
        this.setRight(tableSource);
    }

    @Override
    public SQLJoinTableSource join(SQLTableSource right, SQLJoinTableSource.JoinType joinType, SQLExpr condition) {
        OracleSelectJoin joined = new OracleSelectJoin(this, joinType, right, condition);
        return joined;
    }
}

