/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.spark.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveOutputVisitor;
import com.alibaba.druid.sql.dialect.spark.ast.expr.HiveRowFormat;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkColumnDef;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkColumnSpecExpr;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkDateExpr;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkDefProperty;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkIntervalExpr;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkLimit;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkNullsExpr;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkNumberExpr;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSampleExpr;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectJoinTableSource;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectPivot;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectPivotBase;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectTableReference;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkTablePartition;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkTransformExpr;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkValuesExpr;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkWithExpr;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkAlterDatabaseStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkAlterTableStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkAlterViewStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkCacheTableStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkCreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkCreateTableStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkCreateViewStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkExplainStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkInsertStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkLoadStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkRefreshStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkRepairTableStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkShowCreateTableStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkShowDatabasesStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkShowTableStatement;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import java.util.List;
import java.util.Map;

public class SparkOutputVisitor
extends HiveOutputVisitor
implements SparkVisitor {
    public SparkOutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public SparkOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(SparkCreateTableStatement x) {
        SQLExpr location;
        Map<String, SQLObject> serdeProperties;
        SQLExpr storedAs;
        int buckets;
        List<SQLSelectOrderByItem> sortedBy;
        List<SQLSelectOrderByItem> clusteredBy;
        int partitionSize;
        List<SQLAssignItem> tableOptions;
        List<SQLTableElement> tableElementList;
        int size;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isExternal()) {
            this.print0(this.ucase ? "EXTERNAL " : "external ");
        }
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "TABLE IF NOT EXISTS " : "table if not exists ");
        } else {
            this.print0(this.ucase ? "TABLE " : "table ");
        }
        x.getName().accept(this);
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if ((size = (tableElementList = x.getTableElementList()).size()) > 0) {
            this.print0(" (");
            if (this.isPrettyFormat() && x.hasBodyBeforeComment()) {
                this.print(' ');
                this.printlnComment(x.getBodyBeforeCommentsDirect());
            }
            ++this.indentCount;
            this.println();
            for (int i = 0; i < size; ++i) {
                SQLTableElement element = tableElementList.get(i);
                element.accept(this);
                if (i != size - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && element.hasAfterComment()) {
                    this.print(' ');
                    this.printlnComment(element.getAfterCommentsDirect());
                }
                if (i == size - 1) continue;
                this.println();
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if (x.getDatasource() != null) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            this.print0(x.getDatasource().toString());
        }
        if ((tableOptions = x.getTableOptions()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "OPTIONS (" : "options (");
            this.printAndAccept(tableOptions, ", ");
            this.print(')');
        }
        if (x.getComment() != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        if ((partitionSize = x.getPartitionColumns().size()) > 0) {
            this.println();
            this.print0(this.ucase ? "PARTITIONED BY (" : "partitioned by (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < partitionSize; ++i) {
                SQLColumnDefinition column = x.getPartitionColumns().get(i);
                column.accept(this);
                if (i != partitionSize - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && column.hasAfterComment()) {
                    this.print(' ');
                    this.printlnComment(column.getAfterCommentsDirect());
                }
                if (i == partitionSize - 1) continue;
                this.println();
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if ((clusteredBy = x.getClusteredBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "CLUSTERED BY (" : "clustered by (");
            this.printAndAccept(clusteredBy, ",");
            this.print(')');
        }
        if ((sortedBy = x.getSortedBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "SORTED BY (" : "sorted by (");
            this.printAndAccept(sortedBy, ", ");
            this.print(')');
        }
        if ((buckets = x.getBuckets()) > 0) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            this.print(buckets);
            this.print0(this.ucase ? " BUCKETS" : " buckets");
            if (x.getBucketSelect() != null) {
                this.print0(" (");
                x.getBucketSelect().accept(this);
                this.print0(")");
            }
        }
        if (x.getRowFormat() != null) {
            this.println();
            this.print0(this.ucase ? "ROW FORMAT" : "row rowFormat");
            if (x.getRowFormat().getSerde() == null) {
                this.print0(this.ucase ? " DELIMITED" : " delimited ");
            }
            x.getRowFormat().accept(this);
        }
        if (x.getHiveFormat() != null) {
            this.println();
            x.getHiveFormat().accept(this);
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.println();
            this.print0(this.ucase ? "STORED AS " : "stored as ");
            storedAs.accept(this);
        }
        this.printTblProperties(x.getTblProperties());
        SQLSelect select = x.getSelect();
        if (select != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            select.accept(this);
        }
        if ((serdeProperties = x.getSerdeProperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "TBLPROPERTIES (" : "tblproperties (");
            String seperator = "";
            for (Map.Entry<String, SQLObject> entry : serdeProperties.entrySet()) {
                this.print0("'" + entry.getKey() + "'='");
                entry.getValue().accept(this);
                this.print0("'" + seperator);
                seperator = ",";
            }
            this.print(')');
        }
        if ((location = x.getLocation()) != null) {
            this.println();
            this.print0(this.ucase ? "LOCATION " : "location ");
            location.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkCreateTableStatement x) {
    }

    @Override
    public boolean visit(SparkWithExpr expr) {
        this.print0("(");
        expr.getStatement().accept(this);
        this.print0(")");
        return false;
    }

    @Override
    public void endVisit(SparkWithExpr expr) {
    }

    @Override
    public boolean visit(SparkValuesExpr expr) {
        expr.getTypeExpr().accept(this);
        this.print0(" ");
        this.print0("(");
        for (int i = 0; i < expr.getValues().size(); ++i) {
            SQLExpr sqlExpr = expr.getValues().get(i);
            sqlExpr.accept(this);
            if (i >= expr.getValues().size() - 1) continue;
            this.print0(",");
        }
        this.print0(")");
        return false;
    }

    @Override
    public void endVisit(SparkValuesExpr expr) {
    }

    @Override
    public boolean visit(SQLLimit expr) {
        SparkLimit limit = (SparkLimit)expr;
        if (limit.isAll()) {
            this.print0(this.ucase ? "LIMIT ALL " : "limit all ");
            return false;
        }
        super.visit(expr);
        return false;
    }

    public void endVisit(SparkLimit expr) {
    }

    @Override
    public boolean visit(SparkSelectPivot x) {
        this.print0(this.ucase ? "PIVOT" : "pivot");
        if (x.isXml()) {
            this.print0(this.ucase ? " XML" : " xml");
        }
        this.print0(" (");
        this.printAndAccept(x.getItems(), ", ");
        if (x.getPivotFor().size() > 0) {
            this.print0(this.ucase ? " FOR " : " for ");
            if (x.getPivotFor().size() == 1) {
                x.getPivotFor().get(0).accept(this);
            } else {
                this.print('(');
                this.printAndAccept(x.getPivotFor(), ", ");
                this.print(')');
            }
        }
        if (x.getPivotIn().size() > 0) {
            this.print0(this.ucase ? " IN (" : " in (");
            this.printAndAccept(x.getPivotIn(), ", ");
            this.print(')');
        }
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(SparkSelectPivot x) {
    }

    @Override
    public boolean visit(SparkSelectPivot.Item x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null && x.getAlias().length() > 0) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        return false;
    }

    @Override
    public void endVisit(SparkSelectPivot.Item x) {
    }

    @Override
    public boolean visit(SparkSQLSubqueryTableSource x) {
        this.print('(');
        ++this.indentCount;
        this.println();
        x.getSelect().accept(this);
        --this.indentCount;
        this.println();
        this.print(')');
        SparkSelectPivotBase pivot = x.getPivot();
        if (pivot != null) {
            this.println();
            pivot.accept(this);
        }
        this.printFlashback(x.getFlashback());
        if (x.getAlias() != null && x.getAlias().length() != 0) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        return false;
    }

    @Override
    public void endVisit(SparkSQLSubqueryTableSource x) {
    }

    private void printFlashback(SQLExpr flashback) {
        if (flashback != null) {
            this.println();
            if (flashback instanceof SQLBetweenExpr) {
                flashback.accept(this);
            } else {
                this.print0(this.ucase ? "AS OF " : "as of ");
                flashback.accept(this);
            }
        }
    }

    @Override
    public boolean visit(SparkSelectTableReference x) {
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY (" : "only (");
            this.printTableSourceExpr(x.getExpr());
            if (x.getPartition() != null) {
                this.print(' ');
                x.getPartition().accept(this);
            }
            this.print(')');
        } else {
            this.printTableSourceExpr(x.getExpr());
            if (x.getPartition() != null) {
                this.print(' ');
                x.getPartition().accept(this);
            }
        }
        if (x.getHints().size() > 0) {
            this.printHints(x.getHints());
        }
        if (x.getSample() != null) {
            x.getSample().accept(this);
        }
        if (x.getPivot() != null) {
            this.println();
            x.getPivot().accept(this);
        }
        this.printFlashback(x.getFlashback());
        this.printAlias(x.getAlias());
        return false;
    }

    @Override
    public void endVisit(SparkSelectTableReference x) {
    }

    @Override
    public boolean visit(SparkNullsExpr x) {
        if (x != null) {
            x.getExpr().accept(this);
            if (x.isIgnore()) {
                this.print0(this.ucase ? " IGNORE NULLS " : " ignore nulls ");
            } else {
                this.print0(this.ucase ? " NULLS " : " nulls ");
            }
        }
        return false;
    }

    @Override
    public void endVisit(SparkNullsExpr x) {
    }

    @Override
    public boolean visit(SparkDefProperty x) {
        x.getKey().accept(this);
        if (x.getValue() != null) {
            this.print0(" = ");
            x.getValue().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkDefProperty x) {
    }

    @Override
    public boolean visit(SparkColumnDef x) {
        x.getColumn().accept(this);
        this.print0(" ");
        if (x.getType() != null) {
            x.getType().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkColumnDef x) {
    }

    @Override
    public boolean visit(SparkTransformExpr x) {
        this.print0(this.ucase ? "TRANSFORM" : "transform");
        this.print0("(");
        for (int i = 0; i < x.getArguments().size(); ++i) {
            x.getArguments().get(i).accept(this);
            if (i == x.getArguments().size() - 1) continue;
            this.print0(",");
        }
        this.print0(")");
        if (x.getRowFormat() != null) {
            this.println();
            x.getRowFormat().accept(this);
        }
        if (x.getRecordWriter() != null) {
            this.println();
            this.print0(this.ucase ? "RECORDWRITER " : "recordwriter");
            x.getRecordWriter().accept(this);
        }
        if (x.getCommandScript() != null) {
            this.println();
            x.getCommandScript().accept(this);
        }
        if (x.getUsingRowFormat() != null) {
            this.println();
            x.getUsingRowFormat().accept(this);
        }
        if (x.getRecordReader() != null) {
            this.println();
            this.print0(this.ucase ? "RECORDREADER " : "recordreader");
            x.getRecordReader().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkTransformExpr x) {
    }

    @Override
    public boolean visit(HiveRowFormat x) {
        this.print0(this.ucase ? "ROW FORMAT " : "row format ");
        if (x.getSede() != null) {
            this.println();
            x.getSede().accept(this);
        }
        if (x.getDelimitor() != null) {
            this.println();
            x.getDelimitor().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(HiveRowFormat x) {
    }

    @Override
    public boolean visit(SparkTablePartition x) {
        this.print0(this.ucase ? "PARTITION " : "partition ");
        this.print0("(");
        for (int i = 0; i < x.getCols().size(); ++i) {
            x.getCols().get(i).accept(this);
            if (i == x.getCols().size() - 1) continue;
            this.print0(",");
        }
        this.print0(")");
        return false;
    }

    @Override
    public void endVisit(SparkTablePartition x) {
    }

    @Override
    public boolean visit(SparkDateExpr x) {
        this.print0(this.ucase ? "DATE " : "date ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(SparkDateExpr x) {
    }

    @Override
    public boolean visit(SparkInsertStatement x) {
        if (x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        if (x.isDirectory()) {
            this.print0(this.ucase ? "INSERT OVERWRITE " : "insert overwrite ");
            if (x.isLocal()) {
                this.print0(this.ucase ? "LOCAL " : "local ");
            }
            this.print0(this.ucase ? "DIRECTORY " : "directory ");
            if (x.getDirectoryPath() != null) {
                this.print0(" ");
                x.getDirectoryPath().accept(this);
            }
            if (x.getSparkFormat() != null) {
                this.println();
                x.getSparkFormat().accept(this);
            }
            if (x.getHiveFormat() != null) {
                this.println();
                x.getHiveFormat().accept(this);
            }
            if (x.getStoredAs() != null) {
                this.println();
                this.print0(this.ucase ? "STORED AS " : "stored as ");
                x.getStoredAs().accept(this);
            }
        } else {
            if (x.isOverwrite()) {
                this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
            } else {
                this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
            }
            x.getTableSource().accept(this);
            this.print0(" ");
            if (x.getColumns().size() > 0) {
                this.println();
                this.print0("(");
                for (int i = 0; i < x.getColumns().size(); ++i) {
                    x.getColumns().get(i).accept(this);
                    if (i == x.getColumns().size() - 1) continue;
                    this.print0(" , ");
                }
                this.print0(") ");
            }
        }
        this.println();
        if (x.getFromTable() != null) {
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFromTable().accept(this);
            this.print0(" ");
        }
        SQLSelect select = x.getQuery();
        SQLExpr table = x.getQueryTable();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, " ,\n\t ");
        } else if (table != null) {
            this.print0(this.ucase ? "TABLE " : "table ");
            x.getQueryTable().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkInsertStatement x) {
    }

    @Override
    public boolean visit(SparkInsertStatement.SparkFormat x) {
        this.print0(this.ucase ? "USING " : "using ");
        x.getFileFormat().accept(this);
        this.println();
        if (x.getOptions().size() > 0) {
            this.print0(this.ucase ? "OPTIONS " : "options ");
            this.print0(" (");
            for (int i = 0; i < x.getOptions().size(); ++i) {
                x.getOptions().get(i).accept(this);
                if (i == x.getOptions().size() - 1) continue;
                this.print0(" , ");
            }
            this.print0(") ");
        }
        return false;
    }

    @Override
    public void endVisit(SparkInsertStatement.SparkFormat x) {
    }

    @Override
    public boolean visit(SparkLoadStatement x) {
        this.print0(this.ucase ? "LOAD DATA " : "load data ");
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "INPATH " : "inpath ");
        x.getInPath().accept(this);
        this.print0(" ");
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "OVERWRITE " : "overwrite ");
        }
        this.print0(this.ucase ? "INTO TABLE " : "into table ");
        x.getTable().accept(this);
        return false;
    }

    @Override
    public void endVisit(SparkLoadStatement x) {
    }

    @Override
    public boolean visit(SparkSampleExpr x) {
        this.print0(this.ucase ? " TABLESAMPLE " : " tablesample ");
        this.print0("(");
        if (x.getPercent() != null) {
            x.getPercent().accept(this);
            this.print0(this.ucase ? " PERCENT" : " percent");
        }
        if (x.getRows() != null) {
            x.getRows().accept(this);
            this.print0(this.ucase ? " ROWS" : " rows");
        }
        if (x.getBucket() != null) {
            this.print0(this.ucase ? "BUCKET " : "bucket");
            x.getBucket().accept(this);
            this.print0(this.ucase ? " OUT OF " : " out of ");
            x.getBucketOutOf().accept(this);
        }
        this.print0(")");
        return false;
    }

    @Override
    public void endVisit(SparkSampleExpr x) {
    }

    @Override
    public boolean visit(SparkIntervalExpr x) {
        this.print0(this.ucase ? "INTERVAL " : "interval ");
        for (SparkIntervalExpr.SparkIntervalItem interval : x.getIntervals()) {
            interval.accept(this);
        }
        if (x.getTo() != null) {
            x.getTo().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkIntervalExpr x) {
    }

    @Override
    public boolean visit(SparkIntervalExpr.SparkIntervalItem x) {
        this.print0(" ");
        x.getValue().accept(this);
        if (x.getType() != null) {
            this.print(" ");
            this.print0(this.ucase ? x.getType().toString() : x.getType().toString().toLowerCase());
        }
        return false;
    }

    @Override
    public void endVisit(SparkIntervalExpr.SparkIntervalItem x) {
    }

    @Override
    public boolean visit(SparkNumberExpr x) {
        this.print0(x.getLiteral());
        return false;
    }

    @Override
    public void endVisit(SparkNumberExpr x) {
    }

    @Override
    public void endVisit(SparkExplainStatement x) {
    }

    @Override
    public boolean visit(HiveRowFormat.RowFormatSede x) {
        this.print0(this.ucase ? "SERDE " : "sede ");
        x.getSedeClass().accept(this);
        this.print0(" ");
        if (x.getProps() != null && x.getProps().size() > 0) {
            this.print0(this.ucase ? " WITH SERDEPROPERTIES (" : " with serderproperties (");
            for (int i = 0; i < x.getProps().size(); ++i) {
                x.getProps().get(i).accept(this);
                if (i == x.getProps().size() - 1) continue;
                this.print(",");
            }
            this.print0(") ");
        }
        return false;
    }

    @Override
    public void endVisit(HiveRowFormat.RowFormatSede x) {
    }

    @Override
    public boolean visit(SparkTransformExpr.CommandScriptDef x) {
        this.print0(this.ucase ? "USING " : "using ");
        x.getCommandOrScript().accept(this);
        if (x.getColDefs() != null && x.getColDefs().size() > 0) {
            this.print0(this.ucase ? " AS  (" : " as (");
            for (int i = 0; i < x.getColDefs().size(); ++i) {
                x.getColDefs().get(i).accept(this);
                if (i == x.getColDefs().size() - 1) continue;
                this.print(",");
            }
            this.print0(") ");
        }
        return false;
    }

    @Override
    public void endVisit(SparkTransformExpr.CommandScriptDef x) {
    }

    @Override
    public boolean visit(HiveRowFormat.RowFormatDelimitor x) {
        this.print0(this.ucase ? "DELIMITED  " : "delimited ");
        if (x.getFieldTerminatedChar() != null) {
            this.println();
            this.print0(this.ucase ? "FIELDS TERMINATED BY   " : "fields terminated by ");
            x.getFieldTerminatedChar().accept(this);
            if (x.getEscapeChar() != null) {
                this.print0(this.ucase ? " ESCAPED BY    " : " escaped by ");
                x.getEscapeChar().accept(this);
            }
        }
        if (x.getCollectionItemsTerminatedChar() != null) {
            this.println();
            this.print0(this.ucase ? "COLLECTION ITEMS TERMINATED BY " : "collection items terminated by ");
            x.getCollectionItemsTerminatedChar().accept(this);
        }
        if (x.getMapKeyTerminatedChar() != null) {
            this.println();
            this.print0(this.ucase ? "MAP KEYS TERMINATED BY " : "map keys terminated by ");
            x.getMapKeyTerminatedChar().accept(this);
        }
        if (x.getRowTerminatedChar() != null) {
            this.println();
            this.print0(this.ucase ? "LINES TERMINATED BY " : "lines terminated by ");
            x.getRowTerminatedChar().accept(this);
        }
        if (x.getNullChar() != null) {
            this.println();
            this.print0(this.ucase ? "NULL DEFINED AS " : "null defined as ");
            x.getNullChar().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(HiveRowFormat.RowFormatDelimitor x) {
    }

    private void printHints(List<SQLHint> hints) {
        if (hints.size() > 0) {
            this.print0("/*+ ");
            this.printAndAccept(hints, ", ");
            this.print0(" */");
        }
    }

    @Override
    public boolean visit(SparkSelectJoinTableSource x) {
        x.getLeft().accept(this);
        SQLTableSource right = x.getRight();
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print0(", ");
            x.getRight().accept(this);
        } else {
            boolean isRoot = x.getParent() instanceof SQLSelectQueryBlock;
            if (isRoot) {
                ++this.indentCount;
            }
            this.println();
            this.print0(this.ucase ? x.getJoinType().name : x.getJoinType().name_lcase);
            this.print(' ');
            if (right instanceof SQLJoinTableSource) {
                this.print('(');
                this.incrementIndent();
                this.println();
                right.accept(this);
                this.decrementIndent();
                this.println();
                this.print(')');
            } else {
                right.accept(this);
            }
            if (isRoot) {
                --this.indentCount;
            }
            if (x.getCondition() != null) {
                this.print0(this.ucase ? " ON " : " on ");
                this.incrementIndent();
                x.getCondition().accept(this);
                this.decrementIndent();
                this.print(' ');
            }
            if (x.getUsing().size() > 0) {
                this.print0(this.ucase ? " USING (" : " using (");
                this.printAndAccept(x.getUsing(), ", ");
                this.print(')');
            }
            this.printFlashback(x.getFlashback());
        }
        SparkSelectPivotBase pivot = x.getPivot();
        if (pivot != null) {
            this.println();
            pivot.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkSelectJoinTableSource x) {
    }

    @Override
    public boolean visit(SparkExplainStatement x) {
        this.print0(this.ucase ? "EXPLAIN" : "explain");
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        if (x.isExtended()) {
            this.print0(this.ucase ? " EXTENDED" : " extended");
        }
        if (x.isCodegen()) {
            this.print0(this.ucase ? " CODEGEN" : " codegen");
        }
        if (x.isCost()) {
            this.print0(this.ucase ? " COST" : " cost");
        }
        if (x.isFormatted()) {
            this.print0(this.ucase ? " FORMATTED" : " formatted");
        }
        this.println();
        x.getStatement().accept(this);
        return false;
    }

    @Override
    public void endVisit(SparkShowDatabasesStatement x) {
    }

    @Override
    public boolean visit(SparkShowDatabasesStatement x) {
        this.print0(this.ucase ? "SHOW " : "show ");
        if (x.isDatabases()) {
            this.print0(this.ucase ? "DATABASES" : "databases");
        } else {
            this.print0(this.ucase ? "SCHEMAS " : "schemas");
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkRepairTableStatement x) {
    }

    @Override
    public boolean visit(SparkAlterDatabaseStatement x) {
        this.print0(this.ucase ? "ALTER " : "alter ");
        x.getAlterType().accept(this);
        this.print0(" ");
        x.getName().accept(this);
        this.print0(" ");
        this.print0(this.ucase ? "SET " : "set ");
        if (x.getLocation() != null) {
            this.print0(this.ucase ? "LOCATION " : "location ");
            x.getLocation().accept(this);
        } else {
            x.getPropType().accept(this);
            this.print0(" ");
            this.acceptChild(x.getProps());
        }
        return false;
    }

    @Override
    public void endVisit(SparkAlterDatabaseStatement x) {
    }

    @Override
    public boolean visit(SparkAlterTableStatement x) {
        this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
        x.getTable().accept(this);
        this.println();
        this.acceptChild(x.getRename());
        this.acceptChild(x.getAddColumns());
        this.acceptChild(x.getDropColumns());
        this.acceptChild(x.getRenameColumn());
        this.acceptChild(x.getChangeColumn());
        this.acceptChild(x.getReplaceColumns());
        this.acceptChild(x.getAddOrDropPartition());
        this.acceptChild(x.getSetUnsetProps());
        if (x.getAlterTableType() == SparkAlterTableStatement.AlterTableType.RECOVER_PARTITIONS) {
            this.print0(this.ucase ? "RECOVER PARTITIONS" : "recover partitions");
        }
        return false;
    }

    @Override
    public void endVisit(SparkAlterTableStatement x) {
    }

    @Override
    public boolean visit(SparkAlterTableStatement.SparkAlterTableReNameTo x) {
        this.print0(this.ucase ? "RENAME TO " : "rename to ");
        this.acceptChild(x.getName());
        this.acceptChild(x.getPartition());
        return false;
    }

    @Override
    public void endVisit(SparkAlterTableStatement.SparkAlterTableReNameTo x) {
    }

    @Override
    public boolean visit(SparkAlterTableStatement.SparkAlterTableAddColumns x) {
        this.print0(this.ucase ? "ADD COLUMNS " : "add columns ");
        this.acceptChild(x.getColumns());
        return false;
    }

    @Override
    public void endVisit(SparkAlterTableStatement.SparkAlterTableAddColumns x) {
    }

    @Override
    public boolean visit(SparkAlterTableStatement.SparkAlterTableDropColumns x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        if (x.getColumns().size() == 0) {
            this.print0(this.ucase ? "COLUMNS " : "columns ");
        } else {
            this.print0(this.ucase ? "COLUMN " : "column ");
            this.acceptChild(x.getColumns());
        }
        return false;
    }

    @Override
    public void endVisit(SparkAlterTableStatement.SparkAlterTableDropColumns x) {
    }

    @Override
    public boolean visit(SparkAlterTableStatement.SparkAlterTableRenameColumn x) {
        this.print0(this.ucase ? "RENAME COLUMN " : "rename column ");
        this.acceptChild(x.getColumn());
        this.print0(this.ucase ? " TO " : " to ");
        this.acceptChild(x.getTo());
        return false;
    }

    @Override
    public void endVisit(SparkAlterTableStatement.SparkAlterTableRenameColumn x) {
    }

    @Override
    public boolean visit(SparkAlterTableStatement.SparkAlterTableChangeColumn x) {
        this.print0(this.ucase ? "ALTER  COLUMN " : "alter column ");
        this.acceptChild(x.getColumn());
        this.print0(" ");
        this.acceptChild(x.getSpec());
        return false;
    }

    @Override
    public void endVisit(SparkAlterTableStatement.SparkAlterTableChangeColumn x) {
    }

    @Override
    public boolean visit(SparkAlterTableStatement.SparkAlterTableReplaceColumns x) {
        this.print0(this.ucase ? "REPLACE COLUMNS " : "replace columns ");
        this.acceptChild(x.getColumns());
        return false;
    }

    @Override
    public void endVisit(SparkAlterTableStatement.SparkAlterTableReplaceColumns x) {
    }

    @Override
    public boolean visit(SparkAlterTableStatement.SparkAlterTableAddOrDropPartition x) {
        if (x.isAdd()) {
            this.print0(this.ucase ? "ADD " : "add ");
            if (x.isExists()) {
                this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
            }
        } else {
            this.print0(this.ucase ? "DROP " : "drop ");
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.acceptChild(x.getPartitions(), " ", "", " ");
        if (x.isPurge()) {
            this.print0(this.ucase ? " PRUGE " : " purge ");
        }
        return false;
    }

    @Override
    public void endVisit(SparkAlterTableStatement.SparkAlterTableAddOrDropPartition x) {
    }

    @Override
    public boolean visit(SparkAlterTableStatement.SparkAlterTableSetUnsetProps x) {
        if (x.isUnset()) {
            this.print0(this.ucase ? "UNSET " : "unset ");
        } else {
            this.print0(this.ucase ? "SET " : "set ");
        }
        if (x.getFileFormat() != null) {
            this.print0(this.ucase ? "FILEFORMAT " : "fileformat ");
            this.acceptChild(x.getFileFormat());
        }
        if (x.getLocation() != null) {
            this.print0(this.ucase ? "LOCATION " : "location ");
            this.acceptChild(x.getLocation());
        }
        if (x.getSerde() != null) {
            this.print0(this.ucase ? "SERDE " : "serde ");
            this.acceptChild(x.getSerde());
            this.print0(" ");
            if (x.getProps().size() > 0) {
                this.print0(this.ucase ? "WITH " : "with ");
            }
        }
        if (x.getProps().size() > 0) {
            if (x.isTblProps()) {
                this.print0(this.ucase ? "TBLPROPERTIES " : "tblproperties ");
            } else {
                this.print0(this.ucase ? "SERDEPROPERTIES " : "serdeproperties ");
            }
        }
        if (x.isExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.acceptChild(x.getProps());
        return false;
    }

    @Override
    public void endVisit(SparkAlterTableStatement.SparkAlterTableSetUnsetProps x) {
    }

    @Override
    public boolean visit(SparkAlterViewStatement x) {
        this.print0(this.ucase ? "ALTER VIEW " : "alter view ");
        this.acceptChild(x.getName());
        this.print0(" ");
        this.acceptChild(x.getRename());
        this.acceptChild(x.getSetProps());
        if (x.getSelect() != null) {
            this.print0(this.ucase ? "AS " : "as ");
            this.println();
            this.acceptChild(x.getSelect());
        }
        return false;
    }

    @Override
    public void endVisit(SparkAlterViewStatement x) {
    }

    @Override
    public boolean visit(SparkAlterViewStatement.SparkAlterViewReNameTo x) {
        this.print0(this.ucase ? "RENAME TO " : "rename to ");
        this.acceptChild(x.getName());
        return false;
    }

    @Override
    public void endVisit(SparkAlterViewStatement.SparkAlterViewReNameTo x) {
    }

    @Override
    public boolean visit(SparkAlterViewStatement.SparkAlterViewSetUnsetProps x) {
        if (x.isUnset()) {
            this.print0(this.ucase ? "UNSET TBLPROPERTIES " : "unset tblproperties ");
        } else {
            this.print0(this.ucase ? "SET TBLPROPERTIES " : "set tblproperties ");
            if (x.isExists()) {
                this.print0(this.ucase ? "IF EXISTS  " : "if exists ");
            }
        }
        this.acceptChild(x.getProps());
        return false;
    }

    @Override
    public void endVisit(SparkAlterViewStatement.SparkAlterViewSetUnsetProps x) {
    }

    @Override
    public boolean visit(SparkColumnSpecExpr x) {
        if (x.getName() != null) {
            x.getName().accept(this);
        }
        if (x.getType() != null) {
            this.print0(" ");
            x.getType().accept(this);
        }
        if (x.getComment() != null) {
            this.print0(" ");
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        if (x.getPosition() != null) {
            this.print0(" ");
            x.getPosition().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkColumnSpecExpr x) {
    }

    @Override
    public boolean visit(SparkCreateDatabaseStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        x.getType().accept(this);
        this.print0(" ");
        if (x.isExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getName().accept(this);
        if (x.getComment() != null) {
            this.print0(" ");
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        if (x.getLocation() != null) {
            this.print0(" ");
            this.print0(this.ucase ? "LOCATION " : "location ");
            x.getLocation().accept(this);
        }
        if (x.getProps() != null && x.getProps().size() > 0) {
            this.print0(this.ucase ? " WITH DBPROPERTIES  " : " with dbproperties ");
            this.acceptChild(x.getProps());
        }
        return false;
    }

    @Override
    public void endVisit(SparkCreateDatabaseStatement x) {
    }

    @Override
    public boolean visit(SparkCacheTableStatement x) {
        this.print0(this.ucase ? "CACHE " : "cache ");
        if (x.isLazy()) {
            this.print0(this.ucase ? "LAZY " : "lazy ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        x.getTable().accept(this);
        this.print0(" ");
        if (x.getOptions().size() > 0) {
            this.println();
            this.print0(this.ucase ? "OPTIONS " : "options ");
            this.acceptChild(x.getOptions());
        }
        if (x.getQuery() != null) {
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkCacheTableStatement x) {
    }

    @Override
    public boolean visit(SparkCacheTableStatement.SparkCacheTableStatementQuery x) {
        this.println();
        this.print0(this.ucase ? "AS " : "as ");
        if (x.getTableQuery() != null) {
            this.println();
            this.print0(this.ucase ? "TABLE " : "table ");
            x.getTableQuery().accept(this);
        }
        if (x.getFromQuery() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getTableQuery().accept(this);
        }
        if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkCacheTableStatement.SparkCacheTableStatementQuery x) {
    }

    private void acceptChild(SQLObject e) {
        if (e != null) {
            e.accept(this);
        }
    }

    private void acceptChild(List e) {
        this.acceptChild(e, ", ", "(", ")");
    }

    private void acceptChild(List e, String splitor, String begin, String end) {
        if (e != null && e.size() != 0) {
            if (begin != null) {
                this.print0(begin);
            }
            for (int i = 0; i < e.size(); ++i) {
                SQLObject o = (SQLObject)e.get(i);
                if (o == null) continue;
                o.accept(this);
                if (i == e.size() - 1 || splitor == null) continue;
                this.print0(splitor);
            }
            if (end != null) {
                this.print0(end);
            }
        }
    }

    @Override
    public boolean visit(SparkRepairTableStatement x) {
        this.print0(this.ucase ? "MSCK REPAIR TABLE " : "msck repair table ");
        x.getName().accept(this);
        if (x.getAction() != null) {
            this.print0(" ");
            this.print0(x.getAction().name);
            this.print0(this.ucase ? " PARTITIONS " : " partitions");
        }
        return false;
    }

    @Override
    public void endVisit(SparkCreateViewStatement x) {
    }

    @Override
    public boolean visit(SparkCreateViewStatement x) {
        SQLLiteralExpr comment;
        String sqlSecurity;
        SQLName definer;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "OR REPLACE " : "or replace ");
        }
        if (x.isGlobal()) {
            this.print0(this.ucase ? "GLOBAL" : "global");
        }
        if (x.isTemporary()) {
            this.print0(this.ucase ? " TEMPORARY " : " temporary ");
        }
        ++this.indentCount;
        String algorithm = x.getAlgorithm();
        if (algorithm != null && algorithm.length() > 0) {
            this.print0(this.ucase ? "ALGORITHM = " : "algorithm = ");
            this.print0(algorithm);
            this.println();
        }
        if ((definer = x.getDefiner()) != null) {
            this.print0(this.ucase ? "DEFINER = " : "definer = ");
            definer.accept(this);
            this.println();
        }
        if ((sqlSecurity = x.getSqlSecurity()) != null && sqlSecurity.length() > 0) {
            this.print0(this.ucase ? "SQL SECURITY = " : "sql security = ");
            this.print0(sqlSecurity);
            this.println();
        }
        --this.indentCount;
        this.print0(this.ucase ? "VIEW " : "view ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getTableSource().accept(this);
        List<SQLTableElement> columns = x.getColumns();
        if (columns.size() > 0) {
            this.print0(" (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < columns.size(); ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                columns.get(i).accept(this);
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if ((comment = x.getComment()) != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            comment.accept(this);
        }
        this.printTblProperties(x.getTblProperties());
        this.println();
        this.print0(this.ucase ? "AS" : "as");
        this.println();
        x.getSubQuery().accept(this);
        if (x.isWithLocal()) {
            this.println();
            this.print0(this.ucase ? "WITH LOCAL" : "with local");
        }
        if (x.isWithCascaded()) {
            this.println();
            this.print0(this.ucase ? "WITH CASCADED" : "with cascaded");
        }
        if (x.isWithCheckOption()) {
            if (!x.isWithLocal() && !x.isWithCascaded()) {
                this.println();
                this.print0(this.ucase ? "WITH" : "with");
            }
            this.print0(this.ucase ? " CHECK OPTION" : " check option");
        }
        if (x.isWithReadOnly()) {
            this.println();
            this.print0(this.ucase ? "WITH READ ONLY" : "with read only");
        }
        return false;
    }

    @Override
    public void endVisit(SparkShowCreateTableStatement x) {
    }

    protected void printTblProperties(List<SQLAssignItem> tblProperties) {
        if (tblProperties.size() > 0) {
            this.println();
            this.print0(this.ucase ? "TBLPROPERTIES (" : "tblproperties (");
            this.incrementIndent();
            this.println();
            int i = 0;
            for (SQLAssignItem property : tblProperties) {
                char c0;
                if (i != 0) {
                    this.print(",");
                    this.println();
                }
                String key = property.getTarget().toString();
                boolean unquote = false;
                if (key.length() > 0 && (c0 = key.charAt(0)) != '\"' && c0 != '`' && c0 != '\'') {
                    unquote = true;
                }
                if (unquote) {
                    this.print('\'');
                }
                this.print0(key);
                if (unquote) {
                    this.print('\'');
                }
                this.print0(" = ");
                property.getValue().accept(this);
                ++i;
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
    }

    @Override
    public boolean visit(SparkShowCreateTableStatement x) {
        List<SQLCommentHint> headHints = x.getHeadHintsDirect();
        if (headHints != null) {
            for (SQLCommentHint hint : headHints) {
                hint.accept(this);
                this.println();
            }
        }
        if (x.isAll()) {
            this.print0(this.ucase ? "SHOW ALL CREATE TABLE " : "show all create table ");
        } else {
            this.print0(this.ucase ? "SHOW CREATE TABLE " : "show create table ");
        }
        x.getTable().accept(this);
        if (x.isSerde()) {
            this.print0(this.ucase ? " AS SERDE" : " as serde");
        }
        return false;
    }

    @Override
    public boolean visit(SparkRefreshStatement x) {
        this.print0(this.ucase ? "REFRESH " : "refresh ");
        if (x.getType() == SparkRefreshStatement.Type.TABLE) {
            this.print0(this.ucase ? "TABLE " : "table ");
        } else if (x.getType() == SparkRefreshStatement.Type.FUNCTION) {
            this.print0(this.ucase ? "FUNCTION " : "function ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(SparkRefreshStatement x) {
    }

    @Override
    public boolean visit(SparkShowTableStatement x) {
        List<SQLCommentHint> headHints = x.getHeadHintsDirect();
        if (headHints != null) {
            for (SQLCommentHint hint : headHints) {
                hint.accept(this);
                this.println();
            }
        }
        this.print0(this.ucase ? "SHOW TABLE" : "show table");
        if (x.isExtended()) {
            this.print0(this.ucase ? " EXTENDED" : " extended");
        }
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getPartition() != null) {
            this.print0(" ");
            x.getPartition().accept0(this);
        }
        return false;
    }

    @Override
    public void endVisit(SparkShowTableStatement x) {
    }
}

