/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.common;

import com.alibaba.fastjson.JSONObject;
import com.palacesun.engine.common.GatewaySocketCallback;
import com.palacesun.engine.common.SkipHttpsUtil;
import com.palacesun.engine.gateway.EncryptionGatewayManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ClientUtil {
    private static final Log log = LogFactory.getLog(ClientUtil.class);
    private static final boolean HTTP_LOG_DEBUG = true;
    public static ExecutorService executorService = Executors.newFixedThreadPool(10);

    public static String doClient(String url, String json) {
        String result = "\u8c03\u7528" + url + "\u63a5\u53e3\u7ed3\u675f\uff01";
        InnerThread innerThread = new InnerThread();
        innerThread.url = url;
        innerThread.json = json;
        innerThread.start();
        return result;
    }

    public static CloseableHttpClient buildHttpClient() {
        return EncryptionGatewayManager.getParameterValue("gatewayurl").contains("https") ? SkipHttpsUtil.wrapClient() : HttpClients.createDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String json) {
        CloseableHttpClient httpClient = ClientUtil.buildHttpClient();
        HttpPost httpPost = new HttpPost(url);
        String result = null;
        long startTime = System.currentTimeMillis();
        log.info("==================== HTTP\u8bf7\u6c42\u5f00\u59cb ====================");
        log.info("\u8bf7\u6c42URL: " + url);
        log.info("\u8bf7\u6c42\u65b9\u6cd5: POST");
        log.info("\u8bf7\u6c42\u5934: content-type=application/json;charset=UTF-8");
        log.info("\u8bf7\u6c42\u53c2\u6570: " + (json != null ? json : "{}"));
        log.info("\u8bf7\u6c42\u65f6\u95f4: " + new Date());
        try {
            httpPost.setHeader("content-type", "application/json;charset=UTF-8");
            StringEntity se = new StringEntity(json, "utf-8");
            httpPost.setEntity(se);
            CloseableHttpResponse response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString(entity, "UTF-8");
            }
            long endTime = System.currentTimeMillis();
            log.info("==================== HTTP\u54cd\u5e94\u7ed3\u675f ====================");
            log.info("\u54cd\u5e94\u72b6\u6001\u7801: " + response.getStatusLine().getStatusCode());
            log.info("\u54cd\u5e94\u72b6\u6001: " + response.getStatusLine().getReasonPhrase());
            log.info("\u54cd\u5e94\u53c2\u6570: " + (result != null ? result : "null"));
            log.info("\u54cd\u5e94\u65f6\u95f4: " + new Date());
            log.info("\u8bf7\u6c42\u8017\u65f6: " + (endTime - startTime) + " ms");
            log.info("========================================================");
        }
        catch (ClientProtocolException var20) {
            long endTime = System.currentTimeMillis();
            log.error("==================== HTTP\u8bf7\u6c42\u5f02\u5e38 ====================");
            log.error("\u5f02\u5e38\u7c7b\u578b: ClientProtocolException");
            log.error("\u5f02\u5e38\u4fe1\u606f: " + var20.getMessage());
            log.error("\u8bf7\u6c42\u8017\u65f6: " + (endTime - startTime) + " ms");
            log.error("========================================================");
        }
        catch (UnsupportedEncodingException var21) {
            long endTime = System.currentTimeMillis();
            log.error("==================== HTTP\u8bf7\u6c42\u5f02\u5e38 ====================");
            log.error("\u5f02\u5e38\u7c7b\u578b: UnsupportedEncodingException");
            log.error("\u5f02\u5e38\u4fe1\u606f: " + var21.getMessage());
            log.error("\u8bf7\u6c42\u8017\u65f6: " + (endTime - startTime) + " ms");
            log.error("========================================================");
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            log.error("==================== HTTP\u8bf7\u6c42\u5f02\u5e38 ====================");
            log.error("\u5f02\u5e38\u7c7b\u578b: " + e.getClass().getSimpleName());
            log.error("\u5f02\u5e38\u4fe1\u606f: " + e.getMessage());
            log.error("\u8bf7\u6c42\u8017\u65f6: " + (endTime - startTime) + " ms");
            log.error("========================================================");
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String json, GatewaySocketCallback callback) {
        CloseableHttpClient httpClient = ClientUtil.buildHttpClient();
        HttpPost httpPost = new HttpPost(url);
        String result = null;
        String resultStatus = "";
        long startTime = System.currentTimeMillis();
        log.info("==================== HTTP\u8bf7\u6c42\u5f00\u59cb(\u56de\u8c03\u7248\u672c) ====================");
        log.info("\u8bf7\u6c42URL: " + url);
        log.info("\u8bf7\u6c42\u65b9\u6cd5: POST");
        log.info("\u8bf7\u6c42\u5934: content-type=application/json;charset=UTF-8");
        log.info("\u8bf7\u6c42\u53c2\u6570: " + (json != null ? json : "{}"));
        log.info("\u8bf7\u6c42\u65f6\u95f4: " + new Date());
        log.info("\u56de\u8c03\u5bf9\u8c61: " + (callback != null ? callback.getClass().getSimpleName() : "null"));
        try {
            httpPost.setHeader("content-type", "application/json;charset=UTF-8");
            StringEntity se = new StringEntity(json, "utf-8");
            httpPost.setEntity(se);
            CloseableHttpResponse response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString(entity, "UTF-8");
            }
            long endTime = System.currentTimeMillis();
            log.info("==================== HTTP\u54cd\u5e94\u7ed3\u675f(\u56de\u8c03\u7248\u672c) ====================");
            log.info("\u54cd\u5e94\u72b6\u6001\u7801: " + response.getStatusLine().getStatusCode());
            log.info("\u54cd\u5e94\u72b6\u6001: " + response.getStatusLine().getReasonPhrase());
            log.info("\u54cd\u5e94\u53c2\u6570: " + (result != null ? result : "null"));
            log.info("\u54cd\u5e94\u65f6\u95f4: " + new Date());
            log.info("\u8bf7\u6c42\u8017\u65f6: " + (endTime - startTime) + " ms");
            JSONObject jsonObject = JSONObject.parseObject(result);
            String data = (String)jsonObject.get("data");
            if (!jsonObject.get("code").equals("OOW_01")) {
                resultStatus = "refresh".equals(data) ? "refresh" : "norefresh";
                callback.isSucc(data);
                log.info("\u56de\u8c03\u5904\u7406: \u6210\u529f\u5904\u7406\uff0c\u6570\u636e=" + data + "\uff0c\u7ed3\u679c\u72b6\u6001=" + resultStatus);
            } else {
                callback.clean();
                log.info("\u56de\u8c03\u5904\u7406: \u6267\u884c\u6e05\u7406\u64cd\u4f5c");
            }
            log.info("====================================================================");
        }
        catch (ClientProtocolException var24) {
            long endTime = System.currentTimeMillis();
            log.error("==================== HTTP\u8bf7\u6c42\u5f02\u5e38(\u56de\u8c03\u7248\u672c) ====================");
            log.error("\u5f02\u5e38\u7c7b\u578b: ClientProtocolException");
            log.error("\u5f02\u5e38\u4fe1\u606f: " + var24.getMessage());
            log.error("\u8bf7\u6c42\u8017\u65f6: " + (endTime - startTime) + " ms");
            log.error("\u56de\u8c03\u5904\u7406: \u6267\u884c\u5931\u8d25\u56de\u8c03");
            log.error("====================================================================");
            callback.isFail();
            result = "noRefresh";
        }
        catch (UnsupportedEncodingException var25) {
            long endTime = System.currentTimeMillis();
            log.error("==================== HTTP\u8bf7\u6c42\u5f02\u5e38(\u56de\u8c03\u7248\u672c) ====================");
            log.error("\u5f02\u5e38\u7c7b\u578b: UnsupportedEncodingException");
            log.error("\u5f02\u5e38\u4fe1\u606f: " + var25.getMessage());
            log.error("\u8bf7\u6c42\u8017\u65f6: " + (endTime - startTime) + " ms");
            log.error("\u56de\u8c03\u5904\u7406: \u6267\u884c\u5931\u8d25\u56de\u8c03");
            log.error("====================================================================");
            callback.isFail();
            result = "noRefresh";
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            log.error("==================== HTTP\u8bf7\u6c42\u5f02\u5e38(\u56de\u8c03\u7248\u672c) ====================");
            log.error("\u5f02\u5e38\u7c7b\u578b: " + e.getClass().getSimpleName());
            log.error("\u5f02\u5e38\u4fe1\u606f: " + e.getMessage());
            log.error("\u8bf7\u6c42\u8017\u65f6: " + (endTime - startTime) + " ms");
            log.error("\u56de\u8c03\u5904\u7406: \u6267\u884c\u5931\u8d25\u56de\u8c03");
            log.error("====================================================================");
            e.printStackTrace();
            callback.isFail();
            result = "noRefresh";
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultStatus;
    }

    public static CloseableHttpClient getWrapClient() {
        return EncryptionGatewayManager.getParameterValue("gatewayurl").contains("https") ? SkipHttpsUtil.wrapClient() : HttpClients.createDefault();
    }

    public static void main(String[] args) {
        log.info("ClientUtil main method started");
        String url = "http://172.16.100.87:9005/initconfigfile/loadconfig";
        String result = ClientUtil.doClient(url, "{}");
        System.out.println("result:" + result);
    }

    public static class InnerThread
    extends Thread {
        String url;
        String json;

        @Override
        public void run() {
            ClientUtil.doPost(this.url, this.json);
        }
    }
}

