/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.gateway;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.palacesun.engine.common.ClientUtil;
import com.palacesun.engine.common.GatewaySocketCallback;
import com.palacesun.engine.common.TelnetUtil;
import com.palacesun.engine.gateway.cache.CacheFromEncryptionGateway;
import com.palacesun.engine.gateway.cache.UserOriginalVO;
import com.palacesun.engine.gateway.netty.NettyStartApplicationRunner;
import com.palacesun.engine.gateway.util.GatewaySocketLogUtil;
import com.palacesun.engine.test.TestJdbcEventListener;
import com.palacesun.engine.wrapper.PreparedStatementWrapper;
import com.palacesun.masking.adapter.StringUtils;
import com.palacesun.masking.tools.EngineUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class EncryptionGatewayManager {
    protected static Logger logger = Logger.getLogger(EncryptionGatewayManager.class.getName());
    static final String GATEWAY_PUSH_APPUSER_ORIGINAL_INFOS_URI = "/jar_socket_controller/pullAppUserOriginalInfos";
    static final String GATEWAY_PUSH_GATEWAYUSER_ORIGINAL_INFOS_URI = "/jar_socket_controller/pullGatewayOriginalInfos";
    static final String GATEWAY_PUSH_GLOBAL_ORIGINAL_INFOS_URI = "/jar_socket_controller/pullGlobalOriginalConfig";
    static final String GATEWAY_NOTICE_PULL_STATUS = "/jar_socket_controller/noticePullStatus";
    public static int ROOT_PORT = 65536;
    public static Map<String, String> CONFIG_PROPERTIES = new HashMap<String, String>();
    public static Map<String, String> ROOT_CONFIG_PROPERTIES = new HashMap<String, String>();
    public static boolean sendUrl = false;
    static long lastTime = 0L;

    public EncryptionGatewayManager() {
        EncryptionGatewayManager.run();
    }

    public static void run() {
        InnerThread innerThread = new InnerThread();
        innerThread.start();
    }

    public static void scheduledTask() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Long.parseLong(EncryptionGatewayManager.getParameterValue("pullInterval")));
                    EncryptionGatewayManager.pullTask();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                GatewaySocketLogUtil.writeLog("*****************************\u5b9a\u65f6\u4efb\u52a1\u906d\u9047Exception\u5f02\u5e38***************************");
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                GatewaySocketLogUtil.writeLog("*****************************\u5b9a\u65f6\u4efb\u52a1\u906d\u9047Throwable\u5f02\u5e38***************************");
                continue;
            }
            break;
        }
    }

    public static void pullTask() {
        GatewaySocketLogUtil.writeLog("\u3010\u3010\u3010\u3010\u4e00\u6b21\u62c9\u53d6\u5f00\u59cb\uff01\uff01\uff01\uff01\uff01\uff01\u3011\u3011\u3011\u3011");
        try {
            String ip = EncryptionGatewayManager.getParameterValue("gatewayurl").split("://")[1].split(":")[0];
            String port = EncryptionGatewayManager.getParameterValue("gatewayurl").split("://")[1].split(":")[1];
            if (TelnetUtil.telnet(ip, Integer.parseInt(port), 10000)) {
                if (EncryptionGatewayManager.noticeMyStatus("2")) {
                    GatewaySocketLogUtil.writeLog("\u5e73\u53f0\u901a\u77e5\u52a0\u5bc6\u89c4\u5219\u6709\u53d8\u5316\uff0c\u9700\u8981\u91cd\u65b0\u62c9\u53d6");
                    try {
                        EngineUtil.initRule();
                        TestJdbcEventListener.sqlColumSecretKeyMap.clear();
                        PreparedStatementWrapper.sqlIndexKeyMap.clear();
                    }
                    catch (Exception var3) {
                        GatewaySocketLogUtil.writeLog("\u62c9\u53d6\u52a0\u5bc6\u89c4\u5219\u5931\u8d25");
                    }
                } else {
                    GatewaySocketLogUtil.writeLog("\u5e73\u53f0\u901a\u77e5\u52a0\u5bc6\u89c4\u5219\u65e0\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u91cd\u65b0\u62c9\u53d6");
                }
                EncryptionGatewayManager.pullAppUserOriginalInfos();
                EncryptionGatewayManager.pullGatewayUserOriginalInfos();
                EncryptionGatewayManager.pullGlobalOriginalConfig();
                EncryptionGatewayManager.noticeMyStatus("3");
            } else {
                GatewaySocketLogUtil.writeLog("\u8fde\u63a5\u52a0\u5bc6\u7f51\u5173 " + EncryptionGatewayManager.getParameterValue("gatewayurl") + "\u8d85\u65f6\uff0c\u672c\u6b21\u62c9\u53d6\u7ec8\u6b62\uff01");
            }
            GatewaySocketLogUtil.writeLog("\u3010\u3010\u3010\u3010\u4e00\u6b21\u62c9\u53d6\u7ed3\u675f\uff01\uff01\uff01\uff01\uff01\uff01\u3011\u3011\u3011\u3011");
            GatewaySocketLogUtil.writeBlankRows();
        }
        catch (Exception var4) {
            EncryptionGatewayManager.noticeMyStatus("4");
            GatewaySocketLogUtil.writeLog("\u3010\u3010\u3010\u3010\u4e00\u6b21\u62c9\u53d6\u906d\u9047Exception\u5f02\u5e38\uff01\uff01\uff01\uff01\uff01\uff01\u3011\u3011\u3011\u3011");
        }
        catch (Throwable var5) {
            EncryptionGatewayManager.noticeMyStatus("4");
            GatewaySocketLogUtil.writeLog("\u3010\u3010\u3010\u3010\u4e00\u6b21\u62c9\u53d6\u906d\u9047Throwable\u5f02\u5e38\uff01\uff01\uff01\uff01\uff01\uff01\u3011\u3011\u3011\u3011");
        }
    }

    public static void receiveAppUserOriginalInfos(String param) {
        CacheFromEncryptionGateway.appUserOriginalInfos = JSONArray.parseArray(param, UserOriginalVO.class);
    }

    public static void receiveGatewayUserOriginalInfos(String param) {
        CacheFromEncryptionGateway.gatewayUserOriginalInfos = JSONArray.parseArray(param, UserOriginalVO.class);
    }

    public static void receiveGlobalOriginalConfig(String json) {
        Map globalConfig = JSON.toJavaObject(JSON.parseObject(json), Map.class);
        CacheFromEncryptionGateway.appUserGlobalOriginalConfig = (Integer)globalConfig.get("globalOriginalConfig");
    }

    public void setGateWayUserGlobalOriginalConfig() {
        CacheFromEncryptionGateway.gatewayUserGlobalOriginalConfig = 1;
    }

    public static void pullAppUserOriginalInfos() {
        GatewaySocketLogUtil.writeBlankRows();
        GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f00\u59cb\uff01");
        try {
            String url = EncryptionGatewayManager.getParameterValue("gatewayurl") + GATEWAY_PUSH_APPUSER_ORIGINAL_INFOS_URI;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("projectId", EncryptionGatewayManager.getParameterValue("projectid"));
            param.put("remotePort", String.valueOf(ROOT_PORT));
            url = url + "?projectId=" + EncryptionGatewayManager.getParameterValue("projectid");
            url = url + "&remotePort=" + ROOT_PORT;
            String result = ClientUtil.doPost(url, JSON.toJSONString(param));
            GatewaySocketLogUtil.writeLog(url + "\u63a5\u53e3\u8fd4\u56de\u7684\u5185\u5bb9\u4e3a\uff1a" + result);
            JSONObject jsonObject = JSONObject.parseObject(result);
            if (!jsonObject.get("data").toString().equals("[]")) {
                List data;
                JSONArray array = jsonObject.getJSONArray("data");
                CacheFromEncryptionGateway.appUserOriginalInfos = data = (List)array.toJavaObject(new TypeReference<List<UserOriginalVO>>(){});
            }
        }
        catch (Exception var6) {
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f02\u5e38\uff01");
        }
        GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u7ed3\u675f\uff01");
        GatewaySocketLogUtil.writeBlankRows();
    }

    public static void pullGatewayUserOriginalInfos() {
        GatewaySocketLogUtil.writeBlankRows();
        try {
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f00\u59cb\uff01");
            String url = EncryptionGatewayManager.getParameterValue("gatewayurl") + GATEWAY_PUSH_GATEWAYUSER_ORIGINAL_INFOS_URI;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("projectId", EncryptionGatewayManager.getParameterValue("projectid"));
            param.put("remotePort", String.valueOf(ROOT_PORT));
            url = url + "?projectId=" + EncryptionGatewayManager.getParameterValue("projectid");
            url = url + "&remotePort=" + ROOT_PORT;
            String result = ClientUtil.doPost(url, JSON.toJSONString(param));
            GatewaySocketLogUtil.writeLog(url + "\u63a5\u53e3\u8fd4\u56de\u7684\u5185\u5bb9\u4e3a\uff1a" + result);
            JSONObject jsonObject = JSONObject.parseObject(result);
            if (!jsonObject.get("data").toString().equals("[]")) {
                List data;
                JSONArray array = jsonObject.getJSONArray("data");
                CacheFromEncryptionGateway.gatewayUserOriginalInfos = data = (List)array.toJavaObject(new TypeReference<List<UserOriginalVO>>(){});
            }
        }
        catch (Exception var6) {
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f02\u5e38\uff01");
        }
        GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u7ed3\u675f\uff01");
        GatewaySocketLogUtil.writeBlankRows();
    }

    public static void pullGlobalOriginalConfig() {
        GatewaySocketLogUtil.writeBlankRows();
        try {
            Integer globalOriginalConfig;
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f00\u59cb\uff01");
            String url = EncryptionGatewayManager.getParameterValue("gatewayurl") + GATEWAY_PUSH_GLOBAL_ORIGINAL_INFOS_URI;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("projectId", EncryptionGatewayManager.getParameterValue("projectid"));
            param.put("remotePort", String.valueOf(ROOT_PORT));
            url = url + "?projectId=" + EncryptionGatewayManager.getParameterValue("projectid");
            url = url + "&remotePort=" + ROOT_PORT;
            String result = ClientUtil.doPost(url, JSON.toJSONString(param));
            GatewaySocketLogUtil.writeLog(url + "\u63a5\u53e3\u8fd4\u56de\u7684\u5185\u5bb9\u4e3a\uff1a" + result);
            JSONObject jsonObject = JSONObject.parseObject(result);
            CacheFromEncryptionGateway.appUserGlobalOriginalConfig = globalOriginalConfig = (Integer)jsonObject.get("data");
        }
        catch (Exception var5) {
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f02\u5e38\uff01");
        }
        GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u7ed3\u675f\uff01");
        GatewaySocketLogUtil.writeBlankRows();
    }

    public static boolean isPullMode() {
        return EncryptionGatewayManager.getParameterValue("dataSynchronousMode").equalsIgnoreCase("pull");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties() {
        InputStream root = null;
        BufferedReader rootBF = null;
        InputStream fr = null;
        BufferedReader bf = null;
        try {
            String rootStr;
            root = EncryptionGatewayManager.class.getResourceAsStream("/gatewayconfig/config.properties");
            rootBF = new BufferedReader(new InputStreamReader(root));
            while ((rootStr = rootBF.readLine()) != null) {
                if (rootStr.startsWith("#") || !StringUtils.isNotEmpty(rootStr) || rootStr.split("=").length != 2) continue;
                ROOT_CONFIG_PROPERTIES.put(rootStr.split("=")[0].trim(), rootStr.split("=")[1].trim());
            }
            try {
                String str;
                if (ROOT_CONFIG_PROPERTIES.get("encryption.config.location") != null && !"".equals(ROOT_CONFIG_PROPERTIES.get("encryption.config.location")) && (fr = new FileInputStream(ROOT_CONFIG_PROPERTIES.get("encryption.config.location"))) != null) {
                    bf = new BufferedReader(new InputStreamReader(fr));
                }
                while ((str = bf.readLine()) != null) {
                    if (str.startsWith("#") || !StringUtils.isNotEmpty(str) || str.split("=").length != 2) continue;
                    CONFIG_PROPERTIES.put(str.split("=")[0].trim(), str.split("=")[1].trim());
                }
            }
            catch (IOException var22) {
                logger.info("\u6ca1\u6709\u8bbe\u7f6e\u5916\u90e8\u914d\u7f6e\u6587\u4ef6\uff0c\u672a\u80fd\u8bfb\u53d6\u5230\u5916\u90e8\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f");
            }
            finally {
                if (rootBF != null) {
                    rootBF.close();
                }
                if (root != null) {
                    root.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bf != null) {
                    bf.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean noticeMyStatus(final String status) {
        String projectId = EncryptionGatewayManager.getParameterValue("projectid");
        String remotePort = "";
        try {
            int portInt = ROOT_PORT;
            remotePort = String.valueOf(ROOT_PORT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        GatewaySocketLogUtil.writeLog("\u901a\u77e5\u52a0\u5bc6\u7f51\u5173\u66f4\u6539\u540c\u6b65\u72b6\u6001\u4e3a" + status + "\uff0c\u53c2\u6570\u4e3a\uff1aprojectId=" + projectId + ",remotePort=" + remotePort + ",status=" + status);
        String url = EncryptionGatewayManager.getParameterValue("gatewayurl") + "/jar_socket_controller/noticePullStatus?projectId=" + projectId + "&remotePort=" + remotePort + "&status=" + status;
        String result = ClientUtil.doPost(url, JSON.toJSONString(new HashMap()), new GatewaySocketCallback(){

            @Override
            public void isSucc(String data) {
                if ("2".equals(status)) {
                    GatewaySocketLogUtil.writeLog("\u52a0\u5bc6\u7f51\u5173\u6210\u529f\u6536\u5230\u62c9\u53d6\u6570\u636e\u7684\u8bf7\u6c42");
                } else if ("3".equals(status)) {
                    GatewaySocketLogUtil.writeLog("\u52a0\u5bc6\u7f51\u5173\u6210\u529f\u6536\u5230\u6570\u636e\u62c9\u53d6\u5b8c\u6210\u7684\u901a\u77e5!\u901a\u77e5\u5185\u5bb9\u4e3a" + data);
                }
            }

            @Override
            public void isFail() {
            }

            @Override
            public void clean() {
                GatewaySocketLogUtil.writeLog("\u5f53\u524d\u5e94\u7528ip\u5728\u767d\u540d\u5355\u5916\uff0c\u52a0\u5bc6\u7f51\u5173\u8981\u6c42\u6e05\u7a7a\u914d\u7f6e");
                CacheFromEncryptionGateway.appUserGlobalOriginalConfig = 0;
                CacheFromEncryptionGateway.gatewayUserOriginalInfos = new ArrayList<UserOriginalVO>();
                CacheFromEncryptionGateway.appUserOriginalInfos = new ArrayList<UserOriginalVO>();
                CacheFromEncryptionGateway.gatewayUserGlobalOriginalConfig = 0;
                EngineUtil.encryptonBeanList.clear();
                EngineUtil.encryptionMap.clear();
            }
        });
        return !"noRefresh".equalsIgnoreCase(result);
    }

    public static boolean checkParameterFlag(String param) {
        String logFlag = CONFIG_PROPERTIES.get(param);
        if (logFlag != null && !"".equals(logFlag) && !"0".equals(logFlag)) {
            return true;
        }
        logFlag = ROOT_CONFIG_PROPERTIES.get(param);
        return logFlag != null && !"".equals(logFlag) && !"0".equals(logFlag);
    }

    public static String getParameterValue(String param) {
        String value;
        if (CONFIG_PROPERTIES.isEmpty() && ROOT_CONFIG_PROPERTIES.isEmpty()) {
            EncryptionGatewayManager.loadProperties();
        }
        if ((value = CONFIG_PROPERTIES.get(param)) != null && !"".equals(value)) {
            return value;
        }
        value = ROOT_CONFIG_PROPERTIES.get(param);
        return value != null && !"".equals(value) ? value : "";
    }

    public static void logDatabaseUrl(String databaseUrl) {
        if (!sendUrl) {
            String projectId = EncryptionGatewayManager.getParameterValue("projectid");
            String remotePort = "";
            remotePort = String.valueOf(ROOT_PORT);
            if (StringUtils.isNotEmpty(EncryptionGatewayManager.getParameterValue("rootport"))) {
                remotePort = EncryptionGatewayManager.getParameterValue("rootport");
            }
            try {
                GatewaySocketLogUtil.writeLog("\u8bb0\u5f55\u7528\u6237\u7684\u6570\u636e\u5e93\u8fde\u63a5url\uff0c\u53c2\u6570\u4e3a\uff1aprojectId=" + projectId + ",remotePort=" + remotePort);
                String url = EncryptionGatewayManager.getParameterValue("gatewayurl") + "/jar_socket_controller/noticePullStatus?projectId=" + projectId + "&remotePort=" + remotePort + "&status=2";
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("databaseUrl", databaseUrl);
                ClientUtil.doPost(url, JSON.toJSONString(param));
            }
            catch (Exception var6) {
                GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f02\u5e38\uff01");
            }
            sendUrl = true;
        }
    }

    public static void logClientError(String errorMsg) {
        long now = System.currentTimeMillis();
        if (lastTime == 0L || now - lastTime <= 10000L) {
            String projectId = EncryptionGatewayManager.getParameterValue("projectid");
            String remotePort = "";
            remotePort = String.valueOf(ROOT_PORT);
            if (StringUtils.isNotEmpty(EncryptionGatewayManager.getParameterValue("rootport"))) {
                remotePort = EncryptionGatewayManager.getParameterValue("rootport");
            }
            try {
                GatewaySocketLogUtil.writeLog("\u8bb0\u5f55\u7528\u6237\u7684\u6570\u636e\u5e93\u8fde\u63a5url\uff0c\u53c2\u6570\u4e3a\uff1aprojectId=" + projectId + ",remotePort=" + remotePort);
                String url = EncryptionGatewayManager.getParameterValue("gatewayurl") + "/jar_socket_controller/noticePullStatus?projectId=" + projectId + "&remotePort=" + remotePort + "&status=2";
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("clientError", errorMsg);
                ClientUtil.doPost(url, JSON.toJSONString(param));
                lastTime = System.currentTimeMillis();
            }
            catch (Exception var8) {
                GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f02\u5e38\uff01");
            }
            sendUrl = true;
        }
    }

    public static void main(String[] args) {
        String[] split;
        String str = "encryption.drivers=";
        for (String var10000 : split = str.split("=")) {
            System.out.println(split.length);
        }
    }

    public static class InnerThread
    extends Thread {
        @Override
        public void run() {
            try {
                while (!StringUtils.isNotEmpty(EncryptionGatewayManager.getParameterValue("rootport"))) {
                    Thread.sleep(100L);
                }
                ROOT_PORT = Integer.parseInt(EncryptionGatewayManager.getParameterValue("rootport"));
                EncryptionGatewayManager.pullTask();
                if (EncryptionGatewayManager.isPullMode()) {
                    EncryptionGatewayManager.scheduledTask();
                } else {
                    NettyStartApplicationRunner.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

