/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.log.access;

import com.palacesun.engine.common.StatementInformation;
import com.palacesun.masking.log.access.AccessLog;
import com.palacesun.masking.log.access.CommonSqlBuffer;
import com.palacesun.masking.log.access.SqlBuffer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import util.SqlUtil;

public class AccessContext {
    private StatementInformation information;
    private AccessLog log;
    private SqlBuffer buffer;
    protected static Logger logger = Logger.getLogger(AccessContext.class.getName());

    public AccessContext() {
        this.log = new AccessLog();
        this.buffer = new CommonSqlBuffer(null);
    }

    public AccessContext(StatementInformation information) {
        this.information = information;
        this.log = new AccessLog();
        this.log.setSql(information.getSql());
        this.buffer = new CommonSqlBuffer(information.getSql());
        if (this.log.getSql() != null) {
            this.setSql(this.log.getSql());
        }
    }

    public void setStatementInfo(StatementInformation information) {
        this.information = information;
        this.log.setSql(information.getSql());
        if (this.log.getSql() != null) {
            this.setSql(this.log.getSql());
        }
    }

    private void setSql(String sql) {
        this.log.setSql(sql);
    }

    public AccessLog getLog() {
        return this.log;
    }

    public SqlBuffer getBuffer() {
        return this.buffer;
    }

    public void log() {
    }

    private Map<String, Object> parse(String sql, String dbType, String schema) throws SQLException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sql", sql);
        params.put("dbType", dbType);
        params.put("schema", schema);
        params.put("encryption", "1");
        params.put("url", this.information.getConnectionInformation().getConnection().getMetaData().getURL());
        SqlUtil sqlUtil = new SqlUtil();
        return sqlUtil.parseSqlStructure(params);
    }

    public String getDbType() {
        String dbType = "mysql";
        try {
            String hiveurl = this.information.getConnectionInformation().getUrl();
            if (hiveurl.toLowerCase().contains("hive")) {
                return "hive";
            }
            String driverName = this.information.getConnectionInformation().getConnection().getMetaData().getDriverName();
            if (driverName.toLowerCase().contains("mysql")) {
                dbType = "mysql";
            } else if (driverName.toLowerCase().contains("oracle")) {
                dbType = "oracle";
            } else if (driverName.toLowerCase().contains("postgresql")) {
                String url = this.information.getConnectionInformation().getConnection().getMetaData().getURL();
                if (url.contains("gauss")) {
                    dbType = "gauss";
                    return dbType;
                }
                if (url.contains("greenplum")) {
                    dbType = "greenplum";
                    return dbType;
                }
                dbType = "postgresql";
            } else if (driverName.toLowerCase().contains("hive")) {
                dbType = "hive";
            } else if (driverName.toLowerCase().contains("hive2")) {
                dbType = "hive";
            } else if (driverName.toLowerCase().contains("dm")) {
                dbType = "dm";
            } else if (driverName.toLowerCase().contains("ibm")) {
                dbType = "db2";
            } else if (driverName.toLowerCase().contains("sql server")) {
                dbType = "sql server";
            } else if (driverName.toLowerCase().contains("kingbase")) {
                dbType = "kingbase";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbType;
    }
}

