/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.palacesun.masking.adapter.StringUtils;
import com.palacesun.masking.tools.ReflectUtil;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class AESUtil {
    private static final String ENCRYPT_ALGO = "AES/GCM/NoPadding";
    private static final byte[] iv = new byte[]{-80, 104, -85, -96, -31, -90, 1, 120, 35, 121, 26, 41};
    public static final int DEF_KEY_SIZE = 128;
    private static final String ALGORITHM_NAME = "AES";
    private static final String ENCODING = "UTF-8";
    private static Properties properties;
    private static String ENCRYPT_LIKE_SPLIT;
    private static String ENCRYPT_LABEL;
    private static final String ENCRYPT_LIKE_OPEN = "1";

    public static String encryptEcb(String encryptKey, String paramStr, String isLike, String keepfirst, String encdigit, String twoindex, String ... encryptMode) throws Exception {
        String encResult;
        byte[] keyBytes = Hex.decode((String)encryptKey);
        String prefix = null;
        String enc = paramStr;
        String suffix = null;
        if (!StringUtils.isBlank(keepfirst)) {
            if (!"0".equals(keepfirst) && !ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                if (!"2".equals(keepfirst)) {
                    return paramStr;
                }
                int first = 0;
                if (StringUtils.isNotBlank(encdigit)) {
                    first = Integer.parseInt(encdigit);
                }
                int last = 0;
                if (StringUtils.isNotBlank(twoindex)) {
                    last = Integer.parseInt(twoindex);
                }
                if (first + last >= paramStr.length() || first >= paramStr.length() || last >= paramStr.length()) {
                    return paramStr;
                }
                prefix = paramStr.substring(0, first);
                enc = paramStr.substring(first, paramStr.length() - last);
                suffix = paramStr.substring(paramStr.length() - last);
            } else if (StringUtils.isNotBlank(encdigit)) {
                if (Integer.parseInt(encdigit) >= paramStr.length()) {
                    return paramStr;
                }
                if (Integer.parseInt(encdigit) != 0) {
                    if ("0".equals(keepfirst)) {
                        prefix = paramStr.substring(0, Integer.parseInt(encdigit));
                        enc = paramStr.substring(Integer.parseInt(encdigit));
                    } else if (ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                        enc = paramStr.substring(0, paramStr.length() - Integer.parseInt(encdigit));
                        suffix = paramStr.substring(paramStr.length() - Integer.parseInt(encdigit));
                    }
                }
            }
        }
        if (ENCRYPT_LIKE_OPEN.equals(isLike)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < enc.length(); ++i) {
                char c = enc.charAt(i);
                byte[] srcData = (c + "").getBytes(ENCODING);
                SecretKeySpec keySpec = new SecretKeySpec(keyBytes, ALGORITHM_NAME);
                Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
                cipher.init(1, (Key)keySpec, (AlgorithmParameterSpec)new AEADParameterSpec(iv, 128));
                byte[] ciphertext = cipher.doFinal(srcData);
                String s = Hex.toHexString((byte[])ciphertext);
                sb.append(s).append(ENCRYPT_LIKE_SPLIT);
            }
            encResult = sb.deleteCharAt(sb.length() - 1).toString();
        } else {
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, ALGORITHM_NAME);
            Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
            cipher.init(1, (Key)keySpec, (AlgorithmParameterSpec)new AEADParameterSpec(iv, 128));
            byte[] ciphertext = cipher.doFinal(enc.getBytes(ENCODING));
            encResult = Hex.toHexString((byte[])ciphertext);
        }
        if ("0".equals(keepfirst) && null != prefix) {
            encResult = prefix + encResult;
        } else if (ENCRYPT_LIKE_OPEN.equals(keepfirst) && null != suffix) {
            encResult = encResult + suffix;
        } else if ("2".equals(keepfirst)) {
            if (null != prefix) {
                encResult = prefix + encResult;
            }
            if (null != suffix) {
                encResult = encResult + suffix;
            }
        }
        return encResult;
    }

    public static String decryptEcb(String decryptKey, String paramStr, String isLike, String keepfirst, String encdigit, String twoindex, String ... encryptMode) throws Exception {
        String encResult;
        byte[] keyBytes = Hex.decode((String)decryptKey);
        String prefix = null;
        String enc = paramStr;
        String suffix = null;
        if (!StringUtils.isBlank(keepfirst)) {
            if (!"0".equals(keepfirst) && !ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                if ("2".equals(keepfirst)) {
                    int first = 0;
                    if (StringUtils.isNotBlank(encdigit)) {
                        first = Integer.parseInt(encdigit);
                    }
                    int last = 0;
                    if (StringUtils.isNotBlank(twoindex)) {
                        last = Integer.parseInt(twoindex);
                    }
                    if (first + last >= paramStr.length() || first >= paramStr.length() || last >= paramStr.length()) {
                        return paramStr;
                    }
                    prefix = paramStr.substring(0, first);
                    enc = paramStr.substring(first, paramStr.length() - last);
                    suffix = paramStr.substring(paramStr.length() - last);
                }
            } else if (StringUtils.isNotBlank(encdigit)) {
                if (Integer.parseInt(encdigit) >= paramStr.length()) {
                    return paramStr;
                }
                if (Integer.parseInt(encdigit) != 0) {
                    if ("0".equals(keepfirst)) {
                        prefix = paramStr.substring(0, Integer.parseInt(encdigit));
                        enc = paramStr.substring(Integer.parseInt(encdigit));
                    } else if (ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                        enc = paramStr.substring(0, paramStr.length() - Integer.parseInt(encdigit));
                        suffix = paramStr.substring(paramStr.length() - Integer.parseInt(encdigit));
                    }
                }
            }
        }
        if (ENCRYPT_LIKE_OPEN.equals(isLike)) {
            String[] split;
            StringBuilder sb = new StringBuilder();
            for (String s : split = enc.split(ENCRYPT_LIKE_SPLIT)) {
                try {
                    byte[] encryptBytes = Hex.decode((String)s);
                    SecretKeySpec keySpec = new SecretKeySpec(keyBytes, ALGORITHM_NAME);
                    Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
                    cipher.init(2, (Key)keySpec, (AlgorithmParameterSpec)new AEADParameterSpec(iv, 128));
                    byte[] decryptedData = cipher.doFinal(encryptBytes);
                    sb.append(new String(decryptedData, ENCODING));
                }
                catch (Exception var22) {
                    return ENCRYPT_LABEL + paramStr;
                }
            }
            encResult = sb.toString();
        } else {
            byte[] encryptBytes = Hex.decode((String)enc);
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, ALGORITHM_NAME);
            Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
            cipher.init(2, (Key)keySpec, (AlgorithmParameterSpec)new AEADParameterSpec(iv, 128));
            byte[] decryptedData = cipher.doFinal(encryptBytes);
            encResult = new String(decryptedData, ENCODING);
        }
        if ("0".equals(keepfirst) && null != prefix) {
            encResult = prefix + encResult;
        } else if (ENCRYPT_LIKE_OPEN.equals(keepfirst) && null != suffix) {
            encResult = encResult + suffix;
        } else if ("2".equals(keepfirst)) {
            if (null != prefix) {
                encResult = prefix + encResult;
            }
            if (null != suffix) {
                encResult = encResult + suffix;
            }
        }
        return encResult;
    }

    public static String generaKey() throws Exception {
        return Hex.toHexString((byte[])AESUtil.generaKey(128));
    }

    public static byte[] generaKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME);
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    public static void main(String[] args) throws Exception {
        String key = AESUtil.generaKey();
        System.out.println(key);
        String data = "~\u8fd9\u662fyuanshi\u7684\u660e\u6587xinxi\u5728\u8fd9\u91cc\u5462,1\u3002";
        System.out.println(data);
        String encrypt = AESUtil.encryptEcb(key, data, ENCRYPT_LIKE_OPEN, "0", "3", "0", new String[0]);
        System.out.println(encrypt);
        String decrypt = AESUtil.decryptEcb(key, encrypt, ENCRYPT_LIKE_OPEN, "0", "3", "0", new String[0]);
        System.out.println(decrypt);
        System.out.println(data.equals(decrypt));
        encrypt = ReflectUtil.engine(ALGORITHM_NAME, data, key, ENCRYPT_LIKE_OPEN, "0", "3", "0", true, null);
        System.out.println(encrypt);
        decrypt = ReflectUtil.engine(ALGORITHM_NAME, encrypt, key, ENCRYPT_LIKE_OPEN, "0", "3", "0", false, null);
        System.out.println(decrypt);
        System.out.println(data.equals(decrypt));
    }

    static {
        ENCRYPT_LIKE_SPLIT = EncryptionGatewayManager.getParameterValue("encryption.like.split");
        ENCRYPT_LABEL = EncryptionGatewayManager.getParameterValue("encryption.label");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

