/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools;

import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Sm4FPEUtil {
    static char[] usual;
    static String ln;
    static int r;
    static HashMap map;
    static HashMap map2;

    public static String generateKey() {
        Random random = new Random();
        byte[] keys = new byte[(r - 1) * 16];
        random.nextBytes(keys);
        return Hex.encodeHexString((byte[])keys);
    }

    static byte[][] upk(String encKey) throws DecoderException {
        byte[] keys = Hex.decodeHex((String)encKey);
        byte[][] key = new byte[r - 1][16];
        for (int i = 0; i < keys.length; ++i) {
            key[i / Sm4FPEUtil.r][i % Sm4FPEUtil.r] = keys[i];
        }
        return key;
    }

    public static String encryptEcb(String hexKey, String a) throws Exception {
        int m = a.length();
        int[] P_length = new int[m];
        int[] Y = new int[m];
        int[] S = new int[m];
        P_length[0] = 3;
        Y[0] = 0;
        S[0] = ln.length();
        for (int i = 1; i < m; ++i) {
            P_length[i] = 4;
            Y[i] = 0;
            S[i] = usual.length;
        }
        byte[][] key = Sm4FPEUtil.upk(hexKey);
        String in = "";
        in = in + Sm4FPEUtil.expand(Integer.toString((Integer)map2.get(Character.valueOf(a.charAt(0)))), P_length[0]);
        for (int i = 1; i < m; ++i) {
            in = in + Sm4FPEUtil.expand(Integer.toString((Integer)map.get(Character.valueOf(a.charAt(i)))), P_length[i]);
        }
        String[] P = new String[m];
        int begin = 0;
        for (int i = 0; i < m; ++i) {
            P[i] = in.substring(begin, begin + P_length[i]);
            begin += P_length[i];
        }
        String out = Sm4FPEUtil.Feistel(m, P, key, P_length, S, Y, true);
        begin = 0;
        String out4 = "";
        for (int i = 0; i < m; ++i) {
            String tmp = out.substring(begin, begin + P_length[i]);
            out4 = i == 0 ? out4 + ln.charAt(Integer.parseInt(tmp)) : out4 + usual[Integer.parseInt(tmp)];
            begin += P_length[i];
        }
        return out4;
    }

    public static void main(String[] args) throws Exception {
        String key1 = Sm4FPEUtil.generateKey();
        String key = "00c0692decd159fea54033c4279562c496353addae40b8bc566547085e117e68ca54fe34c0b9766795e32bf0ad9308aabe16bc12fd1c523449b97045d711bcefa7266bfe634e19d528b954fbef6a97bcd586603fc11074e45a61dedd2e2379a5f0016173ae57302d5cf8588a068989e083ec9282bd44be9927148c50769779dabefa0b28ee4352cf90efc1b89f291d68772e407f66fba7f3f13113ed98533cf4722163576202d804090db5627df4e00ae12f1d3769935ddb20d57034ced522ca2d470a81c1ad88366f773a68f5ebc58df65c9094235a6c96bd724d39288c23f458d2f7e2b106209b4d368ebc71ab1089";
        String x = Sm4FPEUtil.encryptEcb(key, "\u5f20\u4e09\u98ce");
        System.out.println(x);
        String y = Sm4FPEUtil.decryptEcb(key, x);
        System.out.println(y);
    }

    public static String decryptEcb(String hexKey, String out4) throws Exception {
        int m = out4.length();
        int[] P_length = new int[m];
        int[] Y = new int[m];
        int[] S = new int[m];
        P_length[0] = 3;
        Y[0] = 0;
        S[0] = ln.length();
        for (int i = 1; i < m; ++i) {
            P_length[i] = 4;
            Y[i] = 0;
            S[i] = usual.length;
        }
        int begin = 0;
        String out = "";
        for (int i = 0; i < m; ++i) {
            char tmp = out4.charAt(i);
            if (i == 0) {
                int i1 = ln.indexOf(tmp);
                out = out + i1;
                continue;
            }
            out = out + String.format("%04d", map.get(Character.valueOf(tmp))) + "";
        }
        byte[][] key = Sm4FPEUtil.upk(hexKey);
        String[] Q = new String[m];
        byte[][] key2 = new byte[r - 1][16];
        for (int i = 0; i < m; ++i) {
            Q[i] = out.substring(begin, begin + P_length[i]);
            begin += P_length[i];
        }
        for (int var21 = 0; var21 < r - 1; ++var21) {
            key2[var21] = key[r - 1 - var21 - 1];
        }
        String out2 = Sm4FPEUtil.Feistel(m, Q, key2, P_length, S, Y, false);
        String out3 = "";
        begin = 0;
        for (int k = 0; k < m; ++k) {
            String tmp = out2.substring(begin, begin + P_length[k]);
            out3 = k == 0 ? out3 + ln.charAt(Integer.parseInt(tmp)) : out3 + usual[Integer.parseInt(tmp)];
            begin += P_length[k];
        }
        return out3;
    }

    static String PRF(byte[] k, String T, int r) throws Exception {
        Cipher sm4 = Cipher.getInstance("sm4/ecb/pkcs5padding", "BC");
        SecretKeySpec sm4key = new SecretKeySpec(k, "SM4");
        sm4.init(1, sm4key);
        byte[] enc = sm4.doFinal(T.getBytes());
        String ret = Sm4FPEUtil.trunc(enc, r);
        return ret;
    }

    static String trunc(byte[] in, int r) {
        String tmp = Hex.encodeHexString((byte[])in);
        String ret = tmp.substring(0, r);
        return ret;
    }

    static String expand(String a, int b) {
        while (a.length() < b) {
            a = '0' + a;
        }
        return a;
    }

    static String Feistel(int m, String[] P, byte[][] key, int[] P_length, int[] S, int[] Y, boolean enc) throws Exception {
        int flag = 1;
        if (!enc) {
            flag = -1;
        }
        int totalLength = 0;
        String[] L = new String[m / 2];
        String[] R = new String[m - m / 2];
        for (int i = 0; i < P.length; ++i) {
            totalLength += P[i].length();
            if (i < m / 2) {
                L[i] = P[i];
                continue;
            }
            R[i - m / 2] = P[i];
        }
        for (int var24 = 1; var24 <= r; ++var24) {
            if (var24 == r && var24 % 2 == 0) {
                String[] t = (String[])L.clone();
                L = R;
                R = t;
                continue;
            }
            String RString = "";
            for (int RLength = 0; RLength < R.length; ++RLength) {
                RString = RString + R[RLength];
            }
            int var27 = RString.length();
            int LLength = totalLength - var27;
            int loc = (var24 - 1) % 2 * (m / 2);
            String[] LTmp = (String[])R.clone();
            String[] RTmp = new String[L.length];
            String tmp = Sm4FPEUtil.PRF(key[var24 - 1], RString, LLength);
            int begin = 0;
            for (int j = 0; j < L.length; ++j) {
                int a = Integer.parseInt(L[j]);
                String b = tmp.substring(begin, begin + L[j].length());
                if (b.length() % 2 == 1) {
                    b = '0' + b;
                }
                tmp.substring(begin, begin + L[j].length());
                begin += L[j].length();
                int c = new BigInteger(1, Hex.decodeHex((char[])b.toCharArray())).intValue();
                RTmp[j] = Integer.toString(Y[loc + j] + (a - Y[loc + j] + flag * c % S[loc + j] + S[loc + j]) % S[loc + j]);
                RTmp[j] = Sm4FPEUtil.expand(RTmp[j], P_length[loc + j]);
            }
            L = LTmp;
            R = RTmp;
        }
        String ret = "";
        for (int k = 0; k < m; ++k) {
            ret = k < m / 2 ? ret + Sm4FPEUtil.expand(L[k], P_length[k]) : ret + Sm4FPEUtil.expand(R[k - m / 2], P_length[k]);
        }
        return ret;
    }

    static {
        int i;
        r = 16;
        Security.addProvider((Provider)new BouncyCastleProvider());
        usual = new char[]{'\u963f', '\u554a', '\u54c0', '\u5509', '\u6328', '\u77ee', '\u7231', '\u788d', '\u5b89', '\u5cb8', '\u6309', '\u6848', '\u6697', '\u6602', '\u8884', '\u50b2', '\u5965', '\u516b', '\u5df4', '\u6252', '\u5427', '\u75a4', '\u62d4', '\u628a', '\u575d', '\u7238', '\u7f62', '\u9738', '\u767d', '\u767e', '\u67cf', '\u6446', '\u8d25', '\u62dc', '\u73ed', '\u822c', '\u6591', '\u642c', '\u677f', '\u7248', '\u5427', '\u75a4', '\u62d4', '\u628a', '\u575d', '\u7238', '\u7f62', '\u9738', '\u767d', '\u767e', '\u67cf', '\u6446', '\u8d25', '\u62dc', '\u73ed', '\u822c', '\u6591', '\u642c', '\u677f', '\u7248', '\u529e', '\u534a', '\u4f34', '\u626e', '\u62cc', '\u74e3', '\u5e2e', '\u7ed1', '\u699c', '\u8180', '\u508d', '\u68d2', '\u5305', '\u80de', '\u96f9', '\u5b9d', '\u9971', '\u4fdd', '\u5821', '\u62a5', '\u62b1', '\u66b4', '\u7206', '\u676f', '\u60b2', '\u7891', '\u5317', '\u8d1d', '\u5907', '\u80cc', '\u500d', '\u88ab', '\u8f88', '\u5954', '\u672c', '\u7b28', '\u8e66', '\u903c', '\u9f3b', '\u6bd4', '\u5f7c', '\u7b14', '\u9119', '\u5e01', '\u5fc5', '\u6bd5', '\u95ed', '\u6bd9', '\u5f0a', '\u78a7', '\u853d', '\u58c1', '\u907f', '\u81c2', '\u8fb9', '\u7f16', '\u97ad', '\u6241', '\u4fbf', '\u53d8', '\u904d', '\u8fa8', '\u8fa9', '\u8fab', '\u6807', '\u8868', '\u522b', '\u5bbe', '\u6ee8', '\u51b0', '\u5175', '\u4e19', '\u67c4', '\u997c', '\u5e76', '\u75c5', '\u62e8', '\u6ce2', '\u73bb', '\u5265', '\u8116', '\u83e0', '\u64ad', '\u4f2f', '\u9a73', '\u6cca', '\u535a', '\u640f', '\u818a', '\u8584', '\u535c', '\u8865', '\u6355', '\u4e0d', '\u5e03', '\u6b65', '\u6016', '\u90e8', '\u64e6', '\u731c', '\u624d', '\u6750', '\u8d22', '\u88c1', '\u91c7', '\u5f69', '\u776c', '\u8e29', '\u83dc', '\u53c2', '\u9910', '\u6b8b', '\u8695', '\u60ed', '\u60e8', '\u707f', '\u4ed3', '\u82cd', '\u8231', '\u85cf', '\u64cd', '\u69fd', '\u8349', '\u518c', '\u4fa7', '\u5395', '\u6d4b', '\u7b56', '\u5c42', '\u53c9', '\u63d2', '\u67e5', '\u8336', '\u5bdf', '\u5c94', '\u5dee', '\u62c6', '\u67f4', '\u998b', '\u7f20', '\u4ea7', '\u94f2', '\u98a4', '\u660c', '\u957f', '\u80a0', '\u5c1d', '\u507f', '\u5e38', '\u5382', '\u573a', '\u655e', '\u7545', '\u5021', '\u5531', '\u6284', '\u949e', '\u8d85', '\u671d', '\u6f6e', '\u5435', '\u7092', '\u8f66', '\u626f', '\u5f7b', '\u64a4', '\u5c18', '\u81e3', '\u6c89', '\u8fb0', '\u9648', '\u6668', '\u95ef', '\u886c', '\u79f0', '\u8d81', '\u6491', '\u6210', '\u5448', '\u627f', '\u6c60', '\u5319', '\u5c3a', '\u9f7f', '\u803b', '\u65a5', '\u8d64', '\u7fc5', '\u5145', '\u51b2', '\u8bda', '\u57ce', '\u4e58', '\u60e9', '\u7a0b', '\u79e4', '\u5403', '\u9a70', '\u8fdf', '\u6301', '\u81ed', '\u51fa', '\u521d', '\u9664', '\u53a8', '\u9504', '\u7840', '\u50a8', '\u695a', '\u5904', '\u866b', '\u5d07', '\u62bd', '\u4ec7', '\u7ef8', '\u6101', '\u7a20', '\u7b79', '\u916c', '\u4e11', '\u89e6', '\u755c', '\u5ddd', '\u7a7f', '\u4f20', '\u8239', '\u5598', '\u4e32', '\u75ae', '\u7a97', '\u5e8a', '\u521b', '\u5439', '\u708a', '\u5782', '\u9524', '\u6625', '\u7eaf', '\u5507', '\u8822', '\u806a', '\u4e1b', '\u51d1', '\u7c97', '\u4fc3', '\u918b', '\u7a9c', '\u50ac', '\u6467', '\u8106', '\u8bcd', '\u6148', '\u8f9e', '\u78c1', '\u6b64', '\u6b21', '\u523a', '\u4ece', '\u5306', '\u8471', '\u5927', '\u5446', '\u4ee3', '\u5e26', '\u5f85', '\u6020', '\u8d37', '\u888b', '\u902e', '\u6234', '\u7fe0', '\u6751', '\u5b58', '\u5bf8', '\u9519', '\u66fe', '\u642d', '\u8fbe', '\u7b54', '\u6253', '\u86cb', '\u5f53', '\u6321', '\u515a', '\u8361', '\u6863', '\u5200', '\u53e8', '\u5bfc', '\u5c9b', '\u4e39', '\u5355', '\u62c5', '\u803d', '\u80c6', '\u65e6', '\u4f46', '\u8bde', '\u5f39', '\u6de1', '\u5012', '\u8e48', '\u5230', '\u60bc', '\u76d7', '\u9053', '\u7a3b', '\u5f97', '\u5fb7', '\u7684', '\u706f', '\u767b', '\u7b49', '\u51f3', '\u4f4e', '\u5824', '\u6ef4', '\u654c', '\u7b1b', '\u5e95', '\u62b5', '\u5730', '\u5f1f', '\u5e1d', '\u9012', '\u7b2c', '\u98a0', '\u5178', '\u70b9', '\u7535', '\u5e97', '\u57ab', '\u6bbf', '\u53fc', '\u96d5', '\u540a', '\u9493', '\u8c03', '\u6389', '\u7239', '\u8dcc', '\u53e0', '\u8776', '\u4e01', '\u53ee', '\u76ef', '\u9489', '\u9876', '\u8ba2', '\u5b9a', '\u4e22', '\u4e1c', '\u51ac', '\u8463', '\u61c2', '\u52a8', '\u51bb', '\u680b', '\u6d1e', '\u90fd', '\u6597', '\u6296', '\u9661', '\u8c46', '\u9017', '\u7763', '\u6bd2', '\u8bfb', '\u72ec', '\u5835', '\u8d4c', '\u675c', '\u809a', '\u5ea6', '\u6e21', '\u7aef', '\u77ed', '\u6bb5', '\u65ad', '\u7f0e', '\u6735', '\u8eb2', '\u60f0', '\u9e45', '\u86fe', '\u989d', '\u6076', '\u997f', '\u6069', '\u513f', '\u953b', '\u5806', '\u961f', '\u5bf9', '\u5428', '\u8e72', '\u76fe', '\u987f', '\u591a', '\u593a', '\u800c', '\u8033', '\u4e8c', '\u53d1', '\u4e4f', '\u4f10', '\u7f5a', '\u9600', '\u6cd5', '\u5e06', '\u756a', '\u7ffb', '\u51e1', '\u70e6', '\u7e41', '\u53cd', '\u8fd4', '\u72af', '\u6cdb', '\u996d', '\u8303', '\u8d29', '\u65b9', '\u574a', '\u82b3', '\u9632', '\u59a8', '\u623f', '\u4eff', '\u8bbf', '\u7eba', '\u653e', '\u98de', '\u975e', '\u80a5', '\u532a', '\u5e9f', '\u6cb8', '\u80ba', '\u8d39', '\u5206', '\u5429', '\u7eb7', '\u82ac', '\u575f', '\u7c89', '\u4efd', '\u594b', '\u6124', '\u7caa', '\u4e30', '\u98ce', '\u5c01', '\u75af', '\u5cf0', '\u950b', '\u8702', '\u9022', '\u7f1d', '\u8bbd', '\u51e4', '\u5949', '\u4f5b', '\u5426', '\u592b', '\u80a4', '\u4f0f', '\u6276', '\u670d', '\u4fd8', '\u6d6e', '\u7b26', '\u5e45', '\u798f', '\u629a', '\u5e9c', '\u65a7', '\u4fef', '\u8f85', '\u8150', '\u7236', '\u4ed8', '\u5987', '\u8d1f', '\u9644', '\u5490', '\u590d', '\u8d74', '\u526f', '\u5085', '\u5bcc', '\u8179', '\u8986', '\u8be5', '\u6539', '\u76d6', '\u6e89', '\u6982', '\u5e72', '\u7518', '\u7eb2', '\u7f38', '\u94a2', '\u6e2f', '\u6760', '\u9ad8', '\u818f', '\u7cd5', '\u641e', '\u7a3f', '\u6746', '\u809d', '\u7aff', '\u79c6', '\u8d76', '\u6562', '\u611f', '\u5188', '\u521a', '\u5c97', '\u845b', '\u9694', '\u4e2a', '\u5404', '\u7ed9', '\u6839', '\u8ddf', '\u66f4', '\u8015', '\u5de5', '\u544a', '\u54e5', '\u80f3', '\u9e3d', '\u5272', '\u6401', '\u6b4c', '\u9601', '\u9769', '\u683c', '\u5f13', '\u516c', '\u529f', '\u653b', '\u4f9b', '\u5bab', '\u606d', '\u8eac', '\u5de9', '\u5171', '\u8d21', '\u52fe', '\u6c9f', '\u94a9', '\u72d7', '\u6784', '\u8d2d', '\u591f', '\u4f30', '\u59d1', '\u5b64', '\u8f9c', '\u53e4', '\u8c37', '\u80a1', '\u9aa8', '\u9f13', '\u56fa', '\u6545', '\u987e', '\u74dc', '\u522e', '\u6302', '\u4e56', '\u62d0', '\u602a', '\u5173', '\u89c2', '\u5b98', '\u51a0', '\u9986', '\u7ba1', '\u8d2f', '\u60ef', '\u704c', '\u7f50', '\u5149', '\u5e7f', '\u5f52', '\u9f9f', '\u89c4', '\u8f68', '\u9b3c', '\u67dc', '\u8d35', '\u6842', '\u8dea', '\u6eda', '\u68cd', '\u9505', '\u56fd', '\u679c', '\u88f9', '\u8fc7', '\u54c8', '\u5b69', '\u6d77', '\u5bb3', '\u542b', '\u5bd2', '\u558a', '\u6c49', '\u6c57', '\u65f1', '\u822a', '\u6beb', '\u8c6a', '\u597d', '\u53f7', '\u6d69', '\u8d3a', '\u9ed1', '\u75d5', '\u5f88', '\u72e0', '\u6068', '\u6052', '\u6a2a', '\u8861', '\u8f70', '\u8017', '\u559d', '\u79be', '\u5408', '\u4f55', '\u548c', '\u6cb3', '\u6838', '\u8377', '\u76d2', '\u54c4', '\u70d8', '\u7ea2', '\u5b8f', '\u6d2a', '\u8679', '\u5589', '\u7334', '\u543c', '\u540e', '\u539a', '\u5019', '\u4e4e', '\u547c', '\u5ffd', '\u72d0', '\u80e1', '\u58f6', '\u6e56', '\u7cca', '\u5316', '\u5212', '\u753b', '\u8bdd', '\u6000', '\u69d0', '\u574f', '\u6b22', '\u8fd8', '\u73af', '\u8774', '\u864e', '\u4e92', '\u6237', '\u62a4', '\u82b1', '\u534e', '\u54d7', '\u6ed1', '\u733e', '\u6643', '\u8c0e', '\u7070', '\u6062', '\u6325', '\u8f89', '\u56de', '\u6094', '\u6c47', '\u4f1a', '\u7f13', '\u5e7b', '\u5524', '\u6362', '\u60a3', '\u8352', '\u614c', '\u7687', '\u9ec4', '\u714c', '\u6d3b', '\u706b', '\u4f19', '\u6216', '\u8d27', '\u83b7', '\u7978', '\u60d1', '\u51fb', '\u9965', '\u7ed8', '\u8d3f', '\u60e0', '\u6bc1', '\u6167', '\u660f', '\u5a5a', '\u6d51', '\u9b42', '\u6df7', '\u5409', '\u7ea7', '\u5373', '\u6781', '\u6025', '\u75be', '\u96c6', '\u7c4d', '\u51e0', '\u5df1', '\u573e', '\u673a', '\u808c', '\u9e21', '\u8ff9', '\u79ef', '\u57fa', '\u7ee9', '\u6fc0', '\u53ca', '\u65e2', '\u6d4e', '\u7ee7', '\u5bc4', '\u52a0', '\u5939', '\u4f73', '\u5bb6', '\u5609', '\u7532', '\u6324', '\u810a', '\u8ba1', '\u8bb0', '\u7eaa', '\u5fcc', '\u6280', '\u9645', '\u5242', '\u5b63', '\u95f4', '\u80a9', '\u8270', '\u517c', '\u76d1', '\u714e', '\u62e3', '\u4fed', '\u8327', '\u6361', '\u4ef7', '\u9a7e', '\u67b6', '\u5047', '\u5ac1', '\u7a3c', '\u5978', '\u5c16', '\u575a', '\u6b7c', '\u5065', '\u8230', '\u6e10', '\u8df5', '\u9274', '\u952e', '\u7bad', '\u6c5f', '\u59dc', '\u5c06', '\u51cf', '\u526a', '\u68c0', '\u7b80', '\u89c1', '\u4ef6', '\u5efa', '\u5251', '\u8350', '\u8d31', '\u90ca', '\u5a07', '\u6d47', '\u9a84', '\u80f6', '\u6912', '\u7126', '\u8549', '\u89d2', '\u72e1', '\u6d46', '\u50f5', '\u7586', '\u8bb2', '\u5956', '\u6868', '\u5320', '\u964d', '\u9171', '\u4ea4', '\u7686', '\u63a5', '\u63ed', '\u8857', '\u8282', '\u52ab', '\u6770', '\u6d01', '\u7ed3', '\u6377', '\u7ede', '\u997a', '\u811a', '\u6405', '\u7f34', '\u53eb', '\u8f7f', '\u8f83', '\u6559', '\u9636', '\u4eca', '\u65a4', '\u91d1', '\u6d25', '\u7b4b', '\u4ec5', '\u7d27', '\u8c28', '\u9526', '\u5c3d', '\u622a', '\u7aed', '\u59d0', '\u89e3', '\u4ecb', '\u6212', '\u5c4a', '\u754c', '\u501f', '\u5dfe', '\u6676', '\u775b', '\u7cbe', '\u4e95', '\u9888', '\u666f', '\u8b66', '\u51c0', '\u5f84', '\u7ade', '\u52b2', '\u8fd1', '\u8fdb', '\u664b', '\u6d78', '\u7981', '\u4eac', '\u7ecf', '\u830e', '\u60ca', '\u9152', '\u65e7', '\u6551', '\u5c31', '\u8205', '\u5c45', '\u62d8', '\u97a0', '\u5c40', '\u83ca', '\u7adf', '\u656c', '\u5883', '\u9759', '\u955c', '\u7ea0', '\u7a76', '\u63ea', '\u4e5d', '\u4e45', '\u6a58', '\u4e3e', '\u77e9', '\u53e5', '\u5de8', '\u62d2', '\u5177', '\u4ff1', '\u5267', '\u60e7', '\u636e', '\u8ddd', '\u952f', '\u805a', '\u6350', '\u5377', '\u5026', '\u7ee2', '\u51b3', '\u7edd', '\u89c9', '\u6398', '\u56bc', '\u519b', '\u541b', '\u5747', '\u83cc', '\u4fca', '\u5361', '\u5f00', '\u51ef', '\u6168', '\u520a', '\u582a', '\u780d', '\u770b', '\u5eb7', '\u7ce0', '\u625b', '\u6297', '\u7095', '\u8003', '\u70e4', '\u9760', '\u79d1', '\u68f5', '\u9897', '\u58f3', '\u54b3', '\u53ef', '\u6e34', '\u514b', '\u523b', '\u5ba2', '\u8bfe', '\u80af', '\u57a6', '\u6073', '\u5751', '\u7a7a', '\u5b54', '\u6050', '\u63a7', '\u53e3', '\u6263', '\u5bc7', '\u67af', '\u54ed', '\u82e6', '\u5e93', '\u88e4', '\u9177', '\u5938', '\u57ae', '\u630e', '\u8de8', '\u5757', '\u5feb', '\u5bbd', '\u6b3e', '\u7b50', '\u72c2', '\u51b5', '\u65f7', '\u77ff', '\u6846', '\u4e8f', '\u8475', '\u6127', '\u6606', '\u6346', '\u56f0', '\u6269', '\u62ec', '\u9614', '\u5783', '\u62c9', '\u5566', '\u5587', '\u814a', '\u61d2', '\u70c2', '\u6ee5', '\u90ce', '\u72fc', '\u5eca', '\u6717', '\u6d6a', '\u635e', '\u52b3', '\u8721', '\u8fa3', '\u6765', '\u8d56', '\u5170', '\u62e6', '\u680f', '\u84dd', '\u7bee', '\u89c8', '\u7d2f', '\u51b7', '\u5398', '\u68a8', '\u72f8', '\u79bb', '\u7281', '\u9e42', '\u7483', '\u9ece', '\u7262', '\u8001', '\u59e5', '\u6d9d', '\u4e50', '\u52d2', '\u96f7', '\u5792', '\u6cea', '\u7c7b', '\u52b1', '\u4f8b', '\u96b6', '\u6817', '\u7c92', '\u4fe9', '\u8fde', '\u5e18', '\u601c', '\u83b2', '\u793c', '\u674e', '\u91cc', '\u7406', '\u529b', '\u5386', '\u5389', '\u7acb', '\u4e3d', '\u5229', '\u6881', '\u7cae', '\u7cb1', '\u4e24', '\u4eae', '\u8c05', '\u8f86', '\u91cf', '\u8fbd', '\u7597', '\u8054', '\u5ec9', '\u9570', '\u8138', '\u7ec3', '\u70bc', '\u604b', '\u94fe', '\u826f', '\u51c9', '\u4e34', '\u6dcb', '\u4f36', '\u7075', '\u5cad', '\u94c3', '\u9675', '\u96f6', '\u9f84', '\u9886', '\u50da', '\u4e86', '\u6599', '\u5217', '\u52a3', '\u70c8', '\u730e', '\u88c2', '\u90bb', '\u6797', '\u7b3c', '\u804b', '\u9686', '\u5784', '\u62e2', '\u697c', '\u6402', '\u6f0f', '\u9732', '\u82a6', '\u4ee4', '\u53e6', '\u6e9c', '\u5218', '\u6d41', '\u7559', '\u69b4', '\u67f3', '\u516d', '\u9f99', '\u65c5', '\u5c61', '\u5f8b', '\u8651', '\u7387', '\u7eff', '\u5375', '\u4e71', '\u63a0', '\u7565', '\u7089', '\u864f', '\u9c81', '\u9646', '\u5f55', '\u9e7f', '\u6ee4', '\u788c', '\u8def', '\u9a74', '\u843d', '\u5988', '\u9ebb', '\u9a6c', '\u7801', '\u8682', '\u9a82', '\u5417', '\u57cb', '\u4e70', '\u8f6e', '\u8bba', '\u7f57', '\u841d', '\u9523', '\u7ba9', '\u9aa1', '\u87ba', '\u7edc', '\u9a86', '\u5fd9', '\u8292', '\u76f2', '\u832b', '\u732b', '\u6bdb', '\u77db', '\u8305', '\u8302', '\u5192', '\u8fc8', '\u9ea6', '\u5356', '\u8109', '\u86ee', '\u9992', '\u7792', '\u6ee1', '\u6162', '\u6f2b', '\u7f8e', '\u59b9', '\u95e8', '\u95f7', '\u4eec', '\u840c', '\u76df', '\u731b', '\u8499', '\u5b5f', '\u8d38', '\u5e3d', '\u8c8c', '\u4e48', '\u6ca1', '\u7709', '\u6885', '\u7164', '\u9709', '\u6bcf', '\u68c9', '\u514d', '\u52c9', '\u9762', '\u82d7', '\u63cf', '\u79d2', '\u5999', '\u5e99', '\u706d', '\u68a6', '\u8ff7', '\u8c1c', '\u7c73', '\u772f', '\u79d8', '\u5bc6', '\u871c', '\u7720', '\u7ef5', '\u6469', '\u78e8', '\u9b54', '\u62b9', '\u672b', '\u6cab', '\u83ab', '\u6f20', '\u58a8', '\u9ed8', '\u8511', '\u6c11', '\u654f', '\u540d', '\u660e', '\u9e23', '\u547d', '\u6478', '\u6a21', '\u819c', '\u66ae', '\u62ff', '\u54ea', '\u5185', '\u90a3', '\u7eb3', '\u4e43', '\u5976', '\u8010', '\u7537', '\u8c0b', '\u67d0', '\u6bcd', '\u4ea9', '\u6728', '\u76ee', '\u7267', '\u5893', '\u5e55', '\u6155', '\u5c3c', '\u6ce5', '\u4f60', '\u9006', '\u5e74', '\u5ff5', '\u5a18', '\u917f', '\u9e1f', '\u5c3f', '\u5357', '\u96be', '\u56ca', '\u6320', '\u607c', '\u8111', '\u95f9', '\u5462', '\u5ae9', '\u80fd', '\u5974', '\u52aa', '\u6012', '\u5973', '\u6696', '\u632a', '\u6b27', '\u5076', '\u8f9f', '\u8db4', '\u634f', '\u60a8', '\u5b81', '\u51dd', '\u725b', '\u626d', '\u7ebd', '\u519c', '\u6d53', '\u5f04', '\u4e53', '\u65c1', '\u80d6', '\u629b', '\u70ae', '\u888d', '\u8dd1', '\u6ce1', '\u966a', '\u57f9', '\u722c', '\u6015', '\u62cd', '\u724c', '\u6d3e', '\u6500', '\u76d8', '\u5224', '\u53db', '\u76fc', '\u78b0', '\u6279', '\u62ab', '\u5288', '\u76ae', '\u75b2', '\u813e', '\u5339', '\u50fb', '\u7247', '\u8d54', '\u4f69', '\u914d', '\u55b7', '\u76c6', '\u670b', '\u68da', '\u84ec', '\u81a8', '\u6367', '\u4e52', '\u5e73', '\u8bc4', '\u51ed', '\u82f9', '\u74f6', '\u840d', '\u5761', '\u6cfc', '\u5a46', '\u504f', '\u7bc7', '\u9a97', '\u6f02', '\u98d8', '\u7968', '\u6487', '\u62fc', '\u8d2b', '\u54c1', '\u8c31', '\u4e03', '\u59bb', '\u621a', '\u671f', '\u6b3a', '\u6f06', '\u9f50', '\u5176', '\u5947', '\u8feb', '\u7834', '\u9b44', '\u5256', '\u4ec6', '\u6251', '\u94fa', '\u8461', '\u6734', '\u666e', '\u6c7d', '\u780c', '\u5668', '\u6070', '\u6d3d', '\u5343', '\u8fc1', '\u7275', '\u94c5', '\u8c26', '\u9a91', '\u68cb', '\u65d7', '\u4e5e', '\u4f01', '\u5c82', '\u542f', '\u8d77', '\u6c14', '\u5f03', '\u8154', '\u5f3a', '\u5899', '\u62a2', '\u6084', '\u6572', '\u9539', '\u4e54', '\u4fa8', '\u6865', '\u7b7e', '\u524d', '\u94b1', '\u94b3', '\u6f5c', '\u6d45', '\u9063', '\u6b20', '\u6b49', '\u67aa', '\u79bd', '\u52e4', '\u9752', '\u8f7b', '\u503e', '\u6e05', '\u873b', '\u60c5', '\u6674', '\u9877', '\u77a7', '\u5de7', '\u5207', '\u8304', '\u4e14', '\u7a83', '\u4eb2', '\u4fb5', '\u82b9', '\u7434', '\u5c48', '\u8d8b', '\u6e20', '\u53d6', '\u53bb', '\u8da3', '\u5708', '\u5168', '\u6743', '\u6cc9', '\u8bf7', '\u5e86', '\u7a77', '\u4e18', '\u79cb', '\u6c42', '\u7403', '\u533a', '\u66f2', '\u9a71', '\u7fa4', '\u7136', '\u71c3', '\u67d3', '\u56b7', '\u58e4', '\u8ba9', '\u9976', '\u6270', '\u7ed5', '\u62f3', '\u72ac', '\u529d', '\u5238', '\u7f3a', '\u5374', '\u96c0', '\u786e', '\u9e4a', '\u88d9', '\u65e5', '\u7ed2', '\u8363', '\u5bb9', '\u7194', '\u878d', '\u67d4', '\u63c9', '\u8089', '\u5982', '\u60f9', '\u70ed', '\u4eba', '\u4ec1', '\u5fcd', '\u5203', '\u8ba4', '\u4efb', '\u6254', '\u4ecd', '\u4e73', '\u8fb1', '\u5165', '\u8f6f', '\u9510', '\u745e', '\u6da6', '\u82e5', '\u5f31', '\u6492', '\u6d12', '\u585e', '\u8d5b', '\u4e09', '\u4f1e', '\u6563', '\u6851', '\u55d3', '\u4e27', '\u626b', '\u5220', '\u886b', '\u95ea', '\u9655', '\u6247', '\u5584', '\u4f24', '\u5546', '\u88f3', '\u664c', '\u5ac2', '\u8272', '\u68ee', '\u6740', '\u6c99', '\u7eb1', '\u50bb', '\u7b5b', '\u6652', '\u5c71', '\u54e8', '\u820c', '\u86c7', '\u820d', '\u8bbe', '\u793e', '\u5c04', '\u6d89', '\u6444', '\u7533', '\u8d4f', '\u4e0a', '\u5c1a', '\u634e', '\u68a2', '\u70e7', '\u7a0d', '\u52fa', '\u5c11', '\u7ecd', '\u614e', '\u5347', '\u751f', '\u58f0', '\u7272', '\u80dc', '\u7ef3', '\u7701', '\u5723', '\u76db', '\u4f38', '\u8eab', '\u6df1', '\u795e', '\u6c88', '\u5ba1', '\u5a76', '\u80be', '\u751a', '\u6e17', '\u77f3', '\u65f6', '\u8bc6', '\u5b9e', '\u62fe', '\u8680', '\u98df', '\u53f2', '\u4f7f', '\u59cb', '\u5269', '\u5c38', '\u5931', '\u5e08', '\u8bd7', '\u65bd', '\u72ee', '\u6e7f', '\u5341', '\u4ec0', '\u89c6', '\u8bd5', '\u9970', '\u5ba4', '\u662f', '\u67ff', '\u9002', '\u901d', '\u91ca', '\u8a93', '\u9a76', '\u58eb', '\u6c0f', '\u4e16', '\u5e02', '\u793a', '\u5f0f', '\u4e8b', '\u4f8d', '\u52bf', '\u4e66', '\u53d4', '\u6b8a', '\u68b3', '\u758f', '\u8212', '\u8f93', '\u852c', '\u719f', '\u6691', '\u6536', '\u624b', '\u5b88', '\u9996', '\u5bff', '\u53d7', '\u517d', '\u552e', '\u6388', '\u7626', '\u800d', '\u8870', '\u6454', '\u7529', '\u5e05', '\u62f4', '\u53cc', '\u971c', '\u723d', '\u8c01', '\u9f20', '\u5c5e', '\u85af', '\u672f', '\u675f', '\u8ff0', '\u6811', '\u7ad6', '\u6570', '\u5237', '\u65af', '\u6495', '\u6b7b', '\u56db', '\u5bfa', '\u4f3c', '\u9972', '\u8086', '\u677e', '\u5b8b', '\u6c34', '\u7a0e', '\u7761', '\u987a', '\u8bf4', '\u55fd', '\u4e1d', '\u53f8', '\u79c1', '\u601d', '\u901f', '\u5bbf', '\u5851', '\u9178', '\u849c', '\u7b97', '\u867d', '\u968f', '\u5c81', '\u788e', '\u8bf5', '\u9001', '\u9882', '\u641c', '\u8258', '\u82cf', '\u4fd7', '\u8bc9', '\u8083', '\u7d20', '\u5b83', '\u584c', '\u5854', '\u8e0f', '\u53f0', '\u62ac', '\u592a', '\u6001', '\u6cf0', '\u8d2a', '\u7a57', '\u5b59', '\u635f', '\u7b0b', '\u7f29', '\u6240', '\u7d22', '\u9501', '\u5979', '\u4ed6', '\u644a', '\u6ee9', '\u575b', '\u8c08', '\u75f0', '\u6bef', '\u53f9', '\u70ad', '\u63a2', '\u953b', '\u5806', '\u961f', '\u5bf9', '\u5428', '\u8e72', '\u76fe', '\u987f', '\u591a', '\u593a', '\u6d9b', '\u638f', '\u6ed4', '\u9003', '\u6843', '\u9676', '\u6dd8', '\u8404', '\u8ba8', '\u5957', '\u6c64', '\u5510', '\u5802', '\u5858', '\u819b', '\u7cd6', '\u5018', '\u8eba', '\u70eb', '\u8d9f', '\u60d5', '\u66ff', '\u5929', '\u6dfb', '\u7530', '\u751c', '\u586b', '\u6311', '\u6761', '\u8df3', '\u7279', '\u75bc', '\u817e', '\u68af', '\u8e22', '\u63d0', '\u9898', '\u8e44', '\u4f53', '\u5243', '\u901a', '\u540c', '\u6850', '\u94dc', '\u7ae5', '\u7edf', '\u6876', '\u7b52', '\u75db', '\u5077', '\u8d34', '\u94c1', '\u5e16', '\u5385', '\u542c', '\u4ead', '\u5ead', '\u505c', '\u633a', '\u8247', '\u571f', '\u5410', '\u5154', '\u56e2', '\u63a8', '\u817f', '\u9000', '\u541e', '\u5c6f', '\u6258', '\u5934', '\u6295', '\u900f', '\u79c3', '\u7a81', '\u56fe', '\u5f92', '\u6d82', '\u9014', '\u5c60', '\u5916', '\u5f2f', '\u6e7e', '\u4e38', '\u5b8c', '\u73a9', '\u987d', '\u633d', '\u665a', '\u7897', '\u62d6', '\u8131', '\u9a7c', '\u59a5', '\u5a03', '\u6316', '\u86d9', '\u74e6', '\u889c', '\u6b6a', '\u5371', '\u5a01', '\u5fae', '\u4e3a', '\u56f4', '\u8fdd', '\u552f', '\u7ef4', '\u4f1f', '\u4f2a', '\u4e07', '\u6c6a', '\u4ea1', '\u738b', '\u7f51', '\u5f80', '\u5984', '\u5fd8', '\u65fa', '\u671b', '\u6e29', '\u6587', '\u7eb9', '\u95fb', '\u868a', '\u7a33', '\u95ee', '\u7fc1', '\u7a9d', '\u6211', '\u5c3e', '\u59d4', '\u536b', '\u672a', '\u4f4d', '\u5473', '\u754f', '\u80c3', '\u5582', '\u6170', '\u5348', '\u4f0d', '\u6b66', '\u4fae', '\u821e', '\u52ff', '\u52a1', '\u7269', '\u8bef', '\u609f', '\u6c83', '\u5367', '\u63e1', '\u4e4c', '\u6c61', '\u545c', '\u5c4b', '\u65e0', '\u5434', '\u4e94', '\u7a00', '\u6eaa', '\u9521', '\u7184', '\u819d', '\u4e60', '\u5e2d', '\u88ad', '\u6d17', '\u559c', '\u96fe', '\u5915', '\u897f', '\u5438', '\u5e0c', '\u6790', '\u606f', '\u727a', '\u6089', '\u60dc', '\u5413', '\u590f', '\u53a6', '\u4ed9', '\u5148', '\u7ea4', '\u6380', '\u9c9c', '\u95f2', '\u5f26', '\u620f', '\u7cfb', '\u7ec6', '\u9699', '\u867e', '\u778e', '\u5ce1', '\u72ed', '\u971e', '\u4e0b', '\u5baa', '\u9677', '\u9985', '\u7fa1', '\u732e', '\u4e61', '\u76f8', '\u9999', '\u7bb1', '\u8be6', '\u8d24', '\u54b8', '\u8854', '\u5acc', '\u663e', '\u9669', '\u53bf', '\u73b0', '\u7ebf', '\u9650', '\u524a', '\u5bb5', '\u6d88', '\u9500', '\u5c0f', '\u6653', '\u5b5d', '\u6548', '\u6821', '\u7b11', '\u7965', '\u4eab', '\u54cd', '\u60f3', '\u5411', '\u5df7', '\u9879', '\u8c61', '\u50cf', '\u6a61', '\u6cfb', '\u5378', '\u5c51', '\u68b0', '\u8c22', '\u5fc3', '\u8f9b', '\u6b23', '\u65b0', '\u85aa', '\u4e9b', '\u6b47', '\u534f', '\u90aa', '\u80c1', '\u659c', '\u643a', '\u978b', '\u5199', '\u6cc4', '\u59d3', '\u5e78', '\u6027', '\u51f6', '\u5144', '\u80f8', '\u96c4', '\u718a', '\u4f11', '\u4fee', '\u4fe1', '\u5174', '\u661f', '\u8165', '\u5211', '\u884c', '\u5f62', '\u578b', '\u9192', '\u674f', '\u8bb8', '\u5e8f', '\u53d9', '\u7eea', '\u7eed', '\u7d6e', '\u84c4', '\u5ba3', '\u60ac', '\u65cb', '\u7f9e', '\u673d', '\u79c0', '\u7ee3', '\u8896', '\u9508', '\u987b', '\u865a', '\u9700', '\u5f90', '\u8bad', '\u8baf', '\u8fc5', '\u538b', '\u5440', '\u62bc', '\u9e26', '\u9e2d', '\u7259', '\u82bd', '\u9009', '\u7a74', '\u5b66', '\u96ea', '\u8840', '\u5bfb', '\u5de1', '\u65ec', '\u8be2', '\u5faa', '\u5ca9', '\u6cbf', '\u708e', '\u7814', '\u76d0', '\u8712', '\u989c', '\u63a9', '\u773c', '\u6f14', '\u5d16', '\u54d1', '\u96c5', '\u4e9a', '\u54bd', '\u70df', '\u6df9', '\u5ef6', '\u4e25', '\u8a00', '\u626c', '\u7f8a', '\u9633', '\u6768', '\u6d0b', '\u4ef0', '\u517b', '\u6c27', '\u75d2', '\u6837', '\u538c', '\u5bb4', '\u8273', '\u9a8c', '\u7130', '\u96c1', '\u71d5', '\u592e', '\u6b83', '\u79e7', '\u8000', '\u7237', '\u4e5f', '\u51b6', '\u91ce', '\u4e1a', '\u53f6', '\u9875', '\u591c', '\u6db2', '\u5996', '\u8170', '\u9080', '\u7a91', '\u8c23', '\u6447', '\u9065', '\u54ac', '\u836f', '\u8981', '\u4e59', '\u5df2', '\u4ee5', '\u8681', '\u501a', '\u6905', '\u4e49', '\u4ebf', '\u5fc6', '\u827a', '\u4e00', '\u8863', '\u533b', '\u4f9d', '\u4eea', '\u5b9c', '\u59e8', '\u79fb', '\u9057', '\u7591', '\u6bc5', '\u7ffc', '\u56e0', '\u9634', '\u59fb', '\u97f3', '\u94f6', '\u5f15', '\u996e', '\u9690', '\u8bae', '\u4ea6', '\u5f02', '\u5f79', '\u8bd1', '\u6613', '\u75ab', '\u76ca', '\u8c0a', '\u610f', '\u5f71', '\u6620', '\u786c', '\u4f63', '\u62e5', '\u5eb8', '\u6c38', '\u548f', '\u6cf3', '\u52c7', '\u5370', '\u5e94', '\u82f1', '\u6a31', '\u9e70', '\u8fce', '\u76c8', '\u8425', '\u8747', '\u8d62', '\u6e38', '\u53cb', '\u6709', '\u53c8', '\u53f3', '\u5e7c', '\u8bf1', '\u4e8e', '\u4e88', '\u4f59', '\u6d8c', '\u7528', '\u4f18', '\u5fe7', '\u60a0', '\u5c24', '\u7531', '\u72b9', '\u90ae', '\u6cb9', '\u96e8', '\u8bed', '\u7389', '\u80b2', '\u90c1', '\u72f1', '\u6d74', '\u9884', '\u57df', '\u6b32', '\u9c7c', '\u5a31', '\u6e14', '\u6109', '\u611a', '\u6986', '\u4e0e', '\u5b87', '\u5c7f', '\u7fbd', '\u5706', '\u63f4', '\u7f18', '\u6e90', '\u8fdc', '\u6028', '\u9662', '\u613f', '\u7ea6', '\u6708', '\u5fa1', '\u88d5', '\u9047', '\u6108', '\u8a89', '\u51a4', '\u5143', '\u5458', '\u56ed', '\u539f', '\u6655', '\u97f5', '\u6742', '\u707e', '\u683d', '\u5bb0', '\u8f7d', '\u518d', '\u5728', '\u54b1', '\u94a5', '\u60a6', '\u9605', '\u8dc3', '\u8d8a', '\u4e91', '\u5300', '\u5141', '\u5b55', '\u8fd0', '\u7682', '\u9020', '\u71e5', '\u8e81', '\u5219', '\u62e9', '\u6cfd', '\u8d23', '\u8d3c', '\u600e', '\u6682', '\u8d5e', '\u810f', '\u846c', '\u906d', '\u7cdf', '\u65e9', '\u67a3', '\u6fa1', '\u7076', '\u5b85', '\u7a84', '\u503a', '\u5be8', '\u6cbe', '\u7c98', '\u65a9', '\u5c55', '\u76cf', '\u5d2d', '\u589e', '\u8d60', '\u6e23', '\u624e', '\u8f67', '\u95f8', '\u7728', '\u70b8', '\u69a8', '\u6458', '\u80c0', '\u969c', '\u62db', '\u627e', '\u53ec', '\u5146', '\u8d75', '\u7167', '\u7f69', '\u906e', '\u5360', '\u6218', '\u7ad9', '\u5f20', '\u7ae0', '\u6da8', '\u638c', '\u4e08', '\u4ed7', '\u5e10', '\u8bca', '\u6795', '\u9635', '\u632f', '\u9547', '\u9707', '\u4e89', '\u5f81', '\u6323', '\u7741', '\u6298', '\u54f2', '\u8005', '\u8fd9', '\u6d59', '\u8d1e', '\u9488', '\u4fa6', '\u73cd', '\u771f', '\u6c41', '\u829d', '\u679d', '\u77e5', '\u7ec7', '\u80a2', '\u8102', '\u8718', '\u6267', '\u4f84', '\u7b5d', '\u84b8', '\u6574', '\u6b63', '\u8bc1', '\u90d1', '\u653f', '\u75c7', '\u4e4b', '\u652f', '\u6307', '\u81f3', '\u5fd7', '\u5236', '\u5e1c', '\u6cbb', '\u8d28', '\u79e9', '\u81f4', '\u667a', '\u76f4', '\u503c', '\u804c', '\u690d', '\u6b96', '\u6b62', '\u53ea', '\u65e8', '\u5740', '\u7eb8', '\u821f', '\u5468', '\u6d32', '\u7ca5', '\u5b99', '\u663c', '\u76b1', '\u9aa4', '\u6731', '\u682a', '\u7f6e', '\u4e2d', '\u5fe0', '\u7ec8', '\u949f', '\u80bf', '\u79cd', '\u4f17', '\u91cd', '\u5dde', '\u4f4f', '\u52a9', '\u6ce8', '\u9a7b', '\u67f1', '\u795d', '\u8457', '\u7b51', '\u94f8', '\u6293', '\u73e0', '\u8bf8', '\u732a', '\u86db', '\u7af9', '\u70db', '\u9010', '\u4e3b', '\u716e', '\u5631', '\u8ffd', '\u51c6', '\u6349', '\u684c', '\u6d4a', '\u5544', '\u7740', '\u4ed4', '\u59ff', '\u8d44', '\u722a', '\u4e13', '\u7816', '\u8f6c', '\u8d5a', '\u5e84', '\u88c5', '\u58ee', '\u72b6', '\u649e', '\u8d70', '\u594f', '\u79df', '\u8db3', '\u65cf', '\u963b', '\u7ec4', '\u7956', '\u94bb', '\u5634', '\u6ecb', '\u5b50', '\u7d2b', '\u5b57', '\u81ea', '\u5b97', '\u68d5', '\u8e2a', '\u603b', '\u7eb5', '\u6700', '\u7f6a', '\u9189', '\u5c0a', '\u9075', '\u6628', '\u5de6', '\u4f5c', '\u5750', '\u5ea7', '\u505a'};
        ln = "\u8d75\u94b1\u5b59\u674e\u5468\u5434\u90d1\u738b\u51af\u9648\u891a\u536b\u848b\u6c88\u97e9\u6768\u6731\u79e6\u5c24\u8bb8\u4f55\u5415\u65bd\u5f20\u5b54\u66f9\u4e25\u534e\u91d1\u9b4f\u9676\u59dc\u621a\u8c22\u90b9\u55bb\u67cf\u6c34\u7aa6\u7ae0\u4e91\u82cf\u6f58\u845b\u595a\u8303\u5f6d\u90ce\u9c81\u97e6\u660c\u9a6c\u82d7\u51e4\u82b1\u65b9\u4fde\u4efb\u8881\u67f3\u9146\u9c8d\u53f2\u5510\u8d39\u5ec9\u5c91\u859b\u96f7\u8d3a\u502a\u6c64\u6ed5\u6bb7\u7f57\u6bd5\u90dd\u90ac\u5b89\u5e38\u4e50\u4e8e\u65f6\u5085\u76ae\u535e\u9f50\u5eb7\u4f0d\u4f59\u5143\u535c\u987e\u5b5f\u5e73\u9ec4\u548c\u7a46\u8427\u5c39\u59da\u90b5\u6e5b\u6c6a\u7941\u6bdb\u79b9\u72c4\u7c73\u8d1d\u660e\u81e7\u8ba1\u4f0f\u6210\u6234\u8c08\u5b8b\u8305\u5e9e\u718a\u7eaa\u8212\u5c48\u9879\u795d\u8463\u6881\u675c\u962e\u84dd\u95f5\u5e2d\u5b63\u9ebb\u5f3a\u8d3e\u8def\u5a04\u5371\u6c5f\u7ae5\u989c\u90ed\u6885\u76db\u6797\u5201\u949f\u5f90\u90b1\u9a86\u9ad8\u590f\u8521\u7530\u6a0a\u80e1\u51cc\u970d\u865e\u4e07\u652f\u67ef\u661d\u7ba1\u5362\u83ab\u7ecf\u623f\u88d8\u7f2a\u5e72\u89e3\u5e94\u5b97\u4e01\u5ba3\u8d32\u9093\u90c1\u5355\u676d\u6d2a\u5305\u8bf8\u5de6\u77f3\u5d14\u5409\u94ae\u9f9a\u7a0b\u5d47\u90a2\u6ed1\u88f4\u9646\u8363\u7fc1\u8340\u7f8a\u65bc\u60e0\u7504\u66f2\u5bb6\u5c01\u82ae\u7fbf\u50a8\u9773\u6c72\u90b4\u7cdc\u677e\u4e95\u6bb5\u5bcc\u5deb\u4e4c\u7126\u5df4\u5f13\u7267\u9697\u5c71\u8c37\u8f66\u4faf\u5b93\u84ec\u5168\u90d7\u73ed\u4ef0\u79cb\u4ef2\u4f0a\u5bab\u5b81\u4ec7\u683e\u66b4\u7518\u94ad\u5389\u620e\u7956\u6b66\u7b26\u5218\u666f\u8a79\u675f\u9f99\u53f6\u5e78\u53f8\u97f6\u90dc\u9ece\u84df\u8584\u5370\u5bbf\u767d\u6000\u84b2\u90b0\u4ece\u9102\u7d22\u54b8\u7c4d\u8d56\u5353\u853a\u5c60\u8499\u6c60\u4e54\u9634\u9b31\u80e5\u80fd\u82cd\u53cc\u95fb\u8398\u515a\u7fdf\u8c2d\u8d21\u52b3\u9004\u59ec\u7533\u6276\u5835\u5189\u5bb0\u90e6\u96cd\u90e4\u74a9\u6851\u6842\u6fee\u725b\u5bff\u901a\u8fb9\u6248\u71d5\u5180\u90cf\u6d66\u5c1a\u519c\u6e29\u522b\u5e84\u664f\u67f4\u77bf\u960e\u5145\u6155\u8fde\u8339\u4e60\u5ba6\u827e\u9c7c\u5bb9\u5411\u53e4\u6613\u614e\u6208\u5ed6\u5ebe\u7ec8\u66a8\u5c45\u8861\u6b65\u90fd\u803f\u6ee1\u5f18\u5321\u56fd\u6587\u5bc7\u5e7f\u7984\u9619\u4e1c\u6b27\u6bb3\u6c83\u5229\u851a\u8d8a\u5914\u9686\u5e08\u5de9\u538d\u8042\u6641\u52fe\u6556\u878d\u51b7\u8a3e\u8f9b\u961a\u90a3\u7b80\u9976\u7a7a\u66fe\u6bcb\u6c99\u4e5c\u517b\u97a0\u987b\u4e30\u5de2\u5173\u84af\u76f8\u67e5\u540e\u8346\u7ea2\u6e38\u7afa\u6743\u902f\u76d6\u76ca\u6853\u516c\u4e07\u4fdf\u53f8\u9a6c\u4e0a\u5b98\u6b27\u9633\u590f\u4faf\u8bf8\u845b\u95fb\u4eba\u4e1c\u65b9\u8d6b\u8fde\u7687\u752b\u5c09\u8fdf\u516c\u7f8a\u6fb9\u53f0\u516c\u51b6\u5b97\u653f\u6fee\u9633\u6df3\u4e8e\u5355\u4e8e\u592a\u53d4\u7533\u5c60\u516c\u5b59\u4ef2\u5b59\u8f69\u8f95\u4ee4\u72d0\u949f\u79bb\u5b87\u6587\u957f\u5b59\u6155\u5bb9\u9c9c\u4e8e\u95fe\u4e18\u53f8\u5f92\u53f8\u7a7a\u4e0c\u5b98\u53f8\u5bc7\u4ec9\u7763\u5b50\u8f66\u989b\u5b59\u7aef\u6728\u5deb\u9a6c\u516c\u897f\u6f06\u96d5\u4e50\u6b63\u58e4\u9a77\u516c\u826f\u62d3\u8dcb\u5939\u8c37\u5bb0\u7236\u8c37\u6881\u664b\u695a\u95eb\u6cd5\u6c5d\u9122\u6d82\u94a6\u6bb5\u5e72\u767e\u91cc\u4e1c\u90ed\u5357\u95e8\u547c\u5ef6\u5f52\u6d77\u7f8a\u820c\u5fae\u751f\u5cb3\u5e05\u7f11\u4ea2\u51b5\u90c8\u6709\u7434\u6881\u4e18\u5de6\u4e18\u4e1c\u95e8\u897f\u95e8\u5546\u725f\u4f58\u4f74\u4f2f\u8d4f\u5357\u5bab\u58a8\u54c8\u8c2f\u7b2a\u5e74\u7231\u9633\u4f5f\u7b2c\u4e94\u8a00\u798f\u767e\u5bb6\u59d3\u7ec8";
        map = new HashMap();
        for (i = 0; i < usual.length; ++i) {
            map.put(Character.valueOf(usual[i]), i);
        }
        map2 = new HashMap();
        for (i = 0; i < ln.length(); ++i) {
            map2.put(Character.valueOf(ln.charAt(i)), i);
        }
    }
}

