/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools.sm4fpe;

import com.palacesun.masking.tools.sm4fpe.SM4FPEBase;
import com.palacesun.masking.tools.sm4fpe.SM4FPEEntity;
import com.palacesun.masking.tools.sm4fpe.SegmentType;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4FPECompany
extends SM4FPEBase {
    static ArrayList<SM4FPEEntity> companyEntities;
    static char[] excludeChars;
    static ArrayList chineseCharsCompany;
    static ArrayList otherChineseCharsCompany;
    static HashMap chineseCharsCompanyMap;
    static HashMap otherChineseCharsCompanyMap;
    private static Pattern companyNamePattern;

    @Override
    public String encryptEcb(String hexKey, String a) throws Exception {
        String out = this.encrypt(hexKey, a, companyEntities);
        return out;
    }

    @Override
    public String decryptEcb(String hexKey, String input) throws Exception {
        String out = this.decrypt(hexKey, input, companyEntities);
        return out;
    }

    public static boolean isCompanyName(String companyName) {
        boolean result = false;
        int length = companyName.length();
        if (length >= 3) {
            Matcher matcher;
            if (null == companyNamePattern) {
                companyNamePattern = Pattern.compile("(\u516c\u53f8|\u6709\u9650\u516c\u53f8|\u80a1\u4efd\u6709\u9650\u516c\u53f8)$");
            }
            if ((matcher = companyNamePattern.matcher(companyName)).find() && matcher.start() > 0 && matcher.end() == length) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public int initTypes(String input, int m, SegmentType[] types, ArrayList<SM4FPEEntity> entities) throws Exception {
        int i;
        int typeIndex = 0;
        int endIndex = input.length();
        if (input.endsWith("\u80a1\u4efd\u6709\u9650\u516c\u53f8")) {
            endIndex -= 6;
        } else if (input.endsWith("\u6709\u9650\u516c\u53f8")) {
            endIndex -= 4;
        } else if (input.endsWith("\u516c\u53f8")) {
            endIndex -= 2;
        }
        for (i = 0; i < endIndex; ++i) {
            int j;
            for (j = 0; j < entities.size(); ++j) {
                Integer index = (Integer)entities.get(j).getCharsMap().get(Character.valueOf(input.charAt(i)));
                if (index == null) continue;
                types[typeIndex++].type = j;
                break;
            }
            if (j != entities.size()) continue;
            types[typeIndex++].type = 99999;
        }
        for (i = endIndex; i < input.length(); ++i) {
            types[typeIndex++].type = 99999;
        }
        return typeIndex++;
    }

    @Override
    String generateInputRandom(String input) {
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            input = input + companyEntities.get(0).getList().get(random.nextInt(companyEntities.get(0).getList().size()));
        }
        input = input + "\u80a1\u4efd\u6709\u9650\u516c\u53f8";
        return input;
    }

    public static boolean check(String input) {
        return SM4FPECompany.isCompanyName(input);
    }

    static {
        int i;
        companyEntities = new ArrayList();
        excludeChars = new char[]{'\u80a1', '\u4efd', '\u6709', '\u9650', '\u516c', '\u53f8'};
        Security.addProvider((Provider)new BouncyCastleProvider());
        chineseCharsCompany = SM4FPECompany.excludeChars(SM4FPECompany.toArrayList(chineseChars), excludeChars);
        otherChineseCharsCompany = SM4FPECompany.excludeChars(otherChineseChars, excludeChars);
        chineseCharsCompanyMap = new HashMap();
        for (i = 0; i < chineseCharsCompany.size(); ++i) {
            chineseCharsCompanyMap.put(chineseCharsCompany.get(i), i);
        }
        otherChineseCharsCompanyMap = new HashMap();
        for (i = 0; i < otherChineseCharsCompany.size(); ++i) {
            otherChineseCharsCompanyMap.put(otherChineseCharsCompany.get(i), i);
        }
        companyEntities.add(new SM4FPEEntity(0, chineseCharsCompany, chineseCharsCompanyMap));
        companyEntities.add(new SM4FPEEntity(1, otherChineseCharsCompany, otherChineseCharsCompanyMap));
        SM4FPECompany.checkDuplicate(companyEntities);
    }
}

