/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools.sm4fpe;

import com.palacesun.masking.tools.sm4fpe.SM4FPEBase;
import com.palacesun.masking.tools.sm4fpe.SM4FPEEntity;
import com.palacesun.masking.tools.sm4fpe.SegmentType;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Pattern;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4FPEEmail
extends SM4FPEBase {
    static ArrayList<SM4FPEEntity> emailEntities = new ArrayList();
    private static Pattern emailPrefix;
    private static Pattern emailSuffix;

    @Override
    public String encryptEcb(String hexKey, String a) throws Exception {
        String out = this.encrypt(hexKey, a, emailEntities);
        return out;
    }

    @Override
    public String decryptEcb(String hexKey, String input) throws Exception {
        String out = this.decrypt(hexKey, input, emailEntities);
        return out;
    }

    public static boolean isemail(String email) {
        boolean result = false;
        if ((email = email.trim()).length() < 6) {
            return result;
        }
        String[] emailsuffix = email.split("@");
        if (emailsuffix.length == 2) {
            result = true;
        }
        if (!result) {
            return result;
        }
        if (null == emailPrefix || null == emailSuffix) {
            emailPrefix = Pattern.compile("^((?!_\\-\\.)[\\u4e00-\\u9fa5a-zA-Z0-9]+)([\\u4e00-\\u9fa5a-zA-Z0-9_\\-\\.]*)");
            emailSuffix = Pattern.compile("^((?!\\.$)(?!\\_$)(?!\\-$).)*$");
        }
        result = emailPrefix.matcher(emailsuffix[0]).find() && emailSuffix.matcher(emailsuffix[0]).matches() && emailPrefix.matcher(emailsuffix[1]).find() && emailSuffix.matcher(emailsuffix[1]).matches();
        return result;
    }

    @Override
    String generateInputRandom(String input) {
        int index;
        int i;
        Random random = new Random();
        for (i = 0; i < 10; ++i) {
            index = random.nextInt(emailEntities.size());
            input = input + emailEntities.get(index).getList().get(random.nextInt(emailEntities.get(index).getList().size()));
        }
        input = input + "@";
        for (i = 0; i < 8; ++i) {
            index = random.nextInt(emailEntities.size());
            input = input + emailEntities.get(index).getList().get(random.nextInt(emailEntities.get(index).getList().size()));
        }
        input = input + ".";
        for (i = 0; i < 5; ++i) {
            index = random.nextInt(emailEntities.size());
            input = input + emailEntities.get(index).getList().get(random.nextInt(emailEntities.get(index).getList().size()));
        }
        return input;
    }

    @Override
    public int initTypes(String input, int m, SegmentType[] types, ArrayList<SM4FPEEntity> entities) throws Exception {
        String[] emailsuffix = input.split("@");
        if (emailsuffix.length == 2) {
            int dotIndex = emailsuffix[1].indexOf(".");
            if (dotIndex > 0) {
                int dotInInput = emailsuffix[0].length() + 1 + dotIndex;
                String inputBeforeDot = input.substring(0, dotInInput);
                int dataSegmentLen = super.initTypes(inputBeforeDot, inputBeforeDot.length(), types, entities);
                types[dataSegmentLen].type = 99999;
                types[dataSegmentLen].length = input.length() - inputBeforeDot.length();
                return ++dataSegmentLen;
            }
            return super.initTypes(input, m, types, entities);
        }
        return super.initTypes(input, m, types, entities);
    }

    public static boolean check(String input) {
        return SM4FPEEmail.isemail(input);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        emailEntities.add(new SM4FPEEntity(0, SM4FPEEmail.toArrayList(enCapitalChars), enCapitalCharsMap));
        emailEntities.add(new SM4FPEEntity(1, SM4FPEEmail.toArrayList(enSmallChars), enSmallCharsMap));
        emailEntities.add(new SM4FPEEntity(2, SM4FPEEmail.toArrayList(digitChars), digitCharsMap));
        emailEntities.add(new SM4FPEEntity(3, SM4FPEEmail.toArrayList(chineseChars), chineseCharsMap));
        SM4FPEEmail.checkDuplicate(emailEntities);
    }
}

