/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools.sm4fpe;

import com.palacesun.masking.tools.ReflectUtil;
import com.palacesun.masking.tools.sm4fpe.SM4FPEAddress;
import com.palacesun.masking.tools.sm4fpe.SM4FPEBase;
import com.palacesun.masking.tools.sm4fpe.SM4FPECellPhone;
import com.palacesun.masking.tools.sm4fpe.SM4FPECompany;
import com.palacesun.masking.tools.sm4fpe.SM4FPEEmail;
import com.palacesun.masking.tools.sm4fpe.SM4FPEIdentityNo;
import com.palacesun.masking.tools.sm4fpe.SM4FPEName;
import com.palacesun.masking.tools.sm4fpe.SM4FPENameUtil;
import com.palacesun.masking.tools.sm4fpe.SM4FPETools;
import java.io.UnsupportedEncodingException;

public class SM4FPEToolsTest {
    public static boolean isPrint = true;

    public static void main(String[] args) throws Exception {
        String key = SM4FPENameUtil.generateKey();
        System.out.println(key);
        String data = "\u5f20\u4e09\u8dd1";
        System.out.println(data);
        String encrypt = SM4FPENameUtil.encryptEcb(key, data, "1", "0", "3", "0");
        System.out.println(encrypt);
        String decrypt = SM4FPENameUtil.decryptEcb(key, encrypt, "1", "0", "3", "0");
        System.out.println(decrypt);
        System.out.println(data.equals(decrypt));
        encrypt = ReflectUtil.engine("SM4_FPE_NAME", data, key, "1", "0", "0", "0", true, null);
        System.out.println(encrypt);
        decrypt = ReflectUtil.engine("SM4_FPE_NAME", encrypt, key, "1", "0", "0", "0", false, null);
        System.out.println(decrypt);
        System.out.println(data.equals(decrypt));
    }

    private static void testSet() throws Exception {
        SM4FPEToolsTest.testAllExample();
    }

    public static byte[] convertEncoding_ByteArr(byte[] src, String srcCharset, String destCharet) throws UnsupportedEncodingException {
        String s = new String(src, srcCharset);
        return s.getBytes(destCharet);
    }

    private static void testCharSet() throws UnsupportedEncodingException {
        String test2 = "\u79bb\u4e2d\u56fd";
        byte[] bytes = test2.getBytes("UTF-8");
        byte[] bytes2 = SM4FPEToolsTest.convertEncoding_ByteArr(test2.getBytes("UTF-8"), "UTF-8", "GBK");
        String test22 = new String(bytes2, "GBK");
        char[] chars = test2.toCharArray();
        char[] chars2 = test22.toCharArray();
    }

    private static void testIsPersonName() throws Exception {
        String input = "\u5468\u5509\u6328";
        input = "\u5468\u5509\u6328";
        String key = SM4FPETools.generateKey();
        input = "\u5468\u5509\u6328";
        String x = SM4FPETools.encryptEcbAuto(key, input);
        String y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u516c\u5b59\u5509";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u5355\u4e8e\u77ee";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
    }

    private static void testPersonName() throws Exception {
        String input = "\u5468\u5509\u6328";
        input = "\u5468\u5509\u6328";
        String key = "9c073de10dca9daf1943f77048874ef39265eff78cf7af1c7e6bd17934ca71c9b288837ff6b528a87eb3e7bdf16b76e7ba05c9dbf3f4d68d5ff47ec27db04ccba032e7574e0c8e049ba3fe30711c7dbb1d96a9242fcf91760ab825c2515dbce76e4ba51f8f1ed4d4403dc69b25e36470595e6a2ee7ae540f33391cf748fff7366d63a04a2af5ca4421c8fa1f7f9c91798ed01db4f66ecd21b09254eb4de45606b0d9fd8005ba285b560253448465992be2d5b059e92e4c13fbd781a41f90ed228e703f44f8f2d826db08cb5b4f9a0c5aff2ab92684b5bbdbb10559c2d32247c922f24a114f8c08c011d033778c24cf2d";
        SM4FPEName name = new SM4FPEName();
        input = "\u738b\u4e1a\u660e";
        String x = name.encryptEcb(key, input);
        String y = name.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u4ee4\u72d0\u897f\u95e8";
        x = name.encryptEcb(key, input);
        y = name.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u9a74\u5934\u72fc";
        x = name.encryptEcb(key, input);
        y = name.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u9a74\u5934\u72fc2342";
        x = name.encryptEcb(key, input);
        y = name.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u5218\u504a\u504b\u504c\u504d\u504e\u504f\u5050\u5051\u5052\u5053\u5054";
        x = name.encryptEcb(key, input);
        y = name.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u9a74\u5934\u72fc2342\uff08\uff09\uff08sfsd**&\u2026\u2026\u2026\u2026SD";
        x = name.encryptEcb(key, input);
        y = name.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
    }

    private static void testPhoneNumber() throws Exception {
        String input = "\u5468\u5509\u6328";
        input = "\u5468\u5509\u6328";
        String key = SM4FPETools.generateKey();
        SM4FPECellPhone phone = new SM4FPECellPhone();
        System.out.println(key);
        key = "CAF36B99753915223C00B51D78BA395A";
        input = "+999999915615608356";
        String x = phone.encryptEcb(key, input);
        String y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "15615608356";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "15706966819";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "+115706966819";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "+8615706966819";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "+21215706966819";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "+144115706966819";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "+1439715706966819";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "+991439715706966819";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "+9914";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "+9915706966819";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "8615706966819";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "06966819";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "06966819sdf2348()*^\u4e2d\u6587";
        x = phone.encryptEcb(key, input);
        y = phone.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
    }

    private static void testIdentifyNo() throws Exception {
        String input = "\u5468\u5509\u6328";
        input = "\u5468\u5509\u6328";
        String key = SM4FPETools.generateKey();
        SM4FPEIdentityNo identityNo = new SM4FPEIdentityNo();
        input = "513030188001310014";
        String x = identityNo.encryptEcb(key, input);
        String y = identityNo.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "320000491231002";
        x = identityNo.encryptEcb(key, input);
        y = identityNo.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "32000049123100223423";
        x = identityNo.encryptEcb(key, input);
        y = identityNo.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "32000";
        x = identityNo.encryptEcb(key, input);
        y = identityNo.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "23sdfLKJ*&*)(__\u4e2d\u6587";
        x = identityNo.encryptEcb(key, input);
        y = identityNo.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
    }

    private static void testEmail() throws Exception {
        String input = "\u5468\u5509\u6328";
        input = "\u5468\u5509\u6328";
        String key = SM4FPETools.generateKey();
        SM4FPEEmail email = new SM4FPEEmail();
        input = "username@domain.com";
        String x = email.encryptEcb(key, input);
        String y = email.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "usernamedomaincom";
        x = email.encryptEcb(key, input);
        y = email.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "userna23423erweLKJ()*(&*(\u4e2d\u6587";
        x = email.encryptEcb(key, input);
        y = email.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
    }

    private static void testAddress() throws Exception {
        String input = "\u5468\u5509\u6328";
        input = "\u5468\u5509\u6328";
        String key = SM4FPETools.generateKey();
        SM4FPEAddress address = new SM4FPEAddress();
        input = "\u8fbd";
        String x = address.encryptEcb(key, input);
        String y = address.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u8fbd\u4f60\u8bf4\u7684\u8985\u5bc4\u9001\u5230\u5357\u65b9\u5c71\u4e1c\u798f\u5efa\u5c71\u4e1c\u5206\u5c40\u9001\u5230\u9001\u7684\u98d3\u98ce\u6851\u8fea\u53d1\u5409\u8428\u914d\u8ba4\u4e3aJoe\u5747\u4e3a\u54e6\u9644\u4ef6\u4e3a\u7532\u65b9\u54e6\u70b9\u51fb\u53d1\u9001i\u5927\u5bb6\u4f5b\u5c3115489\uff09\uff08&**\u2026\u2026\uff08&";
        x = address.encryptEcb(key, input);
        y = address.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u6c34\u96fb\u8cbb\u6536\u5230\u9644\u4ef6\u5169\u6b3e\u624b\u6a5f\u5730\u4f4d\u87ba\u7d72\u91d8\u89e3\u653e\u662f\u8003\u616e\u5230\u623f\u50f9";
        x = address.encryptEcb(key, input);
        y = address.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
    }

    private static void testCompany() throws Exception {
        String input = "\u5468\u5509\u6328";
        input = "\u5468\u5509\u6328";
        String key = SM4FPETools.generateKey();
        SM4FPECompany company = new SM4FPECompany();
        input = "\u5149\u534e\u51a0\u7fa4sdfs(*)(*JLKJK23";
        String x = company.encryptEcb(key, input);
        String y = company.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u58eb\u5927\u592b\u52dd\u591a\u8ca0\u5c11\u6709\u9650\u516c\u53f8";
        x = company.encryptEcb(key, input);
        y = company.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
    }

    private static void testBase() throws Exception {
        String input = "\u5468\u5509\u6328";
        String key = SM4FPETools.generateKey();
        SM4FPEBase base = new SM4FPEBase();
        input = "\u5149\u534e\u51a0\u7fa4sdfs(*)(*JLKJK23\u9edc\u9edd\u9ede\u9edf\u9ee0\u9ee1\u9ee2\u9ee3\u9ee4\u9ee5\u9ee6\u9ee7\u9ee8\u9ee9\u9eea\u9eeb\u9eec\u9eed\u9eee\u9eef";
        String x = base.encryptEcb(key, input);
        String y = base.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
    }

    private static void testAllExample() throws Exception {
        String key = SM4FPETools.generateKey();
        System.out.println(key.length());
        SM4FPEAddress address = new SM4FPEAddress();
        String input = "\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u6492\u65e6\u53d1\u5c04\u70b9\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u58eb\u5927\u592b\u77f3\u5e06\u80dc\u4e30\u58eb\u5927\u592b\u58eb\u5927\u592b\u968f\u98ce\u5012\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u6492\u65e6\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u6492\u65e6\u53d1\u5c04\u70b9\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u58eb\u5927\u592b\u77f3\u5e06\u80dc\u4e30\u58eb\u5927\u592b\u58eb\u5927\u592b\u968f\u98ce\u5012\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u6492\u65e6\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u6492\u65e6\u53d1\u5c04\u70b9\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u58eb\u5927\u592b\u77f3\u5e06\u80dc\u4e30\u58eb\u5927\u592b\u58eb\u5927\u592b\u968f\u98ce\u5012\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u6492\u65e6\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u6492\u65e6\u53d1\u5c04\u70b9\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u58eb\u5927\u592b\u77f3\u5e06\u80dc\u4e30\u58eb\u5927\u592b\u58eb\u5927\u592b\u968f\u98ce\u5012\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u6492\u65e6\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u6492\u65e6\u53d1\u5c04\u70b9\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u58eb\u5927\u592b\u77f3\u5e06\u80dc\u4e30\u58eb\u5927\u592b\u58eb\u5927\u592b\u968f\u98ce\u5012\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u6492\u65e6\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u6492\u65e6\u53d1\u5c04\u70b9\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u58eb\u5927\u592b\u77f3\u5e06\u80dc\u4e30\u58eb\u5927\u592b\u58eb\u5927\u592b\u968f\u98ce\u5012\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u6492\u65e6\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u6492\u65e6\u53d1\u5c04\u70b9\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u58eb\u5927\u592b\u77f3\u5e06\u80dc\u4e30\u58eb\u5927\u592b\u58eb\u5927\u592b\u968f\u98ce\u5012\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u6492\u65e6\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u6492\u65e6\u53d1\u5c04\u70b9\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u58eb\u5927\u592b\u77f3\u5e06\u80dc\u4e30\u58eb\u5927\u592b\u58eb\u5927\u592b\u968f\u98ce\u5012\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u6492\u65e6\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u6492\u65e6\u53d1\u5c04\u70b9\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u58eb\u5927\u592b\u77f3\u5e06\u80dc\u4e30\u58eb\u5927\u592b\u58eb\u5927\u592b\u968f\u98ce\u5012\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u6492\u65e6\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u6492\u65e6\u53d1\u5c04\u70b9\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u80dc\u591a\u8d1f\u5c11\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u58eb\u5927\u592b\u77f3\u5e06\u80dc\u4e30\u58eb\u5927\u592b\u58eb\u5927\u592b\u968f\u98ce\u5012\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u6492\u65e6\u53d1\u5c04\u70b9\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b\u58eb\u5927\u592b";
        String x = address.encryptEcb(key, input);
        String y = address.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4";
        x = address.encryptEcb(key, input);
        y = address.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u4e2d\u56fd\u533b\u79d1\u5927\u5b66\u9644\u5c5e\u76db\u4eac\u533b\u9662(\u5357\u6e56\u9662\u533a)";
        x = address.encryptEcb(key, input);
        y = address.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u65b0\u7586\u4e4c\u9c81\u6728\u9f50\u5e02\u5357\u533a\u5929\u9f99\u885752-4\u53f7";
        x = address.encryptEcb(key, input);
        y = address.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        SM4FPECompany company = new SM4FPECompany();
        input = "\u5149\u534e\u51a0\u7fa4\u80a1\u4efd\u6709\u9650\u516c\u53f8";
        x = company.encryptEcb(key, input);
        y = company.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u5149\u534e\u51a0\u7fa4\u6709\u9650\u516c\u53f8";
        x = company.encryptEcb(key, input);
        y = company.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u5149\u534e\u51a0\u7fa4\u516c\u53f8";
        x = company.encryptEcb(key, input);
        y = company.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "533223180003311620";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "452728189802290349";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "32000019491231002X";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "513030188001310014";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "320000491231002";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "513030800131001";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "15615608356";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "15706966819";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "+8615706966819";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u4e0a\u6d77\u5e02\u5b9d\u5c71\u533a\u4e30\u6751";
        x = SM4FPETools.encryptEcb(key, input);
        y = SM4FPETools.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u5468\u5509\u661f";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u516c\u5b59\u5b89";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u897f\u95e8\u98de\u5b89";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u5355\u4e8e\u98de";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "1993-11-13 16:01:20";
        x = SM4FPETools.encryptEcb(key, input);
        y = SM4FPETools.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "username@domain.com";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "username@domain.com.cn";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "user.name@domain.com.cn";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "abc123@163.com";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "\u5f20\u4e09@123.com";
        x = SM4FPETools.encryptEcbAuto(key, input);
        y = SM4FPETools.decryptEcbAuto(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
    }

    private static void test2() throws Exception {
        String key = SM4FPETools.generateKey();
        String input = "010101019999";
        String x = SM4FPETools.encryptEcb(key, input);
        SM4FPEBase.digitChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*'};
        SM4FPEBase.sm4FPEEntities.get(2).setList(SM4FPEBase.toArrayList(SM4FPEBase.digitChars));
        String y = SM4FPETools.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
        input = "010101019999*";
        SM4FPEBase.digitChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        SM4FPEBase.sm4FPEEntities.get(2).setList(SM4FPEBase.toArrayList(SM4FPEBase.digitChars));
        x = SM4FPETools.encryptEcb(key, input);
        SM4FPEBase.digitChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*'};
        SM4FPEBase.sm4FPEEntities.get(2).setList(SM4FPEBase.toArrayList(SM4FPEBase.digitChars));
        y = SM4FPETools.decryptEcb(key, x);
        SM4FPEToolsTest.print(key, input, x, y);
    }

    private static void print(String key, String input, String x, String y) {
        if (isPrint || !input.equals(y) && x.length() == input.length()) {
            System.out.println("----------- begin");
            System.out.println("\u8f93\u5165\u7684\uff1a" + input);
            System.out.println("\u52a0\u5bc6\u540e\uff1a" + x);
            System.out.println("\u89e3\u5bc6\u540e\uff1a" + y);
            System.out.println("----------- end");
        }
    }

    private static void randomPhone_test() throws Exception {
        SM4FPECellPhone phone = new SM4FPECellPhone();
        for (int i = 0; i < 2000; ++i) {
            String x;
            String y;
            String key = SM4FPETools.generateKey();
            String input = "";
            if ((input = phone.generateInputRandom(input)).equals(y = SM4FPETools.decryptEcbAuto(key, x = SM4FPETools.encryptEcbAuto(key, input))) || x.length() != input.length()) continue;
            SM4FPEToolsTest.print(key, input, x, y);
            System.out.println("-------------------- error");
        }
    }

    private static void randomEmail_test() throws Exception {
        SM4FPEEmail email = new SM4FPEEmail();
        for (int i = 0; i < 2000; ++i) {
            String x;
            String y;
            String key = SM4FPETools.generateKey();
            String input = "";
            if ((input = email.generateInputRandom(input)).equals(y = email.decryptEcb(key, x = email.encryptEcb(key, input))) || x.length() != input.length()) continue;
            SM4FPEToolsTest.print(key, input, x, y);
            System.out.println("-------------------- error");
        }
    }

    private static void randomAddress_test() throws Exception {
        String x;
        String input = "\u8fbd\u5b81\u7701\u6c88\u9633\u5e02\u6d51\u5357\u533a\u4e07\u8fbe\u5e7f\u573a6\u53f7\u697c1501\u5ba4";
        SM4FPEAddress address = new SM4FPEAddress();
        String key = SM4FPETools.generateKey();
        String y = address.decryptEcb(key, x = address.encryptEcb(key, input));
        if (!input.equals(y) && x.length() == input.length()) {
            SM4FPEToolsTest.print(key, input, x, y);
            System.out.println("-------------------- error");
        }
    }

    private static void randomCompany_test() throws Exception {
        SM4FPECompany company = new SM4FPECompany();
        for (int i = 0; i < 2000; ++i) {
            String x;
            String y;
            String key = SM4FPETools.generateKey();
            String input = "";
            if ((input = company.generateInputRandom(input)).equals(y = company.decryptEcb(key, x = company.encryptEcb(key, input))) || x.length() != input.length()) continue;
            SM4FPEToolsTest.print(key, input, x, y);
            System.out.println("-------------------- error");
        }
    }

    private static void randomIdentify_test() throws Exception {
        SM4FPEIdentityNo identityNo = new SM4FPEIdentityNo();
        for (int i = 0; i < 2000; ++i) {
            String x;
            String y;
            String key = SM4FPETools.generateKey();
            String input = "";
            if ((input = identityNo.generateInputRandom(input)).equals(y = SM4FPETools.decryptEcbAuto(key, x = SM4FPETools.encryptEcbAuto(key, input))) || x.length() != input.length()) continue;
            SM4FPEToolsTest.print(key, input, x, y);
            System.out.println("-------------------- error");
        }
    }

    private static void randomName_test() throws Exception {
        SM4FPEName name = new SM4FPEName();
        for (int i = 0; i < 200; ++i) {
            String x;
            String y;
            String key = SM4FPETools.generateKey();
            String input = "";
            if ((input = name.generateInputRandom(input)).equals(y = name.decryptEcb(key, x = name.encryptEcb(key, input))) || x.length() != input.length()) continue;
            SM4FPEToolsTest.print(key, input, x, y);
            System.out.println("-------------------- error");
        }
    }

    private static void random_test() throws Exception {
        SM4FPEBase base = new SM4FPEBase();
        for (int i = 0; i < 2000; ++i) {
            String x;
            String y;
            String key = SM4FPETools.generateKey();
            String input = "";
            if ((input = base.generateInputRandom(input)).equals(y = SM4FPETools.decryptEcb(key, x = SM4FPETools.encryptEcb(key, input))) || x.length() != input.length()) continue;
            SM4FPEToolsTest.print(key, input, x, y);
            System.out.println("-------------------- error");
        }
    }

    private static void unsupport_test() throws Exception {
        for (int i = 0; i < 20; ++i) {
            String x;
            String input = "Test3.\u5929\u4e0b\u6253\u4e71#$\uffe5";
            String key = SM4FPETools.generateKey();
            String y = SM4FPETools.decryptEcb(key, x = SM4FPETools.encryptEcb(key, input));
            if (input.equals(y) || x.length() != input.length()) continue;
            SM4FPEToolsTest.print(key, input, x, y);
            System.out.println("-------------------- error");
        }
    }

    private static void generateAllChinese() {
        char c = '\u4e00';
        int i = 0;
        while (c <= '\u9fa5') {
            System.out.print(c);
            if (i % 70 == 69) {
                System.out.println();
            }
            c = (char)(c + '\u0001');
            i = (char)(i + 1);
        }
    }

    private static void generateMothday() {
        SM4FPEToolsTest.getMothday(1, 31);
        SM4FPEToolsTest.getMothday(2, 29);
        SM4FPEToolsTest.getMothday(3, 31);
        SM4FPEToolsTest.getMothday(4, 30);
        SM4FPEToolsTest.getMothday(5, 31);
        SM4FPEToolsTest.getMothday(6, 30);
        SM4FPEToolsTest.getMothday(7, 31);
        SM4FPEToolsTest.getMothday(8, 31);
        SM4FPEToolsTest.getMothday(9, 30);
        SM4FPEToolsTest.getMothday(10, 31);
        SM4FPEToolsTest.getMothday(11, 30);
        SM4FPEToolsTest.getMothday(12, 31);
    }

    private static void getMothday(int month, int end) {
        for (int i = 1; i <= end; ++i) {
            System.out.println(SM4FPEToolsTest.expand(month) + SM4FPEToolsTest.expand(i));
        }
    }

    private static String expand(int i) {
        String a = String.valueOf(i);
        while (a.length() < 2) {
            a = '0' + a;
        }
        return a;
    }
}

