/*
 * Decompiled with CFR 0.152.
 */
package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import bean.View;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonJavaScript;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import util.getdata.CacheData;

public class CacheMongoDB
extends CacheData {
    public CacheMongoDB(DataBase dataBase, CountDownLatch cdl) {
        super(dataBase, cdl);
    }

    @Override
    public List<Schema> getSchema(Statement statement) throws SQLException {
        return null;
    }

    @Override
    public List<Table> getTable(Statement statement, String schema) throws SQLException {
        return null;
    }

    @Override
    public List<Column> getColumn(Statement statement, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public List<View> getView(Statement statement, String schema) throws SQLException {
        return null;
    }

    @Override
    public void run() {
        System.out.println("mongodb\u5f00\u59cb\u7f13\u5b58");
        try {
            this.cacheWriteToRedis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.getCdl().countDown();
            System.out.println("mongodb\u7d50\u675f\u7f13\u5b58");
        }
    }

    @Override
    public List<Schema> cacheToMemory() {
        String username = this.getDataBase().getUsername();
        String databaseName = this.getDataBase().getServername();
        String passwd = this.getDataBase().getPassword();
        String ip_port = this.getDataBase().getIp_port();
        String[] ipports = ip_port.split(":");
        String ip = ipports[0];
        String port = ipports[1];
        try {
            MongoClient client = username != null && !"".equals(username) ? this.connect(databaseName, username, passwd, ip, Integer.valueOf(port), true) : this.connect(databaseName, username, passwd, ip, Integer.valueOf(port), false);
            List dblist = client.getDatabaseNames();
            ArrayList<Schema> schemas = new ArrayList<Schema>();
            for (String dbname : dblist) {
                MongoDatabase db = client.getDatabase(dbname);
                Schema schema = new Schema(dbname);
                ArrayList<Table> tables = new ArrayList<Table>();
                MongoIterable colls = db.listCollectionNames();
                for (String coll : colls) {
                    if (coll.contains("system")) continue;
                    List<Column> columns = this.findAllColumns(client, dbname, coll);
                    Table table = new Table(coll, dbname);
                    table.setColumnList(columns);
                    tables.add(table);
                }
                schema.setTableList(tables);
                schemas.add(schema);
            }
            DataBase dataBase = this.getDataBase();
            return schemas;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Schema>();
        }
    }

    public List<Column> findAllColumns(MongoClient client, String schema, String collectionName) throws Exception {
        ArrayList<Column> columns = new ArrayList<Column>();
        MongoDatabase db = null;
        db = client.getDatabase(schema);
        ArrayList<BsonElement> bsonElements = new ArrayList<BsonElement>();
        String erName = "ghca_cache_meta_keys";
        bsonElements.add(new BsonElement("mapreduce", (BsonValue)new BsonString(collectionName)));
        bsonElements.add(new BsonElement("map", (BsonValue)new BsonJavaScript("function() {\n    for (var key in this) { emit(key, null); }\n  }")));
        bsonElements.add(new BsonElement("reduce", (BsonValue)new BsonJavaScript("function(key, stuff) { return null; }")));
        bsonElements.add(new BsonElement("out", (BsonValue)new BsonString(erName)));
        BsonDocument b = new BsonDocument(bsonElements);
        db.runCommand((Bson)b);
        ArrayList<BsonElement> bsonElements1 = new ArrayList<BsonElement>();
        bsonElements1.add(new BsonElement("distinct", (BsonValue)new BsonString(erName)));
        bsonElements1.add(new BsonElement("key", (BsonValue)new BsonString("_id")));
        bsonElements1.add(new BsonElement("query", (BsonValue)new BsonNull()));
        BsonDocument b1 = new BsonDocument(bsonElements1);
        Document document1 = db.runCommand((Bson)b1);
        for (String s : (List)document1.get((Object)"values")) {
            Column column = new Column();
            column.setColumnName(s);
            column.setTable(collectionName);
            column.setSchema(schema);
            columns.add(column);
        }
        db.getCollection(erName).drop();
        return columns;
    }

    public List<Document> findAll(MongoCollection<Document> collection) {
        ArrayList<Document> results = new ArrayList<Document>();
        FindIterable iterables = collection.find();
        MongoCursor cursor = iterables.iterator();
        while (cursor.hasNext()) {
            results.add((Document)cursor.next());
        }
        return results;
    }

    public MongoClient connect(String databaseName, String username, String passwd, String ip, int port, boolean auth) throws Exception {
        MongoClient client = null;
        if (auth) {
            MongoCredential credential = MongoCredential.createCredential((String)username, (String)databaseName, (char[])passwd.toCharArray());
            ServerAddress addr = new ServerAddress(ip, port);
            client = new MongoClient(addr, Arrays.asList(credential));
        } else {
            client = new MongoClient(ip, port);
        }
        return client;
    }
}

