/*
 * Decompiled with CFR 0.152.
 */
package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import bean.View;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import util.JdbcCacheUtil;
import util.getdata.CacheData;
import util.getdata.SparkTool;

public class CacheSparkSQL
extends CacheData {
    public CacheSparkSQL(DataBase dataBase, CountDownLatch cdl) {
        super(dataBase, cdl);
    }

    @Override
    public void run() {
        System.out.println("SparkSQL\u5f00\u59cb\u7f13\u5b58");
        try {
            this.cacheWriteToRedis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                JdbcCacheUtil.closeConnection(this.connection);
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            this.getCdl().countDown();
            System.out.println("SparkSQL\u7ed3\u675f\u7f13\u5b58");
        }
    }

    @Override
    public List<Schema> cacheToMemory() throws SQLException {
        this.connection = JdbcCacheUtil.getConnection(this.DataBase.getUrl(), this.DataBase.getUsername(), this.DataBase.getPassword());
        this.statement = this.connection.createStatement();
        SparkTool spark = new SparkTool(this.connection);
        List<Schema> schemaList = spark.loadDatabase(this.DataBase);
        this.toUppercase(schemaList);
        this.DataBase.setCaseSensitive(false);
        return schemaList;
    }

    @Override
    public List<Schema> getSchema(Statement statement) throws SQLException {
        return null;
    }

    @Override
    public List<Table> getTable(Statement statement, String schema) throws SQLException {
        return null;
    }

    @Override
    public List<Column> getColumn(Statement statement, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public List<View> getView(Statement statement, String schema) throws SQLException {
        return null;
    }

    private void toUppercase(List<Schema> schemaList) {
        if (schemaList != null && schemaList.size() != 0) {
            for (Schema schema : schemaList) {
                if (schema == null) continue;
                schema.setName(schema.getName());
                if (schema.getViewList() != null && schema.getViewList().size() > 0) {
                    for (View view : schema.getViewList()) {
                        if (view == null) continue;
                        view.setName(view.getName());
                    }
                }
                if (schema.getTableList() == null || schema.getTableList().size() <= 0) continue;
                for (Table table : schema.getTableList()) {
                    if (table == null) continue;
                    table.setName(table.getName());
                    if (table.getColumnList() == null || table.getColumnList().size() == 0) continue;
                    for (Column column : table.getColumnList()) {
                        if (column == null) continue;
                        column.setColumnName(column.getColumnName());
                    }
                }
            }
        }
    }

    static {
        try {
            Class.forName("org.apache.hive.jdbc.HiveDriver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

