/*
 * Decompiled with CFR 0.152.
 */
package util.getdata;

import bean.DataBase;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import util.JdbcCacheUtil;
import util.getdata.CacheDB2;
import util.getdata.CacheData;
import util.getdata.CacheDm;
import util.getdata.CacheEs;
import util.getdata.CacheGauss;
import util.getdata.CacheGbase;
import util.getdata.CacheGbase8S;
import util.getdata.CacheGreenPlum;
import util.getdata.CacheHbase;
import util.getdata.CacheHive;
import util.getdata.CacheHiveTDH;
import util.getdata.CacheKingBase;
import util.getdata.CacheMongoDB;
import util.getdata.CacheMysql;
import util.getdata.CacheOracle;
import util.getdata.CachePostgreSql;
import util.getdata.CacheSparkSQL;
import util.getdata.CacheSqlServer;

public class DataBaseGetData
implements Runnable {
    private List<DataBase> dataBaseList = new ArrayList<DataBase>();
    private List<DataBase> oldDataBaseList;
    public ExecutorService threadPool = Executors.newFixedThreadPool(10);
    public CountDownLatch cdl = null;
    private String json = "";

    public DataBaseGetData(List<DataBase> dataBaseList) {
        this.oldDataBaseList = dataBaseList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheData() {
        List<DataBase> list = this.oldDataBaseList;
        synchronized (list) {
            block17: {
                long stime = System.currentTimeMillis();
                boolean var18 = false;
                try {
                    var18 = true;
                    DataBase dataBaseSource = JSONObject.parseObject(this.json, DataBase.class);
                    boolean exist = false;
                    for (DataBase dataBase : JdbcCacheUtil.dataBaseList) {
                        try {
                            this.dataBaseList.add(dataBase.clone());
                        }
                        catch (CloneNotSupportedException e) {
                            e.printStackTrace();
                        }
                    }
                    for (DataBase dataBase : this.dataBaseList) {
                        if (!dataBase.getIp_port().equals(dataBaseSource.getIp_port())) continue;
                        exist = true;
                        break;
                    }
                    if (!exist) {
                        this.dataBaseList.add(dataBaseSource);
                    }
                    this.cdl = new CountDownLatch(this.dataBaseList.size());
                    for (DataBase dataBase : this.dataBaseList) {
                        try {
                            this.cacheInfo(dataBase, this.cdl);
                        }
                        catch (Exception e) {
                            this.cdl.countDown();
                            e.printStackTrace();
                        }
                    }
                    this.cdl.await();
                    var18 = false;
                    break block17;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    var18 = false;
                }
                finally {
                    if (var18) {
                        long var10 = System.currentTimeMillis();
                        this.threadPool.shutdown();
                        this.oldDataBaseList.clear();
                        this.oldDataBaseList.addAll(this.dataBaseList);
                    }
                }
                long etime = System.currentTimeMillis();
                this.threadPool.shutdown();
                this.oldDataBaseList.clear();
                this.oldDataBaseList.addAll(this.dataBaseList);
                return;
            }
            long etime = System.currentTimeMillis();
            this.threadPool.shutdown();
            this.oldDataBaseList.clear();
            this.oldDataBaseList.addAll(this.dataBaseList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<DataBase> list = this.oldDataBaseList;
        synchronized (list) {
            block17: {
                long stime = System.currentTimeMillis();
                boolean var18 = false;
                try {
                    var18 = true;
                    DataBase dataBaseSource = JSONObject.parseObject(this.json, DataBase.class);
                    boolean exist = false;
                    for (DataBase dataBase : JdbcCacheUtil.dataBaseList) {
                        try {
                            this.dataBaseList.add(dataBase.clone());
                        }
                        catch (CloneNotSupportedException e) {
                            e.printStackTrace();
                        }
                    }
                    for (DataBase dataBase : this.dataBaseList) {
                        if (!dataBase.getIp_port().equals(dataBaseSource.getIp_port())) continue;
                        exist = true;
                        dataBase.setIncludeSchema(dataBaseSource.getIncludeSchema());
                        break;
                    }
                    if (!exist) {
                        this.dataBaseList.add(dataBaseSource);
                    }
                    this.cdl = new CountDownLatch(this.dataBaseList.size());
                    for (DataBase dataBase : this.dataBaseList) {
                        try {
                            this.cacheInfo(dataBase, this.cdl);
                        }
                        catch (Exception e) {
                            this.cdl.countDown();
                            e.printStackTrace();
                        }
                    }
                    this.cdl.await();
                    var18 = false;
                    break block17;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    var18 = false;
                }
                finally {
                    if (var18) {
                        long var10 = System.currentTimeMillis();
                        this.threadPool.shutdown();
                        this.oldDataBaseList.clear();
                        this.oldDataBaseList.addAll(this.dataBaseList);
                    }
                }
                long etime = System.currentTimeMillis();
                this.threadPool.shutdown();
                this.oldDataBaseList.clear();
                this.oldDataBaseList.addAll(this.dataBaseList);
                return;
            }
            long etime = System.currentTimeMillis();
            this.threadPool.shutdown();
            this.oldDataBaseList.clear();
            this.oldDataBaseList.addAll(this.dataBaseList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.dataBaseList = new ArrayList<DataBase>();
        List<DataBase> list = this.oldDataBaseList;
        synchronized (list) {
            long stime;
            block16: {
                stime = System.currentTimeMillis();
                boolean var19 = false;
                try {
                    var19 = true;
                    DataBase dataBaseSource = JSONObject.parseObject(this.json, DataBase.class);
                    DataBase target = null;
                    boolean exist = false;
                    for (DataBase dataBase : JdbcCacheUtil.dataBaseList) {
                        try {
                            if (dataBase.getIp_port().equalsIgnoreCase(dataBaseSource.getIp_port())) {
                                target = dataBase;
                                continue;
                            }
                            this.dataBaseList.add(dataBase);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (target == null) {
                        target = dataBaseSource;
                    }
                    System.out.println("\u5f00\u59cb\u7f13\u5b58\u6570\u636e\u5e93\u6570\u636e");
                    this.cdl = new CountDownLatch(1);
                    try {
                        target.setIncludeSchema(dataBaseSource.getIncludeSchema());
                        this.refreshCacheInfo(target, this.cdl);
                    }
                    catch (Exception e) {
                        this.cdl.countDown();
                        e.printStackTrace();
                    }
                    this.cdl.await();
                    this.dataBaseList.add(target);
                    var19 = false;
                    break block16;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    var19 = false;
                }
                finally {
                    if (var19) {
                        long etime = System.currentTimeMillis();
                        this.threadPool.shutdown();
                        System.out.println("\u7ed3\u675f\u7f13\u5b58\u6570\u636e\u5e93\u6570\u636e,\u7528\u65f6\uff1a" + (etime - stime) / 1000L + "\u79d2");
                        this.oldDataBaseList.clear();
                        this.oldDataBaseList.addAll(this.dataBaseList);
                    }
                }
                long etime = System.currentTimeMillis();
                this.threadPool.shutdown();
                System.out.println("\u7ed3\u675f\u7f13\u5b58\u6570\u636e\u5e93\u6570\u636e,\u7528\u65f6\uff1a" + (etime - stime) / 1000L + "\u79d2");
                this.oldDataBaseList.clear();
                this.oldDataBaseList.addAll(this.dataBaseList);
                return;
            }
            long etime = System.currentTimeMillis();
            this.threadPool.shutdown();
            System.out.println("\u7ed3\u675f\u7f13\u5b58\u6570\u636e\u5e93\u6570\u636e,\u7528\u65f6\uff1a" + (etime - stime) / 1000L + "\u79d2");
            this.oldDataBaseList.clear();
            this.oldDataBaseList.addAll(this.dataBaseList);
        }
    }

    public void refreshCacheInfo(DataBase dataBase, CountDownLatch cdl) {
        dataBase.setUpdateTime(new Date());
        CacheData cacheData = null;
        String dbType = dataBase.getDbType();
        if (!("mysql".equals(dbType) || "mariadb".equals(dbType) || "kundb".equals(dbType))) {
            if ("oracle".equals(dbType)) {
                cacheData = new CacheOracle(dataBase, cdl);
            } else if ("postgresql".equals(dbType)) {
                cacheData = new CachePostgreSql(dataBase, cdl);
            } else if ("hive".equals(dbType)) {
                cacheData = new CacheHive(dataBase, cdl);
            } else if ("dm".equals(dbType)) {
                cacheData = new CacheDm(dataBase, cdl);
            } else if ("db2".equals(dbType)) {
                cacheData = new CacheDB2(dataBase, cdl);
            } else if (!("MSSQLSERVER".equals(dbType) || "mssqlserver".equals(dbType) || "sql server".equals(dbType))) {
                if ("kingbase".equals(dbType)) {
                    cacheData = new CacheKingBase(dataBase, cdl);
                } else if ("gbase".equals(dbType)) {
                    cacheData = new CacheGbase(dataBase, cdl);
                } else if ("hbase".equals(dbType)) {
                    cacheData = new CacheHbase(dataBase, cdl);
                } else if ("greenplum".equals(dbType)) {
                    cacheData = new CacheGreenPlum(dataBase, cdl);
                } else if ("gauss".equals(dbType)) {
                    cacheData = new CacheGauss(dataBase, cdl);
                } else if ("gbase8s".equals(dbType)) {
                    cacheData = new CacheGbase8S(dataBase, cdl);
                } else if ("hive_tdh".equals(dbType)) {
                    cacheData = new CacheHiveTDH(dataBase, cdl);
                } else if ("sparksql".equals(dbType)) {
                    cacheData = new CacheSparkSQL(dataBase, cdl);
                } else if ("mongodb".equals(dbType)) {
                    cacheData = new CacheMongoDB(dataBase, cdl);
                } else if ("es".equals(dbType)) {
                    cacheData = new CacheEs(dataBase, cdl);
                }
            } else {
                cacheData = new CacheSqlServer(dataBase, cdl);
            }
        } else {
            cacheData = new CacheMysql(dataBase, cdl);
        }
        this.threadPool.execute(cacheData);
    }

    public void cacheInfo(DataBase dataBase, CountDownLatch cdl) {
        if (!this.checkExpire(dataBase.getUpdateTime())) {
            cdl.countDown();
        } else {
            dataBase.setUpdateTime(new Date());
            CacheData cacheData = null;
            String dbType = dataBase.getDbType();
            if (!("mysql".equals(dbType) || "mariadb".equals(dbType) || "kundb".equals(dbType))) {
                if ("oracle".equals(dbType)) {
                    cacheData = new CacheOracle(dataBase, cdl);
                } else if ("postgresql".equals(dbType)) {
                    cacheData = new CachePostgreSql(dataBase, cdl);
                } else if ("hive".equals(dbType)) {
                    cacheData = new CacheHive(dataBase, cdl);
                } else if ("dm".equals(dbType)) {
                    cacheData = new CacheDm(dataBase, cdl);
                } else if ("db2".equals(dbType)) {
                    cacheData = new CacheDB2(dataBase, cdl);
                } else if (!("MSSQLSERVER".equals(dbType) || "mssqlserver".equals(dbType) || "sql server".equals(dbType))) {
                    if ("kingbase".equals(dbType)) {
                        cacheData = new CacheKingBase(dataBase, cdl);
                    } else if ("gbase".equals(dbType)) {
                        cacheData = new CacheGbase(dataBase, cdl);
                    } else if ("hbase".equals(dbType)) {
                        cacheData = new CacheHbase(dataBase, cdl);
                    } else if ("greenplum".equals(dbType)) {
                        cacheData = new CacheGreenPlum(dataBase, cdl);
                    } else if ("gauss".equals(dbType)) {
                        cacheData = new CacheGauss(dataBase, cdl);
                    } else if ("gbase8s".equals(dbType)) {
                        cacheData = new CacheGbase8S(dataBase, cdl);
                    } else if ("hive_tdh".equals(dbType)) {
                        cacheData = new CacheHiveTDH(dataBase, cdl);
                    } else if ("es".equals(dbType)) {
                        cacheData = new CacheEs(dataBase, cdl);
                    } else if ("sparksql".equals(dbType)) {
                        cacheData = new CacheSparkSQL(dataBase, cdl);
                    } else if ("mongodb".equals(dbType)) {
                        cacheData = new CacheMongoDB(dataBase, cdl);
                    }
                } else {
                    cacheData = new CacheSqlServer(dataBase, cdl);
                }
            } else {
                cacheData = new CacheMysql(dataBase, cdl);
            }
            this.threadPool.execute(cacheData);
        }
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public boolean checkExpire(Date updateTime) {
        if (updateTime == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        long update = updateTime.getTime() + 300000L;
        return update < now;
    }
}

