/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.hive.ast.stmt.HiveAlterDatabaseStatement;
import com.alibaba.druid.sql.dialect.hive.ast.stmt.HiveCreateTableStatement;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.util.StringUtils;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import util.DataUtil;
import util.JdbcUtil;
import util.SqlUtil;
import util.StringJoin;
import util.log.SQLLogger;
import util.sqlparse.visitor.common.Context;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.hive.HiveNameWrapper;
import util.sqlparse.visitor.hive.SQLParser;
import util.sqlparse.visitor.hive.visitor.FieldVisitor;
import util.sqlparse.visitor.hive.visitor.HiveScopeDialector;
import util.sqlparse.visitor.hive.visitor.ScopeVisitor;

public class HiveParse {
    public HashMap<String, List<Column>> tableList = new HashMap();
    public List<Column> columnList = new ArrayList<Column>();
    public Map<String, String> tableMap = new HashMap<String, String>();
    public Map<String, String> unionTableMap = new HashMap<String, String>();
    public Map<String, String> schemaMap = new HashMap<String, String>();
    public Map<String, String> whereMap = new HashMap<String, String>();
    public Map<String, String> params;
    public List<Map<String, Object>> whereList = new ArrayList<Map<String, Object>>();
    public List<Map<String, Object>> whereValueList = new ArrayList<Map<String, Object>>();
    public String dbType = "hive";

    public HiveParse(Map<String, String> params) {
        this.params = params;
    }

    public HiveParse() {
    }

    public String rowVisitControl(Map<String, Object> param) throws SQLException {
        String sql = (String)param.get("sql");
        if ("".equalsIgnoreCase(sql)) {
            return sql;
        }
        Map tableKeyWord = (Map)param.get("tableKeyWord");
        Map modifyTable = (Map)param.get("modifyTable");
        String operateType = (String)param.get("operateType");
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, this.dbType);
        SQLStatement sqlStatement = stmtList.get(0);
        SchemaStatVisitor visitor = SQLUtils.createSchemaStatVisitor(DbType.of(this.dbType));
        sqlStatement.accept(visitor);
        Map<TableStat.Name, TableStat> tables = visitor.getTables();
        for (TableStat.Name tableName : tables.keySet()) {
            TableStat tableStat;
            String tableType;
            String name = tableName.getName();
            if (name.split("\\.").length > 1) {
                name = name.split("\\.")[1];
            }
            if (!tableKeyWord.containsKey(name) || (tableType = (tableStat = tables.get(tableName)).toString()).equalsIgnoreCase(operateType)) continue;
            modifyTable.remove(name);
            tableKeyWord.remove(name);
        }
        sql = this.addWhereCondition(param);
        return sql;
    }

    public String addWhereCondition(Map<String, Object> param) throws SQLException {
        String sql = (String)param.get("sql");
        String sqlType = HiveParse.getSqlType(sql, this.dbType);
        if ("select".equals(sqlType)) {
            SQLSelectQueryBlock query = this.aliParseSelect(this.dbType, sql, false);
            this.parseFromAndAddWhereCondition(query.getFrom(), param);
            sql = query.toString();
        } else if ("update".equals(sqlType)) {
            SQLUpdateStatement update = this.aliParseUpdate(this.dbType, sql);
            this.parseUpdateAndAddWhereCondition(update, param);
            sql = update.toString();
        } else if ("delete".equals(sqlType)) {
            SQLDeleteStatement delete = this.aliParseDelete(this.dbType, sql);
            this.parseDeleteAndAddWhereCondition(delete, param);
            sql = delete.toString();
        }
        return sql;
    }

    public void parseFromAndAddWhereCondition(SQLTableSource from, Map<String, Object> param) {
        if (from instanceof SQLExprTableSource) {
            Map modifyTable = (Map)param.get("modifyTable");
            Map tableKeyWord = (Map)param.get("tableKeyWord");
            SQLExprTableSource fromContent = (SQLExprTableSource)from;
            String[] split = fromContent.getExpr().toString().split("\\.");
            String tableName = "";
            tableName = split.length > 1 ? split[1] : split[0];
            tableName = tableName.replaceAll("`", "");
            String tableAlisa = fromContent.getAlias();
            tableAlisa = tableAlisa == null ? tableName : tableAlisa;
            SQLObject parent = fromContent.getParent();
            while (!(parent instanceof SQLSelectQueryBlock) && !(parent instanceof SQLDeleteStatement)) {
                parent = parent.getParent();
            }
            if (parent instanceof SQLSelectQueryBlock) {
                SQLSelectQueryBlock p = (SQLSelectQueryBlock)parent;
                for (String key : modifyTable.keySet()) {
                    if (!key.equalsIgnoreCase(tableName)) continue;
                    String id = (String)tableKeyWord.get(tableName);
                    String condition = "(" + tableAlisa + "." + id + " not in ('";
                    condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
                    condition = condition + " or " + tableAlisa + "." + id + " is null)";
                    p.addCondition(condition);
                }
            } else if (parent instanceof SQLDeleteStatement) {
                SQLDeleteStatement p = (SQLDeleteStatement)parent;
                for (String key : modifyTable.keySet()) {
                    if (!key.equalsIgnoreCase(tableName)) continue;
                    String id = (String)tableKeyWord.get(tableName);
                    String condition = tableAlisa + "." + id + " not in ('";
                    condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
                    p.addCondition(condition);
                }
            }
        } else if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
            SQLTableSource left = fromContent.getLeft();
            this.parseFromAndAddWhereCondition(left, param);
            SQLTableSource right = fromContent.getRight();
            this.parseFromAndAddWhereCondition(right, param);
        } else if (from instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
            String alias = fromContent.getAlias();
            SQLUnionQuery union = fromContent.getUnion();
            ArrayList<SQLSelectQueryBlock> unionList = new ArrayList<SQLSelectQueryBlock>();
            this.parseUnionFrom(union, unionList);
        } else if (from instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
            SQLSelect select = fromContent.getSelect();
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
            this.parseFromAndAddWhereCondition(query.getFrom(), param);
        }
    }

    public void parseUpdateAndAddWhereCondition(SQLUpdateStatement update, Map<String, Object> param) {
        String tableName;
        Map modifyTable = (Map)param.get("modifyTable");
        Map tableKeyWord = (Map)param.get("tableKeyWord");
        SQLName table = update.getTableName();
        String tableAlisa = tableName = table.getSimpleName();
        String[] tableInfo = tableName.split("\\.");
        if (tableInfo.length > 1) {
            tableName = tableInfo[1];
            tableAlisa = tableInfo[0];
        }
        for (String key : modifyTable.keySet()) {
            if (!key.equalsIgnoreCase(tableName)) continue;
            String id = (String)tableKeyWord.get(tableName);
            String condition = "(" + tableAlisa + "." + id + " not in ('";
            condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
            condition = condition + " or " + tableAlisa + "." + id + " is null)";
            update.addCondition(condition);
        }
    }

    public void parseDeleteAndAddWhereCondition(SQLDeleteStatement delete, Map<String, Object> param) {
        String tableName;
        Map modifyTable = (Map)param.get("modifyTable");
        Map tableKeyWord = (Map)param.get("tableKeyWord");
        SQLName table = delete.getTableName();
        String tableAlisa = tableName = table.getSimpleName();
        String[] tableInfo = tableName.split("\\.");
        if (tableInfo.length > 1) {
            tableName = tableInfo[1];
            tableAlisa = tableInfo[0];
        }
        for (String key : modifyTable.keySet()) {
            if (!key.equalsIgnoreCase(tableName)) continue;
            String id = (String)tableKeyWord.get(tableName);
            String condition = "(" + tableAlisa + "." + id + " not in ('";
            condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
            condition = condition + " or " + tableAlisa + "." + id + " is null)";
            delete.addCondition(condition);
        }
    }

    public String parseSql() {
        String sql = this.params.get("sql").replaceAll("`", "");
        String schema = this.params.get("schema");
        String parseSql = sql;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("schema", schema);
        paramMap.put("sql", sql);
        paramMap.put("params", this.params);
        try {
            this.parseSqlStructure(paramMap);
            parseSql = DataUtil.dataDesensitization(paramMap);
        }
        catch (Exception throwables) {
            throwables.printStackTrace();
            SqlUtil.getAnalysisSqlList().add(sql);
        }
        return parseSql;
    }

    public String parseSql_column() {
        String sql = this.params.get("sql");
        String schema = this.params.get("schema");
        String parseSql = sql;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("schema", schema);
        paramMap.put("sql", sql);
        paramMap.put("params", this.params);
        try {
            this.parseSqlStructure(paramMap);
            parseSql = DataUtil.columnDesensitization(paramMap);
        }
        catch (Exception throwables) {
            throwables.printStackTrace();
        }
        return parseSql;
    }

    public String parseSql_table() {
        String sql = this.params.get("sql");
        String schema = this.params.get("schema");
        String parseSql = sql;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("schema", schema);
        paramMap.put("sql", sql);
        paramMap.put("params", this.params);
        try {
            this.parseSqlStructure(paramMap);
            parseSql = DataUtil.tableDesensitization(paramMap);
        }
        catch (Exception throwables) {
            throwables.printStackTrace();
        }
        return parseSql;
    }

    public String parseSql_data() {
        String sql = this.params.get("sql");
        String schema = this.params.get("schema");
        String parseSql = sql;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("schema", schema);
        paramMap.put("sql", sql);
        paramMap.put("params", this.params);
        try {
            this.parseSqlStructure(paramMap);
            parseSql = DataUtil.desensitization(paramMap);
        }
        catch (Exception throwables) {
            throwables.printStackTrace();
        }
        return parseSql;
    }

    public static String getIpPort(String url) {
        String[] urlSplit = url.split("/");
        String ip_port = urlSplit[2];
        return ip_port;
    }

    public void parseSqlStructure(Map<String, Object> paramMap) throws SQLException {
        String sql = this.params.get("sql");
        boolean isEncryption = this.params.containsKey("encryption");
        String sqlType = HiveParse.getSqlType(sql, this.dbType);
        List<SQLStatement> statements = SQLUtils.parseStatements(sql, "hive");
        if (!("union".equals(sqlType) || "select".equals(sqlType) || "with_select".equals(sqlType) || "insert".equals(sqlType) || "update".equals(sqlType) || "delete".equals(sqlType) || "insert_select".equals(sqlType))) {
            if ("create".equals(sqlType)) {
                SQLCreateStatement drop = this.parseCreate(this.dbType, sql);
                paramMap.put("type", "create");
                paramMap.put("statement", drop);
                paramMap.put("sql", drop.toString());
            } else if ("alter".equals(sqlType)) {
                HiveAlterDatabaseStatement alter = this.parseAlter(this.dbType, sql);
                paramMap.put("type", "alter");
                paramMap.put("statement", alter);
                paramMap.put("sql", alter.toString());
            } else if ("drop".equals(sqlType)) {
                SQLDropTableStatement drop = this.parseDrop(this.dbType, sql);
                paramMap.put("type", "drop");
                paramMap.put("statement", drop);
                paramMap.put("sql", drop.toString());
            } else if ("grant".equals(sqlType)) {
                SQLGrantStatement grant = this.parseGrant(this.dbType, sql);
                paramMap.put("type", "grant");
                paramMap.put("statement", grant);
                paramMap.put("sql", grant.toString());
            } else if ("revoke".equals(sqlType)) {
                SQLRevokeStatement revoke = this.parseRevoke(this.dbType, sql);
                paramMap.put("type", "revoke");
                paramMap.put("statement", revoke);
                paramMap.put("sql", revoke.toString());
            } else if ("drop_other".equals(sqlType)) {
                SQLDDLStatement drop = this.parseDropOther(this.dbType, sql);
                paramMap.put("type", "drop");
                paramMap.put("statement", drop);
                paramMap.put("sql", drop.toString());
            } else {
                List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, this.dbType);
                SQLStatement statement = stmtList.get(0);
                paramMap.put("type", sqlType);
                paramMap.put("statement", statement);
                paramMap.put("sql", statement.toString());
            }
        } else {
            String permission = this.params.get("permission");
            String url = this.params.get("url");
            String schema = this.params.get("schema");
            String ip_port = HiveParse.getIpPort(url);
            DataBase dataBase = new DataBase();
            for (DataBase db : JdbcUtil.dataBaseList) {
                if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
                dataBase = db;
                break;
            }
            SQLParser sqlParser = new SQLParser();
            SQLResult parse = sqlParser.parse(sql, dataBase, schema);
            if ("alter".equals(sqlType)) {
                parse.outputs = parse.fields;
            }
            List<FieldInfo> columnlist = "masking".equalsIgnoreCase(permission) ? parse.outputs : ("full".equalsIgnoreCase(permission) ? parse.fields : (isEncryption ? (!"insert".equalsIgnoreCase(sqlType) && !"update".equalsIgnoreCase(sqlType) ? parse.outputs : parse.fields) : parse.outputs));
            HiveNameWrapper wrapper = new HiveNameWrapper(dataBase.simpleCache);
            HashSet<String> tabSet = new HashSet<String>();
            for (FieldInfo fieldInfo : columnlist) {
                List<Object> fieldInfoList = new ArrayList<FieldInfo>();
                if (fieldInfo.getRelations().size() > 0) {
                    fieldInfoList = fieldInfo.getRelations();
                } else {
                    fieldInfoList.add(fieldInfo);
                }
                for (FieldInfo fieldInfo2 : fieldInfoList) {
                    String name = fieldInfo2.getName();
                    if (StringUtils.isEmpty(name)) continue;
                    Map<String, TableInfo> tables = fieldInfo2.getTables();
                    String tableName = "";
                    String schemaName = "";
                    for (String string : tables.keySet()) {
                        String[] segment = string.split("\\.");
                        if (StringUtils.isEmpty(segment[0]) || StringUtils.isEmpty(segment[1])) continue;
                        schemaName = segment[0];
                        tableName = segment[1];
                        break;
                    }
                    if (tableName.length() == 0 && fieldInfo2.getTables().size() > 0) {
                        for (Map.Entry entry : fieldInfo2.getTables().entrySet()) {
                            TableInfo tbInfo = (TableInfo)entry.getValue();
                            if (tbInfo == null || tbInfo.getTable() == null || StringUtils.isEmpty(tbInfo.getTable().schema) || StringUtils.isEmpty(tbInfo.getTable().name)) continue;
                            tableName = tbInfo.getTable().name;
                            schemaName = tbInfo.getTable().schema;
                            break;
                        }
                    }
                    schemaName = wrapper.unwrapSchema(schemaName);
                    tableName = wrapper.unwrapTable(schemaName, tableName);
                    tabSet.add(tableName);
                    if (name.equalsIgnoreCase("ROWID") || name.equalsIgnoreCase("ORA_ROWSCN")) continue;
                    Column column = new Column();
                    column.setColumnName(tableName + "." + name);
                    column.setTable(tableName);
                    column.setSchema(schemaName);
                    column.setColumnAlisa(fieldInfo2.getAlias());
                    column.setSubQuery(false);
                    this.columnList.add(column);
                }
            }
            for (TableInfo table : parse.tables) {
                TableMemo tb = table.getTable();
                String schName = wrapper.unwrapSchema(tb.schema);
                String string = wrapper.unwrapTable(schName, tb.name);
                this.tableMap.put(string, string);
                this.schemaMap.put(string, schName);
            }
            for (ValueInfo value : parse.values) {
                FieldMemo field = value.field;
                this.whereMap.put(field.name, value.value.toString());
                HashMap<String, String> map = new HashMap<String, String>();
                String string = value.getValueNames();
                map.put("column", string.substring(0, string.length() - 1));
                map.put("columnValue", value.value.toString());
                map.put("type", value.operator);
                this.whereList.add(map);
            }
            paramMap.put("whereList", this.whereList);
            paramMap.put("statement", parse.statement);
            paramMap.put("type", sqlType);
            paramMap.put("sql", parse.statement.toString());
            wrapper.unwrapFullColumns(this.columnList);
        }
        paramMap.put("whereMap", this.whereMap);
        paramMap.put("tableMap", this.tableMap);
        paramMap.put("columnList", this.columnList);
        paramMap.put("schemaMap", this.schemaMap);
    }

    public String parseSelect(String dbType, String sql) throws SQLException {
        SQLSelectQueryBlock query = this.aliParseSelect(dbType, sql, true);
        this.parseFrom(query.getFrom(), null);
        sql = this.parseSelectStar(query);
        query = this.aliParseSelect(dbType, sql, false);
        this.parseQueryColumns(query, "");
        sql = this.parseSelectStar(query);
        return sql;
    }

    public SQLSelectQueryBlock aliParseSelect(String dbType, String sql, boolean first) throws SQLException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
        SQLSelect select = stmt.getSelect();
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
        if (first) {
            query = JdbcUtil.hiveJudgeViewAndModify(query, this.params, this.tableList);
        }
        return query;
    }

    public Map<String, String> parseFrom(SQLTableSource from, Map<String, String> map) throws SQLException {
        String className = from.getClass().getName();
        if (className.contains("SQLExprTableSource")) {
            SQLExprTableSource fromContent = (SQLExprTableSource)from;
            String tableName = fromContent.getExpr().toString();
            String tableAlisa = fromContent.getAlias();
            String exprClass = fromContent.getExpr().getClass().getName();
            if (exprClass.contains("SQLPropertyExpr")) {
                SQLPropertyExpr expr = (SQLPropertyExpr)fromContent.getExpr();
                tableName = expr.getName();
                String owner = expr.getOwner().toString();
                this.schemaMap.put(tableName, owner);
            } else {
                String owner = this.params.get("schema");
                SQLIdentifierExpr expr = (SQLIdentifierExpr)fromContent.getExpr();
                SQLPropertyExpr pExpr = new SQLPropertyExpr();
                pExpr.setName(expr.getName());
                pExpr.setOwner(owner);
                fromContent.setExpr(pExpr);
                this.schemaMap.put(tableName, owner);
            }
            if (map == null) {
                this.tableMap.put(tableAlisa == null ? tableName : tableAlisa, tableName);
            } else {
                map.put(tableAlisa == null ? tableName : tableAlisa, tableName);
            }
        } else if (className.contains("SQLJoinTableSource")) {
            SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
            SQLTableSource left = fromContent.getLeft();
            this.parseFrom(left, map);
            SQLTableSource right = fromContent.getRight();
            this.parseFrom(right, map);
        } else if (className.contains("SQLUnionQueryTableSource")) {
            SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
            String alias = fromContent.getAlias();
            SQLUnionQuery union = fromContent.getUnion();
            ArrayList<SQLSelectQueryBlock> unionList = new ArrayList<SQLSelectQueryBlock>();
            this.parseUnionFrom(union, unionList);
            this.paresUnionFromSql(unionList, alias);
            if (map == null) {
                this.tableMap.put(alias, alias);
            } else {
                map.put(alias, alias);
            }
        } else if (className.contains("SQLSubqueryTableSource")) {
            SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
            SQLSelect select = fromContent.getSelect();
            if (map == null) {
                SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
                this.parseFrom(query.getFrom(), null);
                String sql = this.parseSelectStar(query);
                query = this.aliParseSelect(this.params.get("dbType"), sql, false);
                this.parseQueryColumns(query, fromContent.getAlias());
                this.tableMap.put(fromContent.getAlias(), fromContent.getAlias());
            } else {
                map.put(fromContent.getAlias(), fromContent.getAlias());
            }
        }
        return this.tableMap;
    }

    public void parseUnionFrom(SQLUnionQuery union, List<SQLSelectQueryBlock> unionList) {
        List<SQLSelectQuery> queryList = union.getRelations();
        for (int i = 0; i < queryList.size(); ++i) {
            SQLSelectQuery selectQuery = queryList.get(i);
            String className = selectQuery.getClass().getName();
            if (className.contains("SQLUnionQuery")) {
                SQLUnionQuery unQuery = (SQLUnionQuery)selectQuery;
                this.parseUnionFrom(unQuery, unionList);
                continue;
            }
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
            unionList.add(query);
        }
    }

    public void paresUnionFromSql(List<SQLSelectQueryBlock> unionList, String alias) throws SQLException {
        for (int i = 0; i < unionList.size(); ++i) {
            this.unionTableMap.clear();
            SQLSelectQueryBlock query = unionList.get(i);
            SQLExprTableSource fromContent = (SQLExprTableSource)query.getFrom();
            String tableName = fromContent.getExpr().toString();
            String tableAlisa = fromContent.getAlias();
            this.unionTableMap.put(tableAlisa == null ? tableName : tableAlisa, tableName);
            this.tableMap.put(tableAlisa == null ? tableName : tableAlisa, tableName);
            String sql = this.parseSelectStar(query);
            if (i != unionList.size() - 1) continue;
            query = this.aliParseSelect(this.dbType, sql, false);
            this.parseQueryColumns(query, alias);
        }
    }

    public String parseSelectStar(SQLSelectQueryBlock query) throws SQLException {
        String sql = query.toString();
        for (SQLSelectItem field : query.getSelectList()) {
            String column;
            String[] columns = field.getExpr().toString().trim().split("\\.");
            String alias = columns[0];
            String string = column = columns.length == 1 ? columns[0] : columns[1];
            if ("*".equalsIgnoreCase(column)) {
                HashMap<String, String> map = new HashMap<String, String>();
                this.parseFrom(query.getFrom(), map);
                sql = this.columnReplaceStar(sql, alias, map);
                continue;
            }
            if (columns.length != 1) continue;
            ArrayList<Column> sqlExprList = new ArrayList<Column>();
            SQLExpr fieldExpr = field.getExpr();
            this.parseSQLExpr(fieldExpr, fieldExpr, sqlExprList, false);
            for (Column col : sqlExprList) {
                this.columnAddTableAlias(col.getExpr());
            }
            sql = query.toString();
        }
        return sql;
    }

    public void columnAddTableAlias(SQLExpr fieldExpr) throws SQLException {
        String column = fieldExpr.toString();
        if (!"*".equalsIgnoreCase(column)) {
            String columnName;
            String[] split;
            String schema_real;
            String schema_temp;
            String url = this.params.get("url");
            String schema = this.params.get("schema");
            String ip_port = url.split("/")[2];
            SQLIdentifierExpr expr = (SQLIdentifierExpr)fieldExpr;
            String sql = fieldExpr.toString();
            for (String s : this.tableList.keySet()) {
                for (Column tableColumn : this.tableList.get(s)) {
                    String columnName2;
                    String[] split2 = tableColumn.getColumnName().split("\\.");
                    if (split2.length < 2 || !(columnName2 = split2[1]).equalsIgnoreCase(column.replaceAll("[\"`]", ""))) continue;
                    sql = sql.replaceAll(column, s + "." + column);
                    expr.setName(sql);
                    return;
                }
            }
            for (String key : this.unionTableMap.keySet()) {
                schema_temp = this.schemaMap.get(this.unionTableMap.get(key));
                schema_real = schema_temp == null ? schema : schema_temp;
                for (Column tableColumn : JdbcUtil.getTableColumns(ip_port, schema_real, this.unionTableMap.get(key), key, this.tableList)) {
                    split = tableColumn.getColumnName().split("\\.");
                    if (split.length < 2 || !(columnName = split[1]).equalsIgnoreCase(column.replaceAll("[\"`]", ""))) continue;
                    sql = sql.replaceAll(column, key + "." + column);
                    expr.setName(sql);
                    return;
                }
            }
            for (String key : this.tableMap.keySet()) {
                schema_temp = this.schemaMap.get(this.tableMap.get(key));
                schema_real = schema_temp == null ? schema : schema_temp;
                for (Column tableColumn : JdbcUtil.getTableColumns(ip_port, schema_real, this.tableMap.get(key), key, this.tableList)) {
                    split = tableColumn.getColumnName().split("\\.");
                    if (split.length < 2 || !(columnName = split[1]).equalsIgnoreCase(column.replaceAll("[\"`]", ""))) continue;
                    sql = sql.replaceAll(column, key + "." + column);
                    expr.setName(sql);
                    return;
                }
            }
        }
    }

    public String columnReplaceStar(String sql, String alias, Map<String, String> tableMap) throws SQLException {
        String url = this.params.get("url");
        String schema = this.params.get("schema");
        String ip_port = url.split("/")[2];
        ArrayList columns = new ArrayList();
        if ("*".equalsIgnoreCase(alias)) {
            for (String key : tableMap.keySet()) {
                String schema_temp = this.schemaMap.get(tableMap.get(key));
                String schema_real = schema_temp == null ? schema : schema_temp;
                List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema_real, tableMap.get(key), key, this.tableList);
                ArrayList<String> colList = new ArrayList<String>();
                for (int i = 0; i < tableColumns.size(); ++i) {
                    Column col = tableColumns.get(i);
                    String column = "";
                    column = col.getColumnAlisa() != null ? key + "." + col.getColumnAlisa() : key + "." + col.getColumnName().split("\\.")[1];
                    colList.add(column);
                }
                columns.addAll(colList);
            }
            if (columns.size() > 0) {
                sql = sql.replaceFirst("\\*", StringJoin.join(columns, ","));
            }
        } else if (tableMap.get(alias) != null) {
            List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema, tableMap.get(alias), alias, this.tableList);
            for (int i = 0; i < tableColumns.size(); ++i) {
                Column col = tableColumns.get(i);
                String column = "";
                column = col.getColumnAlisa() != null ? alias + "." + col.getColumnAlisa() : alias + "." + col.getColumnName().split("\\.")[1];
                columns.add(column);
            }
            if (columns.size() > 0) {
                sql = sql.replaceFirst(alias + "\\.\\*", StringJoin.join(columns, ","));
            }
        }
        return sql;
    }

    public void parseQueryColumns(SQLSelectQueryBlock query, String alias) throws SQLException {
        List<SQLSelectItem> fieldList = query.getSelectList();
        boolean isSub = !"".equalsIgnoreCase(alias);
        ArrayList<Column> temp = new ArrayList<Column>();
        for (SQLSelectItem field : fieldList) {
            SQLExpr fileExpr = field.getExpr();
            String className = fileExpr.getClass().toString();
            if (className.contains("SQLQueryExpr")) {
                String subQuery = this.parseSelect(this.dbType, field.getExpr().toString().replaceAll("\\(|\\)", ""));
                SQLSelectStatement stmt = (SQLSelectStatement)SQLUtils.parseStatements(subQuery, this.params.get("dbType")).get(0);
                SQLSelect select = stmt.getSelect();
                SQLQueryExpr sqlQueryExpr = new SQLQueryExpr(select);
                field.setExpr(sqlQueryExpr);
                continue;
            }
            ArrayList<Column> sqlExprList = new ArrayList<Column>();
            this.parseSQLExpr(fileExpr, fileExpr, sqlExprList, false);
            for (Column col_obj : sqlExprList) {
                SQLExpr sqlExpr = col_obj.getExpr();
                String columnName = sqlExpr.toString();
                Column column = new Column(columnName, field.getAlias(), isSub, alias);
                column.setMethod(col_obj.isMethod());
                column.setFullName(col_obj.getFullName());
                String[] columns = column.getColumnName().split("\\.");
                String c1 = columns[0];
                String c2 = columns.length > 1 ? columns[1] : columns[0];
                List<Column> list = this.tableList.get(c1);
                if (list != null) {
                    for (Column col : list) {
                        String s = col.getColumnName();
                        if (!JdbcUtil.sqlRegex(s, c2) && !JdbcUtil.sqlRegex(col.getColumnAlisa(), c2) || column.getFullName().trim().startsWith("count")) continue;
                        String colName = column.getColumnName();
                        String realName = "";
                        String own = "";
                        String now = "";
                        if (s.split("\\.").length > 1) {
                            realName = s;
                            own = s.split("\\.")[0];
                            now = s.split("\\.")[0] + "." + colName.split("\\.")[1];
                        } else {
                            realName = s;
                            own = colName.split("\\.")[0];
                            now = colName;
                        }
                        column.setColumnName(realName);
                        column.setNowName(now);
                        column.setSubQuery(true);
                        column.setSubAlisa(c1);
                        String fieldClassName = sqlExpr.getClass().getName();
                        if (!fieldClassName.contains("SQLPropertyExpr")) break;
                        SQLPropertyExpr expr = (SQLPropertyExpr)sqlExpr;
                        SQLIdentifierExpr owner = (SQLIdentifierExpr)expr.getOwner();
                        owner.setName(own);
                        break;
                    }
                }
                if (columns.length > 1) {
                    String url = this.params.get("url");
                    String schema = this.params.get("schema");
                    String schema_temp = this.schemaMap.get(c1);
                    String schema_real = schema_temp == null ? schema : schema_temp;
                    String ip_port = url.split("/")[2];
                    String columnDataType = JdbcUtil.getColumnDataType(ip_port, schema_real, this.tableMap.get(c1), c1, c2);
                    column.setDataType(columnDataType);
                }
                if (!isSub && !column.getFullName().trim().startsWith("count")) {
                    this.columnList.add(column);
                }
                temp.add(column);
            }
        }
        if (isSub) {
            this.tableList.put(alias, temp);
        }
    }

    public void parseSQLExpr(SQLExpr oldFileExpr, SQLExpr fileExpr, List<Column> sqlExprList, boolean isMethod) {
        String className = fileExpr.getClass().toString();
        if (!JdbcUtil.sqlRegex(className, "SQLPropertyExpr|SQLIdentifierExpr")) {
            if (className.contains("SQLAggregateExpr")) {
                SQLAggregateExpr expr = (SQLAggregateExpr)fileExpr;
                for (SQLExpr sqlExpr : expr.getArguments()) {
                    String name = sqlExpr.getClass().getName();
                    if (name.contains("SQLCharExpr")) continue;
                    this.parseSQLExpr(oldFileExpr, sqlExpr, sqlExprList, true);
                }
            } else if (className.contains("SQLMethodInvokeExpr")) {
                SQLMethodInvokeExpr expr = (SQLMethodInvokeExpr)fileExpr;
                for (SQLExpr sqlExpr : expr.getArguments()) {
                    String name = sqlExpr.getClass().getName();
                    if (name.contains("SQLCharExpr")) continue;
                    this.parseSQLExpr(oldFileExpr, sqlExpr, sqlExprList, true);
                }
            } else if (className.contains("SQLBinaryOpExpr")) {
                SQLBinaryOpExpr expr = (SQLBinaryOpExpr)fileExpr;
                SQLExpr left = expr.getLeft();
                SQLExpr right = expr.getRight();
                this.parseSQLExpr(oldFileExpr, left, sqlExprList, true);
                this.parseSQLExpr(oldFileExpr, right, sqlExprList, true);
            } else if (className.contains("SQLCaseExpr")) {
                SQLCaseExpr expr = (SQLCaseExpr)fileExpr;
                for (SQLCaseExpr.Item item : expr.getItems()) {
                    this.parseSQLExpr(oldFileExpr, item.getConditionExpr(), sqlExprList, true);
                }
            } else if (className.contains("SQLBetweenExpr")) {
                SQLBetweenExpr expr = (SQLBetweenExpr)fileExpr;
                this.parseSQLExpr(oldFileExpr, expr.getTestExpr(), sqlExprList, true);
            }
        } else {
            Column column = new Column(isMethod, fileExpr);
            column.setFullName(oldFileExpr.toString());
            sqlExprList.add(column);
        }
    }

    public SQLInsertStatement parseInsert(String dbType, String sql) throws SQLException {
        SQLInsertStatement insert = this.aliParseInsert(dbType, sql);
        this.parseInsertColumns(insert);
        return insert;
    }

    public SQLInsertStatement aliParseInsert(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLInsertStatement stmt = (SQLInsertStatement)stmtList.get(0);
        return stmt;
    }

    public void parseInsertColumns(SQLInsertStatement insert) throws SQLException {
        List<SQLInsertStatement.ValuesClause> valuesList;
        String tableName = insert.getTableName().getSimpleName();
        String url = this.params.get("url");
        String schema = this.params.get("schema");
        List<SQLExpr> columns = insert.getColumns();
        if (columns.size() == 0) {
            String ip_port = url.split("/")[2];
            String schema_temp = this.schemaMap.get(tableName);
            String schema_real = schema_temp == null ? schema : schema_temp;
            for (Column tableColumn : JdbcUtil.getTableColumnsNormal(ip_port, schema_real, tableName.toLowerCase(), "", this.tableList)) {
                SQLIdentifierExpr sqlIdentifierExpr = new SQLIdentifierExpr();
                sqlIdentifierExpr.setName(tableColumn.getColumnName());
                columns.add(sqlIdentifierExpr);
                Column column = new Column();
                column.setColumnName(tableName + "." + tableColumn.getColumnName());
                this.columnList.add(column);
            }
            this.tableMap.put(tableName, tableName);
        }
        if ((valuesList = insert.getValuesList()).size() == 0) {
            String dbType = this.params.get("dbType");
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)insert.getQuery().getQuery();
            String parseSql = this.parseSelect(dbType, query.toString());
            SQLSelectQueryBlock sqlSelectQueryBlock = this.aliParseSelect(dbType, parseSql, true);
            insert.getQuery().setQuery(sqlSelectQueryBlock);
        }
        this.schemaMap.put(tableName, schema);
    }

    public SQLUpdateStatement parseUpdate(String dbType, String sql) throws SQLException {
        SQLUpdateStatement update = this.aliParseUpdate(dbType, sql);
        this.parseUpdateColumns(update);
        return update;
    }

    public SQLUpdateStatement aliParseUpdate(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLUpdateStatement stmt = (SQLUpdateStatement)stmtList.get(0);
        return stmt;
    }

    public void parseUpdateColumns(SQLUpdateStatement update) {
        String tableName = update.getTableName().getSimpleName();
        SQLExprTableSource tableExpr = (SQLExprTableSource)update.getTableSource();
        SQLExpr expr1 = tableExpr.getExpr();
        String schema = this.params.get("schema");
        if (expr1 instanceof SQLIdentifierExpr) {
            SQLPropertyExpr expr = new SQLPropertyExpr();
            expr.setName(tableName);
            expr.setOwner(schema);
            tableExpr.setExpr(expr);
        } else if (expr1 instanceof SQLPropertyExpr) {
            schema = ((SQLPropertyExpr)expr1).getOwnerName();
        }
        this.schemaMap.put(tableName, schema);
        String alias = update.getTableSource().getAlias();
        String name = alias == null ? tableName : alias;
        for (SQLUpdateSetItem item : update.getItems()) {
            SQLExprImpl column;
            String className = item.getColumn().getClass().getName();
            String colName = "";
            String colValue = "";
            if (className.contains("SQLPropertyExpr")) {
                column = (SQLPropertyExpr)item.getColumn();
                colName = ((SQLPropertyExpr)column).getName();
                colValue = ((SQLUpdateSetItem)column.getParent()).getValue().toString();
            } else if (className.contains("SQLIdentifierExpr")) {
                column = (SQLIdentifierExpr)item.getColumn();
                colName = ((SQLIdentifierExpr)column).getName();
                colValue = ((SQLUpdateSetItem)column.getParent()).getValue().toString();
            }
            Column col = new Column();
            col.setColumnName(name + "." + colName);
            col.setValue(colValue);
            this.columnList.add(col);
        }
        this.tableMap.put(name, tableName);
    }

    public SQLDeleteStatement parseDelete(String dbType, String sql) throws SQLException {
        SQLDeleteStatement delete = this.aliParseDelete(dbType, sql);
        this.parseDeleteColumns(delete);
        return delete;
    }

    public SQLDeleteStatement aliParseDelete(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLDeleteStatement stmt = (SQLDeleteStatement)stmtList.get(0);
        return stmt;
    }

    public void parseDeleteColumns(SQLDeleteStatement delete) throws SQLException {
        String schema = this.params.get("schema");
        String url = this.params.get("url");
        String ip_port = url.split("/")[2];
        String tableName = delete.getTableName().getSimpleName();
        SQLExprTableSource tableExpr = (SQLExprTableSource)delete.getTableSource();
        SQLExpr expr1 = tableExpr.getExpr();
        if (expr1 instanceof SQLIdentifierExpr) {
            SQLPropertyExpr expr = new SQLPropertyExpr();
            expr.setName(tableName);
            expr.setOwner(schema);
            tableExpr.setExpr(expr);
        } else if (expr1 instanceof SQLPropertyExpr) {
            schema = ((SQLPropertyExpr)expr1).getOwnerName();
        }
        this.tableMap.put(tableName, tableName);
        this.schemaMap.put(tableName, schema);
        for (Column tableColumn : JdbcUtil.getTableColumns(ip_port, schema, tableName, tableName, this.tableList)) {
            Column column = new Column();
            column.setColumnName(tableColumn.getColumnName());
            this.columnList.add(column);
        }
    }

    public SQLTruncateStatement parseTruncate(String dbType, String sql) throws SQLException {
        SQLTruncateStatement truncate = this.aliParseTruncate(dbType, sql);
        this.parseTruncateColumns(truncate);
        return truncate;
    }

    public SQLTruncateStatement aliParseTruncate(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLTruncateStatement stmt = (SQLTruncateStatement)stmtList.get(0);
        return stmt;
    }

    public void parseTruncateColumns(SQLTruncateStatement truncate) {
        for (SQLExprTableSource sqlExprTableSource : truncate.getTableSources()) {
            String tableName = sqlExprTableSource.getName().getSimpleName();
            this.tableMap.put(tableName, tableName);
        }
    }

    public SQLCreateStatement parseCreate(String dbType, String sql) throws SQLException {
        SQLCreateStatement create = this.aliParseCreate(dbType, sql);
        this.parseCreateColumns(create);
        return create;
    }

    public SQLCreateStatement aliParseCreate(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLCreateStatement stmt = (SQLCreateStatement)stmtList.get(0);
        return stmt;
    }

    public void parseCreateColumns(SQLCreateStatement create) throws SQLException {
        String schema = this.params.get("schema");
        String name = create.getClass().getName();
        String tableName = "";
        if (name.contains("HiveCreateTableStatement")) {
            HiveCreateTableStatement createTable = (HiveCreateTableStatement)create;
            tableName = createTable.getTableName();
            List<SQLTableElement> tableElementList = createTable.getTableElementList();
            if (tableElementList.size() == 0) {
                SQLSelect subQuery = createTable.getSelect();
                if (subQuery != null) {
                    this.params.put("sql", subQuery.toString());
                    this.parseSqlStructure(new HashMap<String, Object>());
                }
            } else {
                for (SQLTableElement sqlTableElement : tableElementList) {
                    String className = sqlTableElement.getClass().getName();
                    if (!className.contains("SQLColumnDefinition")) continue;
                    SQLColumnDefinition col = (SQLColumnDefinition)sqlTableElement;
                    String columnName = col.getColumnName();
                    Column column = new Column();
                    column.setColumnName(tableName + "." + columnName);
                    this.columnList.add(column);
                }
            }
            this.tableMap.put(tableName, tableName);
        } else if (name.contains("SQLCreateViewStatement")) {
            SQLCreateViewStatement createView = (SQLCreateViewStatement)create;
            String simpleName = createView.getName().getSimpleName();
            SQLSelect subQuery = createView.getSubQuery();
            this.params.put("sql", subQuery.toString());
            this.parseSqlStructure(new HashMap<String, Object>());
            this.tableMap.put(simpleName, simpleName);
        }
        this.schemaMap.put(tableName, schema);
    }

    public HiveAlterDatabaseStatement parseAlter(String dbType, String sql) throws SQLException {
        HiveAlterDatabaseStatement alter = this.aliParseAlter(dbType, sql);
        return alter;
    }

    public HiveAlterDatabaseStatement aliParseAlter(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        HiveAlterDatabaseStatement stmt = (HiveAlterDatabaseStatement)stmtList.get(0);
        return stmt;
    }

    public void parseAlterColumns(SQLAlterTableStatement alter) {
        String tableName = alter.getTableName();
        for (SQLAlterTableItem item : alter.getItems()) {
            Column col;
            String columnName;
            SQLObjectImpl alterColumn;
            String className = item.getClass().getName();
            if (className.contains("SQLAlterTableAddColumn")) {
                alterColumn = (SQLAlterTableAddColumn)item;
                for (SQLColumnDefinition sQLColumnDefinition : ((SQLAlterTableAddColumn)alterColumn).getColumns()) {
                    columnName = sQLColumnDefinition.getColumnName();
                    col = new Column();
                    col.setColumnName(tableName + "." + columnName);
                    this.columnList.add(col);
                }
                continue;
            }
            if (!className.contains("SQLAlterTableDropColumnItem")) continue;
            alterColumn = (SQLAlterTableDropColumnItem)item;
            for (SQLName sQLName : ((SQLAlterTableDropColumnItem)alterColumn).getColumns()) {
                columnName = sQLName.getSimpleName();
                col = new Column();
                col.setColumnName(tableName + "." + columnName);
                this.columnList.add(col);
            }
        }
        this.tableMap.put(tableName, tableName);
    }

    public String parseUnion(String dbType, String sql) throws SQLException {
        StringBuilder result = new StringBuilder();
        SQLUnionQuery query = this.aliParseUnion(dbType, sql);
        this.dealUnion(query, result);
        return result.toString();
    }

    public SQLUnionQuery aliParseUnion(String dbType, String sql) throws SQLException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
        SQLSelect select = stmt.getSelect();
        SQLUnionQuery query = (SQLUnionQuery)select.getQuery();
        return query;
    }

    public void dealUnion(SQLUnionQuery unionQuery, StringBuilder result) throws SQLException {
        List<SQLSelectQuery> queryList = unionQuery.getRelations();
        for (int i = 0; i < queryList.size(); ++i) {
            SQLSelectQuery selectQuery = queryList.get(i);
            String sql = "";
            String className = selectQuery.getClass().getName();
            if (className.contains("SQLUnionQuery")) {
                SQLUnionQuery unQuery = (SQLUnionQuery)selectQuery;
                this.dealUnion(unQuery, result);
            } else {
                SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
                this.parseFrom(query.getFrom(), null);
                sql = this.parseSelectStar(query);
                query = this.aliParseSelect(this.dbType, sql, true);
                this.parseQueryColumns(query, "");
                sql = this.parseSelectStar(query);
                result.append(sql);
            }
            if (i != 0) continue;
            result.append("\n" + unionQuery.getOperator().toString() + "\n");
        }
    }

    public SQLDropTableStatement parseDrop(String dbType, String sql) throws SQLException {
        SQLDropTableStatement drop = this.aliParseDrop(dbType, sql);
        this.parseDropColumns(drop);
        return drop;
    }

    public SQLDropTableStatement aliParseDrop(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLDropTableStatement stmt = (SQLDropTableStatement)stmtList.get(0);
        return stmt;
    }

    public SQLDDLStatement parseDropOther(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLDDLStatement stmt = (SQLDDLStatement)stmtList.get(0);
        return stmt;
    }

    public void parseDropColumns(SQLDropTableStatement drop) {
        for (SQLExprTableSource tableSource : drop.getTableSources()) {
            String tableName = tableSource.getName().getSimpleName();
            this.tableMap.put(tableName, tableName);
        }
    }

    public SQLGrantStatement parseGrant(String dbType, String sql) throws SQLException {
        SQLGrantStatement grant = this.aliParseGrant(dbType, sql);
        return grant;
    }

    public SQLGrantStatement aliParseGrant(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLGrantStatement stmt = (SQLGrantStatement)stmtList.get(0);
        return stmt;
    }

    public void parseGrantColumns(SQLGrantStatement grant) {
        String url = this.params.get("url");
        String ip_port = url.split("/")[2];
        SQLExprTableSource resource = (SQLExprTableSource)grant.getResource();
        SQLPropertyExpr expr = (SQLPropertyExpr)resource.getExpr();
        String name = expr.getName();
        String owner = expr.getOwner().toString();
        if ("*".equalsIgnoreCase(owner)) {
            for (DataBase dataBase : JdbcUtil.dataBaseList) {
                if (!dataBase.getIp_port().equalsIgnoreCase(ip_port)) continue;
                for (Schema schema : dataBase.getSchemaList()) {
                    for (Table table : schema.getTableList()) {
                        this.schemaMap.put(table.getName(), schema.getName());
                        this.tableMap.put(table.getName(), table.getName());
                    }
                }
            }
        } else if ("*".equalsIgnoreCase(name)) {
            for (DataBase dataBase : JdbcUtil.dataBaseList) {
                if (!dataBase.getIp_port().equalsIgnoreCase(ip_port)) continue;
                for (Schema schema : dataBase.getSchemaList()) {
                    if (!schema.getName().equalsIgnoreCase(owner)) continue;
                    for (Table table : schema.getTableList()) {
                        this.schemaMap.put(table.getName(), owner);
                        this.tableMap.put(table.getName(), table.getName());
                    }
                }
            }
        } else {
            this.schemaMap.put(name, owner);
            this.tableMap.put(name, name);
        }
    }

    public SQLRevokeStatement parseRevoke(String dbType, String sql) throws SQLException {
        SQLRevokeStatement revoke = this.aliParseRevoke(dbType, sql);
        return revoke;
    }

    public SQLRevokeStatement aliParseRevoke(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLRevokeStatement stmt = (SQLRevokeStatement)stmtList.get(0);
        return stmt;
    }

    public void parseRevokeColumns(SQLRevokeStatement revoke) {
        String url = this.params.get("url");
        String ip_port = url.split("/")[2];
        SQLExprTableSource resource = (SQLExprTableSource)revoke.getResource();
        SQLPropertyExpr expr = (SQLPropertyExpr)resource.getExpr();
        String name = expr.getName();
        String owner = expr.getOwner().toString();
        if ("*".equalsIgnoreCase(owner)) {
            for (DataBase dataBase : JdbcUtil.dataBaseList) {
                if (!dataBase.getIp_port().equalsIgnoreCase(ip_port)) continue;
                for (Schema schema : dataBase.getSchemaList()) {
                    for (Table table : schema.getTableList()) {
                        this.schemaMap.put(table.getName(), schema.getName());
                        this.tableMap.put(table.getName(), table.getName());
                    }
                }
            }
        } else if ("*".equalsIgnoreCase(name)) {
            for (DataBase dataBase : JdbcUtil.dataBaseList) {
                if (!dataBase.getIp_port().equalsIgnoreCase(ip_port)) continue;
                for (Schema schema : dataBase.getSchemaList()) {
                    if (!schema.getName().equalsIgnoreCase(owner)) continue;
                    for (Table table : schema.getTableList()) {
                        this.schemaMap.put(table.getName(), owner);
                        this.tableMap.put(table.getName(), table.getName());
                    }
                }
            }
        } else {
            this.schemaMap.put(name, owner);
            this.tableMap.put(name, name);
        }
    }

    public List<String> parseWheres(String sql) {
        SQLParser parser = new SQLParser();
        return parser.where(sql);
    }

    public String formatSQL(String sql) {
        SQLParser parser = new SQLParser();
        return parser.format(sql);
    }

    public static String getSqlType(String sql, String dbType) {
        SQLLogger.log(sql);
        Object statement = null;
        sql = sql.trim();
        String sqlType = "";
        if (JdbcUtil.followRules_like(sql, "(?i)^(create)(\\s+?)(TEMPORARY)(\\s+?)(macro)(.*)")) {
            return "macro";
        }
        if (JdbcUtil.followRules_like(sql, "(?i)^(create)(\\s+?)((TEMPORARY)(\\s+?))?(function)(.*)")) {
            return "function";
        }
        if (JdbcUtil.followRules_like(sql, "(?i)^(drop)(\\s+?)(table)")) {
            return "drop";
        }
        if (JdbcUtil.followRules_like(sql, "(?i)^(drop)(\\s+?)(.*)")) {
            return "drop_other";
        }
        sqlType = JdbcUtil.followRules_like(sql, "(?i)^(insert)(\\s+?)(into)(\\s+?)(select)(.*)(from)") ? "insert_select" : (JdbcUtil.followRules_like(sql, "(?i)^(insert)(\\s+?)(into)(.*)") ? "insert" : (JdbcUtil.followRules_like(sql, "(?i)^(update)(.*)(set)") ? "update" : (JdbcUtil.followRules_like(sql, "(?i)^(replace)(.*)(into)") ? "replace" : (JdbcUtil.followRules_like(sql, "(?i)^(delete)(\\s+?)(from)(.*)") ? "delete" : (JdbcUtil.followRules_like(sql, "(?i)^(truncate)(\\s+?)(table)?") ? "truncate" : (JdbcUtil.followRules_like(sql, "(?i)^(create)(\\s+?)(table|view|EXTERNAL|TEMPORARY|Materialized)") ? "create" : (JdbcUtil.followRules_like(sql, "(?i)^(alter)(\\s+?)(table)") ? "alter" : (JdbcUtil.followRules_like(sql, "(?i)^(grant)(.*)(to)") ? "grant" : (JdbcUtil.followRules_like(sql, "(?i)^(revoke)(.*)(on)(.*)(from)") ? "revoke" : (JdbcUtil.followRules_like(sql, "(?i)(\\s+)(union|union all|INTERSECT|MINUS)(\\s+)") ? "union" : (JdbcUtil.followRules_like(sql, "(?i)^(with)(.*?)(as)(.*)(select)") ? "with_select" : (JdbcUtil.followRules_like(sql, "(?i)^(select)(.*?)(from)") ? "select" : (JdbcUtil.followRules_like(sql, "(?i)^(merge)(\\s+?)(into)(.*)") ? "merge" : (JdbcUtil.followRules_like(sql, "(?i)^(alter)(\\s+?)(schema|database)(.*)") ? "alter" : (JdbcUtil.followRules_like(sql, "(?i)^(show)(\\s+?)(.*)") ? "show" : "general")))))))))))))));
        return sqlType;
    }

    public void parseSqlStructureAndReplace2(Map<String, Object> paramMap, List<Map> repalceMap) throws SQLException {
        String sql = this.params.get("sql");
        String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
        if ("select".equals(sqlType) || "union".equals(sqlType) || "update".equals(sqlType) || "insert".equals(sqlType) || "delete".equals(sqlType)) {
            String permission = this.params.get("permission");
            String url = this.params.get("url");
            String schema = this.params.get("schema");
            String ip_port = url.split("/")[2];
            SQLParser sqlParser = new SQLParser();
            DataBase dataBase = new DataBase();
            for (DataBase db : JdbcUtil.dataBaseList) {
                if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
                dataBase = db;
                break;
            }
            SQLResult parse = sqlParser.parse(sql, dataBase, schema);
            List<Object> columnlist = new ArrayList();
            if ("masking".equalsIgnoreCase(permission)) {
                columnlist = parse.outputs;
            } else if ("full".equalsIgnoreCase(permission)) {
                columnlist = parse.fields;
            } else if (!"insert".equalsIgnoreCase(sqlType) && !"update".equalsIgnoreCase(sqlType)) {
                columnlist = parse.outputs;
            }
            for (FieldInfo fieldInfo : columnlist) {
                List<Object> fieldInfoList = new ArrayList<FieldInfo>();
                if (fieldInfo.getRelations().size() > 1) {
                    fieldInfoList = fieldInfo.getRelations();
                } else {
                    fieldInfoList.add(fieldInfo);
                }
                for (FieldInfo fieldInfo2 : fieldInfoList) {
                    String name = fieldInfo2.getName();
                    Map<String, TableInfo> tables = fieldInfo2.getTables();
                    String tableName = "";
                    for (String s : tables.keySet()) {
                        tableName = s.split("\\.")[1];
                    }
                    Column column = new Column();
                    column.setColumnName(tableName + "." + name);
                    column.setColumnAlisa(fieldInfo2.getAlias());
                    column.setSubQuery(false);
                    this.columnList.add(column);
                }
            }
            for (TableInfo tableInfo : parse.tables) {
                TableMemo tb = tableInfo.getTable();
                this.tableMap.put(tb.name, tb.name);
                this.schemaMap.put(tb.name, tb.schema);
            }
            for (ValueInfo valueInfo : parse.values) {
                FieldMemo field = valueInfo.field;
                this.whereMap.put(field.name, valueInfo.value.toString());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("column", field.getAtomName());
                map.put("columnValue", valueInfo.value.toString());
                map.put("type", valueInfo.operator);
                this.whereList.add(map);
            }
            sqlParser.replace(parse.values, repalceMap);
            paramMap.put("whereList", this.whereList);
            paramMap.put("statement", parse.statement);
            paramMap.put("type", parse.sqlType.name().toLowerCase());
            paramMap.put("sql", parse.statement.toString());
        }
        paramMap.put("tableMap", this.tableMap);
        paramMap.put("columnList", this.columnList);
        paramMap.put("schemaMap", this.schemaMap);
        paramMap.put("whereMap", this.whereMap);
        paramMap.put("whereList", this.flatWhereListValues());
    }

    private List<Map<String, Object>> flatWhereListValues() {
        if (this.whereValueList != null && this.whereValueList.size() != 0) {
            ArrayList<Map<String, Object>> flats = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> column : this.whereValueList) {
                Object columnValue = column.get("columnValue");
                if (columnValue instanceof List) {
                    List values = (List)columnValue;
                    if (values != null && values.size() != 0) {
                        for (Object value : values) {
                            HashMap<String, Object> columnMap = new HashMap<String, Object>(column);
                            columnMap.put("columnValue", value);
                            flats.add(columnMap);
                        }
                        continue;
                    }
                    column.put("columnValue", "");
                    flats.add(column);
                    continue;
                }
                flats.add(column);
            }
            return flats;
        }
        return this.whereValueList;
    }

    public Scope getScope(String ip_port, String schema, List<SQLStatement> statements) {
        Context context = new Context();
        DataBase dataBase = new DataBase();
        for (DataBase db : JdbcUtil.dataBaseList) {
            if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
            dataBase = db;
            break;
        }
        context.initialize(dataBase, schema, this.dbType);
        Scope scope = new Scope();
        scope.dialector = new HiveScopeDialector(scope);
        scope.context = context;
        scope.isCheckIsolated = true;
        ScopeVisitor scopeVisitor = new ScopeVisitor(scope);
        scopeVisitor.perform(statements);
        FieldVisitor fieldVisitor = new FieldVisitor(scope);
        fieldVisitor.perform(statements);
        return scope;
    }
}

