/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGAlterSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGAlterViewStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDropSchemaStatement;
import com.alibaba.druid.util.StringUtils;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import util.JdbcUtil;
import util.StringJoin;
import util.getdata.DatabaseCache;
import util.sqlparse.visitor.common.Context;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.postgresql.PostgresqlNameWrapper;
import util.sqlparse.visitor.postgresql.SQLParser;
import util.sqlparse.visitor.postgresql.visitor.Desensitization;
import util.sqlparse.visitor.postgresql.visitor.FieldVisitor;
import util.sqlparse.visitor.postgresql.visitor.PostgresqlScopeDialector;
import util.sqlparse.visitor.postgresql.visitor.ScopeVisitor;

public class PostgreSqlParse {
    public HashMap<String, List<Column>> tableList = new HashMap();
    public List<Column> columnList = new ArrayList<Column>();
    public Map<String, Object> whereMap = new HashMap<String, Object>();
    public List<Map<String, Object>> whereValueList = new ArrayList<Map<String, Object>>();
    private List<SQLObject> parsedCache = new ArrayList<SQLObject>();
    private List<SQLExpr> parsedWhereExprs = new ArrayList<SQLExpr>();
    public Map<String, String> tableMap = new HashMap<String, String>();
    public Map<String, String> unionTableMap = new HashMap<String, String>();
    public Map<String, String> schemaMap = new HashMap<String, String>();
    public Map<String, String> params;
    public List<Map<String, Object>> whereList = new ArrayList<Map<String, Object>>();
    public String dbType = "postgresql";

    public static String getIpPort(String url) {
        String[] urlSplit = url.split("/");
        String ip_port = urlSplit[2];
        return ip_port;
    }

    public PostgreSqlParse(Map<String, String> params) {
        this.params = params;
    }

    public PostgreSqlParse() {
    }

    public String rowVisitControl(Map<String, Object> param) throws SQLException {
        Desensitization desensitization = new Desensitization();
        Map map = desensitization.parseRowVisit(param);
        return (String)map.get("newSql");
    }

    public String addWhereCondition(Map<String, Object> param) throws SQLException {
        String sql = (String)param.get("sql");
        String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
        if ("select".equals(sqlType)) {
            SQLSelectQueryBlock query = this.aliParseSelect(this.dbType, sql, false);
            this.parseFromAndAddWhereCondition(query.getFrom(), param);
            sql = query.toString();
        } else if ("update".equals(sqlType)) {
            SQLUpdateStatement update = this.aliParseUpdate(this.dbType, sql);
            this.parseUpdateAndAddWhereCondition(update, param);
            sql = update.toString();
        } else if ("delete".equals(sqlType)) {
            SQLDeleteStatement delete = this.aliParseDelete(this.dbType, sql);
            this.parseDeleteAndAddWhereCondition(delete, param);
            sql = delete.toString();
        }
        return sql;
    }

    public void parseFromAndAddWhereCondition(SQLTableSource from, Map<String, Object> param) {
        if (from instanceof SQLExprTableSource) {
            Map modifyTable = (Map)param.get("modifyTable");
            Map tableKeyWord = (Map)param.get("tableKeyWord");
            SQLExprTableSource fromContent = (SQLExprTableSource)from;
            String[] split = fromContent.getExpr().toString().split("\\.");
            String tableName = "";
            tableName = split.length > 1 ? split[1] : split[0];
            tableName = tableName.replaceAll("`", "");
            String tableAlisa = fromContent.getAlias();
            tableAlisa = tableAlisa == null ? tableName : tableAlisa;
            SQLObject parent = fromContent.getParent();
            while (!(parent instanceof SQLSelectQueryBlock) && !(parent instanceof SQLDeleteStatement)) {
                parent = parent.getParent();
            }
            if (parent instanceof SQLSelectQueryBlock) {
                SQLSelectQueryBlock p = (SQLSelectQueryBlock)parent;
                for (String key : modifyTable.keySet()) {
                    if (!key.equalsIgnoreCase(tableName)) continue;
                    String id = (String)tableKeyWord.get(tableName);
                    String condition = "(" + tableAlisa + "." + id + " not in ('";
                    condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
                    condition = condition + " or " + tableAlisa + "." + id + " is null)";
                    p.addCondition(condition);
                }
            } else if (parent instanceof SQLDeleteStatement) {
                SQLDeleteStatement p = (SQLDeleteStatement)parent;
                for (String key : modifyTable.keySet()) {
                    if (!key.equalsIgnoreCase(tableName)) continue;
                    String id = (String)tableKeyWord.get(tableName);
                    String condition = tableAlisa + "." + id + " not in ('";
                    condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
                    p.addCondition(condition);
                }
            }
        } else if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
            SQLTableSource left = fromContent.getLeft();
            this.parseFromAndAddWhereCondition(left, param);
            SQLTableSource right = fromContent.getRight();
            this.parseFromAndAddWhereCondition(right, param);
        } else if (from instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
            String alias = fromContent.getAlias();
            SQLUnionQuery union = fromContent.getUnion();
            ArrayList<SQLSelectQueryBlock> unionList = new ArrayList<SQLSelectQueryBlock>();
            this.parseUnionFrom(union, unionList);
        } else if (from instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
            SQLSelect select = fromContent.getSelect();
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
            this.parseFromAndAddWhereCondition(query.getFrom(), param);
        }
    }

    public void parseUpdateAndAddWhereCondition(SQLUpdateStatement update, Map<String, Object> param) {
        String tableName;
        Map modifyTable = (Map)param.get("modifyTable");
        Map tableKeyWord = (Map)param.get("tableKeyWord");
        SQLName table = update.getTableName();
        String tableAlisa = tableName = table.getSimpleName();
        String[] tableInfo = tableName.split("\\.");
        if (tableInfo.length > 1) {
            tableName = tableInfo[1];
            tableAlisa = tableInfo[0];
        }
        for (String key : modifyTable.keySet()) {
            if (!key.equalsIgnoreCase(tableName)) continue;
            String id = (String)tableKeyWord.get(tableName);
            String condition = "(" + tableAlisa + "." + id + " not in ('";
            condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
            condition = condition + " or " + tableAlisa + "." + id + " is null)";
            update.addCondition(condition);
        }
    }

    public void parseDeleteAndAddWhereCondition(SQLDeleteStatement delete, Map<String, Object> param) {
        String tableName;
        Map modifyTable = (Map)param.get("modifyTable");
        Map tableKeyWord = (Map)param.get("tableKeyWord");
        SQLName table = delete.getTableName();
        String tableAlisa = tableName = table.getSimpleName();
        String[] tableInfo = tableName.split("\\.");
        if (tableInfo.length > 1) {
            tableName = tableInfo[1];
            tableAlisa = tableInfo[0];
        }
        for (String key : modifyTable.keySet()) {
            if (!key.equalsIgnoreCase(tableName)) continue;
            String id = (String)tableKeyWord.get(tableName);
            String condition = "(" + tableAlisa + "." + id + " not in ('";
            condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
            condition = condition + " or " + tableAlisa + "." + id + " is null)";
            delete.addCondition(condition);
        }
    }

    public String parseSql() {
        Desensitization desensitization = new Desensitization();
        Map map = desensitization.parseData(this.params);
        return (String)map.get("newSql");
    }

    public String parseSql_column() {
        Desensitization desensitization = new Desensitization();
        Map map = desensitization.parseColumn(this.params);
        return (String)map.get("newSql");
    }

    private void parseCols(String schema) {
        String url = this.params.get("url");
        String ip_port = url.split("/")[2];
        DataBase dataBase = null;
        for (DataBase db : JdbcUtil.dataBaseList) {
            if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
            dataBase = db;
            break;
        }
        if (this.schemaMap.size() > 0) {
            schema = this.schemaMap.values().iterator().next();
        }
        DatabaseCache simpleCache = dataBase.simpleCache;
        Set<String> columns = simpleCache.getColumns();
        if (this.columnList != null && this.columnList.size() > 0) {
            for (Column column : this.columnList) {
                String table;
                String columnName = column.getColumnName();
                if (columnName.equalsIgnoreCase(column.getRawName())) continue;
                String[] split = columnName.split("\\.");
                String string = split.length == 2 ? split[0] : (table = split.length == 3 ? split[1] : "");
                String col = split.length == 1 ? split[0] : (split.length == 2 ? split[1] : split[2]);
                schema = schema.replace("\"", "");
                table = table.replace("\"", "");
                col = col.replace("\"", "");
                String id = schema + "." + table + "." + col;
                boolean contains = columns.contains(id);
                if (!contains) {
                    column.setColumnName(column.getColumnName().replace("\"", ""));
                    continue;
                }
                StringBuilder s = new StringBuilder();
                for (int i = 0; i < split.length; ++i) {
                    if (i == split.length - 1) {
                        s.append(split[i]);
                    } else {
                        String name = split[i];
                        if (name == null || name.length() == 0) continue;
                        if (name.contains("\"")) {
                            s.append(name);
                        } else {
                            s.append("\"" + name + "\"");
                        }
                    }
                    s.append(".");
                }
                s.deleteCharAt(s.length() - 1);
                column.setColumnName(s.toString());
            }
        }
    }

    public String parseSql_table() {
        try {
            Desensitization desensitization = new Desensitization();
            desensitization.parseTable(this.params);
        }
        catch (Exception throwables) {
            throwables.printStackTrace();
        }
        return this.params.get("newSql");
    }

    public String parseSql_data() {
        Desensitization desensitization = new Desensitization();
        Map map = desensitization.parseData(this.params);
        return (String)map.get("newSql");
    }

    public void parseSqlStructureAndReplace(Map<String, Object> paramMap, Map<String, String> repalceMap) throws SQLException {
        String sql = this.params.get("sql");
        String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
        if ("select".equals(sqlType)) {
            String parseSql = this.parseSelectAndReplace(this.dbType, sql, repalceMap);
            paramMap.put("type", "select");
            paramMap.put("sql", parseSql);
        } else if ("union".equals(sqlType)) {
            String var6 = this.parseUnion(this.dbType, sql);
            paramMap.put("type", "union");
            paramMap.put("sql", var6);
        }
        paramMap.put("tableMap", this.tableMap);
        paramMap.put("columnList", this.columnList);
        paramMap.put("schemaMap", this.schemaMap);
        paramMap.put("whereMap", this.whereMap);
        paramMap.put("whereList", this.flatWhereListValues());
    }

    private List<Map<String, Object>> flatWhereListValues() {
        if (this.whereValueList != null && this.whereValueList.size() != 0) {
            ArrayList<Map<String, Object>> flats = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> column : this.whereValueList) {
                Object columnValue = column.get("columnValue");
                if (columnValue instanceof List) {
                    List values = (List)columnValue;
                    if (values != null && values.size() != 0) {
                        for (Object value : values) {
                            HashMap<String, Object> columnMap = new HashMap<String, Object>(column);
                            columnMap.put("columnValue", value);
                            flats.add(columnMap);
                        }
                        continue;
                    }
                    column.put("columnValue", "");
                    flats.add(column);
                    continue;
                }
                flats.add(column);
            }
            return flats;
        }
        return this.whereValueList;
    }

    public void parseSqlStructure(Map<String, Object> paramMap) throws SQLException {
        String sql = this.params.get("sql");
        boolean isEncryption = this.params.containsKey("encryption");
        List<SQLStatement> statements = SQLUtils.parseStatements(sql, "postgresql");
        if (statements != null && statements.size() != 0) {
            String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
            if (!("union".equals(sqlType) || "select".equals(sqlType) || "with_select".equals(sqlType) || "insert".equals(sqlType) || "update".equals(sqlType) || "delete".equals(sqlType) || "create".equals(sqlType) || "alter".equals(sqlType) || "insert_select".equals(sqlType))) {
                if ("truncate".equals(sqlType)) {
                    SQLTruncateStatement stmt = (SQLTruncateStatement)statements.get(0);
                    this.parseTruncateColumnsPG(stmt);
                    paramMap.put("tableMap", this.tableMap);
                    paramMap.put("columnList", this.columnList);
                    paramMap.put("schemaMap", this.schemaMap);
                    paramMap.put("whereMap", this.whereMap);
                    paramMap.put("sql", stmt.toString());
                    paramMap.put("whereList", new ArrayList());
                    paramMap.put("type", sqlType);
                    return;
                }
                if ("drop".equals(sqlType)) {
                    SQLDropTableStatement drop = (SQLDropTableStatement)statements.get(0);
                    this.parseDropTable(drop);
                    paramMap.put("sql", drop.toString());
                    paramMap.put("whereList", new ArrayList());
                    paramMap.put("type", sqlType);
                } else if ("grant".equals(sqlType)) {
                    SQLGrantStatement grant = this.parseGrant(this.dbType, sql);
                    paramMap.put("type", "grant");
                    paramMap.put("statement", grant);
                    paramMap.put("sql", grant.toString());
                } else if ("revoke".equals(sqlType)) {
                    SQLRevokeStatement revoke = this.parseRevoke(this.dbType, sql);
                    paramMap.put("type", "revoke");
                    paramMap.put("statement", revoke);
                    paramMap.put("sql", revoke.toString());
                } else if ("drop schema".equals(sqlType)) {
                    PGDropSchemaStatement dropSchema = (PGDropSchemaStatement)statements.get(0);
                    this.parseDropSchema(dropSchema);
                    paramMap.put("sql", dropSchema.toString());
                    paramMap.put("whereList", new ArrayList());
                    paramMap.put("type", sqlType);
                } else if ("alter schema".equals(sqlType)) {
                    PGAlterSchemaStatement alterSchemaStatement = (PGAlterSchemaStatement)statements.get(0);
                    this.parseAlterSchema(alterSchemaStatement);
                    paramMap.put("sql", alterSchemaStatement.toString());
                    paramMap.put("whereList", new ArrayList());
                    paramMap.put("type", sqlType);
                } else if ("alter view".equals(sqlType)) {
                    PGAlterViewStatement alterViewStatement = (PGAlterViewStatement)statements.get(0);
                    this.parseAlterView(alterViewStatement);
                    paramMap.put("sql", alterViewStatement.toString());
                    paramMap.put("whereList", new ArrayList());
                    paramMap.put("type", sqlType);
                }
            } else {
                String permission = this.params.get("permission");
                String url = this.params.get("url");
                String schema = this.params.get("schema");
                String ip_port = PostgreSqlParse.getIpPort(url);
                SQLParser sqlParser = new SQLParser();
                DataBase dataBase = new DataBase();
                for (DataBase db : JdbcUtil.dataBaseList) {
                    if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
                    dataBase = db;
                    break;
                }
                SQLResult parse = sqlParser.parse(sql, dataBase, schema);
                if ("alter".equals(sqlType)) {
                    parse.outputs = parse.fields;
                }
                List<FieldInfo> columnlist = "masking".equalsIgnoreCase(permission) ? parse.outputs : ("full".equalsIgnoreCase(permission) ? parse.fields : (isEncryption ? (!"insert".equalsIgnoreCase(sqlType) && !"update".equalsIgnoreCase(sqlType) ? parse.outputs : parse.fields) : parse.outputs));
                PostgresqlNameWrapper wrapper = new PostgresqlNameWrapper(dataBase.simpleCache);
                HashSet<String> tabSet = new HashSet<String>();
                for (FieldInfo fieldInfo : columnlist) {
                    List<Object> fieldInfoList = new ArrayList<FieldInfo>();
                    if (fieldInfo.getRelations().size() > 0) {
                        fieldInfoList = fieldInfo.getRelations();
                    } else {
                        fieldInfoList.add(fieldInfo);
                    }
                    for (FieldInfo fieldInfo2 : fieldInfoList) {
                        String name = fieldInfo2.getName();
                        if (StringUtils.isEmpty(name)) continue;
                        Map<String, TableInfo> tables = fieldInfo2.getTables();
                        String tableName = "";
                        String schemaName = "";
                        for (String string : tables.keySet()) {
                            String[] segment = string.split("\\.");
                            if (StringUtils.isEmpty(segment[0]) || StringUtils.isEmpty(segment[1])) continue;
                            schemaName = segment[0];
                            tableName = segment[1];
                            break;
                        }
                        if (tableName.length() == 0 && fieldInfo2.getTables().size() > 0) {
                            for (Map.Entry entry : fieldInfo2.getTables().entrySet()) {
                                TableInfo tbInfo = (TableInfo)entry.getValue();
                                if (tbInfo == null || tbInfo.getTable() == null || StringUtils.isEmpty(tbInfo.getTable().schema) || StringUtils.isEmpty(tbInfo.getTable().name)) continue;
                                tableName = tbInfo.getTable().name;
                                schemaName = tbInfo.getTable().schema;
                                break;
                            }
                        }
                        schemaName = wrapper.unwrapSchema(schemaName);
                        tableName = wrapper.unwrapTable(schemaName, tableName);
                        tabSet.add(tableName);
                        if (name.equalsIgnoreCase("ROWID") || name.equalsIgnoreCase("ORA_ROWSCN")) continue;
                        Column column = new Column();
                        column.setColumnName(tableName + "." + name);
                        column.setTable(tableName);
                        column.setSchema(schemaName);
                        column.setColumnAlisa(fieldInfo2.getAlias() != null && !"".equals(fieldInfo2.getAlias()) ? fieldInfo2.getAlias().replaceAll("\"", "") : "");
                        if (null != fieldInfo.getAlias() && !"".equals(fieldInfo.getAlias()) && !fieldInfo.getAlias().equals(column.getColumnAlisa()) && null != this.columnList && this.columnList.size() > 0) {
                            ListIterator<Column> listIterator = this.columnList.listIterator();
                            while (listIterator.hasNext()) {
                                Column element = listIterator.next();
                                if (!element.getSchema().equals(column.getSchema()) || !element.getTable().equals(column.getTable()) || !element.getColumnAlisa().equals(column.getColumnAlisa()) || !element.getRawName().equals(column.getRawName()) || !element.getColumnName().equals(column.getColumnName())) continue;
                                column.setColumnAlisa(fieldInfo.getAlias());
                                break;
                            }
                        }
                        column.setSubQuery(false);
                        column.setSeq(fieldInfo.getSeq());
                        column.setFieldIds(fieldInfo.getFieldIds());
                        this.columnList.add(column);
                    }
                }
                for (TableInfo table : parse.tables) {
                    TableMemo tb = table.getTable();
                    String schName = wrapper.unwrapSchema(tb.schema);
                    String string = wrapper.unwrapTable(schName, tb.name);
                    this.tableMap.put(string, string);
                    this.schemaMap.put(string, schName);
                }
                for (ValueInfo value : parse.values) {
                    FieldMemo field = value.field;
                    this.whereMap.put(field.name, value.value.toString());
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("column", value.getValueNames());
                    map.put("columnValue", value.value.toString());
                    map.put("type", value.operator);
                    this.whereList.add(map);
                }
                paramMap.put("whereList", this.whereList);
                paramMap.put("statement", parse.statement);
                paramMap.put("type", parse.sqlType.name().toLowerCase());
                paramMap.put("sql", parse.statement.toString());
                wrapper.unwrapFullColumns(this.columnList);
            }
            paramMap.put("whereMap", this.whereMap);
            paramMap.put("tableMap", this.tableMap);
            paramMap.put("columnList", this.columnList);
            paramMap.put("schemaMap", this.schemaMap);
        }
    }

    public void parseTruncateColumnsPG(SQLTruncateStatement truncate) throws SQLException {
        List<SQLExprTableSource> tableSources = truncate.getTableSources();
        this.parseTableSourceList(tableSources);
    }

    private void parseAlterView(PGAlterViewStatement alterViewStatement) {
        String url = this.params.get("url");
        String ip_port = PostgreSqlParse.getIpPort(url);
        DataBase dataBase = new DataBase();
        for (DataBase db : JdbcUtil.dataBaseList) {
            if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
            dataBase = db;
            break;
        }
        String schema = this.params.get("schema");
        Context context = new Context();
        context.initialize(dataBase, schema, "postgresql");
        SQLExpr newSchema = alterViewStatement.getNewSchema();
        if (newSchema != null) {
            SQLIdentifierExpr parseschema = (SQLIdentifierExpr)newSchema;
            ArrayList<SQLIdentifierExpr> list = new ArrayList<SQLIdentifierExpr>();
            list.add(parseschema);
            this.parseSchema(list);
        }
    }

    private void parseAlterSchema(PGAlterSchemaStatement stmt) {
        SQLIdentifierExpr schema = stmt.getSchemaName();
        ArrayList<SQLIdentifierExpr> list = new ArrayList<SQLIdentifierExpr>();
        list.add(schema);
        this.parseSchema(list);
    }

    public void parseDropSchema(PGDropSchemaStatement drop) {
        this.parseSchema(drop.getSchemaList());
    }

    private void parseSchema(ArrayList<SQLIdentifierExpr> schemaList) {
        String url = this.params.get("url");
        String ip_port = PostgreSqlParse.getIpPort(url);
        DataBase dataBase = new DataBase();
        for (DataBase db : JdbcUtil.dataBaseList) {
            if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
            dataBase = db;
            break;
        }
        List<Schema> dbSchemaList = dataBase.getSchemaList();
        for (SQLIdentifierExpr expr : schemaList) {
            String schema = expr.getName();
            Schema dbSchema = null;
            for (Schema schema1 : dbSchemaList) {
                if (!schema.equals(schema1.getName())) continue;
                dbSchema = schema1;
            }
            if (dbSchema == null) continue;
            for (Table table : dbSchema.getTableList()) {
                String tableName = table.getName();
                this.tableMap.put(tableName, tableName);
                this.schemaMap.put(tableName, dbSchema.getName());
            }
        }
    }

    private void parseTableSourceList(List<SQLExprTableSource> tableSources) throws SQLException {
        String url = this.params.get("url");
        String ip_port = url.split("/")[2];
        for (SQLExprTableSource tableSource : tableSources) {
            String schema = this.params.get("schema");
            String tableName = tableSource.getTableName();
            SQLExpr expr1 = tableSource.getExpr();
            if (expr1 instanceof SQLIdentifierExpr) {
                SQLPropertyExpr expr = new SQLPropertyExpr();
                expr.setName(tableName);
                expr.setOwner(schema);
                tableSource.setExpr(expr);
            } else if (expr1 instanceof SQLPropertyExpr) {
                schema = ((SQLPropertyExpr)expr1).getOwnerName();
            }
            this.tableMap.put(tableName, tableName);
            this.schemaMap.put(tableName, schema);
            for (Column tableColumn : JdbcUtil.getTableColumns(ip_port, schema, tableName, tableName, this.tableList)) {
                Column column = new Column();
                column.setColumnName(tableColumn.getColumnName());
                this.columnList.add(column);
            }
        }
    }

    public void parseDropTable(SQLDropTableStatement stmt) throws SQLException {
        List<SQLExprTableSource> tableSources = stmt.getTableSources();
        this.parseTableSourceList(tableSources);
    }

    public String parseSelect(String dbType, String sql) throws SQLException {
        SQLSelectQueryBlock query = this.aliParseSelect(dbType, sql, true);
        this.parseFrom(query.getFrom(), null, "", true);
        this.parseFrom(query.getFrom(), null, "", false);
        this.parseWhere(query.getWhere());
        this.parseLimit(query.getLimit());
        sql = this.parseSelectStar(query);
        query = this.aliParseSelect(dbType, sql, false);
        this.parseQueryColumns(query, "");
        sql = this.parseSelectStar(query);
        return sql;
    }

    private void parseSelect(SQLSelect select) throws SQLException {
        SQLSelectQueryBlock selectQuery = select.getQueryBlock();
        if (selectQuery instanceof SQLUnionQuery) {
            StringBuilder result = new StringBuilder();
            SQLUnionQuery query = (SQLUnionQuery)((Object)selectQuery);
            this.dealUnion(query, result);
        } else {
            SQLSelectQueryBlock query = selectQuery;
            this.parseFrom(query.getFrom(), null, "", true);
            this.parseFrom(query.getFrom(), null, "", false);
            this.parseWhere(query.getWhere());
            this.parseLimit(query.getLimit());
            String sql = this.parseSelectStar(query);
            query = this.aliParseSelect(this.dbType, sql, false);
            this.parseQueryColumns(query, "");
            this.parseSelectStar(query);
        }
    }

    public String parseSelectAndReplace(String dbType, String sql, Map<String, String> replaceMap) throws SQLException {
        SQLSelectQueryBlock query = this.aliParseSelectAndRepalce(dbType, sql, true, replaceMap);
        return query.toString();
    }

    public SQLSelectQueryBlock aliParseSelectAndRepalce(String dbType, String sql, boolean first, Map<String, String> replaceMap) throws SQLException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
        SQLSelect select = stmt.getSelect();
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
        if (first) {
            query = JdbcUtil.doPareAndRepalce(query, this.params, this.tableList, replaceMap);
        }
        return query;
    }

    public SQLSelectQueryBlock aliParseSelect(String dbType, String sql, boolean first) throws SQLException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
        SQLSelect select = stmt.getSelect();
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
        if (first) {
            query = JdbcUtil.postgreJudgeViewAndModify(query, this.params, this.tableList);
        }
        return query;
    }

    public Map<String, String> parseFromAndReplace(SQLTableSource from, Map<String, String> map, String subTableAlias, Map<String, String> replaceMap) throws SQLException {
        String className = from.getClass().getName();
        if (className.contains("SQLExprTableSource")) {
            SQLExprTableSource fromContent = (SQLExprTableSource)from;
            String tableName = fromContent.getExpr().toString();
            String tableAlisa = fromContent.getAlias();
            String exprClass = fromContent.getExpr().getClass().getName();
            if (exprClass.contains("SQLPropertyExpr")) {
                SQLPropertyExpr expr = (SQLPropertyExpr)fromContent.getExpr();
                tableName = expr.getName();
                String owner = expr.getOwner().toString();
                this.schemaMap.put(tableName, owner);
            } else {
                String owner = this.params.get("schema");
                SQLIdentifierExpr expr = (SQLIdentifierExpr)fromContent.getExpr();
                SQLPropertyExpr pExpr = new SQLPropertyExpr();
                pExpr.setName(expr.getName());
                pExpr.setOwner(owner);
                fromContent.setExpr(pExpr);
                this.schemaMap.put(tableName, owner);
            }
            String string = tableAlisa = tableAlisa == null ? tableName : tableAlisa;
            if (map == null) {
                this.tableMap.put(tableAlisa, tableName);
                String realTable = this.tableMap.get(subTableAlias);
                if (realTable == null) {
                    this.tableMap.put(subTableAlias, tableName);
                } else if (!realTable.equalsIgnoreCase(subTableAlias)) {
                    this.tableMap.put(subTableAlias, realTable + "." + tableName);
                }
                String name = fromContent.getParent().getClass().getName().toLowerCase();
                if (name.contains("SQLSelectQueryBlock".toLowerCase())) {
                    this.parseWhereAndReplace(((SQLSelectQueryBlock)from.getParent()).getWhere(), replaceMap);
                    SQLSelectGroupByClause groupBy = ((SQLSelectQueryBlock)from.getParent()).getGroupBy();
                    if (groupBy != null) {
                        this.parseHavingAndReplace(((SQLSelectQueryBlock)from.getParent()).getGroupBy().getHaving(), replaceMap);
                    }
                } else if (name.contains("SQLJoinTableSource".toLowerCase())) {
                    this.parseWhereAndReplace(((SQLJoinTableSource)from.getParent()).getCondition(), replaceMap);
                }
            } else {
                map.put(tableAlisa, tableName);
            }
        } else if (className.contains("SQLJoinTableSource")) {
            SQLSelectQueryBlock block;
            SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
            SQLTableSource left = fromContent.getLeft();
            this.parseFromAndReplace(left, map, "", replaceMap);
            SQLTableSource right = fromContent.getRight();
            this.parseFromAndReplace(right, map, "", replaceMap);
            if (from.getParent().getClass().equals(SQLSelectQueryBlock.class) && (block = (SQLSelectQueryBlock)from.getParent()).getWhere() != null) {
                this.parseWhereAndReplace(block.getWhere(), replaceMap);
                if (block.getGroupBy() != null) {
                    this.parseHavingAndReplace(block.getGroupBy().getHaving(), replaceMap);
                }
            }
        } else if (className.contains("SQLUnionQueryTableSource")) {
            SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
            String alias = fromContent.getAlias();
            SQLUnionQuery union = fromContent.getUnion();
            ArrayList<SQLSelectQueryBlock> unionList = new ArrayList<SQLSelectQueryBlock>();
            this.parseUnionFrom(union, unionList);
            this.paresUnionFromSqlAndReplace(unionList, alias, replaceMap);
            if (map == null) {
                this.tableMap.put(alias, alias);
            } else {
                map.put(alias, alias);
            }
        } else if (className.contains("SQLSubqueryTableSource")) {
            SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
            SQLSelect select = fromContent.getSelect();
            if (map == null) {
                SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
                this.parseFromAndReplace(query.getFrom(), map, fromContent.getAlias(), replaceMap);
                String sql = this.parseSelectStar(query);
                SQLSelectQueryBlock subQuery = this.aliParseSelect(this.dbType, sql, false);
                this.parseQueryColumns(subQuery, fromContent.getAlias());
                if (!"".equalsIgnoreCase(subTableAlias)) {
                    this.tableMap.put(subTableAlias, fromContent.getAlias());
                }
                this.parseWhereAndReplace(query.getWhere(), replaceMap);
                if (from.getParent() instanceof SQLJoinTableSource) {
                    this.parseWhereAndReplace(((SQLJoinTableSource)from.getParent()).getCondition(), replaceMap);
                }
            } else {
                map.put(fromContent.getAlias(), fromContent.getAlias());
            }
        }
        return this.tableMap;
    }

    public Map<String, String> parseFrom(SQLTableSource from, Map<String, String> map, String subTableAlias, boolean first) throws SQLException {
        String className = from.getClass().getName();
        if (className.contains("SQLExprTableSource")) {
            SQLExprTableSource fromContent = (SQLExprTableSource)from;
            String tableName = fromContent.getExpr().toString();
            String tableAlisa = fromContent.getAlias();
            String exprClass = fromContent.getExpr().getClass().getName();
            if (exprClass.contains("SQLPropertyExpr")) {
                SQLPropertyExpr expr = (SQLPropertyExpr)fromContent.getExpr();
                tableName = expr.getName();
                String owner = expr.getOwner().toString();
                this.schemaMap.put(tableName, owner);
            } else {
                String owner = this.params.get("schema");
                SQLIdentifierExpr expr = (SQLIdentifierExpr)fromContent.getExpr();
                SQLPropertyExpr pExpr = new SQLPropertyExpr();
                pExpr.setName(expr.getName());
                pExpr.setOwner(owner);
                fromContent.setExpr(pExpr);
                this.schemaMap.put(tableName, owner);
            }
            String string = tableAlisa = tableAlisa == null ? tableName : tableAlisa;
            if (map == null) {
                this.tableMap.put(tableAlisa.toLowerCase(), tableName);
                String realTable = this.tableMap.get(subTableAlias);
                if (realTable == null) {
                    this.tableMap.put(subTableAlias, tableName);
                } else if (!realTable.equalsIgnoreCase(subTableAlias)) {
                    this.tableMap.put(subTableAlias, realTable + "." + tableName);
                }
                String name = fromContent.getParent().getClass().getName().toLowerCase();
                if (name.contains("SQLSelectQueryBlock".toLowerCase()) && !first) {
                    this.parseWhere(((SQLSelectQueryBlock)from.getParent()).getWhere());
                    SQLSelectGroupByClause groupBy = ((SQLSelectQueryBlock)from.getParent()).getGroupBy();
                    if (groupBy != null && !first) {
                        this.parseHaving(((SQLSelectQueryBlock)from.getParent()).getGroupBy().getHaving());
                    }
                } else if (name.contains("SQLJoinTableSource".toLowerCase()) && !first) {
                    this.parseWhere(((SQLJoinTableSource)from.getParent()).getCondition());
                }
            } else {
                map.put(tableAlisa, tableName);
            }
        } else if (className.contains("SQLJoinTableSource")) {
            SQLSelectQueryBlock block;
            SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
            SQLTableSource left = fromContent.getLeft();
            this.parseFrom(left, map, "", first);
            SQLTableSource right = fromContent.getRight();
            this.parseFrom(right, map, "", first);
            if (fromContent.getCondition() != null && map == null && !first) {
                this.parseWhere(fromContent.getCondition());
            }
            if (from.getParent().getClass().equals(SQLSelectQueryBlock.class) && (block = (SQLSelectQueryBlock)from.getParent()).getWhere() != null && map == null && !first) {
                this.parseWhere(block.getWhere());
                if (block.getGroupBy() != null && !first) {
                    this.parseHaving(block.getGroupBy().getHaving());
                }
            }
        } else if (className.contains("SQLUnionQueryTableSource")) {
            SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
            String alias = fromContent.getAlias();
            SQLUnionQuery union = fromContent.getUnion();
            ArrayList<SQLSelectQueryBlock> unionList = new ArrayList<SQLSelectQueryBlock>();
            this.parseUnionFrom(union, unionList);
            this.paresUnionFromSql(unionList, alias, first);
            if (map == null) {
                this.tableMap.put(alias.toLowerCase(), alias);
            } else {
                map.put(alias, alias);
            }
        } else if (className.contains("SQLSubqueryTableSource")) {
            SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
            SQLSelect select = fromContent.getSelect();
            if (map == null) {
                SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
                this.parseFrom(query.getFrom(), map, fromContent.getAlias(), first);
                String sql = this.parseSelectStar(query);
                SQLSelectQueryBlock subQuery = this.aliParseSelect(this.dbType, sql, false);
                this.parseQueryColumns(subQuery, fromContent.getAlias());
                if (!"".equalsIgnoreCase(subTableAlias)) {
                    this.tableMap.put(subTableAlias.toLowerCase(), fromContent.getAlias());
                }
                if (!first) {
                    this.parseWhere(query.getWhere());
                }
            } else {
                map.put(fromContent.getAlias(), fromContent.getAlias());
            }
        }
        return this.tableMap;
    }

    private void parseHaving(SQLExpr having) throws SQLException {
        this.parseWhere(having);
    }

    private void parseHavingAndReplace(SQLExpr having, Map<String, String> replaceMap) {
        this.parseWhereAndReplace(having, replaceMap);
    }

    public void parseUnionFrom(SQLUnionQuery union, List<SQLSelectQueryBlock> unionList) {
        List<SQLSelectQuery> queryList = union.getRelations();
        for (int i = 0; i < queryList.size(); ++i) {
            SQLSelectQuery selectQuery = queryList.get(i);
            String className = selectQuery.getClass().getName();
            if (className.contains("SQLUnionQuery")) {
                SQLUnionQuery unQuery = (SQLUnionQuery)selectQuery;
                this.parseUnionFrom(unQuery, unionList);
                continue;
            }
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
            unionList.add(query);
        }
    }

    public void paresUnionFromSql(List<SQLSelectQueryBlock> unionList, String alias, boolean first) throws SQLException {
        for (int i = 0; i < unionList.size(); ++i) {
            this.unionTableMap.clear();
            SQLSelectQueryBlock query = unionList.get(i);
            this.parseFrom(query.getFrom(), null, "", first);
            String sql = this.parseSelectStar(query);
            if (i != unionList.size() - 1) continue;
            query = this.aliParseSelect(this.dbType, sql, false);
            this.parseQueryColumns(query, alias);
        }
    }

    public void paresUnionFromSqlAndReplace(List<SQLSelectQueryBlock> unionList, String alias, Map<String, String> replaceMap) throws SQLException {
        for (int i = 0; i < unionList.size(); ++i) {
            this.unionTableMap.clear();
            SQLSelectQueryBlock query = unionList.get(i);
            this.parseFromAndReplace(query.getFrom(), null, "", replaceMap);
            String sql = this.parseSelectStar(query);
            if (i != unionList.size() - 1) continue;
            query = this.aliParseSelect(this.dbType, sql, false);
            this.parseQueryColumns(query, alias);
        }
    }

    public boolean isHaveOwner(SQLInListExpr sqlInListExpr) {
        boolean isHave = true;
        try {
            SQLPropertyExpr expr = (SQLPropertyExpr)sqlInListExpr.getExpr();
            SQLIdentifierExpr sQLIdentifierExpr = (SQLIdentifierExpr)expr.getOwner();
        }
        catch (Exception var5) {
            isHave = false;
        }
        return isHave;
    }

    private void putInWhereParams(SQLExpr expr, String key, Object value) {
        for (SQLExpr parsedExpr : this.parsedWhereExprs) {
            if (expr != parsedExpr) continue;
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String type = SQLBinaryOperator.Equality.toString();
        SQLObject curr = expr;
        SQLExpr op = null;
        int MAX_STEP = 10;
        for (int i = 0; i < MAX_STEP; ++i) {
            if (curr instanceof SQLBinaryOpExpr) {
                op = curr;
                break;
            }
            if (curr instanceof SQLInListExpr) {
                op = curr;
                break;
            }
            if (curr.getParent() == null) break;
            curr = curr.getParent();
        }
        if (op != null) {
            if (op instanceof SQLBinaryOpExpr) {
                type = ((SQLBinaryOpExpr)op).getOperator().toString();
            }
            if (op instanceof SQLInListExpr) {
                type = "IN";
            }
        }
        map.put("column", key);
        map.put("columnValue", value);
        map.put("type", type);
        this.whereValueList.add(map);
        this.parsedWhereExprs.add(expr);
    }

    public void parseWhereAndReplace(SQLExpr where, Map<String, String> replaceMap) {
        if (where != null) {
            if (where instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr sqlExpr = (SQLBinaryOpExpr)where;
                SQLBinaryOperator operator = sqlExpr.getOperator();
                if (operator.toString().equalsIgnoreCase("BooleanAnd")) {
                    this.parseWhereAndReplace(sqlExpr.getLeft(), replaceMap);
                    this.parseWhereAndReplace(sqlExpr.getRight(), replaceMap);
                } else if (operator.toString().equalsIgnoreCase("BooleanOr")) {
                    this.parseWhereAndReplace(sqlExpr.getLeft(), replaceMap);
                    this.parseWhereAndReplace(sqlExpr.getRight(), replaceMap);
                } else if (operator.toString().equalsIgnoreCase("like")) {
                    SQLExpr right;
                    String tableName = "";
                    String colName = "";
                    String schema = "";
                    SQLExpr left = sqlExpr.getLeft();
                    if (!this.parseMethodInvokeAndReplaceExpr(left, right = sqlExpr.getRight(), replaceMap)) {
                        if (!(left instanceof SQLIdentifierExpr)) {
                            if (left instanceof SQLPropertyExpr) {
                                SQLExpr owner = ((SQLPropertyExpr)left).getOwner();
                                String alisaName = ((SQLIdentifierExpr)owner).getName();
                                colName = ((SQLPropertyExpr)left).getName();
                                tableName = this.tableMap.get(alisaName);
                                schema = this.schemaMap.get(tableName);
                            }
                        } else {
                            colName = ((SQLIdentifierExpr)left).getName();
                            for (String key : this.tableMap.keySet()) {
                                if (key.isEmpty()) continue;
                                tableName = this.tableMap.get(key);
                            }
                            schema = this.schemaMap.get(tableName);
                        }
                        String replaceValue = replaceMap.get(schema + "." + tableName + "." + colName);
                        if (right instanceof SQLCharExpr && replaceValue != null && !replaceValue.isEmpty()) {
                            ((SQLCharExpr)right).setText(replaceValue);
                        }
                    }
                } else if (operator.toString().equalsIgnoreCase("equality")) {
                    SQLExpr right;
                    String tableName = "";
                    String colName = "";
                    String schema = "";
                    SQLExpr left = sqlExpr.getLeft();
                    if (!this.parseMethodInvokeAndReplaceExpr(left, right = sqlExpr.getRight(), replaceMap)) {
                        if (!(left instanceof SQLIdentifierExpr)) {
                            if (left instanceof SQLPropertyExpr) {
                                SQLExpr owner = ((SQLPropertyExpr)left).getOwner();
                                String alisaName = ((SQLIdentifierExpr)owner).getName();
                                colName = ((SQLPropertyExpr)left).getName();
                                tableName = this.tableMap.get(alisaName);
                                schema = this.schemaMap.get(tableName);
                            }
                        } else {
                            colName = ((SQLIdentifierExpr)left).getName();
                            for (String key : this.tableMap.keySet()) {
                                if (key.isEmpty()) continue;
                                tableName = this.tableMap.get(key);
                            }
                            schema = this.schemaMap.get(tableName);
                        }
                        if (right instanceof SQLTextLiteralExpr) {
                            String replaceValue = replaceMap.get(schema + "." + tableName + "." + colName);
                            if (replaceValue != null && !replaceValue.isEmpty()) {
                                ((SQLCharExpr)right).setText(replaceValue);
                            }
                        } else if (right instanceof SQLQueryExpr) {
                            SQLTableSource subFrom = ((SQLQueryExpr)right).getSubQuery().getQueryBlock().getFrom();
                            try {
                                this.parseFromAndReplace(subFrom, null, "", replaceMap);
                            }
                            catch (SQLException throwables) {
                                throwables.printStackTrace();
                            }
                        }
                    }
                } else {
                    SQLExpr left = sqlExpr.getLeft();
                    SQLExpr right = sqlExpr.getRight();
                    String fieldName = left.toString();
                    String fieldValue = right.toString();
                    if (!this.parseMethodInvokeAndReplaceExpr(left, right, replaceMap)) {
                        try {
                            if (left.getClass().getName().contains("SQLIdentifierExpr") && left.toString().split("\\.").length == 1) {
                                HashMap<String, String> localMap = new HashMap<String, String>();
                                this.parseFrom(((SQLSelectQueryBlock)where.getParent()).getFrom(), localMap, "", true);
                                this.columnAddTableAlias(left, localMap);
                            }
                        }
                        catch (SQLException throwables) {
                            throwables.printStackTrace();
                        }
                        String value = (String)this.whereMap.get(fieldName);
                        if (value == null) {
                            this.whereMap.put(fieldName, fieldValue);
                            this.putInWhereParams(left, fieldName, fieldValue);
                        } else if (!value.equalsIgnoreCase(fieldValue)) {
                            this.whereMap.put(fieldName, value + "," + fieldValue);
                            this.putInWhereParams(left, fieldName, value + "," + fieldValue);
                        }
                    }
                }
            } else if (where instanceof SQLExistsExpr) {
                SQLExistsExpr existsExpr = (SQLExistsExpr)where;
                SQLSelect sqlSelect = existsExpr.subQuery;
                SQLBinaryOpExpr curWhere = (SQLBinaryOpExpr)((SQLSelectQueryBlock)sqlSelect.getQuery()).getWhere();
                SQLSelectQueryBlock subQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
                try {
                    this.parseFromAndReplace(subQuery.getFrom(), null, "", replaceMap);
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
                this.parseWhereAndReplace(curWhere, replaceMap);
            } else if (where instanceof SQLInListExpr) {
                SQLInListExpr sqlInListExpr = (SQLInListExpr)where;
                String tableName = "";
                String columnWithTable = "";
                if (this.isHaveOwner(sqlInListExpr)) {
                    SQLPropertyExpr expr = (SQLPropertyExpr)sqlInListExpr.getExpr();
                    SQLIdentifierExpr owner = (SQLIdentifierExpr)expr.getOwner();
                    String ownerName = owner.getName();
                    tableName = this.tableMap.get(ownerName);
                    columnWithTable = tableName + "." + expr.getName();
                } else {
                    SQLObject parent = sqlInListExpr.getParent();
                    while (!(parent instanceof SQLSelectQueryBlock)) {
                        parent = parent.getParent();
                    }
                    tableName = ((SQLPropertyExpr)((SQLExprTableSource)((SQLSelectQueryBlock)parent).getFrom()).getExpr()).getName();
                    columnWithTable = tableName + "." + ((SQLIdentifierExpr)sqlInListExpr.getExpr()).getName();
                }
                String schema = this.schemaMap.get(tableName);
                String replaceValue = replaceMap.get(schema + "." + columnWithTable);
                if (replaceValue != null && !replaceValue.isEmpty()) {
                    String[] split;
                    ArrayList<SQLExpr> list = new ArrayList<SQLExpr>();
                    for (String s : split = replaceValue.split(",")) {
                        SQLCharExpr expr = new SQLCharExpr(s);
                        list.add(expr);
                    }
                    sqlInListExpr.setTargetList(list);
                }
            }
        }
    }

    private boolean parseMethodInvokeAndReplaceExpr(SQLExpr expr, SQLExpr right, Map<String, String> replaceMap) {
        if (!(expr instanceof SQLMethodInvokeExpr)) {
            return false;
        }
        String colValue = right.toString();
        List<SQLExpr> params = ((SQLMethodInvokeExpr)expr).getParameters();
        if (params != null) {
            for (SQLExpr param : params) {
                String colName = "";
                String tableName = "";
                String schema = "";
                if (!(param instanceof SQLIdentifierExpr)) {
                    if (param instanceof SQLPropertyExpr) {
                        SQLExpr owner = ((SQLPropertyExpr)param).getOwner();
                        String alisaName = ((SQLIdentifierExpr)owner).getName();
                        colName = ((SQLPropertyExpr)param).getName();
                        tableName = this.tableMap.get(alisaName);
                        schema = this.schemaMap.get(tableName);
                    }
                } else {
                    colName = ((SQLIdentifierExpr)param).getName();
                    for (String key : this.tableMap.keySet()) {
                        if (key.isEmpty()) continue;
                        tableName = this.tableMap.get(key);
                    }
                    schema = this.schemaMap.get(tableName);
                }
                String replaceValue = replaceMap.get(schema + "." + tableName + "." + colName);
                if (right instanceof SQLCharExpr && replaceValue != null && !replaceValue.isEmpty()) {
                    ((SQLCharExpr)right).setText(replaceValue);
                }
                this.whereMap.put(schema + "." + tableName + "." + colName, colValue);
                this.putInWhereParams(param, schema + "." + tableName + "." + colName, colValue);
            }
        }
        return true;
    }

    public void parseWhere(SQLExpr where) throws SQLException {
        if (where != null) {
            boolean exists = false;
            for (SQLObject sqlObject : this.parsedCache) {
                if (sqlObject != where) continue;
                exists = true;
            }
            if (!exists) {
                this.parsedCache.add(where);
                String tableAlias = null;
                if (where instanceof SQLBinaryOpExpr) {
                    SQLBinaryOpExpr sqlExpr = (SQLBinaryOpExpr)where;
                    SQLBinaryOperator operator = sqlExpr.getOperator();
                    if (operator.toString().equalsIgnoreCase("BooleanAnd")) {
                        this.parseWhere(sqlExpr.getLeft());
                        this.parseWhere(sqlExpr.getRight());
                    } else if (operator.toString().equalsIgnoreCase("BooleanOr")) {
                        this.parseWhere(sqlExpr.getLeft());
                        this.parseWhere(sqlExpr.getRight());
                    } else if (operator.toString().equalsIgnoreCase("like")) {
                        String tableName = "";
                        String colName = "";
                        Object colValue = "";
                        String schema = "";
                        SQLExpr left = sqlExpr.getLeft();
                        SQLExpr right = sqlExpr.getRight();
                        if (right instanceof SQLCharExpr) {
                            colValue = ((SQLCharExpr)right).getText().replaceAll("%", "").replaceAll("_", "");
                        } else if (right instanceof SQLVariantRefExpr) {
                            colValue = right.toString().replaceAll("%", "").replaceAll("_", "");
                        } else if (right instanceof SQLMethodInvokeExpr) {
                            colValue = ((SQLMethodInvokeExpr)right).getArguments();
                        }
                        if (!this.parseMethodInvokeExpr(left, right)) {
                            if (!(left instanceof SQLIdentifierExpr)) {
                                if (left instanceof SQLPropertyExpr) {
                                    SQLExpr owner = ((SQLPropertyExpr)left).getOwner();
                                    String alisaName = ((SQLIdentifierExpr)owner).getName();
                                    colName = ((SQLPropertyExpr)left).getName();
                                    tableName = this.tableMap.get(alisaName);
                                    schema = this.schemaMap.get(tableName);
                                }
                            } else {
                                colName = ((SQLIdentifierExpr)left).getName();
                                for (String key : this.tableMap.keySet()) {
                                    if (key.isEmpty()) continue;
                                    tableName = this.tableMap.get(key);
                                }
                                schema = this.schemaMap.get(tableName);
                            }
                            this.whereMap.put(schema + "." + tableName + "." + colName, colValue);
                            this.putInWhereParams(left, schema + "." + tableName + "." + colName, colValue);
                        }
                    } else if (!(operator.toString().equalsIgnoreCase("equality") || operator.toString().equalsIgnoreCase("LessThanOrGreater") || operator.toString().equalsIgnoreCase("NotEqual") || operator.toString().equalsIgnoreCase(SQLBinaryOperator.LessThan.toString()) || operator.toString().equalsIgnoreCase(SQLBinaryOperator.LessThanOrEqual.toString()) || operator.toString().equalsIgnoreCase(SQLBinaryOperator.GreaterThan.toString()) || operator.toString().equalsIgnoreCase(SQLBinaryOperator.GreaterThanOrEqual.toString()))) {
                        SQLExpr right;
                        SQLExpr left;
                        if (!(operator.toString().equalsIgnoreCase(SQLBinaryOperator.Is.toString()) || operator.toString().equalsIgnoreCase(SQLBinaryOperator.IsNot.toString()) || this.parseMethodInvokeExpr(left = sqlExpr.getLeft(), right = sqlExpr.getRight()))) {
                            try {
                                if (left.getClass().getName().contains("SQLIdentifierExpr") && left.toString().split("\\.").length == 1) {
                                    HashMap<String, String> localMap = new HashMap<String, String>();
                                    this.parseFrom(((SQLSelectQueryBlock)where.getParent()).getFrom(), localMap, "", true);
                                    this.columnAddTableAlias(left, localMap);
                                }
                            }
                            catch (SQLException throwables) {
                                throwables.printStackTrace();
                            }
                            String fieldName = left.toString();
                            String fieldValue = right.toString();
                            String value = (String)this.whereMap.get(fieldName);
                            if (value == null) {
                                this.whereMap.put(fieldName, fieldValue);
                                this.putInWhereParams(left, fieldName, fieldValue);
                            } else if (!value.equalsIgnoreCase(fieldValue)) {
                                this.whereMap.put(fieldName, value + "," + fieldValue);
                                this.putInWhereParams(left, fieldName, value + "," + fieldValue);
                            }
                        }
                    } else {
                        String tableName = "";
                        String colName = "";
                        String colValue = "";
                        String schema = "";
                        SQLExpr left = sqlExpr.getLeft();
                        SQLExpr right = sqlExpr.getRight();
                        if (!(left instanceof SQLIntegerExpr || left instanceof SQLCharExpr || this.parseMethodInvokeExpr(left, right))) {
                            if (!(left instanceof SQLIdentifierExpr)) {
                                if (left instanceof SQLPropertyExpr) {
                                    SQLExpr owner = ((SQLPropertyExpr)left).getOwner();
                                    String alisaName = ((SQLIdentifierExpr)owner).getName();
                                    colName = ((SQLPropertyExpr)left).getName();
                                    tableAlias = alisaName.toLowerCase();
                                    tableName = this.tableMap.get(alisaName.toLowerCase());
                                    schema = this.schemaMap.get(tableName);
                                }
                            } else {
                                colName = ((SQLIdentifierExpr)left).getName();
                                for (String key : this.tableMap.keySet()) {
                                    if (key.isEmpty()) continue;
                                    tableName = this.tableMap.get(key);
                                }
                                schema = this.schemaMap.get(tableName);
                            }
                            if (right instanceof SQLCharExpr) {
                                colValue = ((SQLCharExpr)right).getText();
                            } else if (right instanceof SQLVariantRefExpr) {
                                colValue = right.toString();
                            } else if (right instanceof SQLIntegerExpr) {
                                colValue = right.toString();
                            }
                            if (tableName == null && tableAlias != null && this.tableList.containsKey(tableAlias)) {
                                List<Column> columns = this.tableList.get(tableAlias);
                                String finalColName = colName;
                                Column column = null;
                                for (Column x : columns) {
                                    if (!x.getColumnName().equalsIgnoreCase(finalColName) && !x.getColumnName().contains("." + finalColName)) continue;
                                    column = x;
                                    break;
                                }
                                if (column != null) {
                                    String[] arr = column.getColumnName().split("\\.");
                                    String alias = "";
                                    if (arr.length == 2) {
                                        alias = arr[0];
                                    } else if (arr.length == 3) {
                                        alias = arr[1];
                                    }
                                    if (alias != "") {
                                        tableName = this.tableMap.get(alias.toLowerCase());
                                        schema = this.schemaMap.get(tableName);
                                    }
                                }
                            }
                            this.whereMap.put(schema + "." + tableName + "." + colName, colValue);
                            this.putInWhereParams(left, schema + "." + tableName + "." + colName, colValue);
                        }
                    }
                } else if (where instanceof SQLExistsExpr) {
                    SQLExistsExpr existsExpr = (SQLExistsExpr)where;
                    SQLSelect sqlSelect = existsExpr.subQuery;
                    SQLBinaryOpExpr curWhere = (SQLBinaryOpExpr)((SQLSelectQueryBlock)sqlSelect.getQuery()).getWhere();
                    this.parseWhere(curWhere);
                } else if (where instanceof SQLInListExpr) {
                    SQLInListExpr sqlInListExpr = (SQLInListExpr)where;
                    String tableName = "";
                    String columnWithTable = "";
                    if (this.isHaveOwner(sqlInListExpr)) {
                        SQLPropertyExpr expr = (SQLPropertyExpr)sqlInListExpr.getExpr();
                        SQLIdentifierExpr owner = (SQLIdentifierExpr)expr.getOwner();
                        String ownerName = owner.getName();
                        tableName = this.tableMap.get(ownerName);
                        String schema = this.schemaMap.get(tableName);
                        columnWithTable = schema + "." + tableName + "." + expr.getName();
                    } else {
                        SQLObject parent = sqlInListExpr.getParent();
                        while (!(parent instanceof SQLSelectQueryBlock)) {
                            parent = parent.getParent();
                        }
                        tableName = ((SQLPropertyExpr)((SQLExprTableSource)((SQLSelectQueryBlock)parent).getFrom()).getExpr()).getName();
                        String schema = this.schemaMap.get(tableName);
                        tableName = schema + "." + tableName;
                        columnWithTable = tableName + "." + ((SQLIdentifierExpr)sqlInListExpr.getExpr()).getName();
                    }
                    this.whereMap.put(columnWithTable, sqlInListExpr.getTargetList());
                    this.putInWhereParams(sqlInListExpr, columnWithTable, sqlInListExpr.getTargetList());
                } else if (where instanceof SQLInSubQueryExpr) {
                    SQLInSubQueryExpr subInQuery = (SQLInSubQueryExpr)where;
                    this.parseSelect(subInQuery.getSubQuery());
                }
            }
        }
    }

    public void parseLimit(SQLLimit limit) {
        if (limit != null) {
            SQLExpr offset = limit.getOffset();
            SQLExpr rowCount = limit.getRowCount();
            if (offset != null) {
                this.putInWhereParams(offset, "a.b.limit1", offset.toString());
            }
            if (rowCount != null) {
                this.putInWhereParams(rowCount, "a.b.limit2", rowCount.toString());
            }
        }
    }

    private boolean parseMethodInvokeExpr(SQLExpr expr, SQLExpr right) {
        if (!(expr instanceof SQLMethodInvokeExpr)) {
            return false;
        }
        List<SQLExpr> params = ((SQLMethodInvokeExpr)expr).getParameters();
        String colValue = right.toString();
        if (params != null) {
            Iterator<SQLExpr> var5 = params.iterator();
            while (true) {
                if (!var5.hasNext()) {
                    return true;
                }
                SQLExpr param = var5.next();
                String colName = "";
                String tableName = "";
                String schema = "";
                if (!(param instanceof SQLIdentifierExpr)) {
                    if (param instanceof SQLPropertyExpr) {
                        SQLExpr owner = ((SQLPropertyExpr)param).getOwner();
                        String alisaName = ((SQLIdentifierExpr)owner).getName();
                        colName = ((SQLPropertyExpr)param).getName();
                        tableName = this.tableMap.get(alisaName);
                        schema = this.schemaMap.get(tableName);
                    } else if (param instanceof SQLCharExpr) {
                        continue;
                    }
                } else {
                    colName = ((SQLIdentifierExpr)param).getName();
                    for (String key : this.tableMap.keySet()) {
                        if (key.isEmpty()) continue;
                        tableName = this.tableMap.get(key);
                    }
                    schema = this.schemaMap.get(tableName);
                }
                this.whereMap.put(schema + "." + tableName + "." + colName, colValue);
                this.putInWhereParams(param, schema + "." + tableName + "." + colName, colValue);
            }
        }
        return true;
    }

    public String parseSelectStar(SQLSelectQueryBlock query) throws SQLException {
        String sql = query.toString();
        for (SQLSelectItem field : query.getSelectList()) {
            String[] columns = field.getExpr().toString().trim().split("\\.");
            String alias = columns[0];
            String column = columns.length == 1 ? columns[0] : columns[1];
            HashMap<String, String> map = new HashMap<String, String>();
            this.parseFrom(query.getFrom(), map, "", true);
            if ("*".equalsIgnoreCase(column)) {
                sql = this.columnReplaceStar(sql, alias, map);
                continue;
            }
            if (columns.length != 1) continue;
            ArrayList<Column> sqlExprList = new ArrayList<Column>();
            SQLExpr fieldExpr = field.getExpr();
            this.parseSQLExpr(fieldExpr, fieldExpr, sqlExprList, false);
            for (Column col : sqlExprList) {
                this.columnAddTableAlias(col.getExpr(), map);
            }
            sql = query.toString();
        }
        return sql;
    }

    public void columnAddTableAlias(SQLExpr fieldExpr, Map<String, String> tableMap) throws SQLException {
        String column = fieldExpr.toString();
        if (!"*".equalsIgnoreCase(column)) {
            String columnName;
            String[] split;
            String schema_real;
            String schema_temp;
            String url = this.params.get("url");
            String schema = this.params.get("schema");
            String ip_port = url.split("/")[2];
            SQLIdentifierExpr expr = (SQLIdentifierExpr)fieldExpr;
            String sql = fieldExpr.toString();
            for (String s : this.tableList.keySet()) {
                if (!tableMap.containsKey(s)) continue;
                for (Column tableColumn : this.tableList.get(s)) {
                    String columnName2;
                    String[] split2 = tableColumn.getColumnName().split("\\.");
                    if (split2.length < 2 || !(columnName2 = split2[1]).equalsIgnoreCase(column.replaceAll("[\"`]", ""))) continue;
                    sql = sql.replaceAll(column, s + "." + column);
                    expr.setName(sql);
                    return;
                }
            }
            for (String key : this.unionTableMap.keySet()) {
                schema_temp = this.schemaMap.get(this.unionTableMap.get(key));
                schema_real = schema_temp == null ? schema : schema_temp;
                for (Column tableColumn : JdbcUtil.getTableColumns(ip_port, schema_real, this.unionTableMap.get(key), key, this.tableList)) {
                    split = tableColumn.getColumnName().split("\\.");
                    if (split.length < 2 || !(columnName = split[1]).equalsIgnoreCase(column.replaceAll("[\"`]", ""))) continue;
                    sql = sql.replaceAll(column, key + "." + column);
                    expr.setName(sql);
                    return;
                }
            }
            for (String key : tableMap.keySet()) {
                schema_temp = this.schemaMap.get(tableMap.get(key));
                schema_real = schema_temp == null ? schema : schema_temp;
                for (Column tableColumn : JdbcUtil.getTableColumns(ip_port, schema_real, tableMap.get(key), key, this.tableList)) {
                    split = tableColumn.getColumnName().split("\\.");
                    if (split.length < 2 || !(columnName = split[1]).equalsIgnoreCase(column.replaceAll("[\"`]", ""))) continue;
                    sql = sql.replaceAll(column, key + "." + column);
                    expr.setName(sql);
                    return;
                }
            }
        }
    }

    public String columnReplaceStar(String sql, String alias, Map<String, String> tableMap) throws SQLException {
        String url = this.params.get("url");
        String schema = this.params.get("schema");
        String ip_port = url.split("/")[2];
        ArrayList columns = new ArrayList();
        if ("*".equalsIgnoreCase(alias)) {
            for (String key : tableMap.keySet()) {
                String schema_temp = this.schemaMap.get(tableMap.get(key));
                String schema_real = schema_temp == null ? schema : schema_temp;
                List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema_real, tableMap.get(key), key, this.tableList);
                ArrayList<String> colList = new ArrayList<String>();
                for (int i = 0; i < tableColumns.size(); ++i) {
                    Column col = tableColumns.get(i);
                    String column = "";
                    column = col.getColumnAlisa() != null ? key + "." + col.getColumnAlisa() : key + "." + col.getColumnName().split("\\.")[1];
                    colList.add(column);
                }
                columns.addAll(colList);
            }
            if (columns.size() > 0) {
                sql = sql.replaceFirst("\\*", StringJoin.join(columns, ","));
            }
        } else if (tableMap.get(alias) != null) {
            List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema, tableMap.get(alias), alias, this.tableList);
            for (int i = 0; i < tableColumns.size(); ++i) {
                Column col = tableColumns.get(i);
                String column = "";
                column = col.getColumnAlisa() != null ? alias + "." + col.getColumnAlisa() : alias + "." + col.getColumnName().split("\\.")[1];
                columns.add(column);
            }
            if (columns.size() > 0) {
                sql = sql.replaceFirst(alias + "\\.\\*", StringJoin.join(columns, ","));
            }
        }
        return sql;
    }

    public void parseQueryColumns(SQLSelectQueryBlock query, String alias) throws SQLException {
        List<SQLSelectItem> fieldList = query.getSelectList();
        boolean isSub = !"".equalsIgnoreCase(alias);
        ArrayList<Column> temp = new ArrayList<Column>();
        for (SQLSelectItem field : fieldList) {
            SQLExpr fileExpr = field.getExpr();
            String className = fileExpr.getClass().toString();
            if (className.contains("SQLQueryExpr")) {
                String subQuery = this.parseSelect(this.dbType, field.getExpr().toString().replaceAll("\\(|\\)", ""));
                SQLSelectStatement stmt = (SQLSelectStatement)SQLUtils.parseStatements(subQuery, this.params.get("dbType")).get(0);
                SQLSelect select = stmt.getSelect();
                SQLQueryExpr sqlQueryExpr = new SQLQueryExpr(select);
                field.setExpr(sqlQueryExpr);
                continue;
            }
            ArrayList<Column> sqlExprList = new ArrayList<Column>();
            this.parseSQLExpr(fileExpr, fileExpr, sqlExprList, false);
            for (Column col_obj : sqlExprList) {
                SQLExpr sqlExpr = col_obj.getExpr();
                String columnName = sqlExpr.toString();
                Column column = new Column(columnName, field.getAlias(), isSub, alias);
                column.setMethod(col_obj.isMethod());
                column.setFullName(col_obj.getFullName());
                String[] columns = column.getColumnName().split("\\.");
                String c1 = columns[0];
                String c2 = columns.length > 1 ? columns[1] : columns[0];
                List<Column> list = this.tableList.get(c1);
                if (list != null) {
                    for (Column col : list) {
                        String s = col.getColumnName();
                        if (!JdbcUtil.sqlRegex(s, c2) && !JdbcUtil.sqlRegex(col.getColumnAlisa(), c2) || column.getFullName().trim().startsWith("count")) continue;
                        String colName = column.getColumnName();
                        String realName = "";
                        String own = "";
                        String now = "";
                        if (s.split("\\.").length > 1) {
                            realName = s;
                            own = s.split("\\.")[0];
                            now = s.split("\\.")[0] + "." + colName.split("\\.")[1];
                        } else {
                            realName = s;
                            own = colName.split("\\.")[0];
                            now = colName;
                        }
                        column.setColumnName(realName);
                        column.setNowName(now);
                        column.setSubQuery(true);
                        column.setSubAlisa(c1);
                        String fieldClassName = sqlExpr.getClass().getName();
                        if (!fieldClassName.contains("SQLPropertyExpr")) break;
                        SQLPropertyExpr expr = (SQLPropertyExpr)sqlExpr;
                        SQLIdentifierExpr owner = (SQLIdentifierExpr)expr.getOwner();
                        owner.setName(own);
                        break;
                    }
                }
                if (columns.length > 1) {
                    String url = this.params.get("url");
                    String schema = this.params.get("schema");
                    String schema_temp = this.schemaMap.get(c1);
                    String schema_real = schema_temp == null ? schema : schema_temp;
                    String ip_port = url.split("/")[2];
                    String columnDataType = JdbcUtil.getColumnDataType(ip_port, schema_real, this.tableMap.get(c1), c1, c2);
                    column.setDataType(columnDataType);
                }
                if (!isSub && !column.getFullName().trim().startsWith("count")) {
                    this.columnList.add(column);
                }
                temp.add(column);
            }
        }
        if (isSub) {
            this.tableList.put(alias, temp);
        }
    }

    public void parseSQLExpr(SQLExpr oldFileExpr, SQLExpr fileExpr, List<Column> sqlExprList, boolean isMethod) {
        String className = fileExpr.getClass().toString();
        if (!JdbcUtil.sqlRegex(className, "SQLPropertyExpr|SQLIdentifierExpr")) {
            if (className.contains("SQLAggregateExpr")) {
                SQLAggregateExpr expr = (SQLAggregateExpr)fileExpr;
                for (SQLExpr sqlExpr : expr.getArguments()) {
                    String name = sqlExpr.getClass().getName();
                    if (name.contains("SQLCharExpr")) continue;
                    this.parseSQLExpr(oldFileExpr, sqlExpr, sqlExprList, true);
                }
            } else if (className.contains("SQLMethodInvokeExpr")) {
                SQLMethodInvokeExpr expr = (SQLMethodInvokeExpr)fileExpr;
                for (SQLExpr sqlExpr : expr.getArguments()) {
                    String name = sqlExpr.getClass().getName();
                    if (name.contains("SQLCharExpr")) continue;
                    this.parseSQLExpr(oldFileExpr, sqlExpr, sqlExprList, true);
                }
            } else if (className.contains("SQLBinaryOpExpr")) {
                SQLBinaryOpExpr expr = (SQLBinaryOpExpr)fileExpr;
                SQLExpr left = expr.getLeft();
                SQLExpr right = expr.getRight();
                this.parseSQLExpr(oldFileExpr, left, sqlExprList, true);
                this.parseSQLExpr(oldFileExpr, right, sqlExprList, true);
            } else if (className.contains("SQLCaseExpr")) {
                SQLCaseExpr expr = (SQLCaseExpr)fileExpr;
                for (SQLCaseExpr.Item item : expr.getItems()) {
                    this.parseSQLExpr(oldFileExpr, item.getConditionExpr(), sqlExprList, true);
                }
            } else if (className.contains("SQLBetweenExpr")) {
                SQLBetweenExpr expr = (SQLBetweenExpr)fileExpr;
                this.parseSQLExpr(oldFileExpr, expr.getTestExpr(), sqlExprList, true);
            }
        } else {
            Column column = new Column(isMethod, fileExpr);
            column.setFullName(oldFileExpr.toString());
            sqlExprList.add(column);
        }
    }

    public SQLInsertStatement parseInsert(String dbType, String sql) throws SQLException {
        SQLInsertStatement insert = this.aliParseInsert(dbType, sql);
        this.parseInsertColumns(insert);
        return insert;
    }

    public SQLInsertStatement aliParseInsert(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLInsertStatement stmt = (SQLInsertStatement)stmtList.get(0);
        return stmt;
    }

    public void parseInsertColumns(SQLInsertStatement insert) throws SQLException {
        List<SQLExpr> columns;
        String url = this.params.get("url");
        String schema = this.params.get("schema");
        SQLName tableExpr = insert.getTableName();
        if (tableExpr instanceof SQLPropertyExpr) {
            SQLPropertyExpr propExpr = (SQLPropertyExpr)tableExpr;
            schema = propExpr.getOwnerName();
        }
        String tableName = insert.getTableName().getSimpleName();
        String className = insert.getTableName().getClass().getName();
        if (className.contains("SQLIdentifierExpr")) {
            SQLPropertyExpr expr = new SQLPropertyExpr();
            expr.setName(tableName);
            expr.setOwner(schema);
            insert.setTableName(expr);
        }
        if ((columns = insert.getColumns()).size() == 0) {
            String schema_temp = this.schemaMap.get(tableName);
            Object schema_real = schema_temp == null ? schema : schema_temp;
            String ip_port = url.split("/")[2];
            for (Column tableColumn : JdbcUtil.getTableColumns(ip_port, (String)schema_real, tableName, "", this.tableList)) {
                SQLIdentifierExpr sqlIdentifierExpr = new SQLIdentifierExpr();
                sqlIdentifierExpr.setName(tableColumn.getColumnName());
                columns.add(sqlIdentifierExpr);
                Column column = new Column();
                column.setColumnName(tableName + "." + tableColumn.getColumnName());
                this.columnList.add(column);
            }
        } else {
            for (SQLExpr column : columns) {
                Column col = new Column();
                String name = column.getClass().getName();
                String colname = "";
                if (name.contains("SQLIdentifierExpr")) {
                    col.setColumnName(tableName + "." + column.toString());
                } else if (column instanceof SQLPropertyExpr) {
                    SQLPropertyExpr prop = (SQLPropertyExpr)column;
                    tableName = prop.getOwnerName();
                    col.setColumnName(column.toString());
                } else {
                    col.setColumnName(column.toString());
                }
                this.columnList.add(col);
            }
        }
        this.tableMap.put(tableName, tableName);
        List<SQLInsertStatement.ValuesClause> valuesList = insert.getValuesList();
        if (valuesList.size() == 0) {
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)insert.getQuery().getQuery();
            String parseSql = this.parseSelect(this.dbType, query.toString());
            SQLSelectQueryBlock sqlSelectQueryBlock = this.aliParseSelect(this.dbType, parseSql, true);
            insert.getQuery().setQuery(sqlSelectQueryBlock);
        }
        this.schemaMap.put(tableName, schema);
    }

    public SQLUpdateStatement parseUpdate(String dbType, String sql) throws SQLException {
        SQLUpdateStatement update = this.aliParseUpdate(dbType, sql);
        this.parseUpdateColumns(update);
        return update;
    }

    public SQLUpdateStatement aliParseUpdate(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLUpdateStatement stmt = (SQLUpdateStatement)stmtList.get(0);
        return stmt;
    }

    public void parseUpdateColumns(SQLUpdateStatement update) throws SQLException {
        String tableName = update.getTableName().getSimpleName();
        SQLExprTableSource tableExpr = (SQLExprTableSource)update.getTableSource();
        SQLExpr expr1 = tableExpr.getExpr();
        String schema = this.params.get("schema");
        if (expr1 instanceof SQLIdentifierExpr) {
            SQLPropertyExpr expr = new SQLPropertyExpr();
            expr.setName(tableName);
            expr.setOwner(schema);
            tableExpr.setExpr(expr);
        } else if (expr1 instanceof SQLPropertyExpr) {
            schema = ((SQLPropertyExpr)expr1).getOwnerName();
        }
        this.schemaMap.put(tableName, schema);
        String alias = update.getTableSource().getAlias();
        String name = alias == null ? tableName : alias;
        for (SQLUpdateSetItem item : update.getItems()) {
            SQLExprImpl column;
            String className = item.getColumn().getClass().getName();
            String colName = "";
            String colValue = "";
            if (className.contains("SQLPropertyExpr")) {
                column = (SQLPropertyExpr)item.getColumn();
                colName = ((SQLPropertyExpr)column).getName();
                colValue = ((SQLUpdateSetItem)column.getParent()).getValue().toString();
            } else if (className.contains("SQLIdentifierExpr")) {
                column = (SQLIdentifierExpr)item.getColumn();
                colName = ((SQLIdentifierExpr)column).getName();
                colValue = ((SQLUpdateSetItem)column.getParent()).getValue().toString();
            }
            Column col = new Column();
            col.setColumnName(name + "." + colName);
            col.setValue(colValue);
            this.columnList.add(col);
        }
        this.tableMap.put(name, tableName);
        this.parseWhere(update.getWhere());
    }

    public SQLDeleteStatement parseDelete(String dbType, String sql) throws SQLException {
        SQLDeleteStatement delete = this.aliParseDelete(dbType, sql);
        this.parseDeleteColumns(delete);
        return delete;
    }

    public SQLDeleteStatement aliParseDelete(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLDeleteStatement stmt = (SQLDeleteStatement)stmtList.get(0);
        return stmt;
    }

    public void parseDeleteColumns(SQLDeleteStatement delete) throws SQLException {
        String schema = this.params.get("schema");
        String url = this.params.get("url");
        String ip_port = url.split("/")[2];
        String tableName = delete.getTableName().getSimpleName();
        SQLExprTableSource tableExpr = (SQLExprTableSource)delete.getTableSource();
        SQLExpr expr1 = tableExpr.getExpr();
        if (expr1 instanceof SQLIdentifierExpr) {
            SQLPropertyExpr expr = new SQLPropertyExpr();
            expr.setName(tableName);
            expr.setOwner(schema);
            tableExpr.setExpr(expr);
        } else if (expr1 instanceof SQLPropertyExpr) {
            schema = ((SQLPropertyExpr)expr1).getOwnerName();
        }
        this.tableMap.put(tableName, tableName);
        this.schemaMap.put(tableName, schema);
        for (Column tableColumn : JdbcUtil.getTableColumns(ip_port, schema, tableName, tableName, this.tableList)) {
            Column column = new Column();
            column.setColumnName(tableColumn.getColumnName());
            this.columnList.add(column);
        }
        this.parseWhere(delete.getWhere());
    }

    public SQLTruncateStatement parseTruncate(String dbType, String sql) throws SQLException {
        SQLTruncateStatement truncate = this.aliParseTruncate(dbType, sql);
        this.parseTruncateColumns(truncate);
        return truncate;
    }

    public SQLTruncateStatement aliParseTruncate(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLTruncateStatement stmt = (SQLTruncateStatement)stmtList.get(0);
        return stmt;
    }

    public void parseTruncateColumns(SQLTruncateStatement truncate) {
        for (SQLExprTableSource sqlExprTableSource : truncate.getTableSources()) {
            String tableName = sqlExprTableSource.getName().getSimpleName();
            this.tableMap.put(tableName, tableName);
        }
    }

    public SQLCreateStatement parseCreate(String dbType, String sql) throws SQLException {
        SQLCreateStatement create = this.aliParseCreate(dbType, sql);
        this.parseCreateColumns(create);
        return create;
    }

    public SQLCreateStatement aliParseCreate(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLCreateStatement stmt = (SQLCreateStatement)stmtList.get(0);
        return stmt;
    }

    public void parseCreateColumns(SQLCreateStatement create) throws SQLException {
        String schema = this.params.get("schema");
        String name = create.getClass().getName();
        String tableName = "";
        if (name.contains("SQLCreateTableStatement")) {
            List<SQLTableElement> tableElementList;
            SQLCreateTableStatement createTable = (SQLCreateTableStatement)create;
            tableName = createTable.getTableName();
            String classTableName = createTable.getTableSource().getName().getClass().getName();
            if (classTableName.contains("SQLIdentifierExpr")) {
                SQLPropertyExpr expr = new SQLPropertyExpr();
                expr.setName(tableName);
                expr.setOwner(schema);
                createTable.getTableSource().setExpr(expr);
            }
            if ((tableElementList = createTable.getTableElementList()).size() == 0) {
                SQLSelect subQuery = createTable.getSelect();
                this.params.put("sql", subQuery.toString());
                this.parseSqlStructure(new HashMap<String, Object>());
            } else {
                for (SQLTableElement sqlTableElement : tableElementList) {
                    String className = sqlTableElement.getClass().getName();
                    if (!className.contains("SQLColumnDefinition")) continue;
                    SQLColumnDefinition col = (SQLColumnDefinition)sqlTableElement;
                    String columnName = col.getColumnName();
                    Column column = new Column();
                    column.setColumnName(tableName + "." + columnName);
                    this.columnList.add(column);
                }
            }
            this.tableMap.put(tableName, tableName);
        } else if (name.contains("SQLCreateViewStatement")) {
            SQLCreateViewStatement createView = (SQLCreateViewStatement)create;
            String simpleName = createView.getName().getSimpleName();
            SQLSelect subQuery = createView.getSubQuery();
            this.params.put("sql", subQuery.toString());
            this.parseSqlStructure(new HashMap<String, Object>());
            this.tableMap.put(simpleName, simpleName);
        }
        this.schemaMap.put(tableName, schema);
    }

    public SQLAlterTableStatement parseAlter(String dbType, String sql) throws SQLException {
        SQLAlterTableStatement alter = this.aliParseAlter(dbType, sql);
        this.parseAlterColumns(alter);
        return alter;
    }

    public SQLAlterTableStatement aliParseAlter(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)stmtList.get(0);
        return stmt;
    }

    public void parseAlterColumns(SQLAlterTableStatement alter) {
        String tableName = alter.getTableName();
        for (SQLAlterTableItem item : alter.getItems()) {
            Column col;
            String columnName;
            SQLObjectImpl alterColumn;
            String className = item.getClass().getName();
            if (className.contains("SQLAlterTableAddColumn")) {
                alterColumn = (SQLAlterTableAddColumn)item;
                for (SQLColumnDefinition sQLColumnDefinition : ((SQLAlterTableAddColumn)alterColumn).getColumns()) {
                    columnName = sQLColumnDefinition.getColumnName();
                    col = new Column();
                    col.setColumnName(tableName + "." + columnName);
                    this.columnList.add(col);
                }
                continue;
            }
            if (!className.contains("SQLAlterTableDropColumnItem")) continue;
            alterColumn = (SQLAlterTableDropColumnItem)item;
            for (SQLName sQLName : ((SQLAlterTableDropColumnItem)alterColumn).getColumns()) {
                columnName = sQLName.getSimpleName();
                col = new Column();
                col.setColumnName(tableName + "." + columnName);
                this.columnList.add(col);
            }
        }
        this.tableMap.put(tableName, tableName);
    }

    public String parseUnion(String dbType, String sql) throws SQLException {
        StringBuilder result = new StringBuilder();
        SQLUnionQuery query = this.aliParseUnion(dbType, sql);
        this.dealUnion(query, result);
        return result.toString();
    }

    public SQLUnionQuery aliParseUnion(String dbType, String sql) throws SQLException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
        SQLSelect select = stmt.getSelect();
        SQLUnionQuery query = (SQLUnionQuery)select.getQuery();
        return query;
    }

    public void dealUnion(SQLUnionQuery unionQuery, StringBuilder result) throws SQLException {
        List<SQLSelectQuery> queryList = unionQuery.getRelations();
        for (int i = 0; i < queryList.size(); ++i) {
            SQLSelectQuery selectQuery = queryList.get(i);
            String sql = "";
            String className = selectQuery.getClass().getName();
            if (className.contains("SQLUnionQuery")) {
                SQLUnionQuery unQuery = (SQLUnionQuery)selectQuery;
                this.dealUnion(unQuery, result);
            } else {
                SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
                this.parseFrom(query.getFrom(), null, "", true);
                this.parseFrom(query.getFrom(), null, "", false);
                sql = this.parseSelectStar(query);
                query = this.aliParseSelect(this.dbType, sql, true);
                this.parseQueryColumns(query, "");
                sql = this.parseSelectStar(query);
                result.append(sql);
            }
            if (i != 0) continue;
            result.append("\n" + unionQuery.getOperator().toString() + "\n");
        }
    }

    public SQLDropTableStatement parseDrop(String dbType, String sql) throws SQLException {
        SQLDropTableStatement drop = this.aliParseDrop(dbType, sql);
        this.parseDropColumns(drop);
        return drop;
    }

    public SQLDropTableStatement aliParseDrop(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLDropTableStatement stmt = (SQLDropTableStatement)stmtList.get(0);
        return stmt;
    }

    public void parseDropColumns(SQLDropTableStatement drop) {
        for (SQLExprTableSource tableSource : drop.getTableSources()) {
            String tableName = tableSource.getName().getSimpleName();
            this.tableMap.put(tableName, tableName);
        }
    }

    public SQLGrantStatement parseGrant(String dbType, String sql) throws SQLException {
        SQLGrantStatement grant = this.aliParseGrant(dbType, sql);
        this.parseGrantColumns(grant);
        return grant;
    }

    public SQLGrantStatement aliParseGrant(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLGrantStatement stmt = (SQLGrantStatement)stmtList.get(0);
        return stmt;
    }

    public void parseGrantColumns(SQLGrantStatement grant) {
        String url = this.params.get("url");
        String ip_port = url.split("/")[2];
        SQLExprTableSource resource = (SQLExprTableSource)grant.getResource();
        SQLPropertyExpr expr = (SQLPropertyExpr)resource.getExpr();
        String name = expr.getName();
        String owner = expr.getOwner().toString();
        if ("*".equalsIgnoreCase(owner)) {
            for (DataBase dataBase : JdbcUtil.dataBaseList) {
                if (!dataBase.getIp_port().equalsIgnoreCase(ip_port)) continue;
                for (Schema schema : dataBase.getSchemaList()) {
                    for (Table table : schema.getTableList()) {
                        this.schemaMap.put(table.getName(), schema.getName());
                        this.tableMap.put(table.getName(), table.getName());
                    }
                }
            }
        } else if ("*".equalsIgnoreCase(name)) {
            for (DataBase dataBase : JdbcUtil.dataBaseList) {
                if (!dataBase.getIp_port().equalsIgnoreCase(ip_port)) continue;
                for (Schema schema : dataBase.getSchemaList()) {
                    if (!schema.getName().equalsIgnoreCase(owner)) continue;
                    for (Table table : schema.getTableList()) {
                        this.schemaMap.put(table.getName(), owner);
                        this.tableMap.put(table.getName(), table.getName());
                    }
                }
            }
        } else {
            this.schemaMap.put(name, owner);
            this.tableMap.put(name, name);
        }
    }

    public SQLRevokeStatement parseRevoke(String dbType, String sql) throws SQLException {
        SQLRevokeStatement revoke = this.aliParseRevoke(dbType, sql);
        this.parseRevokeColumns(revoke);
        return revoke;
    }

    public SQLRevokeStatement aliParseRevoke(String dbType, String sql) throws SQLSyntaxErrorException {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() > 1) {
            throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
        }
        SQLRevokeStatement stmt = (SQLRevokeStatement)stmtList.get(0);
        return stmt;
    }

    public void parseRevokeColumns(SQLRevokeStatement revoke) {
        String url = this.params.get("url");
        String ip_port = url.split("/")[2];
        SQLExprTableSource resource = (SQLExprTableSource)revoke.getResource();
        SQLPropertyExpr expr = (SQLPropertyExpr)resource.getExpr();
        String name = expr.getName();
        String owner = expr.getOwner().toString();
        if ("*".equalsIgnoreCase(owner)) {
            for (DataBase dataBase : JdbcUtil.dataBaseList) {
                if (!dataBase.getIp_port().equalsIgnoreCase(ip_port)) continue;
                for (Schema schema : dataBase.getSchemaList()) {
                    for (Table table : schema.getTableList()) {
                        this.schemaMap.put(table.getName(), schema.getName());
                        this.tableMap.put(table.getName(), table.getName());
                    }
                }
            }
        } else if ("*".equalsIgnoreCase(name)) {
            for (DataBase dataBase : JdbcUtil.dataBaseList) {
                if (!dataBase.getIp_port().equalsIgnoreCase(ip_port)) continue;
                for (Schema schema : dataBase.getSchemaList()) {
                    if (!schema.getName().equalsIgnoreCase(owner)) continue;
                    for (Table table : schema.getTableList()) {
                        this.schemaMap.put(table.getName(), owner);
                        this.tableMap.put(table.getName(), table.getName());
                    }
                }
            }
        } else {
            this.schemaMap.put(name, owner);
            this.tableMap.put(name, name);
        }
    }

    public Map<String, String> pareAndReplace(SQLTableSource from, Map<String, String> map, String subTableAlias, Map repalceMap) throws SQLException {
        String className = from.getClass().getName();
        if (className.contains("SQLExprTableSource")) {
            SQLExprTableSource fromContent = (SQLExprTableSource)from;
            String tableName = fromContent.getExpr().toString();
            String tableAlisa = fromContent.getAlias();
            String exprClass = fromContent.getExpr().getClass().getName();
            if (exprClass.contains("SQLPropertyExpr")) {
                SQLPropertyExpr expr = (SQLPropertyExpr)fromContent.getExpr();
                tableName = expr.getName();
                String owner = expr.getOwner().toString();
                this.schemaMap.put(tableName, owner);
            } else {
                String owner = this.params.get("schema");
                SQLIdentifierExpr expr = (SQLIdentifierExpr)fromContent.getExpr();
                SQLPropertyExpr pExpr = new SQLPropertyExpr();
                pExpr.setName(expr.getName());
                pExpr.setOwner(owner);
                fromContent.setExpr(pExpr);
                this.schemaMap.put(tableName, owner);
            }
            String string = tableAlisa = tableAlisa == null ? tableName : tableAlisa;
            if (map == null) {
                this.tableMap.put(tableAlisa, tableName);
                String realTable = this.tableMap.get(subTableAlias);
                if (realTable == null) {
                    this.tableMap.put(subTableAlias, tableName);
                } else if (!realTable.equalsIgnoreCase(subTableAlias)) {
                    this.tableMap.put(subTableAlias, realTable + "." + tableName);
                }
                String name = fromContent.getParent().getClass().getName().toLowerCase();
                if (name.contains("SQLSelectQueryBlock".toLowerCase())) {
                    this.parseWhere(((SQLSelectQueryBlock)from.getParent()).getWhere());
                    SQLSelectGroupByClause groupBy = ((SQLSelectQueryBlock)from.getParent()).getGroupBy();
                    if (groupBy != null) {
                        this.parseHaving(((SQLSelectQueryBlock)from.getParent()).getGroupBy().getHaving());
                    }
                } else if (name.contains("SQLJoinTableSource".toLowerCase())) {
                    this.parseWhere(((SQLJoinTableSource)from.getParent()).getCondition());
                }
            } else {
                map.put(tableAlisa, tableName);
            }
        } else if (className.contains("SQLJoinTableSource")) {
            SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
            SQLTableSource left = fromContent.getLeft();
            this.pareAndReplace(left, map, "", repalceMap);
            SQLTableSource right = fromContent.getRight();
            this.pareAndReplace(right, map, "", repalceMap);
        } else if (className.contains("SQLUnionQueryTableSource")) {
            SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
            String alias = fromContent.getAlias();
            SQLUnionQuery union = fromContent.getUnion();
            ArrayList<SQLSelectQueryBlock> unionList = new ArrayList<SQLSelectQueryBlock>();
            this.parseUnionFrom(union, unionList);
            this.paresUnionFromSql(unionList, alias, false);
            if (map == null) {
                this.tableMap.put(alias, alias);
            } else {
                map.put(alias, alias);
            }
        } else if (className.contains("SQLSubqueryTableSource")) {
            SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
            SQLSelect select = fromContent.getSelect();
            if (map == null) {
                SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
                this.parseFrom(query.getFrom(), map, fromContent.getAlias(), true);
                String sql = this.parseSelectStar(query);
                SQLSelectQueryBlock subQuery = this.aliParseSelect(this.dbType, sql, false);
                this.parseQueryColumns(subQuery, fromContent.getAlias());
                if (!"".equalsIgnoreCase(subTableAlias)) {
                    this.tableMap.put(subTableAlias, fromContent.getAlias());
                }
                this.parseWhere(query.getWhere());
            } else {
                map.put(fromContent.getAlias(), fromContent.getAlias());
            }
        }
        return this.tableMap;
    }

    public void parseSqlStructureAndReplace2(Map<String, Object> paramMap, List<Map> repalceMap) throws SQLException {
        String dbType;
        String sql = this.params.get("sql");
        String sqlType = JdbcUtil.getSqlType(sql, dbType = this.params.get("dbType"));
        if ("with_select".equals(sqlType) || "select".equals(sqlType) || "union".equals(sqlType) || "update".equals(sqlType) || "insert".equals(sqlType) || "insert_select".equals(sqlType) || "delete".equals(sqlType)) {
            String permission = this.params.get("permission");
            String url = this.params.get("url");
            String schema = this.params.get("schema");
            String ip_port = url.split("/")[2];
            SQLParser sqlParser = new SQLParser();
            DataBase dataBase = new DataBase();
            for (DataBase db : JdbcUtil.dataBaseList) {
                if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
                dataBase = db;
                break;
            }
            SQLResult parse = sqlParser.parse(sql, dataBase, schema);
            List<Object> columnlist = new ArrayList();
            if ("masking".equalsIgnoreCase(permission)) {
                columnlist = parse.outputs;
            } else if ("full".equalsIgnoreCase(permission)) {
                columnlist = parse.fields;
            } else if (!"insert".equalsIgnoreCase(sqlType) && !"update".equalsIgnoreCase(sqlType)) {
                columnlist = parse.outputs;
            }
            for (FieldInfo fieldInfo : columnlist) {
                List<Object> fieldInfoList = new ArrayList<FieldInfo>();
                if (fieldInfo.getRelations().size() > 1) {
                    fieldInfoList = fieldInfo.getRelations();
                } else {
                    fieldInfoList.add(fieldInfo);
                }
                for (FieldInfo fieldInfo2 : fieldInfoList) {
                    String name = fieldInfo2.getName();
                    Map<String, TableInfo> tables = fieldInfo2.getTables();
                    String tableName = "";
                    for (String s : tables.keySet()) {
                        tableName = s.split("\\.")[1];
                    }
                    Column column = new Column();
                    column.setColumnName(tableName + "." + name);
                    column.setColumnAlisa(fieldInfo2.getAlias() != null && !"".equals(fieldInfo2.getAlias()) ? fieldInfo2.getAlias().replaceAll("\"", "") : "");
                    column.setSubQuery(false);
                    this.columnList.add(column);
                }
            }
            for (TableInfo tableInfo : parse.tables) {
                TableMemo tb = tableInfo.getTable();
                this.tableMap.put(tb.name, tb.name);
                this.schemaMap.put(tb.name, tb.schema);
            }
            for (ValueInfo valueInfo : parse.values) {
                FieldMemo field = valueInfo.field;
                this.whereMap.put(field.name, valueInfo.value.toString());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("column", field.getAtomName());
                map.put("columnValue", valueInfo.value.toString());
                map.put("type", valueInfo.operator);
                this.whereList.add(map);
            }
            sqlParser.replace(parse.values, repalceMap);
            paramMap.put("whereList", this.whereList);
            paramMap.put("statement", parse.statement);
            paramMap.put("type", parse.sqlType.name().toLowerCase());
            paramMap.put("sql", parse.statement.toString());
        }
        paramMap.put("whereMap", this.whereMap);
        paramMap.put("tableMap", this.tableMap);
        paramMap.put("columnList", this.columnList);
        paramMap.put("schemaMap", this.schemaMap);
        paramMap.put("whereMap", this.whereMap);
        paramMap.put("whereList", this.whereList);
    }

    public List<String> parseWheres(String sql) {
        SQLParser parser = new SQLParser();
        return parser.where(sql);
    }

    public String formatSQL(String sql) {
        SQLParser parser = new SQLParser();
        return parser.format(sql);
    }

    public Scope getScope(String ip_port, String schema, List<SQLStatement> statements) {
        Context context = new Context();
        DataBase dataBase = new DataBase();
        for (DataBase db : JdbcUtil.dataBaseList) {
            if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
            dataBase = db;
            break;
        }
        context.initialize(dataBase, schema, this.dbType);
        Scope scope = new Scope();
        scope.dialector = new PostgresqlScopeDialector(scope);
        scope.context = context;
        scope.isCheckIsolated = true;
        ScopeVisitor scopeVisitor = new ScopeVisitor(scope);
        scopeVisitor.perform(statements);
        FieldVisitor fieldVisitor = new FieldVisitor(scope);
        fieldVisitor.perform(statements);
        return scope;
    }
}

