/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.hive.parser;

import bean.DataBase;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.hive.ast.stmt.HiveCreateTableStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.sqlparse.visitor.common.Context;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.memo.ValueMemo;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.hive.SQLParser;
import util.sqlparse.visitor.hive.parser.SQLStatementParser;
import util.sqlparse.visitor.hive.visitor.FieldVisitor;
import util.sqlparse.visitor.hive.visitor.HiveScopeDialector;
import util.sqlparse.visitor.hive.visitor.ScopeVisitor;
import util.sqlparse.visitor.hive.visitor.ValueReplacer;

public class SimpleSQLStatementParser
extends SQLStatementParser {
    @Override
    public SQLResult parseStatement(SQLStatement statement, DataBase dataBase, String schema) {
        Context context = new Context();
        context.initialize(dataBase, schema, "hive");
        Scope scope = new Scope();
        scope.dialector = new HiveScopeDialector(scope);
        scope.context = context;
        scope.isCheckIsolated = true;
        List<SQLStatement> statements = Arrays.asList(statement);
        ScopeVisitor scopeVisitor = new ScopeVisitor(scope);
        scopeVisitor.perform(statements);
        FieldVisitor fieldVisitor = new FieldVisitor(scope);
        fieldVisitor.perform(statements);
        SQLResult result = new SQLResult();
        result.sqlType = context.sqlType;
        result.tables = context.getTables();
        HashMap<String, TableMemo> tables = new HashMap<String, TableMemo>(6);
        this.getAllTables(scope, tables);
        Collection tablesTemp = tables.values();
        ArrayList<TableMemo> tableMemoList = new ArrayList<TableMemo>();
        for (TableMemo tableMemo : tablesTemp) {
            if (tableMemo.topTable) continue;
            tableMemoList.add(tableMemo);
        }
        result.tableMemos = tableMemoList;
        tables.clear();
        HashMap<String, FieldMemo> fields = new HashMap<String, FieldMemo>();
        HashMap<String, FieldInfo> fieldInfos = new HashMap<String, FieldInfo>();
        this.getAllFields(scope, fields, fieldInfos);
        result.fieldMemos = new ArrayList(fields.values());
        result.fields = new ArrayList(fieldInfos.values());
        fields.clear();
        ArrayList<FieldInfo> outputFields = new ArrayList<FieldInfo>();
        this.getSelectFields(scope, fieldInfos, fields, context.getTableMap(), outputFields);
        result.outputMemos = new ArrayList(fields.values());
        result.outputs = outputFields;
        fields.clear();
        ArrayList<ValueInfo> values = new ArrayList<ValueInfo>();
        this.getValues(scope, fieldInfos, values);
        result.values = values;
        result.statement = statements.get(0);
        result.statementType = SQLParser.getStatementType(result.statement);
        result.isCaseSensitive = scope.isCaseSensitive();
        return result;
    }

    private void getAllTables(Scope scope, Map<String, TableMemo> tableMap) {
        for (Scope child : scope.getChildren()) {
            for (Map.Entry entry : child.getTableMap().entrySet()) {
                tableMap.put(((TableMemo)entry.getValue()).getUniqueName(), (TableMemo)entry.getValue());
            }
            this.getAllTables(child, tableMap);
        }
    }

    private void getAllFields(Scope scope, Map<String, FieldMemo> fieldMap, Map<String, FieldInfo> fields) {
        Map<String, TableInfo> tables = scope.context.getTableMap();
        for (Scope child : scope.getChildren()) {
            for (Map.Entry entry : child.getFieldMap().entrySet()) {
                fieldMap.put(((FieldMemo)entry.getValue()).getUniqueName(), (FieldMemo)entry.getValue());
                FieldMemo fieldMemo = (FieldMemo)entry.getValue();
                HashMap<String, TableInfo> tableMap = new HashMap<String, TableInfo>();
                boolean isValid = true;
                if ((fieldMemo.children.size() == 0 && !fieldMemo.complex || fieldMemo.atom) && !fieldMemo.isConstant) {
                    ArrayList<TableMemo> tableMemos = new ArrayList<TableMemo>(fieldMemo.tables);
                    if (fieldMemo.table != null) {
                        tableMemos.add(fieldMemo.table);
                    }
                    for (TableMemo table : tableMemos) {
                        TableInfo tableInfo = tables.get(table.getAtomName());
                        if (tableInfo == null) {
                            isValid = false;
                            break;
                        }
                        tableMap.put(table.getAtomName(), tableInfo);
                    }
                }
                if (tableMap.size() <= 0 || !isValid) continue;
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setName(fieldMemo.name);
                fieldInfo.setMemo(fieldMemo);
                fieldInfo.setAlias(fieldMemo.name);
                fieldInfo.setFullName(fieldMemo.getAtomName());
                fields.put(fieldMemo.getAtomName(), fieldInfo);
                fieldInfo.setTables(tableMap);
            }
            this.getAllFields(child, fieldMap, fields);
        }
    }

    private void getSelectFields(Scope scope, Map<String, FieldInfo> fields, Map<String, FieldMemo> fieldMap, Map<String, TableInfo> tables, List<FieldInfo> outputFields) {
        for (Scope child : scope.getChildren()) {
            if (child.top) continue;
            if (child.fromField) {
                return;
            }
            if (!child.top && child.getFieldMap().size() > 0) {
                for (Map.Entry entry : child.getFieldMap().entrySet()) {
                    FieldMemo field = (FieldMemo)entry.getValue();
                    if (!field.isSelectItem || field.isConstant) continue;
                    FieldInfo info = new FieldInfo();
                    info.setFullName(field.ref == null ? field.name : field.ref.toString());
                    info.setName(field.name);
                    info.setAlias(field.alias);
                    info.setMemo(field);
                    HashMap<String, FieldInfo> relations = new HashMap<String, FieldInfo>();
                    this.getFieldInfos(field, fields, relations);
                    if (field.tables.size() > 0) {
                        this.getAtomTables(field.tables, tables, info.getTables());
                    }
                    if (relations.size() > 0) {
                        for (Map.Entry e : relations.entrySet()) {
                            info.getTables().putAll(((FieldInfo)e.getValue()).getTables());
                        }
                        info.setRelations(new ArrayList<FieldInfo>(relations.values()));
                    }
                    if (field.complex && relations.size() == 0) continue;
                    fieldMap.put(field.getUniqueName(), field);
                    outputFields.add(info);
                    if (!(child.ref instanceof HiveCreateTableStatement)) continue;
                    this.getSelectFields(child, fields, fieldMap, tables, outputFields);
                }
                continue;
            }
            this.getSelectFields(child, fields, fieldMap, tables, outputFields);
        }
    }

    private void getFieldInfos(FieldMemo fieldMemo, Map<String, FieldInfo> fields, Map<String, FieldInfo> output) {
        if (fieldMemo.children != null && fieldMemo.children.size() != 0) {
            for (FieldMemo child : fieldMemo.children) {
                this.getFieldInfos(child, fields, output);
            }
        } else {
            String name = fieldMemo.getAtomName();
            if (fields.containsKey(name)) {
                FieldInfo fieldInfo = fields.get(name);
                fieldInfo.getMemos().add(fieldMemo);
                output.put(name, fieldInfo);
            }
        }
    }

    private void getAtomTables(List<TableMemo> tables, Map<String, TableInfo> tableMap, Map<String, TableInfo> atomTableMap) {
        if (tables != null && tables.size() != 0) {
            for (TableMemo table : tables) {
                if (table.getChildren().size() == 0) {
                    TableInfo tableInfo = tableMap.get(table.getAtomName());
                    if (tableInfo == null) continue;
                    atomTableMap.put(tableInfo.getAtomName(), tableInfo);
                    continue;
                }
                this.getAtomTables(table.getChildren(), tableMap, atomTableMap);
            }
        }
    }

    private void getValues(Scope scope, Map<String, FieldInfo> fieldMap, List<ValueInfo> values) {
        for (ValueMemo value : scope.getValues()) {
            ValueInfo valueInfo = new ValueInfo(value);
            FieldMemo field = value.field;
            HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
            this.getFieldInfos(field, fieldMap, fields);
            valueInfo.setFields(new ArrayList<FieldInfo>(fields.values()));
            values.add(valueInfo);
        }
    }

    public void replace(List<ValueInfo> values, Map<String, String> replaceValue) {
        ValueReplacer replacer = new ValueReplacer(replaceValue);
        replacer.replaceValues(values);
    }

    public void replace(List<ValueInfo> values, List<Map> whereList) {
        ValueReplacer replacer = new ValueReplacer(whereList);
        replacer.replaceValuesWithList(values);
    }
}

