/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo;

import org.bson.BsonString;
import org.bson.BsonValue;
import util.sqlparse.visitor.mongo.BsonNode;
import util.sqlparse.visitor.mongo.BsonObjectNode;
import util.sqlparse.visitor.mongo.MongoNode;

public class BsonKeyNode
extends BsonNode {
    private BsonObjectNode container;
    private BsonString ref;

    public BsonKeyNode() {
    }

    public BsonKeyNode(String name, BsonObjectNode container) {
        super(name);
        this.container = container;
    }

    @Override
    public Object value() {
        return this.name;
    }

    @Override
    public void value(Object raw, Object ... other) {
        if (raw != null && !raw.toString().equals(this.name)) {
            this.ref = new BsonString(raw.toString());
            Object node = this.container.get(this.name);
            BsonValue data = node.data();
            MongoNode newNode = BsonNode.create(node.getName(), data);
            this.container.remove(this.name);
            this.name = raw.toString();
            this.container.put(this.name, newNode);
        }
    }

    @Override
    public BsonValue data() {
        return this.ref;
    }

    public BsonObjectNode getContainer() {
        return this.container;
    }

    public void setContainer(BsonObjectNode container) {
        this.container = container;
    }

    public BsonString getRef() {
        return this.ref;
    }

    public void setRef(BsonString ref) {
        this.ref = ref;
    }

    @Override
    public BsonNode.BsonNodeType type() {
        return BsonNode.BsonNodeType.Key;
    }

    @Override
    public MongoNode clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

