/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DecoderContext;
import util.sqlparse.visitor.mongo.BsonObjectNode;
import util.sqlparse.visitor.mongo.MongoParser;
import util.sqlparse.visitor.mongo.ParseResult;
import util.sqlparse.visitor.mongo.ScopeVisitor;

public class Test {
    public static void main(String[] args) throws DecoderException {
        Test.teststring();
    }

    static void testParseFromBson() throws DecoderException {
        String data = "d90000000261676772656761746500060000006d79636f6c0004706970656c696e6500760000000330006e000000032467726f75700061000000025f696400090000002462795f757365720003616c6c436f6c6f756d6e73003d00000003247075736800310000000275726c00050000002475726c00026465736372697074696f6e000d000000246465736372697074696f6e00000000000003637572736f72000500000000036c736964001e00000005696400100000000496539c7e4ae24a9fbb0f9d9dbf0c7c1400022464620005000000746573740000";
        byte[] buffer = Hex.decodeHex((char[])data.toCharArray());
        BsonDocument test3 = new BsonDocumentCodec().decode((BsonReader)new BsonBinaryReader(ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN)), DecoderContext.builder().build());
        BsonObjectNode node = new BsonObjectNode(null, test3);
        ScopeVisitor visitor = new ScopeVisitor(null, "db1");
        MongoParser parser = new MongoParser(visitor);
        parser.parse(node);
        ParseResult result = visitor.getResult();
        Test.print(result);
    }

    static void teststring() throws DecoderException {
        String data = "c40000000266696e6400070000006d79436f6c6c000366696c74657200260000000263617465676f72790005000000636166650002737461747573000200000061000003736f727400170000000163617465676f727900000000000000f03f0003636f6c6c6174696f6e0026000000026c6f63616c65000300000066720001737472656e67746800000000000000f03f00036c736964001e000000056964001000000004f49bb8b05ae746bcafcc596b00db470600022464620005000000746573740000";
        byte[] buffer = Hex.decodeHex((char[])data.toCharArray());
        BsonDocument doc = new BsonDocumentCodec().decode((BsonReader)new BsonBinaryReader(ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN)), DecoderContext.builder().build());
        BsonObjectNode node = new BsonObjectNode(null, doc);
        System.out.println(node);
    }

    static void print(ParseResult r) {
        System.out.println("---------------statement-----------------------------");
        System.out.println(r.statement.toString());
        System.out.println("---------------schemas-----------------------------");
        for (String string : r.schemas) {
            System.out.println(string);
        }
        System.out.println("---------------collections-----------------------------");
        for (String string : r.collections) {
            System.out.println(string);
        }
        System.out.println("---------------columns-----------------------------");
        for (Map.Entry entry : r.columns.entrySet()) {
            System.out.println((String)entry.getKey());
        }
    }
}

