/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo;

import bean.DataBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import util.sqlparse.visitor.common.Objects;
import util.sqlparse.visitor.mongo.BsonArrayNode;
import util.sqlparse.visitor.mongo.BsonBasicNode;
import util.sqlparse.visitor.mongo.BsonNode;
import util.sqlparse.visitor.mongo.BsonObjectNode;
import util.sqlparse.visitor.mongo.Identifier;
import util.sqlparse.visitor.mongo.MongoNode;
import util.sqlparse.visitor.mongo.MongoVisitor;

public class WhereVisitor
implements MongoVisitor<Boolean> {
    private DataBase dataBase;
    private String schema;
    private List<String> wheres = new ArrayList<String>();

    public List<String> getWheres() {
        return this.wheres;
    }

    @Override
    public Boolean visitFind(MongoNode context) {
        BsonObjectNode ctx = (BsonObjectNode)context;
        Object find = ctx.get(Identifier.Find.code);
        String collection = find.value().toString();
        BsonObjectNode filter = (BsonObjectNode)ctx.get(Identifier.Filter.code);
        this.visitFilter(collection, filter, false);
        return true;
    }

    private void visitJsonValue(String collection, MongoNode json, boolean isOutput) {
        if (json != null && !StringUtils.equals((String)json.toString(), (String)"{}")) {
            this.visitFilter("", json, false);
        }
    }

    private void visitFilter(String collection, MongoNode filter, boolean isOutput) {
        if (filter != null && !StringUtils.equals((String)filter.toString(), (String)"{}")) {
            this.wheres.add(filter.toString());
        }
    }

    @Override
    public Boolean visitInsert(MongoNode ctx) {
        return true;
    }

    @Override
    public Boolean visitUpdate(MongoNode ctx) {
        BsonArrayNode array = (BsonArrayNode)ctx;
        BsonObjectNode dataCtx = (BsonObjectNode)array.get(0);
        BsonObjectNode updateCtx = (BsonObjectNode)array.get(array.size() - 1);
        Object collectionCtx = updateCtx.get(Identifier.Update.code);
        String collection = collectionCtx.value().toString();
        BsonObjectNode filter = (BsonObjectNode)dataCtx.get(Identifier.Query.code);
        this.visitFilter(collection, filter, false);
        BsonObjectNode update = (BsonObjectNode)dataCtx.get(Identifier.U.code);
        this.visitFilter(collection, update, true);
        MongoNode mergeObjects = this.matchNode(Identifier.MergeObjects.code, dataCtx);
        if (mergeObjects != null) {
            BsonObjectNode mergeCtx = (BsonObjectNode)mergeObjects;
            this.visitFilter(collection, mergeCtx, true);
        }
        return true;
    }

    @Override
    public Boolean visitFindAndModify(MongoNode ctx) {
        BsonObjectNode objCtx = (BsonObjectNode)ctx;
        Object mongoNode = objCtx.get(Identifier.FindAndModify.code);
        String collection = mongoNode.value().toString();
        BsonObjectNode filter = (BsonObjectNode)objCtx.get(Identifier.Query.code);
        if (Objects.nonNull(filter)) {
            this.visitFilter(collection, filter, false);
        }
        return true;
    }

    @Override
    public Boolean visitDelete(MongoNode ctx) {
        BsonArrayNode array = (BsonArrayNode)ctx;
        BsonObjectNode collectionCtx = (BsonObjectNode)array.get(array.size() - 1);
        String collection = collectionCtx.get(Identifier.Delete.code).value().toString();
        for (int i = 0; i < array.children.size() - 1; ++i) {
            BsonObjectNode dataCtx = (BsonObjectNode)array.get(i);
            BsonObjectNode filter = (BsonObjectNode)dataCtx.get("q");
            this.visitFilter(collection, filter, false);
        }
        return true;
    }

    @Override
    public Boolean visitCommand(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitCount(MongoNode ctx) {
        BsonObjectNode objCtx = (BsonObjectNode)ctx;
        Object collectionCtx = objCtx.get(Identifier.Count.code);
        String collection = collectionCtx.value().toString();
        Object mongoNode = objCtx.get(Identifier.Query.code);
        this.visitFilter(collection, (MongoNode)mongoNode, false);
        return true;
    }

    @Override
    public Boolean visitAggregate(MongoNode ctx) {
        BsonObjectNode objNode = (BsonObjectNode)ctx;
        Object collectionCtx = objNode.get(Identifier.Aggregate.code);
        String collection = collectionCtx.value().toString();
        BsonArrayNode pipeCtx = (BsonArrayNode)objNode.get(Identifier.Pipeline.code);
        int allColumn = 1;
        this.visitPipeline(collection, pipeCtx, allColumn);
        return true;
    }

    private int visitPipeline(String collection, BsonArrayNode pipeCtx, int allColumn) {
        for (int i = 0; i < pipeCtx.children.size(); ++i) {
            BsonObjectNode pCtx = (BsonObjectNode)pipeCtx.get(i);
            BsonObjectNode facetCtx = (BsonObjectNode)pCtx.get(Identifier.Facet.code);
            if (facetCtx != null) {
                this.visitFacet(collection, facetCtx, true);
                allColumn = 0;
                continue;
            }
            BsonObjectNode unionWithCtx = (BsonObjectNode)pCtx.get(Identifier.UnionWith.code);
            if (unionWithCtx != null) {
                this.visitUnionWith(unionWithCtx, true);
                continue;
            }
            BsonObjectNode matchCtx = (BsonObjectNode)pCtx.get(Identifier.Match.code);
            if (matchCtx == null) continue;
            this.visitFilter(collection, matchCtx, false);
        }
        return allColumn;
    }

    private void visitUnionWith(BsonObjectNode unionWithCtx, boolean isOutput) {
        int allColumn = 1;
        Map<String, MongoNode> map = unionWithCtx.children();
        MongoNode mongoNode = map.get(Identifier.Coll.code);
        String collection = mongoNode.value().toString();
        BsonArrayNode pipeCtx = (BsonArrayNode)map.get(Identifier.Pipeline.code);
        if (pipeCtx != null) {
            this.visitPipeline(collection, pipeCtx, allColumn);
        }
    }

    private void visitFacet(String collection, BsonObjectNode facetCtx, boolean isOutput) {
        Map<String, MongoNode> children = facetCtx.children();
        for (Map.Entry<String, MongoNode> entry : children.entrySet()) {
            BsonArrayNode arrayNode = (BsonArrayNode)entry.getValue();
            for (MongoNode mongoNode : arrayNode.children()) {
                BsonObjectNode mongoNodeObject = (BsonObjectNode)mongoNode;
                Map<String, MongoNode> childrenNodeLast = mongoNodeObject.children();
                for (Map.Entry<String, MongoNode> nodeLast : childrenNodeLast.entrySet()) {
                    MongoNode value = nodeLast.getValue();
                    if (value.type() == BsonNode.BsonNodeType.Basic) {
                        BsonBasicNode basicCtx = (BsonBasicNode)value;
                        this.visitJsonValue(collection, basicCtx, true);
                        continue;
                    }
                    if (StringUtils.equals((String)nodeLast.getKey(), (String)Identifier.Match.code)) {
                        this.visitFilter(collection, (BsonObjectNode)value, false);
                        continue;
                    }
                    if (StringUtils.equals((String)nodeLast.getKey(), (String)Identifier.BucketAuto.code)) {
                        this.visitBucketAuto(collection, (BsonObjectNode)value, true);
                        continue;
                    }
                    if (!StringUtils.equals((String)nodeLast.getKey(), (String)Identifier.Bucket.code)) continue;
                    this.visitBucket(collection, (BsonObjectNode)value, true);
                }
            }
        }
    }

    private void visitSet(String collection, BsonObjectNode setCtx, boolean isOutput) {
        this.visitJsonValue(collection, setCtx, true);
    }

    private void visitBucketAuto(String collection, BsonObjectNode bucketAutoCtx, boolean isOutput) {
        BsonObjectNode outputCtx;
        Map<String, MongoNode> children = bucketAutoCtx.children();
        BsonBasicNode groupByCtx = (BsonBasicNode)children.get(Identifier.GroupBy.code);
        if (groupByCtx != null) {
            this.visitJsonValue(collection, groupByCtx, true);
        }
        if ((outputCtx = (BsonObjectNode)bucketAutoCtx.get(Identifier.Output.code)) != null) {
            this.visitBucketOutput(collection, outputCtx, true);
        }
    }

    private void visitBucket(String collection, BsonObjectNode bucketCtx, boolean isOutput) {
        BsonObjectNode outputCtx;
        Map<String, MongoNode> children = bucketCtx.children();
        BsonBasicNode groupByCtx = (BsonBasicNode)children.get(Identifier.GroupBy.code);
        if (groupByCtx != null) {
            this.visitFilter(collection, groupByCtx, false);
        }
        if ((outputCtx = (BsonObjectNode)bucketCtx.get(Identifier.Output.code)) != null) {
            this.visitBucketOutput(collection, outputCtx, true);
        }
    }

    private void visitBucketOutput(String collection, BsonObjectNode outputCtx, boolean isOutput) {
        if (outputCtx != null && !StringUtils.equals((String)outputCtx.toString(), (String)"{}")) {
            Map<String, MongoNode> children = outputCtx.children();
            for (Map.Entry<String, MongoNode> entry : children.entrySet()) {
                this.visitJsonValue(collection, entry.getValue(), true);
            }
        }
    }

    private void visitLookUp(BsonObjectNode lookupCtx, boolean isOutput) {
        Object from = lookupCtx.get(Identifier.From.code);
        String collection = from.value().toString();
        BsonArrayNode pipeCtx = (BsonArrayNode)lookupCtx.get(Identifier.Pipeline.code);
        if (pipeCtx != null) {
            boolean allColumn = true;
            for (int i = 0; i < pipeCtx.children.size(); ++i) {
                BsonObjectNode pCtx = (BsonObjectNode)pipeCtx.get(i);
                BsonObjectNode matchCtx = (BsonObjectNode)pCtx.get(Identifier.Match.code);
                if (matchCtx == null) continue;
                this.visitFilter(collection, matchCtx, false);
            }
        }
    }

    @Override
    public Boolean visitDistinct(MongoNode ctx) {
        BsonObjectNode objNode = (BsonObjectNode)ctx;
        Object collectionCtx = objNode.get(Identifier.Distinct.code);
        String collection = collectionCtx.value().toString();
        BsonObjectNode queryCtx = (BsonObjectNode)objNode.get(Identifier.Query.code);
        this.visitFilter(collection, queryCtx, false);
        return true;
    }

    private List<MongoNode> matchNodes(String match, MongoNode from) {
        ArrayList<MongoNode> list;
        block6: {
            block5: {
                if (from == null) {
                    return new ArrayList<MongoNode>();
                }
                list = new ArrayList<MongoNode>();
                if (from.type() == BsonNode.BsonNodeType.Basic) {
                    return list;
                }
                if (from.type() != BsonNode.BsonNodeType.Object) break block5;
                BsonObjectNode ctx = (BsonObjectNode)from;
                for (Map.Entry<String, MongoNode> entry : ctx.children().entrySet()) {
                    if (entry.getKey().equals(match)) {
                        list.add(entry.getValue());
                    }
                    list.addAll(this.matchNodes(match, entry.getValue()));
                }
                break block6;
            }
            if (from.type() != BsonNode.BsonNodeType.Array) break block6;
            BsonArrayNode ctx = (BsonArrayNode)from;
            for (MongoNode child : ctx.children()) {
                list.addAll(this.matchNodes(match, child));
            }
        }
        return list;
    }

    private MongoNode matchNode(String match, MongoNode from) {
        List<MongoNode> mongoNodes = this.matchNodes(match, from);
        return mongoNodes != null && mongoNodes.size() != 0 ? mongoNodes.get(0) : null;
    }

    @Override
    public Boolean visitDrop(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitCreate(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitCreateIndexes(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitDropIndexes(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitReIndex(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitRenameCollection(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitMapreduce(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitCreateUser(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitSaslSupportedMechs(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitUpdateUser(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitUsersInfo(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitGrantRolesToUser(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitRevokeRolesFromUser(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitDropUser(MongoNode ctx) {
        return null;
    }

    @Override
    public Boolean visitCreateCollection(MongoNode ctx) {
        return null;
    }
}

