/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo.desensitization;

import java.util.ArrayList;
import java.util.Map;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonString;
import org.bson.BsonValue;
import util.sqlparse.visitor.mongo.BsonArrayNode;
import util.sqlparse.visitor.mongo.BsonBasicNode;
import util.sqlparse.visitor.mongo.BsonJsScopeNode;
import util.sqlparse.visitor.mongo.BsonObjectNode;
import util.sqlparse.visitor.mongo.Identifier;
import util.sqlparse.visitor.mongo.MongoNode;
import util.sqlparse.visitor.mongo.MongoVisitor;
import util.sqlparse.visitor.mongo.ParseResult;

public class FieldReplaceVisitor
implements MongoVisitor<ParseResult> {
    private ParseResult result;
    private Map params;
    private ArrayList<ParseResult.Column> list;
    private String replaceSchema;
    private String replaceTable;
    private String replaceColumn;
    private String expression;

    public ParseResult getResult() {
        return this.result;
    }

    public FieldReplaceVisitor(Map params, ArrayList<ParseResult.Column> list) {
        this.params = params;
        this.result = new ParseResult();
        this.result.isMatched = false;
        this.list = list;
        this.replaceSchema = (String)params.get("replaceSchema");
        this.replaceTable = (String)params.get("replaceTable");
        this.replaceColumn = (String)params.get("replaceColumn");
        this.expression = (String)params.get("expression");
    }

    @Override
    public ParseResult visitFind(MongoNode context) {
        BsonObjectNode ctx = (BsonObjectNode)context;
        Object find = ctx.get(Identifier.Find.code);
        String collection = find.value().toString();
        BsonObjectNode filter = (BsonObjectNode)ctx.get(Identifier.Filter.code);
        BsonObjectNode projection = (BsonObjectNode)ctx.get(Identifier.Projection.code);
        BsonObjectNode aggregateCtx = new BsonObjectNode();
        BsonDocument aggregateDoc = new BsonDocument();
        aggregateDoc.put(Identifier.Aggregate.code, (BsonValue)new BsonString(collection));
        BsonArray pipline = new BsonArray();
        this.visitPorject(projection, pipline);
        this.visitPipline(ctx, pipline);
        if (filter != null) {
            BsonDocument temp = new BsonDocument();
            temp.put(Identifier.Match.code, (BsonValue)filter.getValue());
            pipline.add((BsonValue)temp);
        }
        aggregateDoc.put(Identifier.Pipeline.code, (BsonValue)pipline);
        this.mergeDocument(aggregateDoc, ctx.getValue(), Identifier.Explain, Identifier.AllowDiskUse, Identifier.Cursor, Identifier.MaxTimeMS, Identifier.BypassDocumentValidation, Identifier.ReadConcern, Identifier.Collation, Identifier.Hint, Identifier.Comment, Identifier.WriteConcern, Identifier.Let);
        BsonValue explain = aggregateDoc.get((Object)Identifier.Explain);
        BsonValue cursor = aggregateDoc.get((Object)Identifier.Cursor);
        if (explain == null && cursor == null) {
            BsonDocument cursorDoc = new BsonDocument();
            aggregateDoc.put(Identifier.Cursor.code, (BsonValue)cursorDoc);
        }
        this.mergeDocument(aggregateDoc, ctx.getValue(), Identifier.LSID, Identifier.DB);
        aggregateCtx.setValue(aggregateDoc);
        this.result.newMongoNode = aggregateCtx;
        return this.result;
    }

    private void visitPorject(BsonObjectNode projection, BsonArray array) {
        BsonDocument project = null;
        if (projection != null) {
            project = projection.getValue().clone();
        }
        this.replaceExpression(array, project);
    }

    private void visitPipline(BsonObjectNode ctx, BsonArray array) {
        this.visitItem(ctx, array, Identifier.Sort, Identifier.SORT);
        this.visitItem(ctx, array, Identifier.Limit, Identifier.DollarLimit);
        this.visitItem(ctx, array, Identifier.Skip, Identifier.DollarSkip);
    }

    private void visitItem(BsonObjectNode ctx, BsonArray array, Identifier source, Identifier target) {
        Object item = ctx.get(source.code);
        if (item != null) {
            BsonDocument sortDoc = new BsonDocument();
            if (item instanceof BsonObjectNode) {
                sortDoc.put(target.code, (BsonValue)((BsonObjectNode)item).getValue());
            } else if (item instanceof BsonBasicNode) {
                sortDoc.put(target.code, ((BsonBasicNode)item).getValue());
            } else if (item instanceof BsonArrayNode) {
                sortDoc.put(target.code, ((BsonArrayNode)item).getValue());
            } else if (item instanceof BsonJsScopeNode) {
                sortDoc.put(target.code, (BsonValue)((BsonJsScopeNode)item).getValue());
            } else {
                sortDoc.put(target.code, (BsonValue)((BsonObjectNode)item).getValue());
            }
            array.add((BsonValue)sortDoc);
        }
    }

    private void replaceExpression(BsonArray array, BsonDocument oldPreject) {
        for (ParseResult.Column column : this.list) {
            String newExpression = this.expression.replaceAll("\\$\\{value}", "\\$" + column.name + "");
            for (BsonValue value : BsonArray.parse((String)newExpression)) {
                String key;
                BsonValue value2;
                if (!(value instanceof BsonDocument)) continue;
                BsonDocument doc = (BsonDocument)value;
                BsonDocument project = (BsonDocument)doc.get((Object)"$project");
                if (project != null && (value2 = project.get((Object)(key = "$" + column.name))) != null) {
                    project.remove((Object)key);
                    if (oldPreject != null) {
                        for (String s : oldPreject.keySet()) {
                            BsonValue value1 = oldPreject.get((Object)s);
                            if (!(value1 instanceof BsonDocument) && !(value1 instanceof BsonArray)) {
                                project.put(s, value1);
                                continue;
                            }
                            project.put(s, (BsonValue)new BsonDouble(1.0));
                        }
                    }
                    project.put(column.name, value2);
                }
                array.add((BsonValue)doc);
            }
        }
    }

    @Override
    public ParseResult visitInsert(MongoNode ctx) {
        BsonArrayNode array = (BsonArrayNode)ctx;
        BsonObjectNode insert = (BsonObjectNode)array.get(array.size() - 1);
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitUpdate(MongoNode ctx) {
        BsonArrayNode array = (BsonArrayNode)ctx;
        BsonObjectNode updateCtx = (BsonObjectNode)array.get(array.size() - 1);
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitFindAndModify(MongoNode ctx) {
        BsonObjectNode objCtx = (BsonObjectNode)ctx;
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitDelete(MongoNode ctx) {
        BsonArrayNode array = (BsonArrayNode)ctx;
        BsonObjectNode collectionCtx = (BsonObjectNode)array.get(array.size() - 1);
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitCount(MongoNode ctx) {
        BsonObjectNode objCtx = (BsonObjectNode)ctx;
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitAggregate(MongoNode ctx) {
        BsonDocument doc;
        BsonValue value;
        BsonObjectNode objNode = (BsonObjectNode)ctx;
        BsonArrayNode pipline = (BsonArrayNode)objNode.get(Identifier.Pipeline.code);
        BsonArray piplineArray = (BsonArray)pipline.value();
        BsonDocument project = null;
        for (int i = piplineArray.size() - 1; !(i < 0 || (value = piplineArray.get(i)) instanceof BsonDocument && (project = (BsonDocument)(doc = (BsonDocument)value).get((Object)"$project")) != null); --i) {
        }
        this.replaceExpression(piplineArray, project);
        objNode.put(Identifier.Pipeline.code, (BsonValue)piplineArray);
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitDistinct(MongoNode ctx) {
        BsonObjectNode objNode = (BsonObjectNode)ctx;
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitDrop(MongoNode ctx) {
        BsonObjectNode objNode = (BsonObjectNode)ctx;
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitCreate(MongoNode ctx) {
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitCreateIndexes(MongoNode ctx) {
        BsonObjectNode createIndexesCtx = (BsonObjectNode)ctx;
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitDropIndexes(MongoNode ctx) {
        BsonObjectNode dropIndexesCtx = (BsonObjectNode)ctx;
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitReIndex(MongoNode ctx) {
        BsonObjectNode dropIndexesCtx = (BsonObjectNode)ctx;
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitRenameCollection(MongoNode ctx) {
        BsonObjectNode renameCollectionCtx = (BsonObjectNode)ctx;
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitMapreduce(MongoNode ctx) {
        BsonObjectNode mapreduceCtx = (BsonObjectNode)ctx;
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitCreateUser(MongoNode ctx) {
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitSaslSupportedMechs(MongoNode ctx) {
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitUpdateUser(MongoNode ctx) {
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitUsersInfo(MongoNode ctx) {
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitGrantRolesToUser(MongoNode ctx) {
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitRevokeRolesFromUser(MongoNode ctx) {
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitDropUser(MongoNode ctx) {
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitCreateCollection(MongoNode ctx) {
        this.result.newMongoNode = ctx;
        return this.result;
    }

    @Override
    public ParseResult visitCommand(MongoNode ctx) {
        this.result.newMongoNode = ctx;
        return this.result;
    }

    private void mergeDocument(BsonDocument target, BsonDocument source, Identifier ... ids) {
        for (Identifier id : ids) {
            BsonValue value = source.get((Object)id.code);
            if (value == null) continue;
            target.put(id.code, value);
        }
    }
}

