/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mysql.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.StatementType;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.memo.TableMemo;

public class RowVisitController {
    private final String tableRegex;
    private final String column;
    private final String value;
    private final SQLResult result;
    private final Map params;
    private String limit;

    public RowVisitController(SQLResult result, Map params) {
        this.result = result;
        this.params = params;
        Map modifyTable = (Map)params.get("modifyTable");
        Map tableKeyWord = (Map)params.get("tableKeyWord");
        this.limit = (String)params.get("limit");
        this.tableRegex = (String)tableKeyWord.keySet().iterator().next();
        this.column = (String)tableKeyWord.values().iterator().next();
        this.value = (String)((List)modifyTable.values().iterator().next()).get(0);
    }

    public void perform() {
        this.limitStatement();
        if (this.checkRowVisit()) {
            SQLStatement statement = this.result.statement;
            Pattern pattern = this.result.isCaseSensitive ? Pattern.compile(".*\\.`?" + this.tableRegex + "`?") : Pattern.compile(".*\\.`?" + this.tableRegex + "`?", 2);
            List<TableInfo> tables = this.result.tables;
            HashSet<SQLObject> parsed = new HashSet<SQLObject>();
            for (TableInfo table : tables) {
                String atomName = table.getAtomName();
                if (!pattern.matcher(atomName).matches()) continue;
                for (TableMemo memo : table.getMemos()) {
                    SQLObject ref = memo.ref;
                    if (parsed.contains(ref) || !(ref instanceof SQLTableSource)) continue;
                    this.params.put("isMatched", "true");
                    switch (this.result.statementType) {
                        case select: {
                            this.select(ref, table);
                            break;
                        }
                        case insert: {
                            this.insert(ref, table);
                            break;
                        }
                        case update: {
                            this.update(ref, table);
                            break;
                        }
                        case replace: {
                            this.replace(ref, table);
                            break;
                        }
                        case delete: {
                            this.delete(ref, table);
                            break;
                        }
                        default: {
                            this.params.put("isMatched", "false");
                        }
                    }
                    parsed.add(ref);
                }
            }
            this.params.put("newSql", statement.toString());
        }
    }

    private void limitStatement() {
        if (this.limit != null && this.limit.trim().length() != 0 && this.result.statement instanceof SQLSelectStatement) {
            SQLSelectStatement statement = (SQLSelectStatement)this.result.statement;
            this.setLimit(statement.getSelect(), this.limit);
        }
    }

    private void setLimit(SQLSelect select, String limit) {
        if (select != null && limit != null) {
            SQLExpr rowCount;
            SQLLimit limits = select.getLimit();
            if (limits == null) {
                SQLSelectQuery query = select.getQuery();
                if (query instanceof SQLSelectQueryBlock) {
                    SQLSelectQueryBlock block = (SQLSelectQueryBlock)query;
                    limits = block.getLimit();
                }
                if (limits == null) {
                    limits = new SQLLimit();
                    select.setLimit(limits);
                }
            }
            if ((rowCount = limits.getRowCount()) == null) {
                limits.setRowCount(Integer.parseInt(limit));
            } else if (rowCount instanceof SQLIntegerExpr) {
                SQLIntegerExpr c = (SQLIntegerExpr)rowCount;
                int row = Math.min(Integer.parseInt(limit), (Integer)c.getValue());
                limits.setRowCount(row);
            }
        }
    }

    private void select(SQLObject ref, TableInfo table) {
        SQLObject body;
        SQLExprTableSource tableSource = (SQLExprTableSource)ref;
        String alias = tableSource.getAlias();
        if (alias == null) {
            alias = table.getTable().name;
        }
        if ((body = this.getStmtBody(StatementType.select, tableSource)) != null) {
            SQLSelect select = (SQLSelect)body;
            this.replaceSelect(select, alias);
        }
    }

    private void insert(SQLObject ref, TableInfo table) {
        SQLObject body;
        SQLExprTableSource tableSource = (SQLExprTableSource)ref;
        String alias = tableSource.getAlias();
        if (alias == null) {
            alias = table.getTable().name;
        }
        if ((body = this.getStmtBody(StatementType.insert, tableSource)) != null && body instanceof SQLSelect) {
            SQLSelect select = (SQLSelect)body;
            this.replaceSelect(select, alias);
        }
    }

    private void update(SQLObject ref, TableInfo table) {
        SQLObject body;
        SQLExprTableSource tableSource = (SQLExprTableSource)ref;
        String alias = tableSource.getAlias();
        if (alias == null) {
            alias = table.getTable().name;
        }
        if ((body = this.getStmtBody(StatementType.update, tableSource)) != null) {
            if (body instanceof SQLSelect) {
                SQLSelect select = (SQLSelect)body;
                this.replaceSelect(select, alias);
            } else if (body instanceof SQLUpdateStatement) {
                SQLUpdateStatement updateStmt = (SQLUpdateStatement)body;
                SQLExpr expr = this.createBinaryExpr(alias);
                updateStmt.addWhere(expr);
            }
        }
    }

    private void replace(SQLObject ref, TableInfo table) {
        SQLObject body;
        SQLExprTableSource tableSource = (SQLExprTableSource)ref;
        String alias = tableSource.getAlias();
        if (alias == null) {
            alias = table.getTable().name;
        }
        if ((body = this.getStmtBody(StatementType.replace, tableSource)) != null && body instanceof SQLSelect) {
            SQLSelect select = (SQLSelect)body;
            this.replaceSelect(select, alias);
        }
    }

    private void delete(SQLObject ref, TableInfo table) {
        SQLObject body;
        SQLExprTableSource tableSource = (SQLExprTableSource)ref;
        String alias = tableSource.getAlias();
        if (alias == null) {
            alias = table.getTable().name;
        }
        if ((body = this.getStmtBody(StatementType.delete, tableSource)) != null) {
            if (body instanceof SQLSelect) {
                SQLSelect select = (SQLSelect)body;
                this.replaceSelect(select, alias);
            } else if (body instanceof SQLDeleteStatement) {
                SQLDeleteStatement stmt = (SQLDeleteStatement)body;
                SQLExpr expr = this.createBinaryExpr(alias);
                stmt.addWhere(expr);
            }
        }
    }

    private void replaceSelect(SQLSelect select, String alias) {
        SQLExpr expr = this.createBinaryExpr(alias);
        select.addWhere(expr);
    }

    private SQLExpr createBinaryExpr(String alias) {
        SQLPropertyExpr left = new SQLPropertyExpr();
        left.setName(this.column);
        left.setOwner(alias);
        SQLCharExpr right = new SQLCharExpr();
        right.setText(this.value);
        SQLBinaryOpExpr expr = new SQLBinaryOpExpr();
        expr.setOperator(SQLBinaryOperator.LessThanOrGreater);
        expr.setLeft(left);
        expr.setRight(right);
        return expr;
    }

    private SQLObject getStmtBody(StatementType stmtType, SQLTableSource tableSource) {
        for (SQLObject cursor = tableSource.getParent(); cursor != null; cursor = cursor.getParent()) {
            if (cursor instanceof SQLSelect) {
                return cursor;
            }
            if (stmtType == StatementType.insert && cursor instanceof SQLInsertStatement) {
                return cursor;
            }
            if (stmtType == StatementType.update && cursor instanceof SQLUpdateStatement) {
                return cursor;
            }
            if (stmtType == StatementType.replace && cursor instanceof SQLReplaceStatement) {
                return cursor;
            }
            if (stmtType != StatementType.delete || !(cursor instanceof SQLDeleteStatement)) continue;
            return cursor;
        }
        return null;
    }

    private boolean checkRowVisit() {
        String operateType = (String)this.params.get("operateType");
        switch (this.result.statementType) {
            case select: {
                if ("select".equalsIgnoreCase(operateType)) break;
                return false;
            }
            case insert: {
                if ("insert".equalsIgnoreCase(operateType)) break;
                return false;
            }
            case update: {
                if ("update".equalsIgnoreCase(operateType)) break;
                return false;
            }
            case replace: {
                if ("replace".equalsIgnoreCase(operateType)) break;
                return false;
            }
            case delete: {
                if ("delete".equalsIgnoreCase(operateType)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

