/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.postgresql.visitor;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource.PGExprTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource.PGSubqueryTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGGrantStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.visitor.DefaultPGASTVisitor;
import java.util.List;
import util.sqlparse.visitor.common.scope.Scope;

public abstract class ParseVisitor
extends DefaultPGASTVisitor {
    private boolean debug = false;
    protected Scope scope;

    public ParseVisitor(Scope scope) {
        this.scope = scope;
    }

    public void perform(List<SQLStatement> statements) {
        if (statements != null && statements.size() != 0) {
            for (SQLStatement statement : statements) {
                statement.accept(this);
            }
            this.scope.reset();
        }
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        if (this.debug) {
            System.out.println("enter SQLSelectStatement" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLSelectStatement x) {
        if (this.debug) {
            System.out.println("exit SQLSelectStatement" + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLInsertStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(PGInsertStatement x) {
        return this.visit((SQLInsertStatement)x);
    }

    @Override
    public void endVisit(PGInsertStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLUpdateStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(PGUpdateStatement x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(PGUpdateStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLDeleteStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(PGDeleteStatement x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(PGDeleteStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(PGGrantStatement x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(PGGrantStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLRevokeStatement x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLRevokeStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLWithSubqueryClause x) {
        if (this.debug) {
            System.out.println("enter SQLWithSubqueryClause" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLWithSubqueryClause x) {
        if (this.debug) {
            System.out.println("exit SQLWithSubqueryClause" + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        if (this.debug) {
            System.out.println("enter SQLWithSubqueryClause.Entry" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLWithSubqueryClause.Entry x) {
        if (this.debug) {
            System.out.println("exit SQLWithSubqueryClause.Entry" + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(PGSelectQueryBlock x) {
        if (this.debug) {
            System.out.println("enter PGSelectQueryBlock " + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(PGSelectQueryBlock x) {
        if (this.debug) {
            System.out.println("exit PGSelectQueryBlock " + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public void endVisit(SQLSelectQueryBlock x) {
        if (this.debug) {
            System.out.println("exit SQLSelectQueryBlock " + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLUnionQuery x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLLateralViewTableSource x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLLateralViewTableSource x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("enter SQLSubqueryTableSource" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("exit SQLSubqueryTableSource" + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(PGSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("enter PGSubqueryTableSource" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(PGSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("exit PGSubqueryTableSource" + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        return true;
    }

    @Override
    public boolean visit(SQLUnionQueryTableSource x) {
        if (this.debug) {
            System.out.println("enter SQLUnionQueryTableSource" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLUnionQueryTableSource x) {
        if (this.debug) {
            System.out.println("exit SQLUnionQueryTableSource" + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public void endVisit(SQLJoinTableSource x) {
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        return true;
    }

    @Override
    public void endVisit(SQLExprTableSource x) {
    }

    @Override
    public boolean visit(PGExprTableSource x) {
        if (!(x.getExpr() instanceof SQLIdentifierExpr) && !(x.getExpr() instanceof SQLPropertyExpr)) {
            if (this.debug) {
                System.out.println("enter PGExprTableSource  " + x);
            }
            this.scope.enterScope(x);
        } else if (this.debug) {
            System.out.println("begin PGExprTableSource" + x.toString());
        }
        return true;
    }

    @Override
    public void endVisit(PGExprTableSource x) {
        if (!(x.getExpr() instanceof SQLIdentifierExpr) && !(x.getExpr() instanceof SQLPropertyExpr)) {
            if (this.debug) {
                System.out.println("exit PGExprTableSource  " + x);
            }
            this.scope.exitScope();
        } else if (this.debug) {
            System.out.println("end PGExprTableSource" + x.toString());
        }
    }

    protected void acceptChild(List<? extends SQLObject> children) {
        if (children != null && children.size() != 0) {
            for (SQLObject sQLObject : children) {
                sQLObject.accept(this);
            }
        }
    }

    protected void visitChild(SQLObject x) {
        if (x != null) {
            x.accept(this);
        }
    }

    protected void visitChild(List<? extends SQLObject> x) {
        if (x != null && x.size() != 0) {
            for (SQLObject sQLObject : x) {
                this.visitChild(sQLObject);
            }
        }
    }

    protected boolean isEqual(String name1, String name2) {
        return this.scope.dialector.isEqual(name1, name2);
    }
}

