/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.spark.visitor;

import bean.Column;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLDbLinkExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectJoinTableSource;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectPivot;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectPivotBase;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectTableReference;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkValuesExpr;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkWithExpr;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkCreateViewStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkInsertStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkLoadStatement;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkRepairTableStatement;
import com.alibaba.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import util.sqlparse.visitor.common.Owner;
import util.sqlparse.visitor.common.memo.AliasField;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.ClauseScope;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.common.scope.TableScope;
import util.sqlparse.visitor.common.utils.Alias;
import util.sqlparse.visitor.spark.visitor.ParseVisitor;

public class ScopeVisitor
extends ParseVisitor {
    private final Alias alias = new Alias();
    private boolean debug = false;

    public ScopeVisitor(Scope scope) {
        super(scope);
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        if (this.debug) {
            System.out.println("enter SQLSelectStatement" + x.toString());
        }
        this.enterClauseScope(x);
        return true;
    }

    @Override
    public boolean visit(SparkInsertStatement x) {
        if (this.scope.context.sqlType == null) {
            this.scope.context.sqlType = TableStat.Mode.Insert;
        }
        if (x.isDirectory()) {
            return false;
        }
        this.wrapInsertQueryTable(x);
        this.wrapInsertFromTable(x);
        this.enterClauseScope(x);
        this.visitChild(x.getWith());
        this.visitChild(x.getTableSource());
        if (x.getColumns().size() == 0) {
            List<Column> columns;
            SQLExprImpl expr;
            String schema = null;
            String table = null;
            SQLName tableName = x.getTableName();
            if (tableName instanceof SQLIdentifierExpr) {
                expr = (SQLIdentifierExpr)tableName;
                table = ((SQLIdentifierExpr)expr).getName();
                schema = this.scope.context.getSchema();
            } else if (tableName instanceof SQLPropertyExpr) {
                expr = (SQLPropertyExpr)tableName;
                table = ((SQLPropertyExpr)expr).getName();
                schema = ((SQLPropertyExpr)expr).getOwnerName();
            }
            if (table != null && schema != null && (columns = this.scope.context.getColumns(schema, table)) != null && columns.size() > 0) {
                for (Column column : columns) {
                    SQLIdentifierExpr expr2 = new SQLIdentifierExpr(column.getRawName());
                    x.getColumns().add(expr2);
                    expr2.setParent(x);
                }
            }
        }
        for (SQLExpr column : x.getColumns()) {
            this.visitChild(column);
            FieldMemo field = (FieldMemo)column.getAttribute("field");
            if (field == null) continue;
            field.isSelectItem = true;
        }
        this.visitChild(x.getValuesList());
        this.visitChild(x.getQuery());
        return false;
    }

    private void wrapInsertQueryTable(SparkInsertStatement x) {
        SQLExpr queryTable;
        SQLSelect query = x.getQuery();
        if (query == null && (queryTable = x.getQueryTable()) != null) {
            SQLSelectQueryBlock block = new SQLSelectQueryBlock();
            SparkSelectTableReference table = new SparkSelectTableReference();
            table.setExpr(queryTable);
            block.setFrom(table);
            block.addSelectItem(new SQLIdentifierExpr("*"));
            SQLSelect select = new SQLSelect();
            select.setQuery(block);
            x.setQuery(select);
            x.setQueryTable(null);
        }
    }

    private void wrapInsertFromTable(SparkInsertStatement x) {
        SQLSelectQueryBlock block;
        SQLSelect query;
        SQLExpr fromTable = x.getFromTable();
        if (fromTable != null && (query = x.getQuery()) != null && (block = query.getQueryBlock()) != null) {
            SparkSelectTableReference table = new SparkSelectTableReference();
            table.setExpr(fromTable);
            block.setFrom(table);
            x.setFromTable(null);
        }
    }

    @Override
    public boolean visit(SparkLoadStatement x) {
        if (this.scope.context.sqlType == null) {
            this.scope.context.sqlType = TableStat.Mode.Other;
        }
        this.enterClauseScope(x);
        SparkSelectTableReference table = x.getTable();
        this.registerTable(table);
        return false;
    }

    @Override
    public void endVisit(SparkLoadStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLWithSubqueryClause x) {
        if (this.debug) {
            System.out.println("enter SQLWithSubqueryClause  " + x.toString());
        }
        ClauseScope scope = this.enterClauseScope(x);
        scope.top = true;
        scope.fromField = scope.isFromField(x);
        return true;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        TableScope scope = this.enterTableScope(x);
        scope.fromField = scope.isFromField(x);
        scope.top = true;
        TableMemo table = this.registerTable(x);
        this.visitChild(x.getSubQuery());
        table.topTable = true;
        x.putAttribute("table", table);
        x.putAttribute("scope", scope);
        scope.table = table;
        return false;
    }

    @Override
    public void endVisit(SQLWithSubqueryClause.Entry x) {
        if (this.debug) {
            System.out.println("enter SQLWithSubqueryClause.Entry  " + x.toString());
        }
        Scope current = this.scope.getCurrent();
        TableMemo table = (TableMemo)x.getAttribute("table");
        boolean addColumns = x.getColumns().size() == 0;
        ArrayList<FieldMemo> fields = new ArrayList<FieldMemo>();
        current.getSubFieldsForWith(fields);
        for (Scope child : current.getChildren()) {
            table.getChildren().addAll(child.getBranchTables());
        }
        current = this.scope.getCurrent();
        int k = 0;
        for (FieldMemo field : fields) {
            FieldMemo newNameField = field.copy();
            newNameField.name = field.alias;
            newNameField.alias = field.alias;
            if (!addColumns) {
                SQLExpr expr = x.getColumns().get(k);
                SQLName exprName = (SQLName)expr;
                String fieldName = exprName.getSimpleName();
                if (!this.isEqual(fieldName, field.alias)) {
                    newNameField.name = fieldName;
                    newNameField.alias = fieldName;
                }
                newNameField.ref = expr;
                newNameField.exprs.add(expr);
            } else {
                SQLIdentifierExpr name = new SQLIdentifierExpr();
                String fieldName = newNameField.name;
                for (AliasField aliasField : field.aliasFields) {
                    if (!aliasField.isOutput) continue;
                    fieldName = aliasField.alias;
                    break;
                }
                newNameField.name = fieldName;
                newNameField.alias = fieldName;
                name.setName(fieldName);
                x.getColumns().add(name);
                name.setParent(x);
                newNameField.ref = name;
                newNameField.exprs.add(name);
            }
            newNameField.table = table;
            newNameField.scope = current;
            newNameField.tables.add(table);
            newNameField.children.add(field);
            current.addField(newNameField);
            ++k;
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        if (this.debug) {
            System.out.println("enter SQLSqlSelectQueryBlock  " + x.toString());
        }
        this.enterClauseScope(x);
        this.scope.fromField = this.scope.isFromField(x);
        if (x.getFrom() != null) {
            this.parseView(x.getFrom(), x);
            this.replaceUsing(x.getFrom());
        }
        this.visitChild(x.getFrom());
        this.parsePivotTableSource(x.getFrom());
        this.parseSelectList(x);
        this.visitChild(x.getWindows());
        this.visitChild(x.getWhere());
        this.visitChild(x.getStartWith());
        this.visitChild(x.getConnectBy());
        this.visitChild(x.getGroupBy());
        this.visitChild(x.getOrderBy());
        this.visitChild(x.getDistributeBy());
        this.visitChild(x.getSortBy());
        this.visitChild(x.getWaitTime());
        return false;
    }

    private void parsePivotTableSource(SQLTableSource tableSource) {
        if (tableSource != null) {
            boolean isPivot;
            Object pivotOptions = tableSource.getAttribute("pivot");
            boolean bl = isPivot = pivotOptions == null ? false : (Boolean)pivotOptions;
            if (isPivot) {
                SparkSelectPivotBase pivot = null;
                if (tableSource instanceof SparkSelectPivotBase) {
                    pivot = ((SparkSelectTableReference)tableSource).getPivot();
                } else if (tableSource instanceof SparkSelectJoinTableSource) {
                    pivot = ((SparkSelectJoinTableSource)tableSource).getPivot();
                } else if (tableSource instanceof SparkSQLSubqueryTableSource) {
                    pivot = ((SparkSQLSubqueryTableSource)tableSource).getPivot();
                }
                if (pivot != null && pivot instanceof SparkSelectPivot) {
                    tableSource.putAttribute("pivot_reverse", false);
                    this.parsePivot((SparkSelectPivot)pivot);
                }
            }
        }
    }

    private void parsePivot(SparkSelectPivot pivot) {
        Scope current = this.scope.getCurrent();
        List<SparkSelectPivot.Item> items = pivot.getItems();
        ArrayList<FieldMemo> aggColumns = new ArrayList<FieldMemo>();
        for (SparkSelectPivot.Item column : items) {
            Object name = column.getAlias();
            if (name == null) {
                name = column.getExpr().toString();
            }
            for (SQLExpr expr : this.scope.getSubFieldExprs(column.getExpr())) {
                FieldMemo memo = this.getOrCreateFieldByName(expr.toString());
                memo.ref = expr;
                memo.exprs.add(column);
                aggColumns.add(memo);
            }
        }
        current.putAttribute("pivot-agg-fields", aggColumns);
        List<SQLExpr> forColumns = pivot.getPivotFor();
        ArrayList<FieldMemo> forFields = new ArrayList<FieldMemo>();
        for (SQLExpr forColumn : forColumns) {
            SQLName sqlName = (SQLName)forColumn;
            String name = sqlName.getSimpleName();
            FieldMemo field = this.getOrCreateFieldByName(name);
            field.ref = forColumn;
            field.exprs.add(forColumn);
            forFields.add(field);
        }
        current.putAttribute("pivot-for-fields", forFields);
        List<SparkSelectPivot.Item> columns = pivot.getPivotIn();
        ArrayList<FieldMemo> newFields = new ArrayList<FieldMemo>();
        for (SparkSelectPivot.Item column : columns) {
            String name = column.getAlias();
            if (name == null) {
                name = column.getExpr().toString();
            }
            FieldMemo memo = this.getOrCreateFieldByName(name);
            if (memo.name == null) {
                memo.alias = memo.name = name;
            }
            memo.ref = column;
            memo.exprs.add(column);
            newFields.add(memo);
        }
        current.putAttribute("pivot-in-fields", newFields);
    }

    private List<FieldMemo> parsePivotColumns(SQLObject x, List<FieldMemo> source) {
        Scope current = this.scope.getCurrent();
        Object pivotOptions = x.getAttribute("pivot");
        if (pivotOptions == null) {
            return source;
        }
        if (!((Boolean)pivotOptions).booleanValue()) {
            return source;
        }
        ArrayList<FieldMemo> target = new ArrayList<FieldMemo>();
        target.addAll(source);
        boolean reverse = (Boolean)x.getAttribute("pivot_reverse");
        List aggColumns = (List)current.getAttribute("pivot-agg-fields");
        List forColumns = (List)current.getAttribute("pivot-for-fields");
        List inColumns = (List)current.getAttribute("pivot-in-fields");
        if (!reverse) {
            FieldMemo z;
            Iterator iterator;
            for (FieldMemo column : aggColumns) {
                iterator = target.iterator();
                while (iterator.hasNext()) {
                    z = (FieldMemo)iterator.next();
                    if (!this.isEqual(z.name, column.name)) continue;
                    iterator.remove();
                }
            }
            for (FieldMemo column : forColumns) {
                iterator = target.iterator();
                while (iterator.hasNext()) {
                    z = (FieldMemo)iterator.next();
                    if (!this.isEqual(z.name, column.name)) continue;
                    iterator.remove();
                }
            }
            target.addAll(inColumns);
        } else {
            for (FieldMemo column : inColumns) {
                Iterator iterator = target.iterator();
                while (iterator.hasNext()) {
                    FieldMemo z = (FieldMemo)iterator.next();
                    if (!this.isEqual(z.name, column.name)) continue;
                    iterator.remove();
                }
            }
            target.addAll(aggColumns);
        }
        return target;
    }

    private FieldMemo getOrCreateFieldByName(String name) {
        FieldMemo memo;
        Scope current = this.scope.getCurrent();
        FieldMemo exists = current.getFieldByName(name);
        if (exists == null) {
            memo = new FieldMemo();
            memo.name = current.dialector.wrap(name);
            memo.tables.addAll(current.getTableMap().values());
        } else {
            memo = exists.copy();
            memo.tables.addAll(exists.tables);
            memo.children.add(exists);
        }
        memo.alias = memo.name;
        if (memo.tables.size() == 1) {
            memo.table = memo.tables.get(0);
        }
        memo.scope = current;
        return memo;
    }

    private void parseSelectList(SQLSelectQueryBlock x) {
        Scope current = this.scope.getCurrent();
        List<SQLSelectItem> selectList = x.getSelectList();
        for (int i = 0; i < selectList.size(); ++i) {
            SQLSelectItem item = selectList.get(i);
            boolean isAll = this.scope.isAllColumn(item.getExpr());
            if (item.getAlias() == null && !isAll) {
                this.setAlias(item);
            }
            if (!isAll || item.getAttribute("expanded") != null) continue;
            item.putAttribute("expanded", true);
            SQLObject parent = item.getParent();
            Owner owner = this.scope.getAllOwner(item.getExpr());
            TableMemo table = owner.alias == null ? null : current.getTable(item.getExpr());
            SQLTableSource tableSource = x.getFrom();
            boolean isSub = table != null && table.isSub || tableSource instanceof SQLSubqueryTableSource || tableSource instanceof SQLUnionQueryTableSource;
            List<FieldMemo> fields = current.expandAllColumns(table, isSub);
            if (fields.size() == 0) continue;
            int k = 0;
            selectList.remove(i);
            String alias = x.getFrom().getAlias();
            if (alias == null) {
                alias = owner.alias;
            }
            for (FieldMemo field : fields) {
                TableMemo fieldTable = field.table;
                SQLPropertyExpr propExpr = new SQLPropertyExpr();
                propExpr.setOwner(alias == null ? fieldTable.alias : alias);
                propExpr.setName(field.alias);
                SQLSelectItem newItem = new SQLSelectItem();
                newItem.setParent(parent);
                newItem.setExpr(propExpr);
                newItem.setAlias(field.alias);
                field.scope = current;
                field.isSelectItem = true;
                field.ref = newItem;
                field.exprs.add(propExpr);
                selectList.add(i + k++, newItem);
            }
        }
        int k = Integer.MIN_VALUE;
        for (SQLSelectItem item : selectList) {
            SQLExpr sqlExpr = item.getExpr();
            boolean isPrimitive = this.scope.isPrimitive(sqlExpr);
            item.putAttribute("isPrimitive", isPrimitive);
            if (this.scope.isAllColumn(sqlExpr)) continue;
            this.visitChild(item);
            FieldMemo field = (FieldMemo)sqlExpr.getAttribute("field");
            if (sqlExpr instanceof SQLValuableExpr) {
                field.isConstant = true;
            }
            field.id = k++;
        }
    }

    private SQLTableSource parseView(SQLTableSource ts, SQLObject parent) {
        if (ts instanceof SQLExprTableSource) {
            SQLTableSource viewTableSource = this.getViewTableSource(ts);
            if (viewTableSource != null) {
                if (parent instanceof SQLSelectQueryBlock) {
                    SQLSelectQueryBlock block = (SQLSelectQueryBlock)parent;
                    block.setFrom(viewTableSource);
                    viewTableSource.setParent(parent);
                }
                return viewTableSource;
            }
        } else if (ts instanceof SQLJoinTableSource) {
            SQLTableSource right;
            SQLJoinTableSource jts = (SQLJoinTableSource)ts;
            SQLTableSource left = this.parseView(jts.getLeft(), jts);
            if (left != null) {
                jts.setLeft(left);
                left.setParent(jts);
            }
            if ((right = this.parseView(jts.getRight(), jts)) != null) {
                jts.setRight(right);
                right.setParent(jts);
            }
        }
        return null;
    }

    private void replaceUsing(SQLTableSource ts) {
        if (ts instanceof SQLJoinTableSource) {
            this.parseUsing((SQLJoinTableSource)ts);
        }
    }

    private void parseUsing(SQLJoinTableSource jts) {
        String leftAlias;
        SQLTableSource rightTable;
        String rightAlias;
        SQLTableSource leftTable = jts.getLeft();
        if (leftTable instanceof SQLJoinTableSource) {
            this.parseUsing((SQLJoinTableSource)leftTable);
        }
        if ((rightAlias = (rightTable = jts.getRight()).getAlias()) == null) {
            rightAlias = rightTable.toString();
        }
        if ((leftAlias = (String)leftTable.getAttribute("join-alias")) == null) {
            leftAlias = leftTable.getAlias();
        }
        if (leftAlias == null) {
            leftAlias = leftTable.toString();
        }
        jts.putAttribute("join-alias", rightAlias);
        if (jts.getUsing() != null && jts.getUsing().size() != 0) {
            SQLExpr conditon;
            SQLBinaryOpExpr link = jts.getUsing().size() > 1 ? new SQLBinaryOpExpr() : null;
            for (int i = 0; i < jts.getUsing().size(); ++i) {
                SQLExpr sqlExpr = jts.getUsing().get(i);
                sqlExpr.setParent(null);
                SQLBinaryOpExpr eqExpr = new SQLBinaryOpExpr();
                eqExpr.setOperator(SQLBinaryOperator.Equality);
                SQLPropertyExpr left = new SQLPropertyExpr();
                left.setOwner(leftAlias);
                left.setName(sqlExpr.toString());
                eqExpr.setLeft(left);
                SQLPropertyExpr right = new SQLPropertyExpr();
                right.setOwner(rightAlias);
                right.setName(sqlExpr.toString());
                eqExpr.setRight(right);
                if (link == null) {
                    link = eqExpr;
                    break;
                }
                if (i == 0) {
                    link.setLeft(eqExpr);
                    link.setOperator(SQLBinaryOperator.BooleanAnd);
                    continue;
                }
                link.setRight(eqExpr);
                if (i >= jts.getUsing().size() - 1) continue;
                SQLBinaryOpExpr chain = new SQLBinaryOpExpr();
                chain.setOperator(SQLBinaryOperator.BooleanAnd);
                chain.setLeft(link);
                link = chain;
            }
            if ((conditon = jts.getCondition()) == null) {
                jts.setCondition(link);
            } else {
                SQLBinaryOpExpr operator = new SQLBinaryOpExpr();
                operator.setOperator(SQLBinaryOperator.BooleanAnd);
                operator.setLeft(link);
                operator.setRight(conditon);
            }
            jts.getUsing().clear();
        }
    }

    private SQLTableSource getViewTableSource(SQLTableSource ts) {
        SQLSelect view;
        String schema;
        SQLExprTableSource e = (SQLExprTableSource)ts;
        String name = e.getTableName();
        String string = schema = e.getSchema() == null ? this.scope.getDefaultSchema() : e.getSchema();
        if (name != null && (view = this.scope.context.getView(schema.toLowerCase(), name.toLowerCase())) != null && this.scope.context.sqlType == TableStat.Mode.Select) {
            SQLSubqueryTableSource subQuery = new SQLSubqueryTableSource();
            String alias = e.getAlias() == null ? e.getTableName() : e.getAlias();
            subQuery.setAlias(alias);
            subQuery.setSelect(view.clone());
            return subQuery;
        }
        return null;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        ClauseScope scope = this.enterClauseScope(x);
        scope.union = true;
        scope.isolated = false;
        this.visitChild(x.getRelations());
        for (Scope s1 : scope.getChildren()) {
            s1.isolated = false;
        }
        this.visitChild(x.getOrderBy());
        this.visitChild(x.getLimit());
        return false;
    }

    @Override
    public boolean visit(SQLLateralViewTableSource x) {
        TableMemo table = this.registerTable(x);
        TableScope scope = this.enterTableScope(x);
        scope.table = table;
        scope.isolated = false;
        return true;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("enter SQLSubqueryTableSource  " + x.toString());
        }
        if (x.getAlias() == null) {
            x.setAlias(this.alias.aliasTable());
        }
        TableMemo table = this.registerTable(x);
        TableScope scope = this.enterTableScope(x);
        scope.table = table;
        scope.isolated = false;
        return true;
    }

    @Override
    public boolean visit(SparkSQLSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("enter SparkSQLSubqueryTableSource  " + x.toString());
        }
        if (x.getAlias() == null) {
            x.setAlias(this.alias.aliasTable());
        }
        x.putAttribute("pivot", x.getPivot() != null);
        TableMemo table = this.registerTable(x);
        TableScope scope = this.enterTableScope(x);
        scope.table = table;
        scope.isolated = false;
        if (x.getSelect() != null) {
            x.getSelect().accept(this);
        }
        for (Scope s : scope.getChildren()) {
            s.isolated = false;
        }
        return false;
    }

    @Override
    public boolean visit(SparkSelectTableReference x) {
        if (!(x.getExpr() instanceof SQLIdentifierExpr) && !(x.getExpr() instanceof SQLDbLinkExpr)) {
            x.putAttribute("pivot", x.getPivot() != null);
            if (this.debug) {
                System.out.println("enter SQLSubqueryTableSource  " + x.toString());
            }
            if (x.getAlias() == null && !(x.getParent() instanceof SparkInsertStatement)) {
                x.setAlias(this.alias.aliasTable());
            }
            x.putAttribute("pivot", x.getPivot() != null);
            TableMemo table = this.registerTable(x);
            TableScope scope = this.enterTableScope(x);
            scope.table = table;
            scope.isolated = false;
            return true;
        }
        this.registerTable(x);
        return true;
    }

    @Override
    public void endVisit(SparkSelectTableReference x) {
        if (!(x.getExpr() instanceof SQLIdentifierExpr) && !(x.getExpr() instanceof SQLDbLinkExpr)) {
            if (this.debug) {
                System.out.println("exit SparkSelectTableReference  " + x);
            }
            this.scope.exitScope();
        } else if (this.debug) {
            System.out.println("end SparkSelectTableReference" + x.toString());
        }
    }

    @Override
    public boolean visit(SQLValuesTableSource x) {
        if (this.debug) {
            System.out.println("begin SQLValuesTableSource  " + x.toString());
        }
        return true;
    }

    @Override
    public boolean visit(SparkWithExpr x) {
        this.visitChild(x.getStatement());
        return false;
    }

    @Override
    public void endVisit(SparkWithExpr x) {
    }

    @Override
    public boolean visit(SparkValuesExpr x) {
        return false;
    }

    @Override
    public void endVisit(SparkValuesExpr x) {
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        this.scope.getCurrent().join = true;
        return true;
    }

    @Override
    public boolean visit(SparkSelectJoinTableSource x) {
        this.scope.getCurrent().join = true;
        return true;
    }

    @Override
    public boolean visit(SQLUnionQueryTableSource x) {
        TableMemo table = this.registerTable(x);
        TableScope scope = this.enterTableScope(x);
        scope.union = true;
        scope.fromField = scope.isFromField(x);
        scope.isolated = false;
        x.putAttribute("table", table);
        x.putAttribute("scope", scope);
        scope.table = table;
        scope.isolated = false;
        this.visitChild(x.getUnion());
        for (Scope s1 : scope.getChildren()) {
            s1.isolated = false;
        }
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        this.registerTable(x);
        return true;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        FieldMemo field = this.createField(x.getExpr(), x.getAlias(), true);
        field.ref = x;
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if (x.getAttribute("parsed") == null) {
            SQLObject parent = x.getParent();
            if (parent != null && parent instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)parent;
                switch (binaryOpExpr.getOperator()) {
                    case Like: 
                    case Like2: 
                    case Like4: 
                    case Likec: 
                    case NotLike: 
                    case NotEqual: 
                    case LessThanOrGreater: 
                    case Equality: 
                    case GreaterThan: 
                    case GreaterThanOrEqual: 
                    case LessThan: 
                    case LessThanOrEqual: 
                    case BooleanAnd: 
                    case BooleanOr: {
                        x.putAttribute("parsed", 1);
                        this.createField(x, "", false);
                        return true;
                    }
                }
            }
            return true;
        }
        List<SQLExpr> arguments = x.getArguments();
        if (arguments == null) {
            return false;
        }
        for (SQLExpr argument : arguments) {
            argument.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        if (this.scope.getCurrent().isFieldState()) {
            FieldMemo field = this.createField(x, x.getName(), false);
            x.putAttribute("field", field);
        } else if (!(x.getParent() instanceof SQLTableSource) && !(x.getParent() instanceof SQLPartition)) {
            x.putAttribute("orderBy", x.getParent() instanceof SQLSelectOrderByItem);
            FieldMemo field = this.createField(x, x.getName(), false);
            x.putAttribute("field", field);
            if (x.getParent() instanceof SQLUpdateSetItem) {
                field.isSelectItem = true;
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        if (this.scope.getCurrent().isFieldState()) {
            FieldMemo field = this.createField(x, x.getName(), false);
            x.putAttribute("field", field);
        } else if (!(x.getParent() instanceof SQLTableSource) && !(x.getParent() instanceof SQLPartition)) {
            x.putAttribute("orderBy", x.getParent() instanceof SQLSelectOrderByItem);
            FieldMemo field = this.createField(x, x.getName(), false);
            x.putAttribute("field", field);
            if (x.getParent() instanceof SQLUpdateSetItem) {
                field.isSelectItem = true;
            }
        }
        return false;
    }

    private FieldMemo createField(SQLExpr expr, String alias, boolean isSelectItem) {
        Scope current = this.scope.getCurrent();
        FieldMemo field = new FieldMemo();
        if (expr instanceof SQLIdentifierExpr) {
            String name;
            FieldMemo exist;
            boolean isOrderBy;
            SQLIdentifierExpr idExpr = (SQLIdentifierExpr)expr;
            boolean bl = isOrderBy = expr.getAttribute("orderBy") != null && (Boolean)expr.getAttribute("orderBy") != false;
            if (isOrderBy && (exist = current.getFieldByAlias(name = current.dialector.wrap(idExpr.getSimpleName()))) != null) {
                return exist;
            }
            field.name = idExpr.getName();
            field.atom = true;
            this.setField(field, alias, isSelectItem, expr);
            field.children = this.scope.getCurrent().getSubRelationFields(field);
            this.setConstant(field);
            this.setAtom(field);
            field = current.addField(field);
        } else if (expr instanceof SQLPropertyExpr) {
            SQLPropertyExpr prop = (SQLPropertyExpr)expr;
            field.name = prop.getName();
            field.atom = true;
            this.setField(field, alias, isSelectItem, expr);
            field.children = this.scope.getCurrent().getSubRelationFields(field);
            this.setConstant(field);
            this.setAtom(field);
            field = current.addField(field);
        } else if (expr instanceof SQLValuableExpr) {
            field.name = alias;
            field.isConstant = true;
            this.setField(field, alias, isSelectItem, expr);
            field = current.addField(field);
        } else {
            AliasField aliasField;
            field.name = alias = current.dialector.wrapAlias(alias);
            field.alias = alias;
            field.isSelectItem = isSelectItem;
            field.complex = true;
            field.ref = expr;
            if (expr instanceof SQLSelectItem) {
                field.exprs.add(((SQLSelectItem)((Object)expr)).getExpr());
                aliasField = new AliasField();
                aliasField.alias = alias;
                aliasField.field = field;
                aliasField.expr = expr;
                aliasField.isOutput = true;
                aliasField.scope = this.scope.getCurrent();
            } else {
                field.exprs.add(expr);
                aliasField = new AliasField();
                aliasField.alias = alias;
                aliasField.field = field;
                aliasField.expr = expr;
                aliasField.isOutput = true;
                aliasField.scope = this.scope.getCurrent();
            }
            current.openFieldState();
            this.visitChild(expr);
            current.closeFieldState();
            List<SQLExpr> exprs = current.getSubFieldExprs(expr);
            ArrayList<FieldMemo> subFields = new ArrayList<FieldMemo>();
            current.getFieldsByExprs(exprs, subFields);
            ArrayList<TableMemo> tables = new ArrayList<TableMemo>();
            ArrayList<FieldMemo> children = new ArrayList<FieldMemo>();
            HashSet<String> names = new HashSet<String>();
            boolean isPrimitive = this.scope.isPrimitive(expr);
            if (!isPrimitive) {
                current.getSubBranchFields(subFields);
            }
            if (subFields.size() <= 0) {
                tables.addAll(current.getBranchTables());
            } else {
                for (FieldMemo subField : subFields) {
                    if (!names.contains(subField.getUniqueName())) {
                        children.add(subField);
                        names.add(subField.getUniqueName());
                    }
                    if (subField.table != null && !names.contains(subField.table.getQualifiedName())) {
                        tables.add(subField.table);
                        names.add(subField.table.getQualifiedName());
                        continue;
                    }
                    if (subField.tables.size() <= 0) continue;
                    for (TableMemo table : subField.tables) {
                        if (names.contains(table.getQualifiedName())) continue;
                        tables.add(table);
                        names.add(table.getQualifiedName());
                    }
                }
            }
            field.tables = tables;
            if (tables.size() == 1) {
                field.table = (TableMemo)tables.get(0);
            }
            field.children = children;
            this.setAtom(field);
            field = current.addField(field);
        }
        expr.putAttribute("field", field);
        return field;
    }

    private void setConstant(FieldMemo field) {
        if (field.children != null && field.children.size() > 0) {
            boolean flag = true;
            for (FieldMemo child : field.children) {
                if (child.isConstant) continue;
                flag = false;
                break;
            }
            field.isConstant = flag;
        }
    }

    private void setAtom(FieldMemo field) {
        if (field.children.size() != 0) {
            Set<String> fdNames = field.tableNames();
            boolean found = false;
            for (FieldMemo child : field.children) {
                if (!this.isEqual(field.name, child.alias)) continue;
                Set<String> cdNames = child.tableNames();
                cdNames.retainAll(fdNames);
                if (cdNames.size() <= 0) continue;
                found = true;
            }
            if (!found) {
                field.atom = false;
            }
        }
    }

    private void setField(FieldMemo field, String alias, boolean isSelectItem, SQLExpr expr) {
        Scope current = this.scope.getCurrent();
        field.alias = alias == null ? field.name : alias;
        field.alias = current.dialector.wrap(field.alias);
        field.name = current.dialector.wrap(field.name);
        field.isSelectItem = isSelectItem;
        field.ref = expr;
        field.table = this.scope.getCurrent().getTable(expr);
        field.tables.add(field.table);
        field.exprs.add(expr);
        AliasField aliasField = new AliasField();
        aliasField.alias = alias;
        aliasField.field = field;
        aliasField.expr = expr;
        aliasField.isOutput = isSelectItem;
        aliasField.scope = this.scope.getCurrent();
    }

    private TableMemo registerTable(SQLTableSource x) {
        Scope current = this.scope.getCurrent();
        if (x instanceof SQLExprTableSource) {
            SQLMethodInvokeExpr method;
            SparkSelectTableReference ref;
            SQLExprTableSource exprTableSource = (SQLExprTableSource)x;
            TableMemo table = new TableMemo(x);
            SQLExprTableSource tableSource = (SQLExprTableSource)x;
            String tableName = current.dialector.wrap(tableSource.getTableName());
            String schemaName = current.dialector.wrap(tableSource.getSchema() == null ? this.scope.getDefaultSchema() : tableSource.getSchema());
            table.name = tableName;
            table.nowName = table.alias = current.dialector.wrap(tableSource.getAlias() == null ? table.name : tableSource.getAlias());
            if (table.name == null) {
                table.name = table.alias;
            }
            if (table.name.equals("*") && exprTableSource.getExpr() != null && exprTableSource.getExpr() instanceof SQLPropertyExpr) {
                return null;
            }
            if (table.name == null && table.alias != null) {
                table.name = table.alias;
            }
            if (exprTableSource.getExpr() != null && exprTableSource.getExpr() instanceof SQLMethodInvokeExpr) {
                table.isSub = true;
            }
            table.schema = schemaName;
            if (x instanceof SparkSelectTableReference && (ref = (SparkSelectTableReference)x).getExpr() != null && ref.getExpr() instanceof SQLMethodInvokeExpr && (method = (SQLMethodInvokeExpr)ref.getExpr()).getArguments().size() == 1 && method.getArguments().get(0) instanceof SQLQueryExpr) {
                if (table.name == null) {
                    String aliasTableName = current.dialector.wrap(this.alias.aliasTable());
                    ref.setAlias(aliasTableName);
                    table.name = aliasTableName;
                    if (table.alias == null) {
                        table.alias = table.name;
                    }
                    table.isSub = true;
                }
                this.setTableRelation(table);
                x.putAttribute("table", table);
                return table;
            }
            TableMemo refTable = current.getParentTable(schemaName, tableName);
            if (refTable != null && refTable.topTable) {
                table.schema = refTable.schema;
                table.topTable = true;
                table.scope = current;
                table.refTable = refTable;
                refTable.getChildren().add(table);
                current.addTable(table);
                table.topTable = refTable.topTable;
                return refTable;
            }
            boolean isFunction = false;
            SQLExpr expr = ((SQLExprTableSource)x).getExpr();
            isFunction = expr instanceof SQLMethodInvokeExpr;
            this.setTableRelation(table);
            table.system = this.scope.dialector.isSystemTable(table.name);
            if (!(table.isSub || isFunction || table.system)) {
                this.scope.context.append(table);
            }
            x.putAttribute("table", table);
            return table;
        }
        if (x instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource tableSource = (SQLSubqueryTableSource)x;
            TableMemo table = new TableMemo(x);
            table.alias = table.name = current.dialector.wrap(tableSource.getAlias());
            table.nowName = table.name;
            table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
            table.isSub = true;
            this.setTableRelation(table);
            x.putAttribute("table", table);
            return table;
        }
        if (x instanceof SQLLateralViewTableSource) {
            SQLLateralViewTableSource tableSource = (SQLLateralViewTableSource)x;
            TableMemo table = new TableMemo(x);
            table.alias = table.name = current.dialector.wrap(tableSource.getAlias());
            table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
            table.isSub = true;
            this.setTableRelation(table);
            x.putAttribute("table", table);
            return table;
        }
        if (x instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource tableSource = (SQLUnionQueryTableSource)x;
            TableMemo table = new TableMemo(x);
            table.alias = table.name = current.dialector.wrap(tableSource.getAlias());
            table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
            table.nowName = table.name;
            table.isSub = true;
            this.setTableRelation(table);
            x.putAttribute("table", table);
            return table;
        }
        return null;
    }

    private TableMemo registerTable(SQLWithSubqueryClause.Entry x) {
        Scope current = this.scope.getCurrent();
        TableMemo table = new TableMemo(x);
        table.nowName = table.name = current.dialector.wrap(x.getAlias());
        table.alias = table.name;
        table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
        table.isSub = true;
        table.topTable = true;
        this.setTableRelation(table);
        return table;
    }

    private void setTableRelation(TableMemo table) {
        TableMemo parentTable;
        Scope current = this.scope.getCurrent();
        table.name = current.dialector.wrap(table.name);
        table.alias = current.dialector.wrap(table.alias);
        table.schema = current.dialector.wrap(table.schema);
        table.scope = current;
        current.addTable(table);
        TableScope tableScope = current.getNearestParentTableScope();
        if (tableScope != null && (parentTable = tableScope.table) != null) {
            parentTable.getChildren().add(table);
            if (table.isSub) {
                parentTable.isSub = true;
            }
        }
    }

    private TableScope enterTableScope(SQLTableSource x) {
        TableScope ts = new TableScope();
        ts.ref = x;
        ts.alias = ts.name = x.getAlias();
        this.scope.enterScope(ts);
        return ts;
    }

    private ClauseScope enterClauseScope(SQLObject x) {
        ClauseScope clauseScope = new ClauseScope();
        clauseScope.ref = x;
        this.scope.enterScope(clauseScope);
        return clauseScope;
    }

    @Override
    public void endVisit(SQLMethodInvokeExpr x) {
        if ("LATERAL".equalsIgnoreCase(x.getMethodName())) {
            this.scope.getCurrent().isolated = false;
            for (Scope s : this.scope.getCurrent().getChildren()) {
                s.isolated = false;
            }
        }
    }

    @Override
    public boolean visit(SparkRepairTableStatement x) {
        SQLExprTableSource tableSource = new SQLExprTableSource(x.getName());
        this.registerTable(tableSource);
        return false;
    }

    @Override
    public boolean visit(SparkCreateViewStatement x) {
        if (x.getSubQuery() != null) {
            x.getSubQuery().accept(this);
        }
        return false;
    }

    private void setAlias(SQLSelectItem x) {
        if (x.getAlias() == null) {
            SQLExpr e = x.getExpr();
            if (e instanceof SQLIdentifierExpr) {
                x.setAlias(((SQLIdentifierExpr)e).getName());
            } else if (e instanceof SQLPropertyExpr) {
                x.setAlias(((SQLPropertyExpr)e).getName());
            } else if (e instanceof SQLNumericLiteralExpr) {
                x.setAlias("`" + e + "`");
            } else {
                x.setAlias(this.scope.dialector.wrap(e.toString()));
            }
        }
    }
}

