package com.chenyang.nse.bussiness.aop;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserprojectDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDictionaryDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleLogDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataAreaDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreSecretkeyDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseAppUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseGroup;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserproject;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionarytype;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProjectReqVO;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreTaskFindrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreDesensitizationRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.MailInformation;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.SnmpTrapInfomation;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.SyslogInfomation;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.app.AppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.app.AuditAppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.masking.app.MaksingAppDataRule;
import com.chenyang.nse.bussiness.entity.vo.AppUserVO;
import com.chenyang.nse.bussiness.entity.vo.ControlledAssertVO;
import com.chenyang.nse.bussiness.entity.vo.DataSystemConfig;
import com.chenyang.nse.bussiness.entity.vo.UserVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataBackUpVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataProjectVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreSearchregexVO;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import com.chenyang.nse.bussiness.service.console.RoleService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.console.UserGroupService;
import com.chenyang.nse.bussiness.service.console.UserService;
import com.chenyang.nse.bussiness.service.core.ControlledAssetService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import com.chenyang.nse.bussiness.service.core.strategy.MaksingAppDataRuleService;
import com.chenyang.nse.bussiness.tools.encryption.SM3Utils;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.token.TokenUtil;
import com.jcabi.aspects.Async;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class OperLogAspect {
   @Autowired
   private TConsoleLogDao tConsoleLogDao;
   @Autowired
   ObjectMapper objectMapper;
   @Autowired
   private UserService userService;
   @Autowired
   private RoleService roleService;
   @Autowired
   private UserGroupService userGroupService;
   @Autowired
   private TConsoleDictionaryDao tConsoleDictionaryDao;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private DiscoverytaskService discoverytaskService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private DictionaryService dictionaryService;
   @Autowired
   private ControlledAssetService controlledAssetService;
   @Autowired
   private MaksingAppDataRuleService maksingAppDataRuleService;
   @Autowired
   private TCoreDataProjectDao tCoreDataProjectDao;
   @Autowired
   private TBaseUserDao tBaseUserDao;
   @Autowired
   private TBaseUserprojectDao tBaseUserprojectDao;
   @Autowired
   private TCoreDataAreaDao tCoreDataAreaDao;
   @Autowired
   private TCoreSecretkeyDao tCoreSecretkeyDao;
   @Autowired
   private TCoreEncryptionDao tCoreEncryptionDao;

   @Pointcut("execution(public * com.chenyang.nse.bussiness.controller..*.*(..))")
   public void operLogPoinCut() {
   }

   @Before("operLogPoinCut()")
   public void logBeforeController(JoinPoint joinPoint) throws Exception {
      this.handleLog(joinPoint);
   }

   @AfterReturning(
      pointcut = "operLogPoinCut()",
      returning = "rvt"
   )
   public void doAfter(JoinPoint joinPoint, Object rvt) throws Exception {
      this.handleLog1(joinPoint, rvt);
   }

   @Async
   private void handleLog1(JoinPoint joinPoint, Object rvt) throws Exception {
      ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
      String username = null;
      if (!ObjectUtils.isEmpty(attributes)) {
         HttpServletRequest request = attributes.getRequest();
         if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getHeader("token"))) {
            username = TokenUtil.getUserId(request.getHeader("token"));
         }
      }

      TConsoleLog operlog = new TConsoleLog();
      operlog.setId(UUID.randomUUID().toString().replace("-", ""));
      MethodSignature signature = (MethodSignature)joinPoint.getSignature();
      Method method = signature.getMethod();
      Object[] args = joinPoint.getArgs();
      String className1 = joinPoint.getTarget().getClass().getName();
      String className = className1.substring(className1.lastIndexOf(".") + 1);
      String methodName = method.getName();
      String module = null;
      String operCode = null;
      if ("DictionartFileController".equals(className)) {
         if ("importfile".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "规则管理-知识库";
            operCode = "DDM_00819";
            operlog.setUser(username);
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username}));
         }

         if ("export".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "规则管理-知识库";
            operCode = "DDM_00820";
            operlog.setUser(username);
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username}));
         }
      }

      if ("IndexController".equals(className) && "doLogin".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
         module = "用户管理-用户";
         operCode = "DDM_00001";
         TBaseUser user = (TBaseUser)args[0];
         username = user.getUsername();
         operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username}));
      }

      if ("TdataProjectController".equals(className)) {
      }

      if (!ObjectUtils.isEmpty(module)) {
         operlog.setModule(module);
         operlog.setOperationObject(operCode);
         operlog.setOperationtime(new Date());
         operlog.setUser(username);
         operlog.setCreatetime(new Date());
         Date date = operlog.getOperationtime();
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         String dateString = sdf.format(date);
         String column_enc = "";

         try {
            column_enc = SM3Utils.encrypt(operlog.getOperationUser() + dateString + operlog.getLogmessage());
         } catch (Exception exception) {
            exception.printStackTrace();
         }

         operlog.setColumn_enc(column_enc);
         this.tConsoleLogDao.save(operlog);
      }

   }

   @Async
   private void handleLog(final JoinPoint joinPoint) throws Exception {
      ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
      String username = null;
      if (!ObjectUtils.isEmpty(attributes)) {
         HttpServletRequest request = attributes.getRequest();
         if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getHeader("token"))) {
            username = TokenUtil.getUserId(request.getHeader("token"));
         }
      }

      TConsoleLog operlog = new TConsoleLog();
      operlog.setId(UUID.randomUUID().toString().replace("-", ""));
      MethodSignature signature = (MethodSignature)joinPoint.getSignature();
      Method method = signature.getMethod();
      Object[] args = joinPoint.getArgs();
      String className1 = joinPoint.getTarget().getClass().getName();
      String className = className1.substring(className1.lastIndexOf(".") + 1);
      String methodName = method.getName();
      String module = null;
      String operCode = null;
      if ("DesensitizationRuleController".equals(className) && "save".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
         module = "规则管理-脱敏算法";
         TCoreDesensitizationRule rule = (TCoreDesensitizationRule)args[0];
         String ruleId = rule.getId();
         String ruleaName = rule.getRulename();
         String areaName = ((TCoreDataArea)this.tCoreDataAreaDao.get(rule.getDataarea_id())).getDataarea();
         if (!"".equals(ruleId) && ruleId != null) {
            operCode = "DDM_02103";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, areaName, ruleaName}));
         } else {
            operCode = "DDM_02104";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, areaName, ruleaName}));
         }
      }

      if ("EncryptionConfigController".equals(className) && "exportToExcel".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
         module = "项目管理";
         operCode = "DDM_02505";
         operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username}));
      }

      if ("TCoreEncryptionController".equals(className)) {
         if ("saveEncryption".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "规则管理-加密规则";
            TCoreEncryption encryption = (TCoreEncryption)args[0];
            String encryptionName = encryption.getEncryption_name();
            if (encryption.getId() != null && !"".equals(encryption.getId())) {
               operCode = "DDM_02308";
            } else {
               operCode = "DDM_02307";
            }

            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, encryptionName}));
         }

         if ("deleteEncryption".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            Map<String, String> map = (Map)args[0];
            String encryptionId = (String)map.get("encryptionId");
            String encryptionName = ((TCoreEncryption)this.tCoreEncryptionDao.get(encryptionId)).getEncryption_name();
            operCode = "DDM_02309";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, encryptionName}));
         }

         if ("saveSecretKey".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "规则管理-加密规则";
            TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)args[0];
            if (tCoreSecretkey.getId() != null && !"".equals(tCoreSecretkey.getId())) {
               String secretKeyName = tCoreSecretkey.getSecret_key_name();
               String encryption_name = ((TCoreEncryption)this.tCoreEncryptionDao.get(tCoreSecretkey.getEncryption_id())).getEncryption_name();
               operCode = "DDM_02311";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, encryption_name, secretKeyName}));
            } else {
               String secretKeyName = tCoreSecretkey.getSecret_key_name();
               String encryption_name = ((TCoreEncryption)this.tCoreEncryptionDao.get(tCoreSecretkey.getEncryption_id())).getEncryption_name();
               operCode = "DDM_02310";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, encryption_name, secretKeyName}));
            }
         }

         if ("delSecretKey".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "规则管理-加密规则";
            Map<String, String> map = (Map)args[0];
            String keyId = (String)map.get("keyId");
            TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)this.tCoreSecretkeyDao.get(keyId);
            String secretKeyName = tCoreSecretkey.getSecret_key_name();
            String encryption_name = ((TCoreEncryption)this.tCoreEncryptionDao.get(tCoreSecretkey.getEncryption_id())).getEncryption_name();
            operCode = "DDM_02312";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, encryption_name, secretKeyName}));
         }

         if ("excelFileUpLoad".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "项目管理";
            operCode = "DDM_02504";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username}));
         }
      }

      if ("TdataProjectController".equals(className)) {
         if ("addDataProject".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "项目管理";
            operCode = "DDM_02501";
            TCoreDataProjectVO tCoreDataProjectVO = (TCoreDataProjectVO)args[0];
            TCoreDataProject projectObj = tCoreDataProjectVO.getProject();
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, projectObj.getProject()}));
         }

         if ("deleteDataProject".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "项目管理";
            operCode = "DDM_02502";
            TCoreDataProjectReqVO tCoreDataProjectReqVO = (TCoreDataProjectReqVO)args[0];
            TCoreDataProject projectObj = tCoreDataProjectReqVO.getProject();
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, projectObj.getProject()}));
         }

         if ("updateDataProject".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "项目管理";
            operCode = "DDM_02503";
            TCoreDataProjectVO tCoreDataProjectVO = (TCoreDataProjectVO)args[0];
            TCoreDataProject projectObj = tCoreDataProjectVO.getProject();
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, projectObj.getProject()}));
         }
      }

      if ("DataBackUpController".equals(className)) {
         if ("dataSync".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "项目管理";
            operCode = "DDM_02202";
            TCoreDataBackUpVO tCoreDataBackUpVO = (TCoreDataBackUpVO)args[0];
            String project = ((TCoreDataProject)this.tCoreDataProjectDao.get(tCoreDataBackUpVO.getProjectId())).getProject();
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, project}));
         }

         if ("exportSql".equals(methodName)) {
            module = "项目管理";
            operCode = "DDM_02203";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username}));
         }

         if ("importSql".equals(methodName)) {
            module = "项目管理";
            operCode = "DDM_02204";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username}));
         }
      }

      if ("UserController".equals(className)) {
         if ("addUser".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "用户管理-用户";
            UserVO userVO = (UserVO)args[0];
            if (StringUtils.isBlank(userVO.getId())) {
               operCode = "DDM_00106";
            } else {
               operCode = "DDM_00105";
            }

            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, userVO.getUsername()}));
            if (StringUtils.isBlank(userVO.getId()) && !ObjectUtils.isEmpty(this.userService.queryByusername(userVO.getUsername()))) {
               operCode = "POP_00010";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("addAppUser".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "用户管理-应用用户";
            AppUserVO appuserVO = (AppUserVO)args[0];
            if (StringUtils.isBlank(appuserVO.getId())) {
               operCode = "DDM_001066";
            } else {
               operCode = "DDM_001055";
            }

            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, appuserVO.getUsername()}));
         }

         if ("removeAppUser".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "用户管理-应用用户";
            Map<String, Object> map = (Map)args[0];
            String id = String.valueOf(map.get("id"));
            operCode = "DDM_001077";
            TBaseAppUser tBaseAppUser = this.userService.queryByAppUserid(id);
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, tBaseAppUser.getUsername()}));
         }

         if ("remove".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "用户管理-用户";
            Map<String, Object> map = (Map)args[0];
            String id = String.valueOf(map.get("id"));
            operCode = "DDM_00107";
            String username1 = this.userService.queryByUserid(id).getUsername();
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, username1}));
         }

         if ("addProjectCrudUser".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "项目管理";
            TBaseUserproject tBaseUserproject = (TBaseUserproject)args[0];
            String project = ((TCoreDataProject)this.tCoreDataProjectDao.get(tBaseUserproject.getProid())).getProject();
            String username1 = ((TBaseUser)this.tBaseUserDao.get(tBaseUserproject.getUserid())).getUsername();
            if ("0".equals(tBaseUserproject.getCrud())) {
               operCode = "DDM_02506";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, project, username1}));
            } else if ("1".equals(tBaseUserproject.getCrud())) {
               operCode = "DDM_02507";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, project, username1}));
            }
         }

         if ("delProjectCrudUserById".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "项目管理";
            Map<String, String> map = (Map)args[0];
            String id = (String)map.get("tid");
            TBaseUserproject tBaseUserproject = (TBaseUserproject)this.tBaseUserprojectDao.get(id);
            String project = ((TCoreDataProject)this.tCoreDataProjectDao.get(tBaseUserproject.getProid())).getProject();
            String username1 = ((TBaseUser)this.tBaseUserDao.get(tBaseUserproject.getUserid())).getUsername();
            if ("0".equals(tBaseUserproject.getCrud())) {
               operCode = "DDM_02508";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, project, username1}));
            } else if ("1".equals(tBaseUserproject.getCrud())) {
               operCode = "DDM_02509";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, project, username1}));
            }
         }
      }

      if ("RoleController".equals(className)) {
         if ("modify".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "用户管理-角色";
            Map<String, Object> map = (Map)args[0];
            TBaseRole role = (TBaseRole)ObjectTool.getObjectByMap(TBaseRole.class, (Map)map.get("roles"));
            operCode = "DDM_00203";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, role.getRolename()}));
         }

         if ("add".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "用户管理-角色";
            Map<String, Object> map = (Map)args[0];
            TBaseRole role = (TBaseRole)ObjectTool.getObjectByMap(TBaseRole.class, (Map)map.get("roles"));
            operCode = "DDM_00204";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, role.getRolename()}));
         }

         if ("remove".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "用户管理-角色";
            Map<String, Object> map = (Map)args[0];
            String id = (String)map.get("id");
            operCode = "DDM_00205";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, this.roleService.queryRoleId(id).getRolename()}));
         }
      }

      if ("UserGroupController".equals(className)) {
         if ("modify".equals(methodName)) {
            module = "用户管理-用户组";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               TBaseGroup group = (TBaseGroup)ObjectTool.getObjectByMap(TBaseGroup.class, (Map)map.get("group"));
               operCode = "DDM_00303";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, group.getGroupname()}));
            } else {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("add".equals(methodName)) {
            module = "用户管理-用户组";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               TBaseGroup group = (TBaseGroup)ObjectTool.getObjectByMap(TBaseGroup.class, (Map)map.get("group"));
               operCode = "DDM_00304";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, group.getGroupname()}));
            } else {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("del".equals(methodName)) {
            module = "用户管理-用户组";
            String groupid = "";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               groupid = (String)map.get("groupid");
               operCode = "DDM_00305";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, this.userGroupService.queryGroupByid(groupid).getGroupname()}));
            } else if (StringUtil.isBlank(groupid)) {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg("POP_00022", new String[0]));
            }
         }
      }

      if ("TdataDiscoveryController".equals(className)) {
         if ("savetask".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "发现梳理";
            Map<String, Object> map = (Map)args[0];
            String taskid = (String)map.get("taskid");
            String taskedit = "";
            if (!StringUtil.isBlank(taskid)) {
               taskedit = "edittask";
            }

            String taskname = (String)map.get("taskname");
            String dataSystemName = (String)map.get("dataSystemName");
            if ("edittask".equals(taskedit)) {
               operCode = "DDM_00403";
            } else {
               operCode = "DDM_00404";
            }

            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dataSystemName, taskname}));
         }

         if ("deleteDiscoverytask".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "发现梳理";
            Map<String, Object> map = (Map)args[0];
            String taskid = (String)map.get("taskid");
            String dataSystemName = (String)map.get("dataSystemName");
            TcoreDiscoveryTask task = this.discoverytaskService.get(taskid);
            operCode = "DDM_00405";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dataSystemName, task.getTname()}));
         }
      }

      if ("SearchRegexController".equals(className)) {
      }

      if ("ExecuteDiscoverytaskController".equals(className)) {
         if ("stoptask".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "发现梳理";
            Map<String, Object> map = (Map)args[0];
            String datasystemname = (String)map.get("dataSystemName");
            String taskname = (String)map.get("taskname");
            operCode = "DDM_00410";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, datasystemname, taskname}));
         }

         if ("executetask".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "发现梳理";
            Map<String, Object> map = (Map)args[0];
            String taskname = (String)map.get("taskname");
            String project = (String)map.get("project");
            operCode = "DDM_02006";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, project, taskname}));
         }
      }

      if ("TdataSearchRegexController".equals(className)) {
         if ("initEdit".equals(methodName)) {
            module = "规则管理-发现规则";
            String ruleid = "402881e558f25eb60158f25edcef0006";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               ruleid = (String)map.get("ruleid");
               new TCoreSearchregexVO();
               List<TCoreSearchregexVO> tConsoleSearchregexlist = this.searchRegexService.querySearchregexById(ruleid);
               TCoreSearchregexVO var166 = (TCoreSearchregexVO)tConsoleSearchregexlist.get(0);
               operCode = "DDM_00702";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, var166.getName()}));
            } else {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("del".equals(methodName)) {
            module = "规则管理-发现规则";
            String ruleid = "";
            String rulename = "";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               ruleid = (String)map.get("ruleid");
               rulename = (String)map.get("rulename");
               operCode = "DDM_00705";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, rulename}));
               List<TcoreTaskFindrule> tsList = this.searchRegexService.queryTcoreTaskFindruleByRuleid(ruleid);
               if (null != tsList && tsList.size() > 0) {
                  operCode = "POP_00024";
                  operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
               }
            } else if (StringUtil.isBlank(ruleid)) {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("setdefault".equals(methodName)) {
            module = "规则管理-发现规则";
            String ruleid = "";
            String rulename = "";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               ruleid = (String)map.get("ruleid");
               rulename = (String)map.get("rulename");
               operCode = "DDM_00707";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, rulename}));
            } else if (StringUtil.isBlank(ruleid)) {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("initEditDataArea".equals(methodName)) {
            module = "规则管理-发现规则";
            String areaid = "909c577409d511eaa04ce0d55e0181c8";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               areaid = (String)map.get("areaid");
               TCoreDataArea tCoreDataArea = this.searchRegexService.queryDataareaById(areaid);
               operCode = "DDM_00720";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, tCoreDataArea.getDataarea()}));
            } else {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("addDataArea".equals(methodName)) {
            module = "规则管理-发现规则";
            TCoreDataArea tCoreDataArea = null;
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               tCoreDataArea = (TCoreDataArea)ObjectTool.getObjectByMap(TCoreDataArea.class, (Map)map.get("tCoreDataArea"));
               if (StringUtil.isBlank(tCoreDataArea.getId())) {
                  operCode = "DDM_00721";
               } else {
                  operCode = "DDM_00722";
               }

               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, tCoreDataArea.getDataarea()}));
            } else {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("delDataArea".equals(methodName)) {
            module = "规则管理-发现规则";
            String areaid = "";
            String areaname = "";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               areaid = (String)map.get("areaid");
               areaname = (String)map.get("areaname");
               operCode = "DDM_00723";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, areaname}));
               List<TConsoleSearchregex> tsList = this.searchRegexService.querySearchregexByDaid(areaid);
               if (null != tsList && tsList.size() > 0) {
                  operCode = "POP_00023";
                  operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
               }
            } else if (StringUtil.isBlank(areaid)) {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("add".equals(methodName)) {
            module = "规则管理-发现规则";
            TConsoleSearchregex searchRegex = null;
            List<Object> subRuleidList = null;
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               searchRegex = (TConsoleSearchregex)ObjectTool.getObjectByMap(TConsoleSearchregex.class, (Map)map.get("searchRegex"));
               List<Object> var128 = (ArrayList)map.get("subRuleidList");
               if (null != searchRegex.getId()) {
                  operCode = "DDM_00703";
               } else {
                  operCode = "DDM_00704";
               }

               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, searchRegex.getName()}));
            } else {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }
      }

      if ("MaksingAppDataRuleController".equals(className)) {
         if ("addTableInfo".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "规则管理-脱敏规则";
            operCode = "DDM_01505";
            Map<String, Object> map = (Map)args[0];
            String datasystemid = (String)map.get("datasystemid");
            String name = (String)map.get("name");
            TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(datasystemid);
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, tCoreDatasystem.getDblinkname(), name}));
         }

         if ("initEdit".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "规则管理-脱敏规则";
            operCode = "DDM_01506";
            String strategyid = (String)args[0];
            MaksingAppDataRule maksingAppDataRule = this.maksingAppDataRuleService.queryById(strategyid);
            TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(maksingAppDataRule.getDatasystemid());
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, tCoreDatasystem.getDblinkname(), maksingAppDataRule.getName()}));
         }

         if ("removeStrategy".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "规则管理-脱敏规则";
            operCode = "DDM_01507";
            Map<String, Object> map = (Map)args[0];
            String strategyid = (String)map.get("strategyid");
            MaksingAppDataRule maksingAppDataRule = this.maksingAppDataRuleService.queryById(strategyid);
            TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(maksingAppDataRule.getDatasystemid());
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, tCoreDatasystem.getDblinkname(), maksingAppDataRule.getName()}));
         }

         if ("updateStatus".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "规则模块-脱敏规则";
            operCode = "DDM_01508";
            Map<String, Object> map = (Map)args[0];
            String strategyid = (String)map.get("strategyid");
            MaksingAppDataRule maksingAppDataRule = this.maksingAppDataRuleService.queryById(strategyid);
            TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(maksingAppDataRule.getDatasystemid());
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, tCoreDatasystem.getDblinkname(), maksingAppDataRule.getName()}));
         }
      }

      if ("TDictionaryController".equals(className)) {
         if ("delDictionaryType".equals(methodName)) {
            module = "规则模块-知识库";
            String dictionaryTypeCode = "";
            String dictionaryTypeName = "";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               dictionaryTypeCode = (String)map.get("dictionaryTypeCode");
               dictionaryTypeName = (String)map.get("dictionaryTypeName");
               operCode = "DDM_00813";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dictionaryTypeName}));
            } else if (StringUtil.isBlank(dictionaryTypeCode)) {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("initEdit".equals(methodName)) {
            module = "规则模块-发现规则";
            String dicId = "183";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               dicId = (String)map.get("dicId");
               operCode = "DDM_00815";
               TConsoleDictionary tConsoleDictionary = this.dictionaryService.initEditDictionary(dicId);
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, tConsoleDictionary.getName()}));
            } else {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("add".equals(methodName)) {
            module = "规则模块-发现规则";
            TConsoleDictionary dictionary = null;
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               dictionary = (TConsoleDictionary)ObjectTool.getObjectByMap(TConsoleDictionary.class, (Map)map.get("dictionary"));
               if (StringUtil.isBlank(dictionary.getId())) {
                  operCode = "DDM_00816";
                  operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dictionary.getValue()}));
               } else {
                  operCode = "DDM_00817";
                  operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dictionary.getValue()}));
               }
            } else {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("del".equals(methodName)) {
            module = "规则模块-发现规则";
            String dicId = "";
            String dicName = "";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               dicName = (String)map.get("dicName");
               dicId = (String)map.get("dicId");
               if (StringUtils.isBlank(dicName)) {
                  TConsoleDictionary tConsoleDictionary = (TConsoleDictionary)this.tConsoleDictionaryDao.get(dicId);
                  dicName = tConsoleDictionary.getValue();
               }

               operCode = "DDM_00818";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dicName}));
            } else if (StringUtil.isBlank(dicId)) {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }
         }

         if ("addDictionaryType".equals(methodName)) {
            module = "规则管理-知识库";
            TConsoleDictionarytype dictionaryType = null;
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               dictionaryType = (TConsoleDictionarytype)ObjectTool.getObjectByMap(TConsoleDictionarytype.class, (Map)map.get("dictionaryType"));
            } else {
               operCode = "POP_00022";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            }

            long typeCount = this.dictionaryService.queryDictionaryTypeCount(dictionaryType.getTypename());
            if (StringUtil.isBlank(dictionaryType.getId())) {
               operCode = "DDM_00811";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dictionaryType.getTypename()}));
            } else {
               operCode = "DDM_00812";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dictionaryType.getTypename()}));
            }
         }
      }

      if ("DictionaryController".equals(className)) {
         if ("addDictionaryType".equals(methodName)) {
            module = "规则管理-知识库";
            TConsoleDictionarytype dictionaryType = null;
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               dictionaryType = (TConsoleDictionarytype)ObjectTool.getObjectByMap(TConsoleDictionarytype.class, (Map)map.get("dictionaryType"));
            } else {
               dictionaryType = new TConsoleDictionarytype();
               dictionaryType.setTypename("test分类");
               dictionaryType.setRemark("asfdasdf");
            }

            long typeCount = this.dictionaryService.queryDictionaryTypeCount(dictionaryType.getTypename());
            if (StringUtil.isBlank(dictionaryType.getId())) {
               operCode = "DDM_00811";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dictionaryType.getTypename()}));
            } else {
               operCode = "DDM_00812";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dictionaryType.getTypename()}));
            }
         }

         if ("delDictionaryType".equals(methodName)) {
            module = "规则管理-知识库";
            String dictionaryTypeCode = "";
            String dictionaryTypeName = "";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               Map<String, Object> map = (Map)args[0];
               dictionaryTypeCode = (String)map.get("dictionaryTypeCode");
               dictionaryTypeName = (String)map.get("dictionaryTypeName");
            } else if (StringUtil.isBlank(dictionaryTypeCode)) {
               dictionaryTypeCode = "28";
               dictionaryTypeName = "402882eb70f190c80170f19b23e40002";
            }

            operCode = "DDM_00812";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, dictionaryTypeName}));
         }
      }

      if ("DataSystemController".equals(className)) {
         if ("add".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "资产库";
            DataSystemConfig datasource = (DataSystemConfig)args[0];
            if (StringTool.emptyOrNull(datasource.getId())) {
               operCode = "DDM_01104";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, datasource.getSysname()}));
            } else {
               operCode = "DDM_01103";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, datasource.getSysname()}));
            }
         }

         if ("remove".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "资产库";
            Map<String, Object> map = (Map)args[0];
            String sysname = (String)map.get("sysname");
            operCode = "DDM_01105";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, sysname}));
         }
      }

      if ("AppDataRuleController".equals(className)) {
         if ("appDataRuleQuery".equals(methodName)) {
            module = "兵器库模块下的APP数据规则库";
            operCode = "DDM_01400";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username}));
         }

         if ("appDataRuleAdd".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "兵器库模块下的APP数据规则库";
            Map<String, Object> map = (Map)args[0];
            AppDataRule ruleinfo = (AppDataRule)ObjectTool.getObjectByMap(AppDataRule.class, (Map)map.get("ruleinfo"));
            String id = ruleinfo.getId();
            if (StringUtil.isBlank(id)) {
               operCode = "DDM_01401";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, ruleinfo.getRulename()}));
            } else {
               operCode = "DDM_01403";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, ruleinfo.getRulename()}));
            }
         }

         if ("appDataRuleInitEdit".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[1])) {
            module = "兵器库模块下的APP数据规则库";
            String rulename = (String)args[1];
            operCode = "DDM_01402";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, rulename}));
         }

         if ("appDataRuleDel".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "兵器库模块下的APP数据规则库";
            Map<String, Object> map = (Map)args[0];
            String rulename = (String)map.get("rulename");
            operCode = "DDM_01404";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, rulename}));
         }
      }

      if ("AuditAppDataRuleController".equals(className)) {
         if ("auditDataRuleAdd".equals(methodName)) {
            module = "受控资产库模块";
            Map<String, Object> map = (Map)args[0];
            AuditAppDataRule ruleinfo = (AuditAppDataRule)ObjectTool.getObjectByMap(AuditAppDataRule.class, (Map)map.get("ruleinfo"));
            String id = ruleinfo.getId();
            if (StringUtil.isBlank(id)) {
               operCode = "DDM_01601";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, ruleinfo.getRulename()}));
            } else {
               operCode = "DDM_01603";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, ruleinfo.getRulename()}));
            }
         }

         if ("auditDataRuleInitEdit".equals(methodName)) {
            module = "受控资产库模块";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[1])) {
               String name = String.valueOf(args[1]);
               operCode = "DDM_01602";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, name}));
            }
         }

         if ("auditDataRuleDel".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "受控资产库模块";
            Map<String, Object> map = (Map)args[0];
            String rulename = (String)map.get("name");
            operCode = "DDM_01604";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, rulename}));
         }
      }

      if ("ControlledAssetController".equals(className)) {
         if ("addControlledAsset".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "受控资产库模块";
            ControlledAssertVO controlledAssertVO = (ControlledAssertVO)args[0];
            if (StringUtils.isBlank(controlledAssertVO.getId()) && !ObjectUtils.isEmpty(this.controlledAssetService.queryByName(controlledAssertVO.getName()))) {
               operCode = "POP_00026";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[0]));
            } else {
               if (StringUtils.isBlank(controlledAssertVO.getId())) {
                  operCode = "DDM_01304";
               } else {
                  operCode = "DDM_01303";
               }

               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, controlledAssertVO.getName()}));
            }
         }

         if ("initControlledAsset".equals(methodName)) {
            module = "受控资产库模块";
            operCode = "DDM_01304";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, username}));
         }

         if ("remove".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "受控资产库模块";
            Map<String, Object> map = (Map)args[0];
            String name = (String)map.get("name");
            operCode = "DDM_01305";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, name}));
         }
      }

      if ("EmailController".equals(className)) {
         if ("addEmail".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "邮件模块";
            MailInformation mailInformation = (MailInformation)args[0];
            if (StringUtils.isBlank(mailInformation.getId())) {
               operCode = "DDM_01704";
            } else {
               operCode = "DDM_01703";
            }

            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, mailInformation.getSendemail()}));
         }

         if ("initEmail".equals(methodName)) {
            module = "邮件模块";
            operCode = "DDM_01704";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, CommonUtils.loginUsername()}));
         }

         if ("remove".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "邮件模块";
            Map<String, Object> map = (Map)args[0];
            String name = (String)map.get("sendEmail");
            operCode = "DDM_01705";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, name}));
         }
      }

      if ("SnmpTrapController".equals(className)) {
         if ("addControlledAsset".equals(methodName)) {
            module = "SNMP通知模块";
            if (null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
               SnmpTrapInfomation snmpTrapInfomation = (SnmpTrapInfomation)args[0];
               if (StringUtils.isBlank(snmpTrapInfomation.getId())) {
                  operCode = "DDM_01804";
                  operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, snmpTrapInfomation.getSnmp_server_name()}));
               } else {
                  operCode = "DDM_01803";
                  operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, snmpTrapInfomation.getSnmp_server_name()}));
               }
            }
         }

         if ("initControlledAsset".equals(methodName)) {
            module = "SNMP通知模块";
            operCode = "DDM_01804";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, username}));
         }

         if ("remove".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "SNMP通知模块";
            operCode = "DDM_01805";
            Map<String, Object> map = (Map)args[0];
            String name = (String)map.get("snmpServerName");
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, name}));
         }
      }

      if ("SysLogController".equals(className)) {
         if ("addControlledAsset".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "Syslog通知模块";
            SyslogInfomation syslogInfomation = (SyslogInfomation)args[0];
            if (StringUtils.isBlank(syslogInfomation.getId())) {
               operCode = "DDM_01904";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, syslogInfomation.getHostname()}));
            } else {
               operCode = "DDM_01903";
               operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, syslogInfomation.getHostname()}));
            }
         }

         if ("initControlledAsset".equals(methodName)) {
            module = "Syslog通知模块";
            operCode = "DDM_01904";
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, username}));
         }

         if ("remove".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            module = "Syslog通知模块";
            operCode = "DDM_01905";
            Map<String, Object> map = (Map)args[0];
            String name = (String)map.get("hostname");
            operlog.setLogmessage(MesUtil.getMsg(operCode, new String[]{username, name}));
         }
      }

      if (!ObjectUtils.isEmpty(module)) {
         operlog.setModule(module);
         operlog.setOperationObject(operCode);
         operlog.setOperationtime(new Date());
         operlog.setUser(username);
         Date date = operlog.getOperationtime();
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         String dateString = sdf.format(date);
         String column_enc = "";

         try {
            column_enc = SM3Utils.encrypt(operlog.getOperationUser() + dateString + operlog.getLogmessage());
         } catch (Exception exception) {
            exception.printStackTrace();
         }

         operlog.setColumn_enc(column_enc);
         this.tConsoleLogDao.save(operlog);
      }

   }
}
