package com.chenyang.nse.bussiness.commmon;

import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class RedisClient {
   private Jedis jedis;
   private JedisPool jedisPool;
   private ShardedJedis shardedJedis;
   private ShardedJedisPool shardedJedisPool;

   public static void main(String[] args) {
      (new RedisClient()).show();
   }

   public RedisClient() {
      this.initialPool();
      this.initialShardedPool();
      this.shardedJedis = this.shardedJedisPool.getResource();
      this.jedis = this.jedisPool.getResource();
   }

   public Jedis getJedis() {
      return this.jedis;
   }

   public void setJedis(Jedis jedis) {
      this.jedis = jedis;
   }

   private void initialPool() {
      JedisPoolConfig config = new JedisPoolConfig();
      config.setMaxTotal(20);
      config.setMaxIdle(5);
      config.setMaxWaitMillis(10001L);
      config.setTestOnBorrow(false);
      this.jedisPool = new JedisPool(config, "192.168.2.90", 6379);
   }

   private void initialShardedPool() {
      JedisPoolConfig config = new JedisPoolConfig();
      config.setMaxTotal(20);
      config.setMaxIdle(5);
      config.setMaxWaitMillis(10001L);
      config.setTestOnBorrow(false);
      List<JedisShardInfo> shards = new ArrayList();
      shards.add(new JedisShardInfo("192.168.2.90", 6379));
      this.shardedJedisPool = new ShardedJedisPool(config, shards);
   }

   public void close() {
      this.jedis.close();
   }

   public void show() {
      this.jedisPool.returnResource(this.jedis);
      this.shardedJedisPool.returnResource(this.shardedJedis);
   }

   private void KeyOperate() {
   }

   private void StringOperate() {
   }

   private void ListOperate() {
   }

   private void SetOperate() {
   }

   private void SortedSetOperate() {
   }

   private void HashOperate() {
   }
}
