package com.chenyang.nse.bussiness.common;

import com.chenyang.nse.bussiness.commmon.json.ErrCode;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.exception.CustomException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConstant {
   private static final Logger log = LoggerFactory.getLogger(PropertiesConstant.class);
   public static final Properties properties;

   private PropertiesConstant() {
   }

   static {
      try {
         properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         log.error("config properties load error", e);
         throw new CustomException(ErrCode.DATA_PROCESS_ERROR);
      }
   }
}
