package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreSensitiveregexVO;
import com.chenyang.nse.bussiness.entity.vo.maskingrule.MaskingInfoRuleVO;
import com.chenyang.nse.bussiness.service.console.EngineManageService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.MaskingRuleService;
import com.chenyang.nse.bussiness.tools.engine.mapplet.DesensitizationRulesXmlParse;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping({"/core/maskingrule"})
public class MaskingRuleController {
   @Autowired
   private MaskingRuleService maskingRuleService;
   @Autowired
   private EngineManageService engineManageService;
   @Autowired
   private OperationService operationService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/rules/sensitiveregex";
   }

   @ResponseBody
   @RequestMapping({"/queryrulegroup"})
   public List<ComboboxVO> queryrulegroup(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> group = this.maskingRuleService.queryRuleGroup();
      List<ComboboxVO> list = new ArrayList();

      for(String gn : group) {
         ComboboxVO c = new ComboboxVO(gn);
         list.add(c);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/query"})
   public Response query(String dataarea, String rulename, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreSensitiveregexVO> list = this.maskingRuleService.querySensitiveregex(dataarea, rulename);
      return RespHelper.updateResp(pageInfo, list);
   }

   @ResponseBody
   @RequestMapping({"/queryrulebyid"})
   public TCoreSensitiveregexVO queryrulebyid(String ruleid, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreSensitiveregexVO rule = (TCoreSensitiveregexVO)this.maskingRuleService.querySensitiveregexByid(ruleid).get(0);
      return rule;
   }

   @ResponseBody
   @RequestMapping({"/save"})
   public void query(TCoreMaskingRule rule, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.maskingRuleService.save(rule);
   }

   @ResponseBody
   @RequestMapping({"/remove"})
   public void remove(String ruleid, String id, String name, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.maskingRuleService.remove(ruleid);
      int count = this.maskingRuleService.queryRuleCount(id);
      if (count == 0) {
         this.maskingRuleService.removeDataarea(id);
      } else {
         this.maskingRuleService.setOtherDefault(id);
      }

      TConsoleLog record = new TConsoleLog();
      LoginUser loginUser1 = (LoginUser)request.getSession().getAttribute("loginUser");
      String username1 = loginUser1.getTsysUser().getUsername();
      record.setModule("数据域模块");
      record.setOperationObject(name);
      record.setOperationtime(new Date());
      record.setUser(username1);
      record.setLogmessage("删除脱敏规则");
      this.operationService.add(record);
   }

   @ResponseBody
   @RequestMapping({"/setdefault"})
   public void setdefault(String ruleid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.maskingRuleService.setDefault(ruleid);
   }

   @RequestMapping({"/info"})
   public String info(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/maskingrule/info";
   }

   @ResponseBody
   @RequestMapping({"/info/query"})
   public DataGridVO<MaskingInfoRuleVO> infoquery(Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      DataGridVO<MaskingInfoRuleVO> vo = this.maskingRuleService.queryInfoRule(pageInfo);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/info/queryinforulebyid"})
   public TCoreMaskingRuleinfo queryinforulebyid(String ruleid, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (ruleid != null && !"".equals(ruleid)) {
         TCoreMaskingRuleinfo rule = this.maskingRuleService.queryInfoRuleById(ruleid);
         return rule;
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/info/save"})
   public String infosave(TCoreMaskingRuleinfo ruleinfo, String dataarea, @RequestParam(value = "file",required = false) MultipartFile file, HttpServletRequest request, HttpServletResponse response, Model model) {
      try {
         if (file != null) {
            String mappletpath = File.separator + "data" + File.separator + "infa_work_report" + File.separator + "cs_mapplet" + File.separator;
            File mappletfile = new File(mappletpath, file.getOriginalFilename().substring(0, file.getOriginalFilename().indexOf(46) + 1) + "xml");
            mappletfile.createNewFile();
            file.transferTo(mappletfile);
         }
      } catch (Exception e) {
         System.out.println(e.toString());
         e.printStackTrace();
         return e.toString();
      }

      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      if (ruleinfo.getId() == null || "null".equals(ruleinfo.getId())) {
         ruleinfo.setId("");
      }

      this.maskingRuleService.saveRuleInfo(ruleinfo, loginUser.getTsysUser().getUsername(), dataarea);
      return "successfully";
   }

   @ResponseBody
   @RequestMapping({"/isrepeatname"})
   public boolean isrepeatname(String rulename) {
      boolean flag = true;
      flag = this.maskingRuleService.checkNameExit(rulename);
      return flag;
   }

   @ResponseBody
   @RequestMapping({"/info/saveInfo"})
   public String infosave(TCoreMaskingRuleinfo ruleinfo, String dataarea, HttpServletRequest request, HttpServletResponse response, Model model) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      this.maskingRuleService.saveRuleInfo(ruleinfo, loginUser.getTsysUser().getUsername(), dataarea);
      return "successfully";
   }

   @ResponseBody
   @RequestMapping({"/info/generateJavaRuleFile"})
   public String generateJavaRuleFile(HttpServletRequest request, HttpServletResponse response, Model model, String rulesXmlName) {
      String reFlg = DesensitizationRulesXmlParse.rulesXmlParsing(rulesXmlName);
      return reFlg;
   }
}
