package com.chenyang.nse.bussiness.controller.core.dataproject;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.TdataDiscoveryService;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.service.core.dataproject.ExecuteDiscoverytaskService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/discoverytask"})
public class ExecuteDiscoverytaskController {
   @Autowired
   private TdataDiscoveryService tdataDiscoveryService;
   @Autowired
   private ExecuteDiscoverytaskService executeDiscoverytaskService;
   ExecutorService taskExecutor = Executors.newFixedThreadPool(10);
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private TdataProjectService tdataProjectService;
   @Autowired
   private RedisService redisService;
   public static final String TASKSTATUS_DONE = "0";
   public static final String TASKSTATUS_DOING = "1";
   public static final String TASKSTATUS_ERROR = "2";
   public static final String TASKSTATUS_STOP = "3";
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");
   private static final Logger handleprocessLogger = LoggerFactory.getLogger("handleprocessLogger");
   public static final Logger tasklogger = LoggerFactory.getLogger("ddmauditLogger");

   @RequestMapping({"/monitorrun"})
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, final String taskid, final String projectid, final String version, String resultid) {
      final LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      this.taskExecutor.execute(new Runnable() {
         public void run() {
            Thread.currentThread().setName("pool" + taskid);
            ExecuteDiscoverytaskController.this.executeDiscoverytaskService.execute(taskid, projectid, version, loginUser.getTsysUser().getId(), loginUser.getTsysUser().getUsername(), false, (List)null);
         }
      });
      model.addAttribute("resultid", resultid);
      model.addAttribute("projectid", projectid);
      model.addAttribute("taskid", taskid);
      return "/core/dataproject/monitor/monitordetails";
   }

   @PostMapping({"/executetask"})
   @ResponseBody
   public Response executetask(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response) {
      String taskid = (String)params.get("taskid");
      String taskname = (String)params.get("taskname");
      String version = (String)params.get("version");
      String projectid = (String)params.get("projectid");
      String project = (String)params.get("project");
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e1) {
         e1.printStackTrace();
      }

      handleprocessLogger.info(MesUtil.getMsg("DDM_02006", new String[]{CommonUtils.loginUsername(), project, taskname}));
      tasklogger.info(MesUtil.getMsg("DIS_001", new String[]{taskname}));
      (new Thread(() -> this.executeDiscoverytaskService.execute(taskid, projectid, version, CommonUtils.loginUsername(), (String)null, false, (List)null), "pool" + taskid)).start();
      return RespHelper.successResp();
   }

   @PostMapping({"stoptask"})
   @ResponseBody
   public Response stoptask(@RequestBody Map<String, String> map) {
      String taskid = (String)map.get("taskid");
      String datasystemname = (String)map.get("dataSystemName");
      String taskname = (String)map.get("taskname");
      handleprocessLogger.info(MesUtil.getMsg("DDM_00410", new String[]{CommonUtils.loginUsername(), datasystemname, taskname}));
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e1) {
         e1.printStackTrace();
      }

      tasklogger.info(MesUtil.getMsg("DIS_013", new String[]{taskname}));

      for(Thread t : Thread.getAllStackTraces().keySet()) {
         if (t.getName().equals("pool" + taskid)) {
            t.interrupt();
            tasklogger.info(MesUtil.getMsg("DIS_014", new String[0]));
         } else {
            tasklogger.info(MesUtil.getMsg("DIS_015", new String[0]));
         }
      }

      this.tdataDiscoveryService.updateTaskstatus(taskid, "3", (String)null);
      tasklogger.info(MesUtil.getMsg("DIS_016", new String[0]));
      return RespHelper.successResp();
   }
}
