package com.chenyang.nse.bussiness.controller.core.encryption;

import ch.qos.logback.classic.Logger;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chenyang.nse.bussiness.annot.EncryptLog;
import com.chenyang.nse.bussiness.annot.PassToken;
import com.chenyang.nse.bussiness.bean.Column;
import com.chenyang.nse.bussiness.bean.DBEasyCache;
import com.chenyang.nse.bussiness.bean.DataBase;
import com.chenyang.nse.bussiness.bean.DataCache;
import com.chenyang.nse.bussiness.ccoresdf.impl.TCoreEncryptionServiceCCoreSDFImpl;
import com.chenyang.nse.bussiness.commmon.ServiceException;
import com.chenyang.nse.bussiness.commmon.json.ErrCode;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.commmon.json.ResponseObj;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.controller.core.EncryptionConfigController;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.TCoreDataSourceSchemaDao;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyTypeManagementDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectDatasourceDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreSecretkeyDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.ColumnPrimaryKeyInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncrypLogDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreJiaMiJieMiJinDuDao;
import com.chenyang.nse.bussiness.encryptor.service.impl.TCoreEncryptionServiceSdkImpl;
import com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasourceSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreTablestructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectDatasource;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.ColumnPrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncrypLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreJiaMiJieMiJinDu;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.TableRuleInfo;
import com.chenyang.nse.bussiness.entity.vo.encyption.EncryptionConfigVO;
import com.chenyang.nse.bussiness.entity.vo.key.TCoreKeyTypeManagementVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.entity.vo.strategy.LoadingColumnParamVO;
import com.chenyang.nse.bussiness.entity.vo.strategy.LoadingParameterVO;
import com.chenyang.nse.bussiness.entity.vo.strategy.ReplaceColumnParamVO;
import com.chenyang.nse.bussiness.entity.vo.strategy.TableInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.kms.service.impl.TCoreEncryptionServiceKmsImpl;
import com.chenyang.nse.bussiness.service.core.SwitchFieldService;
import com.chenyang.nse.bussiness.service.core.TableRuleService;
import com.chenyang.nse.bussiness.service.core.encryption.EncryptionConfigService;
import com.chenyang.nse.bussiness.service.core.encryption.EncryptionProxyService;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.service.core.encryption.impl.TCoreEncryptionContext;
import com.chenyang.nse.bussiness.service.core.impl.encryption.TCoreEncryptionServiceImpl;
import com.chenyang.nse.bussiness.service.core.strategy.MaksingAppDataRuleService;
import com.chenyang.nse.bussiness.service.core.udf.UdfService;
import com.chenyang.nse.bussiness.service.key.KeyManagerService;
import com.chenyang.nse.bussiness.thkms.service.impl.TCoreEncryptionServiceThKmsImpl;
import com.chenyang.nse.bussiness.tools.dataprocess.ApplicationContextProvider;
import com.chenyang.nse.bussiness.tools.dataprocess.ColumnEncryption;
import com.chenyang.nse.bussiness.tools.dataprocess.MongoDBLoadingBatchTask;
import com.chenyang.nse.bussiness.tools.dataprocess.MongoDBLoadingTask;
import com.chenyang.nse.bussiness.tools.dataprocess.MongoDBRemoveLoadingBatchTask;
import com.chenyang.nse.bussiness.tools.dataprocess.MongoDBRemoveLoadingTask;
import com.chenyang.nse.bussiness.tools.dataprocess.NewLoadingBatchTask;
import com.chenyang.nse.bussiness.tools.dataprocess.NewLoadingTask;
import com.chenyang.nse.bussiness.tools.dataprocess.NewRemoveLoadingBatchTask;
import com.chenyang.nse.bussiness.tools.dataprocess.NewRemoveLoadingTask;
import com.chenyang.nse.bussiness.tools.dataprocess.elasticsearch.ElasticSearchTask;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.HdfsLoadingBatchTask;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.HdfsLoadingTask;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.HdfsRemoveLoadingBatchTask;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.HdfsRemoveLoadingTask;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.HiveEncDecType;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.HiveLoadingTask;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.HiveRemoveLoadingTask;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import com.chenyang.nse.bussiness.tools.encryption.EncUtils;
import com.chenyang.nse.bussiness.tools.encryption.SM3Utils;
import com.chenyang.nse.bussiness.tools.encryption.SM4Util;
import com.chenyang.nse.bussiness.tools.es.EsUtil;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MongodbTool;
import com.chenyang.nse.bussiness.tools.logger.LoggerBuilder;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.propertyutil.PropertyGhcaUtil;
import com.chenyang.nse.bussiness.tools.spring.SpringUtil;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.token.TokenUtil;
import com.chenyang.nse.bussiness.tools.utils.GHCAUtils;
import com.mongodb.MongoClient;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping({"/core/encryption"})
public class TCoreEncryptionController {
   private static final String LOCAL_CODE = "1";
   private static final String SDK_CODE = "2";
   private static final String CLOUD_SDK_CODE = "3";
   private static final String C_CORE_SDF_CODE = "4";
   private static final String KMS_CODE = "5";
   private static final String TH_KMS_CODE = "6";
   private static final String ENC_TYPE = "SM4_ECB";
   private static final String ENC_DATA = "随着《数据安全法》和《个人信息保护法》相继推出，以及各行业数据安全标准的不断完善，建立完整的数据安全治理体系已是迫在眉睫。其中，数据安全风险评估作为数据安全建设的基础和前提，在发现数据安全威胁和风险方面意义重大为贯彻落实《数据安全法》关于数据安全风险评估的要求，2023年5月29日，全国信息安全标准化技术委员会发布《网络安全标准实践指南--网络数据安全风险评估实施指引》，该指南共8章内容，附录分为数据安全风险示例、评估报告模板。给出网络数据安全风险评估思路、工作流程和评估内容,可用于指导数据处理者、第三方机构开展数据安全评估，也可为有关主管监管部门组织开展检查评估aaa中华人民共和国数据安全法》已由中华人民共和国第十三届全国人民代表大会常务委员会第二十九次会议于2021年6月10日通过，现予公布q现予法";
   private static final String DATA_UNIT = "KB";
   private static final String SECOND = "秒";
   private static final int THOUSAND = 1000;
   private static int cpuCores = Runtime.getRuntime().availableProcessors();
   private static String COLUMN_ALL_ENCRYPTED = "该列不存在明文数据，无需处理";
   private static String CHECK_COLUMN = "checkColumn";
   SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
   @Autowired
   private TCoreEncrypLogDao tCoreEncrypLogDao;
   @Autowired
   MaksingAppDataRuleService maksingAppDataRuleService;
   @Autowired
   TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;
   @Autowired
   @Qualifier("TCoreEncryptionContext")
   TCoreEncryptionService tCoreEncryptionService;
   @Autowired
   TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   EncryptionConfigController encryptionConfigController;
   @Autowired
   ColumnPrimaryKeyInfoDao columnPrimaryKeyInfoDao;
   @Autowired
   EncryptionConfigService encryptionConfigService;
   @Autowired
   TCoreEncryptionDao tCoreEncryptionDao;
   @Autowired
   TCoreSecretkeyDao tCoreSecretkeyDao;
   @Autowired
   TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao;
   @Autowired
   private TCoreDataProjectDao tCoreDataProjectDao;
   @Autowired
   @Qualifier("incEncryptionThreadPool")
   protected ThreadPoolTaskExecutor taskExecutor;
   @Autowired
   protected SwitchFieldService switchFieldService;
   @Autowired
   EncryptionProxyService encryptionProxyService;
   @Autowired
   private TCoreProjectDatasourceDao tCoreProjectDatasourceDao;
   @Autowired
   protected JdbcTemplate jdbcTemplate;
   @Autowired
   protected KeyManagerService keyManagerService;
   @Autowired
   TCoreKeyTypeManagementDao tCoreKeyTypeManagementDao;
   @Autowired
   private UdfService udfService;
   @Autowired
   private TableRuleService tableRuleService;
   @Autowired
   private TCoreDataSourceSchemaDao tCoreDataSourceSchemaDao;

   @EncryptLog
   @PostMapping({"/save"})
   @ResponseBody
   public Response saveEncryption(@RequestBody TCoreEncryption encryption) {
      this.tCoreEncryptionService.save(encryption);
      return RespHelper.successResp();
   }

   @RequestMapping({"/initEncryptionTypeList"})
   @ResponseBody
   public Response initEncryptionTypeList() {
      List<ComboboxVO> typeList = this.tCoreEncryptionService.initEncryptionTypeList();
      return RespHelper.successResp(typeList);
   }

   @RequestMapping({"/queryPostfix"})
   @ResponseBody
   public Response queryPostfix() {
      HashMap hmap = new HashMap();
      String copySuffix = PropertyGhcaUtil.copySuffix;
      String initialSuffix = PropertyGhcaUtil.initialSuffix;
      String cipherSuffix = PropertyGhcaUtil.cipherSuffix;
      hmap.put("copySuffix", copySuffix);
      hmap.put("initialSuffix", initialSuffix);
      hmap.put("cipherSuffix", cipherSuffix);
      return RespHelper.successResp(hmap);
   }

   @EncryptLog
   @RequestMapping({"/delete"})
   @ResponseBody
   public Response deleteEncryption(@RequestBody Map<String, String> map) {
      String encryptionId = (String)map.get("encryptionId");
      List<TCoreEncryptionTypeField> list = new ArrayList();
      if (!ObjectUtil.isEmpty(encryptionId)) {
         list = this.tCoreEncryptionService.deleteEncryption(encryptionId);
      }

      if (list != null && list.size() > 0) {
         StringBuffer buffer = new StringBuffer();

         for(TCoreEncryptionTypeField x : list) {
            buffer.append(x.getTschemas() + "." + x.getNames() + "." + x.getTable_field_id()).append(",");
         }

         String result = "。";
         return RespHelper.createResp(false, "POP_00030", MesUtil.getMsg("POP_00030", new String[0]) + result);
      } else {
         return RespHelper.successResp();
      }
   }

   /** @deprecated */
   @PassToken
   @PostMapping({"/encryptionAndDecryption"})
   @Deprecated
   @ResponseBody
   public String encryptionAndDecryption(@RequestBody String encryption) {
      HashMap<String, String> encryptionMap = (HashMap)JSON.parseObject(encryption, HashMap.class);
      String val = (String)encryptionMap.get("value");
      String key = (String)encryptionMap.get("key");
      String encrFlag = (String)encryptionMap.get("encrFlag");
      String isLike = (String)encryptionMap.get("isLike");
      String keepfirst = (String)encryptionMap.get("keepfirst");
      String encdigit = (String)encryptionMap.get("encdigit");
      String twoindex = (String)encryptionMap.get("twoindex");
      String text = "";
      if ("1".equals(encrFlag)) {
         text = SM4Util.encryptEcb(key, val, isLike, keepfirst, encdigit, twoindex);
      } else if ("0".equals(encrFlag)) {
         try {
            text = SM4Util.decryptEcb(key, val, isLike, keepfirst, encdigit, twoindex);
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return text;
   }

   @RequestMapping({"/getRandomValue"})
   @ResponseBody
   public Response getRandomValue(@RequestParam("type") String type) {
      TCoreKeyTypeManagementVO tCoreKeyTypeManagementVO = this.keyManagerService.queryTCoreKeyTypeManageUsed();
      if (Objects.isNull(tCoreKeyTypeManagementVO)) {
         return RespHelper.createResp(false, "pop_00034", MesUtil.getMsg("pop_00034", new String[0]));
      } else {
         String typeId = tCoreKeyTypeManagementVO.getTypeid();
         return RespHelper.successResp(this.tCoreEncryptionService.getRandomValue(type));
      }
   }

   @RequestMapping({"/testEncryption"})
   @ResponseBody
   public Response testEncryption(@RequestBody Map<String, String> map) {
      String param = (String)map.get("param");
      String secret_key = (String)map.get("secret_key");
      String type = (String)map.get("type");
      String isLike = StringUtils.isEmpty((String)map.get("isLike")) ? "0" : "1";
      String keepfirst = (String)map.get("keepfirst");
      String encdigit = (String)map.get("encdigit");
      String twoindex = (String)map.get("twoindex");
      String result = this.tCoreEncryptionService.testEncryption(type, param, isLike, secret_key, keepfirst, encdigit, twoindex);
      return RespHelper.successResp(result);
   }

   @EncryptLog
   @RequestMapping({"/saveSecretKey"})
   @ResponseBody
   public Response saveSecretKey(@RequestBody TCoreSecretkey tCoreSecretKey) {
      this.tCoreEncryptionService.saveSecretKey(tCoreSecretKey);
      return RespHelper.successResp();
   }

   @EncryptLog
   @RequestMapping({"/delSecretKey"})
   @ResponseBody
   public Response delSecretKey(@RequestBody Map<String, String> map) {
      String keyId = (String)map.get("keyId");
      List<TCoreEncryptionTypeField> list = new ArrayList();
      if (!ObjectUtil.isEmpty(keyId)) {
         list = this.tCoreEncryptionService.delSecretKey(keyId);
      }

      if (list != null && list.size() > 0) {
         StringBuffer stringBuffer = new StringBuffer();

         for(TCoreEncryptionTypeField x : list) {
            stringBuffer.append(x.getTschemas() + "." + x.getNames() + "." + x.getTable_field_id()).append(",");
         }

         String result = "。";
         return RespHelper.createResp(false, "POP_00030", MesUtil.getMsg("POP_00030", new String[0]) + result);
      } else {
         return RespHelper.successResp();
      }
   }

   @RequestMapping({"/query"})
   @ResponseBody
   public Response queryEncryptionList(@Param("encryption_name") String encryption_name) {
      List<TCoreEncryption> list = this.tCoreEncryptionService.queryEncryptionList(encryption_name);
      return RespHelper.successResp(list);
   }

   @RequestMapping({"/loadingProgress"})
   @ResponseBody
   public Response loadingProgress(@RequestBody LoadingColumnParamVO loadingColumnParamVO) throws Exception {
      String dataSystemId = loadingColumnParamVO.getDataSystemId();
      String projectId = loadingColumnParamVO.getProjectId();
      String schema = loadingColumnParamVO.getSchema();
      String tableName = loadingColumnParamVO.getTableName();
      String columnName = loadingColumnParamVO.getColumnName();
      String state = loadingColumnParamVO.getState();
      List<Map<String, Object>> objectMapList = new ArrayList();
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = new ArrayList();
      PageInfo pageInfo = new PageInfo();
      List<TCoreJiaMiJieMiJinDu> tcoreJiaMiDulist = new ArrayList();
      if (loadingColumnParamVO.getProjectId() != null && !loadingColumnParamVO.getProjectId().trim().equals("")) {
         if (loadingColumnParamVO.getSchema() != null && !loadingColumnParamVO.getSchema().trim().equals("")) {
            tCoreJiaMiJieMiJinList = this.tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinD(dataSystemId, projectId, schema, tableName);
         } else {
            Integer page = loadingColumnParamVO.getPageno();
            Integer rows = loadingColumnParamVO.getPagesize();
            pageInfo.setPageno(page);
            pageInfo.setPagesize(rows);
            tcoreJiaMiDulist = this.encryptionConfigService.queryTCoreJiaMiDulist(pageInfo, projectId, tableName, state);
         }

         int cpp = tCoreJiaMiJieMiJinList.size();
         if (cpp > 0) {
            for(int n = 0; n < cpp; ++n) {
               if (null != tCoreJiaMiJieMiJinList.get(n) && ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getStarttime() != null ) {
                  //&& ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getState() != null
                  Map<String, Object> objectMap = new HashMap();
                  objectMap.put("projectId", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getProjectid());
                  objectMap.put("dataSystemId", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getDatasystemid());
                  objectMap.put("schema", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getSchemahh());
                  objectMap.put("tableName", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getTablename());
                  objectMap.put("flag", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getFlag());
                  objectMap.put("totalCounts", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getTotalcounts());
                  objectMap.put("finishCounts", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getFinishcounts());
                  objectMap.put("failCounts", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getFailcounts());
                  objectMap.put("startTime", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getStarttime() == null ? "" : ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getStarttime());
                  objectMap.put("endTime", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getEndtime() == null ? "" : ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getEndtime());
                  objectMap.put("state", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getState() == null ? "-1" : ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getState());
                  objectMap.put("columnName", columnName);
                  objectMap.put("exceptionString", ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getExceptionstring());
                  int progressNum = 0;
                  double finishcounts = (double)((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getFinishcounts();
                  double totalcounts = (double)((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getTotalcounts();
                  if (0 != ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getTotalcounts()) {
                     progressNum = (int)(finishcounts / totalcounts * (double)100.0F);
                  }

                  objectMap.put("progressNum", progressNum);
                  objectMapList.add(objectMap);
               }
            }
         }
      }

      return loadingColumnParamVO.getSchema() != null && !loadingColumnParamVO.getSchema().trim().equals("") ? RespHelper.successResp(objectMapList) : RespHelper.updateResp(pageInfo, tcoreJiaMiDulist);
   }

   @RequestMapping({"/loadProgress"})
   @ResponseBody
   public Response loadProgress(@RequestBody LoadingColumnParamVO loadingColumnParamVO) throws Exception {
      String projectId = loadingColumnParamVO.getProjectId();
      new ArrayList();
      Map<String, Object> objectMap = new HashMap();
      if (loadingColumnParamVO.getProjectId() != null && !loadingColumnParamVO.getProjectId().trim().equals("")) {
         List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = this.tCoreJiaMiJieMiJinDuDao.queryAll(Order.asc("startTime"), new Criterion[]{Restrictions.eq("projectId", projectId)});
         int cpp = tCoreJiaMiJieMiJinList.size();
         int tableSucNumber = 0;
         int tableLoadingNumber = 0;
         int tableDefeatedNumber = 0;
         int colTotalNumber = 0;
         int colFinishNumber = 0;
         String startTime = "";
         if (cpp > 0) {
            for(int n = 0; n < cpp; ++n) {
               if (null != ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getState()) {
                  if ("1".equals(((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getState())) {
                     ++tableSucNumber;
                  }

                  if ("0".equals(((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getState())) {
                     ++tableLoadingNumber;
                  }

                  if ("-1".equals(((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getState())) {
                     ++tableDefeatedNumber;
                  }
               }

               colTotalNumber += ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getTotalcounts();
               colFinishNumber += ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(n)).getFinishcounts();
               SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
               if (null != ((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(0)).getStarttime()) {
                  startTime = sdf.format(((TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(0)).getStarttime());
               }
            }
         }

         objectMap.put("startTime", startTime);
         objectMap.put("colTotalNumber", colTotalNumber);
         objectMap.put("colFinishNumber", colFinishNumber);
         objectMap.put("colRejectNumber", colTotalNumber - colFinishNumber);
         objectMap.put("tableTotalNumber", cpp);
         objectMap.put("tableSucNumber", tableSucNumber);
         objectMap.put("tableLoadingNumber", tableLoadingNumber);
         objectMap.put("tableDefeatedNumber", tableDefeatedNumber);
      }

      return RespHelper.successResp();
   }

   @RequestMapping({"/checkTableEncOrDecColumn"})
   @ResponseBody
   public Response checkTableEncOrDecColumn(@RequestBody LoadingColumnParamVO loadingColumnParamVO, HttpServletRequest request, HttpServletResponse response) {
      String initialSuffix = PropertyGhcaUtil.initialSuffix;
      String cipherSuffix = PropertyGhcaUtil.cipherSuffix;
      String copySuffix = PropertyGhcaUtil.copySuffix;
      String dataSystemId = loadingColumnParamVO.getDataSystemId();
      String projectId = loadingColumnParamVO.getProjectId();
      String schema = loadingColumnParamVO.getSchema();
      String tableName = loadingColumnParamVO.getTableName();
      HashMap<String, Object> resultMap = new HashMap();
      String flag = "";
      int max = 0;

      try {
         Properties properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String property = properties.getProperty("encryption.field.max");
         if (property != null && property.length() > 0) {
            max = Integer.valueOf(property.trim());
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      if (loadingColumnParamVO.getFlag() != null && !loadingColumnParamVO.getFlag().equals("")) {
         flag = loadingColumnParamVO.getFlag();
      }

      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      List<TCoreEncryptionTypeField> tCorTypeFieldList = new ArrayList();
      if ("0".equals(flag)) {
         List<TCoreEncryptionTypeField> l1 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("flag", "5")});
         List<TCoreEncryptionTypeField> l2 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("flag", "7")});
         List<TCoreEncryptionTypeField> l3 = new ArrayList();
         l3.addAll(l1);
         l3.addAll(l2);
         ResultSet resultSet = null;
         Connection co = null;

         try {
            if (null != l3 && l3.size() != 0) {
               for(TCoreEncryptionTypeField t : l3) {
                  TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", t.getDatasystem_id())});
                  if (!"HIVE_TDH".equals(datasystem.getDbtype()) && !"MONGODB".equals(datasystem.getDbtype()) && !"ES".equals(datasystem.getDbtype())) {
                     co = JdbcTool.getConnection(datasystem);
                     resultSet = JdbcTool.getColumns(co, t.getTschemas(), t.getNames());

                     while(resultSet.next()) {
                        String colName = resultSet.getString("COLUMN_NAME");
                        if ((t.getTable_field_id() + copySuffix).equalsIgnoreCase(colName) && ("0".equals(t.getFlag()) || "7".equals(t.getFlag()))) {
                           Response primaryKeyFlag = RespHelper.errResp(ErrCode.REDUNDANCE_COLUMN);
                           return primaryKeyFlag;
                        }
                     }
                  }

                  if ("ES".equals(datasystem.getDbtype())) {
                     Response var60 = RespHelper.successResp();
                     return var60;
                  }

                  if ("MONGODB".equals(datasystem.getDbtype())) {
                     try {
                        MongoClient client = MongodbTool.connect(datasystem.getDbservername(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), true);
                        List<Column> columnList = MongodbTool.findAllColumns(client, schema, tableName);
                        List<String> columnStrings = (List)columnList.stream().map(Column::getColumnName).collect(Collectors.toList());
                        if (columnStrings.contains(t.getTable_field_id() + copySuffix) && ("0".equals(t.getFlag()) || "7".equals(t.getFlag()))) {
                           Response newLoadingTask = RespHelper.errResp(ErrCode.REDUNDANCE_COLUMN);
                           return newLoadingTask;
                        }
                     } catch (Exception e) {
                        e.printStackTrace();
                     }
                  }
               }
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            if (resultSet != null) {
               try {
                  resultSet.close();
                  co.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

         }

         List<TCoreEncryptionTypeField> tCorTypeFieldList1 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "0");
         List<TCoreEncryptionTypeField> tCorTypeFieldList2 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "7");
         List<TCoreEncryptionTypeField> tCorTypeFieldList3 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "4");
         List<TCoreEncryptionTypeField> tCorTypeFieldList4 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "12");
         if (null != tCorTypeFieldList1 && tCorTypeFieldList1.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList1);
         }

         if (null != tCorTypeFieldList2 && tCorTypeFieldList2.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList2);
         }

         if (null != tCorTypeFieldList3 && tCorTypeFieldList3.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList3);
         }

         if (null != tCorTypeFieldList4 && tCorTypeFieldList4.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList4);
         }

         tCorTypeFieldList2 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "-1");
         if (null != tCorTypeFieldList2 && tCorTypeFieldList2.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList2);
         }

         if (!"MONGODB".equals(tCoreDatasystem.getDbtype()) && !"ES".equals(tCoreDatasystem.getDbtype())) {
            if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
               TableRuleInfo hiveStoreInfo = this.tableRuleService.getHiveStoreInfo(projectId, dataSystemId, schema, tableName);
               if (hiveStoreInfo != null && hiveStoreInfo.getType() == HiveEncDecType.webHdfs) {
                  return RespHelper.successResp();
               }
            } else if ("HIVE".equals(tCoreDatasystem.getDbtype())) {
               return RespHelper.successResp();
            }

            String primaryKeyFlag = "0";
            int totalExtendLength = 0;

            for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCorTypeFieldList) {
               if (!"TEXT".equalsIgnoreCase(tCoreEncryptionTypeField.getColumn_type())) {
                  String columnSize = tCoreEncryptionTypeField.getColumn_size();
                  if (max > 0 && Integer.parseInt(columnSize) >= max) {
                     columnSize = String.valueOf(max);
                  } else {
                     Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(tCoreEncryptionTypeField.getEncryption_secretkey_id());
                     columnSize = EncUtils.strColumnSize(tCoreDatasystem.getDbtype(), tCoreEncryptionTypeField.getColumn_type(), columnSize, tCoreEncryptionTypeField.getIslike(), primaryKeyFlag, (String)encryptionInfo.get("encryptionType"));
                  }

                  NewLoadingTask newLoadingTask = new NewLoadingTask(tCoreDatasystem, tCoreEncryptionTypeField.getColumn_type(), columnSize);
                  long columnsCheckLength = newLoadingTask.getColumnsCheckLength(tCoreDatasystem.getDbtype(), schema, tableName);
                  int columnLength = Integer.parseInt(columnSize);
                  totalExtendLength += columnLength;
                  resultMap = newLoadingTask.checkTableColumnLength(resultMap, tCoreDatasystem.getDbtype(), tCoreEncryptionTypeField.getTable_field_id(), columnsCheckLength, columnLength);
                  if (!CollectionUtils.isEmpty(resultMap)) {
                     return RespHelper.createResp(false, "-1", resultMap.get("checkColumn").toString());
                  }
               }
            }

            NewLoadingTask newLoadingTask = new NewLoadingTask(tCoreDatasystem, "varchar", totalExtendLength + "");
            long columnsCheckLength = newLoadingTask.getColumnsCheckLength(tCoreDatasystem.getDbtype(), schema, tableName);
            resultMap = newLoadingTask.checkTableColumnLength(resultMap, tCoreDatasystem.getDbtype(), "批量加密列", columnsCheckLength, totalExtendLength);
            if (!CollectionUtils.isEmpty(resultMap)) {
               return RespHelper.createResp(false, "-1", resultMap.get("checkColumn").toString());
            } else {
               return RespHelper.successResp();
            }
         } else {
            return RespHelper.successResp();
         }
      } else {
         return RespHelper.successResp();
      }
   }

   @EncryptLog
   @RequestMapping({"/loadingTableParams"})
   @ResponseBody
   public Response loadingTableParams(@RequestBody LoadingColumnParamVO loadingColumnParamVO, HttpServletRequest request, HttpServletResponse response) {
      String username = "";
      if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getHeader("token"))) {
         username = TokenUtil.getUserId(request.getHeader("token"));
      }

      TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
      encryptionLog.setOperModule("加密设置");
      encryptionLog.setProjectId(loadingColumnParamVO.getProjectId());
      encryptionLog.setDataSystemId(loadingColumnParamVO.getDataSystemId());
      encryptionLog.setSchemaName(loadingColumnParamVO.getSchema());
      encryptionLog.setTableName(loadingColumnParamVO.getTableName());
      if (null != loadingColumnParamVO.getFlag() && "0".equals(loadingColumnParamVO.getFlag())) {
         encryptionLog.setCode("DDM_010015");
         encryptionLog.setOperptionMassage("用户[" + username + "]对[" + loadingColumnParamVO.getSchema() + "下的表" + loadingColumnParamVO.getTableName() + "]执行了批量加密操作;");
      } else {
         encryptionLog.setCode("DDM_010019");
         encryptionLog.setOperptionMassage("用户[" + username + "]对[" + loadingColumnParamVO.getSchema() + "下的表" + loadingColumnParamVO.getTableName() + "]执行了批量解密操作;");
      }

      encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
      encryptionLog.setCreatetime(new Date());
      encryptionLog.setOperptionUser(username);
      Date date = encryptionLog.getCreatetime();
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String dateString = sdf.format(date);
      String column_enc = "";

      try {
         column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
      } catch (Exception exception) {
         exception.printStackTrace();
      }

      encryptionLog.setColumn_enc(column_enc);
      this.tCoreEncrypLogDao.save(encryptionLog);
      String initialSuffix = PropertyGhcaUtil.initialSuffix;
      String cipherSuffix = PropertyGhcaUtil.cipherSuffix;
      String copySuffix = PropertyGhcaUtil.copySuffix;
      String dataSystemId = loadingColumnParamVO.getDataSystemId();
      String projectId = loadingColumnParamVO.getProjectId();
      String schema = loadingColumnParamVO.getSchema();
      String tableName = loadingColumnParamVO.getTableName();
      String flag = "";
      if (loadingColumnParamVO.getFlag() != null && !loadingColumnParamVO.getFlag().equals("")) {
         flag = loadingColumnParamVO.getFlag();
      }

      String flagppp = loadingColumnParamVO.getFlag();
      LoadingColumnParamVO loadingColVO = new LoadingColumnParamVO();
      loadingColVO.setProjectId(projectId);
      List<TCoreEncryptionTypeField> tCorTypeFieldList = new ArrayList();
      List<Map<String, Object>> LoadingList = new ArrayList();
      new HashMap();
      Map objectMap;
      if (!tableName.trim().equals("") && tableName != null) {
         if (flag.equals("1")) {
            List<TCoreEncryptionTypeField> tCorTypeFieldList1 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "5");
            List<TCoreEncryptionTypeField> tCorTypeFieldList2 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "11");
            List<TCoreEncryptionTypeField> tCorTypeFieldList3 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "44");
            if (null != tCorTypeFieldList1 && tCorTypeFieldList1.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList1);
            }

            if (null != tCorTypeFieldList2 && tCorTypeFieldList2.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList2);
            }

            if (null != tCorTypeFieldList3 && tCorTypeFieldList3.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList3);
            }
         } else {
            List<TCoreEncryptionTypeField> tCorTypeFieldList1 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "0");
            List<TCoreEncryptionTypeField> tCorTypeFieldList2 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "7");
            List<TCoreEncryptionTypeField> tCorTypeFieldList3 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "4");
            List<TCoreEncryptionTypeField> tCorTypeFieldList4 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "12");
            if (null != tCorTypeFieldList1 && tCorTypeFieldList1.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList1);
            }

            if (null != tCorTypeFieldList2 && tCorTypeFieldList2.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList2);
            }

            if (null != tCorTypeFieldList3 && tCorTypeFieldList3.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList3);
            }

            if (null != tCorTypeFieldList4 && tCorTypeFieldList4.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList4);
            }

            tCorTypeFieldList2 = this.tCoreEncryptionTypeFieldDao.queryTCorTypeFieldList(dataSystemId, projectId, schema, tableName, "-1");
            if (null != tCorTypeFieldList2 && tCorTypeFieldList2.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList2);
            }
         }

         TableInfoVO tableInfoVO = new TableInfoVO();
         tableInfoVO.setTableName(tableName);
         EncryptionConfigVO proEncryptionConfigVO = new EncryptionConfigVO();
         proEncryptionConfigVO.setDatasystem_id(dataSystemId);
         proEncryptionConfigVO.setTable_name(tableName);
         proEncryptionConfigVO.setSchema(schema);
         proEncryptionConfigVO.setProjectId(projectId);
         List<ColumnInfoVO> proColumnInfoVOList = this.encryptionConfigService.queryOriginalList(proEncryptionConfigVO);
         String primaryKeyColumns = "";
         int pt = proColumnInfoVOList.size();

         for(int y = 0; y < pt; ++y) {
            String proKey = ((ColumnInfoVO)proColumnInfoVOList.get(y)).getPrimarykey();
            if (null != proKey && proKey.equals("1")) {
               primaryKeyColumns = primaryKeyColumns + "," + ((ColumnInfoVO)proColumnInfoVOList.get(y)).getColumnname();
            }
         }

         TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
         if (!primaryKeyColumns.equals("") && primaryKeyColumns != null) {
            primaryKeyColumns = primaryKeyColumns.substring(1, primaryKeyColumns.length());
            String[] primaryKeys = primaryKeyColumns.split(",");
            tableInfoVO.setPrimaryKeys(primaryKeys);
         } else if (!"HIVE".equals(tCoreDatasystem.getDbtype())) {
            return RespHelper.errResp(ErrCode.NO_PK);
         }

         LoadingParameterVO loadingParameterVO = new LoadingParameterVO();
         loadingParameterVO.setDataSystemId(dataSystemId);
         loadingParameterVO.settCoreDatasystem(tCoreDatasystem);
         loadingParameterVO.setProjectId(projectId);
         loadingParameterVO.setSchema(schema);
         List<com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO> columnInfoVOList = new ArrayList();
         int c = tCorTypeFieldList.size();

         for(int n = 0; n < c; ++n) {
            if (((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id() != null && ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncryption_secretkey_id() != null && !((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id().equals("") && !((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncryption_secretkey_id().equals("")) {
               String columnName = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id();
               String secretKeyId = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncryption_secretkey_id();
               if (!secretKeyId.equals("") && secretKeyId != null) {
                  com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO columnInfoVO = new com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO();
                  columnInfoVO.setColumnName(columnName);
                  Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                  columnInfoVO.setEncryptionType((String)encryptionInfo.get("encryptionType"));
                  columnInfoVO.setSecretKey((String)encryptionInfo.get("secretkey"));
                  columnInfoVO.setSecretKeyId(secretKeyId);
                  columnInfoVO.setColumnType(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getColumn_type());
                  columnInfoVO.setColumnSize(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getColumn_size());
                  columnInfoVO.setRealitycolumnsize(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getRealitycolumnsize());
                  columnInfoVO.setIsLike(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getIslike());
                  columnInfoVO.setKeepfirst(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getKeepfirst());
                  columnInfoVO.setEncdigit(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncdigit());
                  columnInfoVO.setTwoindex(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTwoindex());
                  columnInfoVO.setTcoreencryptionfieldId(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getId());
                  columnInfoVOList.add(columnInfoVO);
                  String describeInfo = "";
                  if (((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getDescribe_info() != null && !((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getDescribe_info().equals("")) {
                     describeInfo = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getDescribe_info();
                  }

                  String tt = schema + "." + tableName + "." + columnName;
                  HashMap<String, String> ja = new HashMap();
                  ja.put("describe_info", describeInfo);
                  ja.put("encryptionSecretKeyId", secretKeyId);
                  if (flag.equals("0")) {
                     ja.put("flag", "1");
                  } else if (flag.equals("1")) {
                     ja.put("flag", "0");
                  } else {
                     ja.put("flag", "6");
                  }

                  ja.put("columnType", ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getColumn_type());
                  ja.put("columnSize", ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getColumn_size());
                  HashMap<String, HashMap<String, String>> ttMap = new HashMap();
                  ttMap.put(tt, ja);
                  HashMap<String, Object> tyMap = new HashMap();
                  tyMap.put("datasystemid", dataSystemId);
                  tyMap.put("map", ttMap);
                  tyMap.put("projectId", projectId);
                  LoadingList.add(tyMap);
               }
            }
         }

         tableInfoVO.setColumnInfo(columnInfoVOList);
         List<TableInfoVO> tableInfoVOList = new ArrayList();
         tableInfoVOList.add(tableInfoVO);
         loadingParameterVO.setTableInfo(tableInfoVOList);
         List<LoadingParameterVO> loadingParameterVOList = new ArrayList();
         loadingParameterVOList.add(loadingParameterVO);
         if (flag.equals("0")) {
            objectMap = this.doLoadingAllTable(loadingParameterVOList);
         } else {
            objectMap = this.doRemoveLoadingAllTable(loadingParameterVOList);
         }
      } else {
         TCoreDataProject tCoreDataProject = (TCoreDataProject)this.tCoreDataProjectDao.queryUnique(new Criterion[]{Restrictions.eq("id", projectId)});
         if ("0".equals(flag)) {
            tCoreDataProject.setFlag("3");
         }

         if ("5".equals(flag)) {
            tCoreDataProject.setFlag("5");
         }

         this.tCoreDataProjectDao.update(tCoreDataProject);
         if (flag.equals("1")) {
            tCorTypeFieldList = this.tCoreEncryptionTypeFieldDao.queryProjectCorTyFieldList(projectId, "5");
         } else {
            List<TCoreEncryptionTypeField> tCorTypeFieldList1 = this.tCoreEncryptionTypeFieldDao.queryProjectCorTyFieldList(projectId, "0");
            List<TCoreEncryptionTypeField> tCorTypeFieldList2 = this.tCoreEncryptionTypeFieldDao.queryProjectCorTyFieldList(projectId, "7");
            List<TCoreEncryptionTypeField> tCorTypeFieldList3 = this.tCoreEncryptionTypeFieldDao.queryProjectCorTyFieldList(projectId, "12");
            if (null != tCorTypeFieldList1 && tCorTypeFieldList1.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList1);
            }

            if (null != tCorTypeFieldList2 && tCorTypeFieldList2.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList2);
            }

            if (null != tCorTypeFieldList3 && tCorTypeFieldList3.size() > 0) {
               tCorTypeFieldList.addAll(tCorTypeFieldList3);
            }
         }

         Map<String, List<TCoreEncryptionTypeField>> collect = (Map)tCorTypeFieldList.stream().collect(Collectors.groupingBy((x) -> x.getDatasystem_id() + "." + x.getTschemas()));
         List<LoadingParameterVO> loadingParameterVOList = (List)collect.keySet().stream().map((key) -> {
            LoadingParameterVO vo = new LoadingParameterVO();
            Map<String, List<TCoreEncryptionTypeField>> groupTabelMap = collect.get(key).stream().collect(Collectors.groupingBy((x) -> x.getNames()));
            List<TableInfoVO> tableList = (List)groupTabelMap.keySet().stream().map((tkey) -> {
               TableInfoVO tableInfoVo = new TableInfoVO();
               tableInfoVo.setTableName(tkey);
               List<TCoreEncryptionTypeField> tCoreEncryptionTypeFields = (List)groupTabelMap.get(tkey);
               List<com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO> columnInfoList = (List)tCoreEncryptionTypeFields.stream().map((x) -> {
                  com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO columnInfoVO = new com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO();
                  String secretKeyId = x.getEncryption_secretkey_id();
                  columnInfoVO.setColumnName(x.getTable_field_id());
                  Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                  columnInfoVO.setEncryptionType((String)encryptionInfo.get("encryptionType"));
                  columnInfoVO.setSecretKey((String)encryptionInfo.get("secretkey"));
                  columnInfoVO.setSecretKeyId(secretKeyId);
                  columnInfoVO.setDataSystemId(x.getDatasystem_id());
                  columnInfoVO.setSchema(x.getTschemas());
                  columnInfoVO.setColumnType(x.getColumn_type());
                  columnInfoVO.setColumnSize(x.getColumn_size());
                  columnInfoVO.setRealitycolumnsize(x.getRealitycolumnsize());
                  columnInfoVO.setEncdigit(x.getEncdigit());
                  columnInfoVO.setKeepfirst(x.getKeepfirst());
                  columnInfoVO.setTwoindex(x.getTwoindex());
                  columnInfoVO.setTcoreencryptionfieldId(x.getId());
                  String describeInfo = "";
                  if (!x.getDescribe_info().equals("") && x.getDescribe_info() != null) {
                     describeInfo = x.getDescribe_info();
                  }

                  String tt = x.getTschemas() + "." + x.getNames() + "." + x.getTable_field_id();
                  HashMap<String, String> ja = new HashMap();
                  ja.put("describe_info", describeInfo);
                  ja.put("encryptionSecretKeyId", secretKeyId);
                  if (flagppp.equals("0")) {
                     ja.put("flag", "1");
                  } else if (flagppp.equals("1")) {
                     ja.put("flag", "0");
                  } else {
                     ja.put("flag", "6");
                  }

                  ja.put("columnType", x.getColumn_type());
                  ja.put("columnSize", x.getColumn_size());
                  HashMap<String, HashMap<String, String>> ttMap = new HashMap();
                  ttMap.put(tt, ja);
                  HashMap<String, Object> tyMap = new HashMap();
                  tyMap.put("datasystemid", x.getDatasystem_id());
                  tyMap.put("map", ttMap);
                  tyMap.put("projectId", projectId);
                  LoadingList.add(tyMap);
                  return columnInfoVO;
               }).collect(Collectors.toList());
               tableInfoVo.setColumnInfo(columnInfoList);
               int qq = columnInfoList.size();
               String qqDataSystemId = "";
               String qqSchema = "";
               if (qq > 0) {
                  qqDataSystemId = ((com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO)columnInfoList.get(0)).getDataSystemId();
                  qqSchema = ((com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO)columnInfoList.get(0)).getSchema();
               }

               EncryptionConfigVO proEncryptionConfigVO = new EncryptionConfigVO();
               proEncryptionConfigVO.setDatasystem_id(qqDataSystemId);
               proEncryptionConfigVO.setSchema(qqSchema);
               proEncryptionConfigVO.setTable_name(tkey);
               proEncryptionConfigVO.setProjectId(projectId);
               List<ColumnInfoVO> proColumnInfoVOList = this.encryptionConfigService.queryOriginalList(proEncryptionConfigVO);
               String primaryKeyColumns = "";
               int pt = proColumnInfoVOList.size();

               for(int y = 0; y < pt; ++y) {
                  String proKey = ((ColumnInfoVO)proColumnInfoVOList.get(y)).getPrimarykey();
                  if (proKey.equals("1")) {
                     primaryKeyColumns = primaryKeyColumns + "," + ((ColumnInfoVO)proColumnInfoVOList.get(y)).getColumnname();
                  }
               }

               if (!primaryKeyColumns.equals("") && primaryKeyColumns != null) {
                  primaryKeyColumns = primaryKeyColumns.substring(1, primaryKeyColumns.length());
                  String[] primaryKeys = primaryKeyColumns.split(",");
                  tableInfoVo.setPrimaryKeys(primaryKeys);
               }

               return tableInfoVo;
            }).collect(Collectors.toList());
            vo.setTableInfo(tableList);
            String dataId = "";
            String sch2 = "";
            int nnn = tableList.size();
            if (nnn > 0) {
               TableInfoVO tableIn = (TableInfoVO)tableList.get(0);
               List<com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO> columnInfoVOList = tableIn.getColumnInfo();
               dataId = ((com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO)columnInfoVOList.get(0)).getDataSystemId();
               sch2 = ((com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO)columnInfoVOList.get(0)).getSchema();
            }

            TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataId)});
            Connection conn = JdbcTool.getConnection(tCoreDatasystem);
            vo.setDataSystemId(dataId);
            vo.settCoreDatasystem(tCoreDatasystem);
            vo.setProjectId(projectId);
            vo.setSchema(sch2);
            return vo;
         }).collect(Collectors.toList());
         if (flag.equals("0")) {
            objectMap = this.doLoadAllTable(loadingParameterVOList);
         } else {
            objectMap = this.doRemoveLoadAllTable(loadingParameterVOList);
         }
      }

      return CollectionUtils.isEmpty(objectMap) ? RespHelper.successResp() : RespHelper.createResp(false, "-1", objectMap.get("checkColumn").toString());
   }

   public boolean checkExtraColumn(Connection conn, String schemaName, String tableName, String columnName, String projectId, String datasystem_id) {
      String initialSuffix = PropertyGhcaUtil.initialSuffix;
      String cipherSuffix = PropertyGhcaUtil.cipherSuffix;
      String copySuffix = PropertyGhcaUtil.copySuffix;
      ResultSet resultSet = JdbcTool.getColumns(conn, schemaName, tableName);
      TCoreEncryptionTypeField t1 = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschemas", schemaName), Restrictions.eq("names", tableName), Restrictions.eq("flag", "5"), Restrictions.eq("table_field_id", columnName)});
      TCoreEncryptionTypeField t2 = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschemas", schemaName), Restrictions.eq("names", tableName), Restrictions.eq("flag", "7"), Restrictions.eq("table_field_id", columnName)});
      TCoreEncryptionTypeField t3 = t1 == null ? t2 : t1;
      if (t3 != null) {
         try {
            while(resultSet.next()) {
               if (resultSet.getString("COLUMN_NAME").equals(t3.getTable_field_id() + copySuffix) && ("0".equals(t3.getFlag()) || "7".equals(t3.getFlag()))) {
                  boolean e = true;
                  return e;
               }
            }

            return false;
         } catch (SQLException e) {
            e.printStackTrace();
            return false;
         } finally {
            if (resultSet != null) {
               try {
                  resultSet.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

         }
      } else {
         return false;
      }
   }

   @RequestMapping({"/checkSingleEncOrDecColumn"})
   @ResponseBody
   public Response checkSingleEncOrDecColumn(@RequestBody LoadingColumnParamVO loadingColumnParamVO, HttpServletRequest request, HttpServletResponse response) throws Exception {
      HashMap<String, Object> resultMap = new HashMap();
      String dataSystemId = loadingColumnParamVO.getDataSystemId();
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      new ArrayList();
      LoadingParameterVO loadingParameterVO = new LoadingParameterVO();
      String projectId = loadingColumnParamVO.getProjectId();
      String schemaName = loadingColumnParamVO.getSchema();
      String tableName = loadingColumnParamVO.getTableName();
      String columnName = loadingColumnParamVO.getColumnName();
      String datasystem_id = loadingColumnParamVO.getDataSystemId();
      String flag = loadingColumnParamVO.getFlag();
      int max = 0;

      try {
         Properties properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String property = properties.getProperty("encryption.field.max");
         if (property != null && property.length() > 0) {
            max = Integer.valueOf(property.trim());
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      if ("0".equals(flag)) {
         if ("ES".equals(tCoreDatasystem.getDbtype())) {
            return RespHelper.successResp();
         } else {
            if (!"MONGODB".equals(tCoreDatasystem.getDbtype())) {
               Connection conn = JdbcTool.getConnection(tCoreDatasystem);
               loadingParameterVO.setConnection(conn);
               if (!"HIVE_TDH".equals(tCoreDatasystem.getDbtype()) && !"HIVE".equals(tCoreDatasystem.getDbtype())) {
                  boolean exist = this.checkExtraColumn(conn, loadingColumnParamVO.getSchema(), loadingColumnParamVO.getTableName(), loadingColumnParamVO.getColumnName(), loadingColumnParamVO.getProjectId(), loadingColumnParamVO.getDataSystemId());
                  if (exist) {
                     return RespHelper.errResp(ErrCode.REDUNDANCE_COLUMN);
                  }
               }
            } else {
               try {
                  MongoClient connect = MongodbTool.connect(tCoreDatasystem.getDbservername(), tCoreDatasystem.getUsername(), AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca"), tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), true);
                  List<Column> columnList = MongodbTool.findAllColumns(connect, loadingColumnParamVO.getSchema(), loadingColumnParamVO.getTableName());
                  List<String> stringList = (List)columnList.stream().map(Column::getColumnName).collect(Collectors.toList());
                  TCoreEncryptionTypeField t1 = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschemas", schemaName), Restrictions.eq("names", tableName), Restrictions.eq("flag", "5"), Restrictions.eq("table_field_id", columnName)});
                  TCoreEncryptionTypeField t2 = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschemas", schemaName), Restrictions.eq("names", tableName), Restrictions.eq("flag", "7"), Restrictions.eq("table_field_id", columnName)});
                  TCoreEncryptionTypeField t3 = t1 == null ? t2 : t1;
                  if (stringList.contains(t3.getTable_field_id() + PropertyGhcaUtil.copySuffix) && ("0".equals(t3.getFlag()) || "7".equals(t3.getFlag()))) {
                     return RespHelper.errResp(ErrCode.REDUNDANCE_COLUMN);
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }

            TCoreEncryptionTypeField tCoreEncryptionTypeField = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", loadingColumnParamVO.getProjectId()), Restrictions.eq("datasystem_id", loadingColumnParamVO.getDataSystemId()), Restrictions.eq("tschemas", loadingColumnParamVO.getSchema()), Restrictions.eq("names", loadingColumnParamVO.getTableName()), Restrictions.eq("table_field_id", loadingColumnParamVO.getColumnName())});
            if (tCoreEncryptionTypeField.getColumn_type().equalsIgnoreCase("TEXT")) {
               return RespHelper.successResp();
            } else if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
               return RespHelper.successResp();
            } else {
               if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                  TableRuleInfo hiveStoreInfo = this.tableRuleService.getHiveStoreInfo(projectId, dataSystemId, schemaName, tableName);
                  if (hiveStoreInfo != null && hiveStoreInfo.getType() == HiveEncDecType.webHdfs) {
                     return RespHelper.successResp();
                  }
               } else if ("HIVE".equals(tCoreDatasystem.getDbtype())) {
                  return RespHelper.successResp();
               }

               String columnSize = tCoreEncryptionTypeField.getColumn_size();
               String primaryKeyFlag = "0";
               if (max > 0 && Integer.parseInt(columnSize) >= max) {
                  columnSize = String.valueOf(max);
               } else {
                  Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(tCoreEncryptionTypeField.getEncryption_secretkey_id());
                  columnSize = EncUtils.strColumnSize(tCoreDatasystem.getDbtype(), tCoreEncryptionTypeField.getColumn_type(), columnSize, tCoreEncryptionTypeField.getIslike(), primaryKeyFlag, (String)encryptionInfo.get("encryptionType"));
               }

               NewLoadingTask newLoadingTask = new NewLoadingTask(tCoreDatasystem, tCoreEncryptionTypeField.getColumn_type(), columnSize);
               long columnsCheckLength = newLoadingTask.getColumnsCheckLength(tCoreDatasystem.getDbtype(), schemaName, tableName);
               int columnLength = Integer.parseInt(columnSize);
               resultMap = newLoadingTask.checkTableColumnLength(resultMap, tCoreDatasystem.getDbtype(), columnName, columnsCheckLength, columnLength);
               return CollectionUtils.isEmpty(resultMap) ? RespHelper.successResp() : RespHelper.createResp(false, "-1", resultMap.get("checkColumn").toString());
            }
         }
      } else {
         return RespHelper.successResp();
      }
   }

   @RequestMapping({"/checkCanReload"})
   @ResponseBody
   public Response checkCanReload(@RequestBody LoadingColumnParamVO loadingColumnParamVO, HttpServletRequest request, HttpServletResponse response) throws Exception {
      HashMap<String, Object> resultMap = new HashMap();
      String dataSystemId = loadingColumnParamVO.getDataSystemId();
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      String schema = loadingColumnParamVO.getSchema();
      String tableName = loadingColumnParamVO.getTableName();
      String columnName = loadingColumnParamVO.getColumnName();
      if ("ES".equals(tCoreDatasystem.getDbtype())) {
         ClientInterface connect = null;

         try {
            connect = GHCAUtils.getInstance().connectToES(tCoreDatasystem.getDbip(), tCoreDatasystem.getDbport(), tCoreDatasystem.getUsername(), AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca"));
         } catch (Exception e) {
            e.printStackTrace();
         }

         EsUtil esUtil = new EsUtil();
         Map<String, ArrayList> data = esUtil.getDataByClientQueryParam(connect, schema, tableName, columnName, PropertyGhcaUtil.encryptionlabel);
         List<String> results = new ArrayList();
         ArrayList arrayList = (ArrayList)data.get(columnName);
         if (null == arrayList) {
            resultMap.put(CHECK_COLUMN, COLUMN_ALL_ENCRYPTED);
         } else {
            for(Object o : arrayList) {
               if (o instanceof String) {
                  results.add((String)o);
               }
            }

            if (results.size() == 0) {
               resultMap.put(CHECK_COLUMN, COLUMN_ALL_ENCRYPTED);
            }
         }
      } else {
         try {
            Connection conn = JdbcTool.getConnection(tCoreDatasystem);
            Throwable var77 = null;

            try {
               Statement stmt = conn.createStatement();
               Throwable var79 = null;

               try {
                  ResultSet rsC = null;

                  try {
                     if (!EdbType.ORACLE.toString().equals(tCoreDatasystem.getDbtype()) && !EdbType.POSTGRESQL.toString().equals(tCoreDatasystem.getDbtype()) && !EdbType.GREENPLUM.toString().equals(tCoreDatasystem.getDbtype()) && !EdbType.DM.toString().equals(tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equals(tCoreDatasystem.getDbtype()) && !EdbType.GAUSS.toString().equals(tCoreDatasystem.getDbtype())) {
                        if (EdbType.MYSQL.toString().equals(tCoreDatasystem.getDbtype()) || EdbType.MSSQLSERVER.toString().equals(tCoreDatasystem.getDbtype()) || EdbType.HIVE.toString().equals(tCoreDatasystem.getDbtype()) || EdbType.HIVE_TDH.toString().equals(tCoreDatasystem.getDbtype())) {
                           rsC = stmt.executeQuery("SELECT count(1) AS num FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND " + columnName + " NOT LIKE '%" + PropertyGhcaUtil.encryptionlabel + "%'");
                        }
                     } else {
                        rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\"IS NOT NULL AND \"" + columnName + "\" NOT LIKE '%" + PropertyGhcaUtil.encryptionlabel + "%'");
                     }

                     int num;
                     for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                     }

                     if (num == 0) {
                        resultMap.put(CHECK_COLUMN, COLUMN_ALL_ENCRYPTED);
                     }
                  } catch (Exception e) {
                     e.printStackTrace();
                  } finally {
                     if (rsC != null) {
                        try {
                           rsC.close();
                        } catch (SQLException e) {
                           e.printStackTrace();
                        }
                     }

                  }
               } catch (Throwable var71) {
                  var79 = var71;
                  throw var71;
               } finally {
                  if (stmt != null) {
                     if (var79 != null) {
                        try {
                           stmt.close();
                        } catch (Throwable var66) {
                           var79.addSuppressed(var66);
                        }
                     } else {
                        stmt.close();
                     }
                  }

               }
            } catch (Throwable var73) {
               var77 = var73;
               throw var73;
            } finally {
               if (conn != null) {
                  if (var77 != null) {
                     try {
                        conn.close();
                     } catch (Throwable var65) {
                        var77.addSuppressed(var65);
                     }
                  } else {
                     conn.close();
                  }
               }

            }
         } catch (SQLException throwables) {
            throwables.printStackTrace();
         }
      }

      return CollectionUtils.isEmpty(resultMap) ? RespHelper.successResp() : RespHelper.createResp(false, "-1", resultMap.get("checkColumn").toString());
   }

   @EncryptLog
   @RequestMapping({"/loadingColumn"})
   @ResponseBody
   public Response loadingColumn(@RequestBody LoadingColumnParamVO loadingColumnParamVO, HttpServletRequest request, HttpServletResponse response) throws Exception {
      String dataSystemId = loadingColumnParamVO.getDataSystemId();
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      new ArrayList();
      LoadingParameterVO loadingParameterVO = new LoadingParameterVO();
      loadingParameterVO.setDataSystemId(dataSystemId);
      loadingParameterVO.settCoreDatasystem(tCoreDatasystem);
      loadingParameterVO.setProjectId(loadingColumnParamVO.getProjectId());
      loadingParameterVO.setSchema(loadingColumnParamVO.getSchema());
      TableInfoVO tableInfoVO = new TableInfoVO();
      tableInfoVO.setTableName(loadingColumnParamVO.getTableName());
      tableInfoVO.setPrimaryKeys(loadingColumnParamVO.getPrimaryKeys());
      com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO columnInfoVO = new com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO();
      columnInfoVO.setColumnName(loadingColumnParamVO.getColumnName());
      Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(loadingColumnParamVO.getSecretKeyId());
      TCoreEncryptionTypeField tCoreEncryptionTypeField = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", loadingColumnParamVO.getProjectId()), Restrictions.eq("datasystem_id", loadingColumnParamVO.getDataSystemId()), Restrictions.eq("tschemas", loadingColumnParamVO.getSchema()), Restrictions.eq("names", loadingColumnParamVO.getTableName()), Restrictions.eq("table_field_id", loadingColumnParamVO.getColumnName())});
      columnInfoVO.setEncryptionType((String)encryptionInfo.get("encryptionType"));
      columnInfoVO.setSecretKey((String)encryptionInfo.get("secretkey"));
      columnInfoVO.setSecretKeyId(loadingColumnParamVO.getSecretKeyId());
      columnInfoVO.setColumnType(loadingColumnParamVO.getColumnType());
      columnInfoVO.setColumnSize(tCoreEncryptionTypeField.getColumn_size());
      columnInfoVO.setRealitycolumnsize(tCoreEncryptionTypeField.getRealitycolumnsize());
      columnInfoVO.setIsLike(tCoreEncryptionTypeField.getIslike());
      columnInfoVO.setEncdigit(tCoreEncryptionTypeField.getEncdigit());
      columnInfoVO.setKeepfirst(tCoreEncryptionTypeField.getKeepfirst());
      columnInfoVO.setTwoindex(tCoreEncryptionTypeField.getTwoindex());
      columnInfoVO.setTcoreencryptionfieldId(tCoreEncryptionTypeField.getId());
      List<com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO> columnInfoVOList = new ArrayList();
      columnInfoVOList.add(columnInfoVO);
      tableInfoVO.setColumnInfo(columnInfoVOList);
      List<TableInfoVO> tableInfoVOList = new ArrayList();
      tableInfoVOList.add(tableInfoVO);
      loadingParameterVO.setTableInfo(tableInfoVOList);
      List<LoadingParameterVO> LoadingParameterVOList = new ArrayList();
      LoadingParameterVOList.add(loadingParameterVO);
      Map<String, Object> objectMap = this.doLoadingAllTable(LoadingParameterVOList);
      return CollectionUtils.isEmpty(objectMap) ? RespHelper.successResp() : RespHelper.createResp(false, "-1", objectMap.get("checkColumn").toString());
   }

   @EncryptLog
   @RequestMapping({"/reloadingColumn"})
   @ResponseBody
   public Response reloadingColumn(@RequestBody LoadingColumnParamVO loadingColumnParamVO, HttpServletRequest request, HttpServletResponse response) {
      String dataSystemId = loadingColumnParamVO.getDataSystemId();
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      Connection conn = JdbcTool.getConnection(tCoreDatasystem);
      new ArrayList();
      LoadingParameterVO loadingParameterVO = new LoadingParameterVO();
      loadingParameterVO.setDataSystemId(dataSystemId);
      loadingParameterVO.setConnection(conn);
      loadingParameterVO.settCoreDatasystem(tCoreDatasystem);
      loadingParameterVO.setProjectId(loadingColumnParamVO.getProjectId());
      loadingParameterVO.setSchema(loadingColumnParamVO.getSchema());
      TableInfoVO tableInfoVO = new TableInfoVO();
      tableInfoVO.setTableName(loadingColumnParamVO.getTableName());
      tableInfoVO.setPrimaryKeys(loadingColumnParamVO.getPrimaryKeys());
      com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO columnInfoVO = new com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO();
      columnInfoVO.setColumnName(loadingColumnParamVO.getColumnName());
      Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(loadingColumnParamVO.getSecretKeyId());
      TCoreEncryptionTypeField tCoreEncryptionTypeField = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", loadingColumnParamVO.getProjectId()), Restrictions.eq("datasystem_id", loadingColumnParamVO.getDataSystemId()), Restrictions.eq("tschemas", loadingColumnParamVO.getSchema()), Restrictions.eq("names", loadingColumnParamVO.getTableName()), Restrictions.eq("table_field_id", loadingColumnParamVO.getColumnName())});
      columnInfoVO.setEncryptionType((String)encryptionInfo.get("encryptionType"));
      columnInfoVO.setSecretKey((String)encryptionInfo.get("secretkey"));
      columnInfoVO.setSecretKeyId(loadingColumnParamVO.getSecretKeyId());
      columnInfoVO.setColumnType(loadingColumnParamVO.getColumnType());
      columnInfoVO.setColumnSize(tCoreEncryptionTypeField.getColumn_size());
      columnInfoVO.setRealitycolumnsize(tCoreEncryptionTypeField.getRealitycolumnsize());
      columnInfoVO.setIsLike(tCoreEncryptionTypeField.getIslike());
      columnInfoVO.setEncdigit(tCoreEncryptionTypeField.getEncdigit());
      columnInfoVO.setKeepfirst(tCoreEncryptionTypeField.getKeepfirst());
      columnInfoVO.setTwoindex(tCoreEncryptionTypeField.getTwoindex());
      List<com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO> columnInfoVOList = new ArrayList();
      columnInfoVOList.add(columnInfoVO);
      tableInfoVO.setColumnInfo(columnInfoVOList);
      List<TableInfoVO> tableInfoVOList = new ArrayList();
      tableInfoVOList.add(tableInfoVO);
      loadingParameterVO.setTableInfo(tableInfoVOList);
      List<LoadingParameterVO> LoadingParameterVOList = new ArrayList();
      LoadingParameterVOList.add(loadingParameterVO);
      Map<String, Object> objectMap = this.doReloadingAllTable(LoadingParameterVOList);
      return CollectionUtils.isEmpty(objectMap) ? RespHelper.successResp() : RespHelper.createResp(false, "-1", objectMap.get("checkColumn").toString());
   }

   private Map<String, Object> doLoadAllTable(List<LoadingParameterVO> LoadingParameterList) {
      Map<String, Object> resultMap = new HashMap();

      try {
         int taskCount = 0;

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            taskCount += loadingParameterVO.getTableInfo().size();
         }

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            String projectId = loadingParameterVO.getProjectId();
            String dataSystemId = loadingParameterVO.getDataSystemId();
            Connection connection = loadingParameterVO.getConnection();
            TCoreDatasystem tCoreDatasystem = loadingParameterVO.gettCoreDatasystem();
            String schema = loadingParameterVO.getSchema();

            for(TableInfoVO tableInfoVO : loadingParameterVO.getTableInfo()) {
               EncryptionConfigVO vo = new EncryptionConfigVO();
               vo.setDatasystem_id(dataSystemId);
               vo.setSchema(schema);
               vo.setTable_name(tableInfoVO.getTableName());
               vo.setProjectid(projectId);
               List<ColumnInfoVO> allColumnList = this.encryptionConfigService.queryOriginalList(vo);
               List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("project_id", loadingParameterVO.getProjectId()), Restrictions.eq("datasystem_id", loadingParameterVO.getDataSystemId()), Restrictions.eq("tschema", loadingParameterVO.getSchema()), Restrictions.eq("tname", tableInfoVO.getTableName())});
               List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(dataSystemId, schema, tableInfoVO.getTableName());
               if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit(new MongoDBLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
               } else if ("ES".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit(new ElasticSearchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false, "0", (CountDownLatch)null));
               } else if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                  TableRuleInfo hiveStoreInfo = this.tableRuleService.getHiveStoreInfo(projectId, dataSystemId, schema, tableInfoVO.getTableName());
                  if (hiveStoreInfo != null && hiveStoreInfo.getType() == HiveEncDecType.webHdfs) {
                     this.taskExecutor.submit(new HdfsLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
                  } else {
                     this.taskExecutor.submit(new NewLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
                  }
               } else if ("HIVE".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit(new HiveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
               } else {
                  this.taskExecutor.submit(new NewLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         Iterator var20 = LoadingParameterList.iterator();

         while(true) {
            if (!var20.hasNext()) {
               ;
            } else {
               LoadingParameterVO loadingParameterVO = (LoadingParameterVO)var20.next();
               if (null != loadingParameterVO.getConnection()) {
                  try {
                     loadingParameterVO.getConnection().close();
                  } catch (SQLException e) {
                     e.printStackTrace();
                  }
               }

               if (null != loadingParameterVO.getProjectId() && !loadingParameterVO.getProjectId().equals("")) {
                  TCoreDataProject tCoreDataProject = (TCoreDataProject)this.tCoreDataProjectDao.queryUnique(new Criterion[]{Restrictions.eq("id", loadingParameterVO.getProjectId())});
                  tCoreDataProject.setFlag("1");
                  this.tCoreDataProjectDao.update(tCoreDataProject);
               }
            }
         }
      }

   }

   private Map<String, Object> doLoadingAllTable(List<LoadingParameterVO> LoadingParameterList) {
      HashMap<String, Object> resultMap = new HashMap<String, Object>();
      try {
         int taskCount = 0;
         for (LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            taskCount += loadingParameterVO.getTableInfo().size();
         }
         for (LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            String projectId = loadingParameterVO.getProjectId();
            String dataSystemId = loadingParameterVO.getDataSystemId();
            Connection connection = loadingParameterVO.getConnection();
            TCoreDatasystem tCoreDatasystem = loadingParameterVO.gettCoreDatasystem();
            String schema = loadingParameterVO.getSchema();
            List<TableInfoVO> tableInfo = loadingParameterVO.getTableInfo();
            for (TableInfoVO tableInfoVO : tableInfo) {
               EncryptionConfigVO vo = new EncryptionConfigVO();
               vo.setDatasystem_id(dataSystemId);
               vo.setSchema(schema);
               vo.setTable_name(tableInfoVO.getTableName());
               vo.setProjectid(projectId);
               List allColumnList = this.encryptionConfigService.queryOriginalList(vo);
               List columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq((String)"project_id", (Object)loadingParameterVO.getProjectId()), Restrictions.eq((String)"datasystem_id", (Object)loadingParameterVO.getDataSystemId()), Restrictions.eq((String)"tschema", (Object)loadingParameterVO.getSchema()), Restrictions.eq((String)"tname", (Object)tableInfoVO.getTableName())});
               List allColumns = this.maksingAppDataRuleService.queryColumnInfo(dataSystemId, schema, tableInfoVO.getTableName());
               if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit((Runnable)new MongoDBLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
                  continue;
               }
               if ("ES".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit((Runnable)new ElasticSearchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false, "0", null));
                  continue;
               }
               if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                  TableRuleInfo hiveStoreInfo = this.tableRuleService.getHiveStoreInfo(projectId, dataSystemId, schema, tableInfoVO.getTableName());
                  if (hiveStoreInfo != null && hiveStoreInfo.getType() == HiveEncDecType.webHdfs) {
                     this.taskExecutor.submit((Runnable)new HdfsLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
                     continue;
                  }
                  this.taskExecutor.submit((Runnable)new NewLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
                  continue;
               }
               if ("HIVE".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit((Runnable)new HiveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
                  continue;
               }
               this.taskExecutor.submit((Runnable)new NewLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
            }
         }
      }
      catch (Exception e) {
         e.printStackTrace();
      }
      finally {
         for (LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            if (null == loadingParameterVO.getConnection()) continue;
            try {
               loadingParameterVO.getConnection().close();
            }
            catch (SQLException e) {
               e.printStackTrace();
            }
         }
      }
      return resultMap;
   }

   private Map<String, Object> doReloadingAllTable(List<LoadingParameterVO> LoadingParameterList) {
      HashMap<String, Object> resultMap = new HashMap<String, Object>();
      try {
         int taskCount = 0;
         for (LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            taskCount += loadingParameterVO.getTableInfo().size();
         }
         for (LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            String projectId = loadingParameterVO.getProjectId();
            String dataSystemId = loadingParameterVO.getDataSystemId();
            Connection connection = loadingParameterVO.getConnection();
            TCoreDatasystem tCoreDatasystem = loadingParameterVO.gettCoreDatasystem();
            String schema = loadingParameterVO.getSchema();
            List<TableInfoVO> tableInfo = loadingParameterVO.getTableInfo();
            for (TableInfoVO tableInfoVO : tableInfo) {
               EncryptionConfigVO vo = new EncryptionConfigVO();
               vo.setDatasystem_id(dataSystemId);
               vo.setSchema(schema);
               vo.setTable_name(tableInfoVO.getTableName());
               vo.setProjectid(projectId);
               List allColumnList = this.encryptionConfigService.queryOriginalList(vo);
               List columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq((String)"project_id", (Object)loadingParameterVO.getProjectId()), Restrictions.eq((String)"datasystem_id", (Object)loadingParameterVO.getDataSystemId()), Restrictions.eq((String)"tschema", (Object)loadingParameterVO.getSchema()), Restrictions.eq((String)"tname", (Object)tableInfoVO.getTableName())});
               List allColumns = this.maksingAppDataRuleService.queryColumnInfo(dataSystemId, schema, tableInfoVO.getTableName());
               if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit((Runnable)new MongoDBLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, true));
                  continue;
               }
               if ("ES".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit((Runnable)new ElasticSearchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, true, "0", null));
                  continue;
               }
               if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                  TableRuleInfo hiveStoreInfo = this.tableRuleService.getHiveStoreInfo(projectId, dataSystemId, schema, tableInfoVO.getTableName());
                  if (hiveStoreInfo != null && hiveStoreInfo.getType() == HiveEncDecType.webHdfs) {
                     this.taskExecutor.submit((Runnable)new HdfsLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, true));
                     continue;
                  }
                  this.taskExecutor.submit((Runnable)new NewLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, true));
                  continue;
               }
               if ("HIVE".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit((Runnable)new HiveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, false));
                  continue;
               }
               this.taskExecutor.submit((Runnable)new NewLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), allColumns, columnPrimaryKeyInfoList, allColumnList, true));
            }
         }
      }
      catch (Exception e) {
         e.printStackTrace();
      }
      finally {
         for (LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            if (null == loadingParameterVO.getConnection()) continue;
            try {
               loadingParameterVO.getConnection().close();
            }
            catch (SQLException e) {
               e.printStackTrace();
            }
         }
      }
      return resultMap;
   }

   private Map<String, Object> doLoadingBatchTable(List<LoadingParameterVO> LoadingParameterList) {
      Map<String, Object> resultMap = new HashMap();

      try {
         int taskCount = 0;

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            taskCount += loadingParameterVO.getTableInfo().size();
         }

         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         int countdownNum = 0;

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            countdownNum += loadingParameterVO.getTableInfo().size();
         }

         new ArrayList();
         CountDownLatch countDownLatch = new CountDownLatch(countdownNum);

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            try {
               String projectId = loadingParameterVO.getProjectId();
               String dataSystemId = loadingParameterVO.getDataSystemId();
               Connection connection = loadingParameterVO.getConnection();
               TCoreDatasystem tCoreDatasystem = loadingParameterVO.gettCoreDatasystem();
               String schema = loadingParameterVO.getSchema();

               for(TableInfoVO tableInfoVO : loadingParameterVO.getTableInfo()) {
                  try {
                     List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("project_id", loadingParameterVO.getProjectId()), Restrictions.eq("datasystem_id", loadingParameterVO.getDataSystemId()), Restrictions.eq("tschema", loadingParameterVO.getSchema()), Restrictions.eq("tname", tableInfoVO.getTableName())});
                     this.taskExecutor.setCorePoolSize(Integer.valueOf(props.getProperty("corePoolSize")));
                     this.taskExecutor.setMaxPoolSize(Integer.valueOf(props.getProperty("maxPoolSize")));
                     this.taskExecutor.setQueueCapacity(Integer.valueOf(props.getProperty("queueCapacity")));
                     EncryptionConfigVO vo = new EncryptionConfigVO();
                     vo.setDatasystem_id(dataSystemId);
                     vo.setSchema(schema);
                     vo.setTable_name(tableInfoVO.getTableName());
                     vo.setProjectid(projectId);
                     List<ColumnInfoVO> allColumnList = this.encryptionConfigService.queryOriginalList(vo);
                     String loggerPath = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + projectId + File.separator + dataSystemId;
                     (new LoggerBuilder()).getLogger(loggerPath, schema + "." + tableInfoVO.getTableName());
                     if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
                        this.taskExecutor.submit(new MongoDBLoadingBatchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), countDownLatch, columnPrimaryKeyInfoList, allColumnList));
                     } else if ("ES".equals(tCoreDatasystem.getDbtype())) {
                        this.taskExecutor.submit(new ElasticSearchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), (List)null, columnPrimaryKeyInfoList, allColumnList, false, "0", countDownLatch));
                     } else if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                        TableRuleInfo hiveStoreInfo = this.tableRuleService.getHiveStoreInfo(projectId, dataSystemId, schema, tableInfoVO.getTableName());
                        if (hiveStoreInfo != null && hiveStoreInfo.getType() == HiveEncDecType.webHdfs) {
                           this.taskExecutor.submit(new HdfsLoadingBatchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), countDownLatch, columnPrimaryKeyInfoList, allColumnList));
                        } else {
                           this.taskExecutor.submit(new NewLoadingBatchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), countDownLatch, columnPrimaryKeyInfoList, allColumnList));
                        }
                     } else if ("HIVE".equals(tCoreDatasystem.getDbtype())) {
                        this.taskExecutor.submit(new HiveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), (List)null, columnPrimaryKeyInfoList, allColumnList, false));
                     } else {
                        this.taskExecutor.submit(new NewLoadingBatchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), countDownLatch, columnPrimaryKeyInfoList, allColumnList));
                     }
                  } catch (Exception e) {
                     e.printStackTrace();
                     countDownLatch.countDown();
                  }
               }
            } catch (Exception e) {
               e.printStackTrace();

               for(int i = 0; i < loadingParameterVO.getTableInfo().size(); ++i) {
                  countDownLatch.countDown();
               }
            }
         }

         countDownLatch.await();
         if (LoadingParameterList != null && LoadingParameterList.size() > 0) {
            for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
               this.encryptionProxyService.noticeProxyFetchEngineAndMaskingInfosByProject(loadingParameterVO.getProjectId());
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         Iterator var25 = LoadingParameterList.iterator();

         while(true) {
            if (!var25.hasNext()) {
               ;
            } else {
               LoadingParameterVO loadingParameterVO = (LoadingParameterVO)var25.next();
               if (null != loadingParameterVO.getConnection()) {
                  try {
                     loadingParameterVO.getConnection().close();
                  } catch (SQLException e) {
                     e.printStackTrace();
                  }
               }
            }
         }
      }

   }

   private Map<String, Object> doRemoveLoadAllBatchTable(List<LoadingParameterVO> LoadingParameterList) {
      Map<String, Object> resultMap = new HashMap();

      try {
         HashSet<ColumnEncryption> columnSet = null;
         int corePoolSize = 1;
         int cpuCount = Runtime.getRuntime().availableProcessors();
         int maximumPoolSize = Math.round((float)cpuCount);
         long keepAliveTime = 5000L;
         int taskCapacity = 2000;
         int taskCount = 0;
         ThreadPoolExecutor loadingExecutor = null;
         new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(taskCapacity), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            taskCount += loadingParameterVO.getTableInfo().size();
         }

         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         int countdownNum = 0;

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            TCoreDatasystem tCoreDatasystem = loadingParameterVO.gettCoreDatasystem();
            countdownNum += loadingParameterVO.getTableInfo().size();
         }

         CountDownLatch countDownLatch = new CountDownLatch(countdownNum);
         new ArrayList();

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            try {
               String projectId = loadingParameterVO.getProjectId();
               String dataSystemId = loadingParameterVO.getDataSystemId();
               Connection connection = loadingParameterVO.getConnection();
               TCoreDatasystem tCoreDatasystem = loadingParameterVO.gettCoreDatasystem();
               String schema = loadingParameterVO.getSchema();

               for(TableInfoVO tableInfoVO : loadingParameterVO.getTableInfo()) {
                  try {
                     List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("project_id", loadingParameterVO.getProjectId()), Restrictions.eq("datasystem_id", loadingParameterVO.getDataSystemId()), Restrictions.eq("tschema", loadingParameterVO.getSchema()), Restrictions.eq("tname", tableInfoVO.getTableName())});
                     EncryptionConfigVO vo = new EncryptionConfigVO();
                     vo.setDatasystem_id(dataSystemId);
                     vo.setSchema(schema);
                     vo.setTable_name(tableInfoVO.getTableName());
                     vo.setProjectid(projectId);
                     List<ColumnInfoVO> allColumnList = this.encryptionConfigService.queryOriginalList(vo);
                     this.taskExecutor.setCorePoolSize(Integer.valueOf(props.getProperty("corePoolSize")));
                     this.taskExecutor.setMaxPoolSize(Integer.valueOf(props.getProperty("maxPoolSize")));
                     this.taskExecutor.setQueueCapacity(Integer.valueOf(props.getProperty("queueCapacity")));
                     if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
                        this.taskExecutor.submit(new MongoDBRemoveLoadingBatchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), countDownLatch, columnPrimaryKeyInfoList, allColumnList));
                     } else if ("ES".equals(tCoreDatasystem.getDbtype())) {
                        this.taskExecutor.submit(new ElasticSearchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), (List)null, columnPrimaryKeyInfoList, allColumnList, false, "1", countDownLatch));
                     } else if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                        TableRuleInfo hiveStoreInfo = this.tableRuleService.getHiveStoreInfo(projectId, dataSystemId, schema, tableInfoVO.getTableName());
                        if (hiveStoreInfo != null && hiveStoreInfo.getType() == HiveEncDecType.webHdfs) {
                           this.taskExecutor.submit(new HdfsRemoveLoadingBatchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), countDownLatch, columnPrimaryKeyInfoList, allColumnList));
                        } else {
                           this.taskExecutor.submit(new NewRemoveLoadingBatchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), countDownLatch, columnPrimaryKeyInfoList, allColumnList));
                        }
                     } else if ("HIVE".equals(tCoreDatasystem.getDbtype())) {
                        this.taskExecutor.submit(new HiveRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
                     } else {
                        this.taskExecutor.submit(new NewRemoveLoadingBatchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), countDownLatch, columnPrimaryKeyInfoList, allColumnList));
                     }
                  } catch (Exception var45) {
                     countDownLatch.countDown();
                  }
               }
            } catch (Exception var46) {
               List<TableInfoVO> tableInfo = loadingParameterVO.getTableInfo();
               if (tableInfo != null && tableInfo.size() > 0) {
                  tableInfo.forEach((x) -> countDownLatch.countDown());
               }
            }
         }

         countDownLatch.await();
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         Iterator var32 = LoadingParameterList.iterator();

         while(true) {
            if (!var32.hasNext()) {
               ;
            } else {
               LoadingParameterVO loadingParameterVO = (LoadingParameterVO)var32.next();
               if (null != loadingParameterVO.getConnection()) {
                  try {
                     loadingParameterVO.getConnection().close();
                  } catch (SQLException e) {
                     e.printStackTrace();
                  }
               }
            }
         }
      }

   }

   @EncryptLog
   @RequestMapping({"/removeLoadingColumn"})
   @ResponseBody
   public Response removeLoadingColumn(@RequestBody LoadingColumnParamVO loadingColumnParamVO, HttpServletRequest request, HttpServletResponse response) {
      String dataSystemId = loadingColumnParamVO.getDataSystemId();
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      Connection conn = JdbcTool.getConnection(tCoreDatasystem);
      new ArrayList();
      LoadingParameterVO loadingParameterVO = new LoadingParameterVO();
      loadingParameterVO.setDataSystemId(dataSystemId);
      loadingParameterVO.setConnection(conn);
      loadingParameterVO.settCoreDatasystem(tCoreDatasystem);
      loadingParameterVO.setProjectId(loadingColumnParamVO.getProjectId());
      loadingParameterVO.setSchema(loadingColumnParamVO.getSchema());
      TableInfoVO tableInfoVO = new TableInfoVO();
      tableInfoVO.setTableName(loadingColumnParamVO.getTableName());
      tableInfoVO.setPrimaryKeys(loadingColumnParamVO.getPrimaryKeys());
      com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO columnInfoVO = new com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO();
      columnInfoVO.setColumnName(loadingColumnParamVO.getColumnName());
      Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(loadingColumnParamVO.getSecretKeyId());
      TCoreEncryptionTypeField tCoreEncryptionTypeField = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", loadingColumnParamVO.getProjectId()), Restrictions.eq("datasystem_id", loadingColumnParamVO.getDataSystemId()), Restrictions.eq("tschemas", loadingColumnParamVO.getSchema()), Restrictions.eq("names", loadingColumnParamVO.getTableName()), Restrictions.eq("table_field_id", loadingColumnParamVO.getColumnName())});
      columnInfoVO.setEncryptionType((String)encryptionInfo.get("encryptionType"));
      columnInfoVO.setSecretKey((String)encryptionInfo.get("secretkey"));
      columnInfoVO.setSecretKeyId(loadingColumnParamVO.getSecretKeyId());
      columnInfoVO.setColumnType(loadingColumnParamVO.getColumnType());
      columnInfoVO.setColumnSize(tCoreEncryptionTypeField.getColumn_size());
      columnInfoVO.setRealitycolumnsize(tCoreEncryptionTypeField.getRealitycolumnsize());
      columnInfoVO.setIsLike(tCoreEncryptionTypeField.getIslike());
      columnInfoVO.setKeepfirst(tCoreEncryptionTypeField.getKeepfirst());
      columnInfoVO.setEncdigit(tCoreEncryptionTypeField.getEncdigit());
      columnInfoVO.setTwoindex(tCoreEncryptionTypeField.getTwoindex());
      columnInfoVO.setTcoreencryptionfieldId(tCoreEncryptionTypeField.getId());
      List<com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO> columnInfoVOList = new ArrayList();
      columnInfoVOList.add(columnInfoVO);
      tableInfoVO.setColumnInfo(columnInfoVOList);
      List<TableInfoVO> tableInfoVOList = new ArrayList();
      tableInfoVOList.add(tableInfoVO);
      loadingParameterVO.setTableInfo(tableInfoVOList);
      List<LoadingParameterVO> LoadingParameterVOList = new ArrayList();
      LoadingParameterVOList.add(loadingParameterVO);
      Map<String, Object> objectMap = this.doRemoveLoadingAllTable(LoadingParameterVOList);
      return CollectionUtils.isEmpty(objectMap) ? RespHelper.successResp() : RespHelper.createResp(false, "-1", objectMap.get("checkColumn").toString());
   }

   @EncryptLog
   @RequestMapping({"/replaceColumn"})
   @ResponseBody
   public Response replaceColumn(@RequestBody ReplaceColumnParamVO replaceColumnParamVO, HttpServletRequest request, HttpServletResponse response) throws SQLException {
      String loggerPath = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + replaceColumnParamVO.getProjectId() + File.separator + replaceColumnParamVO.getDataSystemId();
      Logger logger = (new LoggerBuilder()).getLogger(loggerPath, replaceColumnParamVO.getSchema() + "." + replaceColumnParamVO.getTableName());
      String flag = replaceColumnParamVO.getFlag();
      String primaryKeyFlag = "0";
      String primary_key_col = "";
      String primary_key_columns = "";
      List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(replaceColumnParamVO.getDataSystemId(), replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName());

      for(ColumnInfoVO allColumn : allColumns) {
         if (allColumn.getPrimarykey().equals("1")) {
            primary_key_col = "\"" + primary_key_columns + allColumn.getColumnname() + "\",";
            primary_key_columns = primary_key_columns + allColumn.getColumnname() + ",";
         }
      }

      if (!"".equals(primary_key_col) && primary_key_col.charAt(primary_key_col.length() - 1) == ',') {
         primary_key_col = primary_key_col.substring(0, primary_key_col.length() - 1);
      }

      if (!"".equals(primary_key_columns)) {
         if (primary_key_columns.charAt(primary_key_columns.length() - 1) == ',') {
            primary_key_columns = primary_key_columns.substring(0, primary_key_columns.length() - 1);
         }

         String[] fileds = primary_key_columns.split(",");
         if (fileds.length > 0) {
            for(String filed : fileds) {
               if (replaceColumnParamVO.getColumnName().equals(filed)) {
                  primaryKeyFlag = "1";
               }
            }
         }
      }

      boolean ispk = false;
      List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("project_id", replaceColumnParamVO.getProjectId()), Restrictions.eq("datasystem_id", replaceColumnParamVO.getDataSystemId()), Restrictions.eq("tschema", replaceColumnParamVO.getSchema()), Restrictions.eq("tname", replaceColumnParamVO.getTableName())});
      if (columnPrimaryKeyInfoList != null && columnPrimaryKeyInfoList.size() != 0) {
         String[] primaryKeys = ((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getPrimary_key_columns().split(",");
         if (primaryKeys != null && primaryKeys.length != 0) {
            List pklist = Arrays.asList(primaryKeys);
            if (pklist.contains(replaceColumnParamVO.getColumnName()) && columnPrimaryKeyInfoList != null && columnPrimaryKeyInfoList.size() != 0 && (((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getFlag() == null || !((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getFlag().equals("1"))) {
               ispk = true;
            }
         }
      }

      String copySuffix = PropertyGhcaUtil.copySuffix;
      String initialSuffix = PropertyGhcaUtil.initialSuffix;
      String cipherSuffix = PropertyGhcaUtil.cipherSuffix;
      String dataSystemId = replaceColumnParamVO.getDataSystemId();
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      Connection conn = JdbcTool.getConnection(tCoreDatasystem);

      try {
         Statement stmt = conn.createStatement();
         String replaceFlag = "";
         conn.setAutoCommit(false);
         if (!"1".equals(replaceColumnParamVO.getFlag()) && !"9".equals(replaceColumnParamVO.getFlag())) {
            TCoreEncryptionTypeField tCoreEncryptionTypeField = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("datasystem_id", replaceColumnParamVO.getDataSystemId()), Restrictions.eq("names", replaceColumnParamVO.getTableName()), Restrictions.eq("table_field_id", replaceColumnParamVO.getColumnName()), Restrictions.eq("projectid", replaceColumnParamVO.getProjectId()), Restrictions.eq("tschemas", replaceColumnParamVO.getSchema())});
            String res = this.checkDecryption(tCoreDatasystem, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), tCoreEncryptionTypeField.getEncryption_secretkey_id(), tCoreEncryptionTypeField.getIslike(), tCoreEncryptionTypeField.getKeepfirst(), tCoreEncryptionTypeField.getEncdigit(), tCoreEncryptionTypeField.getTwoindex());
            if (!"ok".equals(res)) {
               logger.error(String.format("列%s.%s.%s解密校验替换失败。", replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName()));
               this.updateFieldFlag(tCoreEncryptionTypeField.getId(), "11");
               Response var59 = this.createErrorStateResponse(ErrCode.CHECK_ERROR, "2");
               return var59;
            }

            try {
               if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  replaceTableFieldNameInitial(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + cipherSuffix + "\"", replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                  replaceTableFieldNameCopy(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + copySuffix + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
               } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                     replaceTableFieldNameInitial(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + cipherSuffix + "\"", replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + copySuffix + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                     replaceTableFieldNameInitial(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + cipherSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName() + copySuffix, replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                     replaceTableFieldNameInitial(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + cipherSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + copySuffix + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                     replaceTableFieldNameInitial(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + cipherSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + copySuffix + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  } else {
                     replaceTableFieldNameInitial(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + cipherSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName() + copySuffix, replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  }
               } else {
                  replaceTableFieldNameInitial(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + cipherSuffix + "\"", replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                  replaceTableFieldNameCopy(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + copySuffix + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
               }

               replaceFlag = "7";
            } catch (Exception e) {
               replaceFlag = "10";
               logger.error("替换失败:" + e);
               e.printStackTrace();
               JdbcTool.rollbackReplaceColumn(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + cipherSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
            }
         } else {
            TCoreEncryptionTypeField tCoreEncryptionTypeField = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("datasystem_id", replaceColumnParamVO.getDataSystemId()), Restrictions.eq("names", replaceColumnParamVO.getTableName()), Restrictions.eq("table_field_id", replaceColumnParamVO.getColumnName()), Restrictions.eq("projectid", replaceColumnParamVO.getProjectId()), Restrictions.eq("tschemas", replaceColumnParamVO.getSchema())});
            String res = this.checkEncryption(tCoreDatasystem, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), tCoreEncryptionTypeField.getEncryption_secretkey_id(), tCoreEncryptionTypeField.getIslike(), tCoreEncryptionTypeField.getKeepfirst(), tCoreEncryptionTypeField.getEncdigit(), tCoreEncryptionTypeField.getTwoindex());
            if (!"ok".equals(res)) {
               logger.error(String.format("列%s.%s.%s加密替换校验失败。", replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName()));
               this.updateFieldFlag(tCoreEncryptionTypeField.getId(), "12");
               Response e = this.createErrorStateResponse(ErrCode.CHECK_ERROR, "1");
               return e;
            }

            try {
               if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  replaceTableFieldNameInitial(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + initialSuffix + "\"", replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                  replaceTableFieldNameCopy(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + copySuffix + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
               } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                     replaceTableFieldNameInitial(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + initialSuffix + "\"", replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + copySuffix + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                     replaceTableFieldNameInitial(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + initialSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName() + copySuffix, replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                     replaceTableFieldNameInitial(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + initialSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName() + copySuffix, replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                     replaceTableFieldNameInitial(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + initialSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + copySuffix + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                     replaceTableFieldNameInitial(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + initialSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + copySuffix + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  } else {
                     replaceTableFieldNameInitial(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + initialSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                     replaceTableFieldNameCopy(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName() + copySuffix, replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
                  }
               } else {
                  replaceTableFieldNameInitial(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + initialSuffix + "\"", replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_columns, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
                  replaceTableFieldNameCopy(conn, "\"" + replaceColumnParamVO.getSchema() + "\"", "\"" + replaceColumnParamVO.getTableName() + "\"", "\"" + replaceColumnParamVO.getColumnName() + copySuffix + "\"", "\"" + replaceColumnParamVO.getColumnName() + "\"", replaceColumnParamVO.getTargetColumnType(), replaceColumnParamVO.getTargetColumnSize(), primaryKeyFlag, primary_key_columns, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem, allColumns, ispk);
               }

               replaceFlag = "5";
            } catch (Exception e) {
               replaceFlag = "9";
               logger.error("替换失败:" + e);
               e.printStackTrace();
               JdbcTool.rollbackReplaceColumn(conn, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName(), replaceColumnParamVO.getColumnName() + initialSuffix, replaceColumnParamVO.getSourceColumnType(), replaceColumnParamVO.getSourceColumnSize(), primaryKeyFlag, primary_key_col, replaceColumnParamVO.getColumnName(), tCoreDatasystem);
            }
         }

         conn.commit();
         this.encryptionConfigService.saveStatus(replaceColumnParamVO.getEncryptionId(), replaceFlag);
         if ("10".equals(replaceFlag) || "9".equals(replaceFlag)) {
            ResponseObj var56 = RespHelper.createRespObj(ErrCode.REPLACE_FAIL.getCode(), "9".equals(replaceFlag) ? "加载替换失败" : "解密替换失败");
            return var56;
         }
      } catch (SQLException e) {
         logger.error("替换校验失败:" + e);

         try {
            conn.rollback();
         } catch (SQLException ex) {
            ex.printStackTrace();
         }

         throw e;
      } finally {
         try {
            conn.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      List<TCoreProjectDatasource> relations = this.tCoreProjectDatasourceDao.queryAll(new Criterion[]{Restrictions.eq("systemsource_id", dataSystemId)});
      if (relations != null && relations.size() > 0) {
         for(TCoreProjectDatasource relation : relations) {
            this.encryptionProxyService.noticeProxyFetchEngineAndMaskingInfosByProject(relation.getProject_id());
         }
      }

      return RespHelper.successResp();
   }

   private String delCopyColumn(String schema, String tableName, String columnName) {
      String sql = String.format("ALTER TABLE %s.%s DROP COLUMN %s", schema, tableName, columnName);
      return sql;
   }

   private int updateFieldFlag(String id, String flag) {
      int num = this.jdbcTemplate.update("UPDATE t_core_encryption_field SET flag = ? WHERE id = ?", new Object[]{flag, id});
      return num;
   }

   private static void replaceTableFieldNameInitial(Connection con, String schema, String tableName, String sourceFieldName, String targetFieldName, String columnType, String columnSize, String primaryKeyFlag, String primary_key_columns, String columnNameKey, TCoreDatasystem tCoreDatasystem) throws SQLException {
      String copySuffix = PropertyGhcaUtil.copySuffix;
      String columnSizestr = "";
      if (StringUtils.isNotBlank(columnSize)) {
         if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            columnSizestr = "(" + columnSize + " BYTE)";
         } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
            if (!tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               columnSizestr = "(" + columnSize + ")";
            } else {
               columnSizestr = "(" + columnSize + ")";
            }
         } else {
            columnSizestr = "(" + columnSize + ")";
         }
      }

      if (null != columnType && columnType.toLowerCase().contains("text")) {
         columnSizestr = "";
      }

      String sql = "";
      if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         sql = "ALTER TABLE " + schema + "." + tableName + "  RENAME COLUMN " + sourceFieldName + " TO " + targetFieldName;
      } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
         if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
            sql = "ALTER TABLE " + schema + "." + tableName + "  RENAME COLUMN " + sourceFieldName + " TO " + targetFieldName;
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            sql = "EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + sourceFieldName + "]', '" + targetFieldName + "', 'COLUMN'";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            sql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  alter column \"" + sourceFieldName + "\" rename to \"" + targetFieldName + "\"";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
            sql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + sourceFieldName + "\" TO \"" + targetFieldName + "\"";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
            sql = "ALTER TABLE " + schema + "." + tableName + "  change " + sourceFieldName + " " + targetFieldName + " " + columnType + columnSizestr;
         } else {
            sql = "alter table " + schema + "." + tableName + " change column " + sourceFieldName + " " + targetFieldName + " " + columnType + columnSizestr;
         }
      } else {
         sql = "ALTER TABLE " + schema + "." + tableName + "  RENAME COLUMN " + sourceFieldName + " TO " + targetFieldName;
      }

      PreparedStatement preStatement = con.prepareStatement(sql);
      preStatement.executeUpdate();
      if (preStatement != null) {
         try {
            preStatement.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }
      }

      if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
         String primaryKeysqlIndex = "";
         String primaryKeysql = "";
         String primaryKeysql1 = "";
         if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
            if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               String tableName1 = tableName.replace("\"", "");
               primaryKeysql = "alter table " + schema + "." + tableName + "  DROP CONSTRAINT \"" + tableName1 + "_pkey\"";
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(con, schema, tableName);
               StringBuilder primaryKeysqlBuilder = new StringBuilder();
               if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                  for(int i = 0; i < primarykeyInfo.size(); ++i) {
                     primaryKeysql = "ALTER TABLE " + schema + "." + tableName + " DROP  Constraint " + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + " ";
                     primaryKeysqlBuilder.append(primaryKeysql);
                  }

                  primaryKeysql = primaryKeysqlBuilder.toString();
               }
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(con, schema, tableName);
               if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                  for(int i = 0; i < primarykeyInfo.size(); ++i) {
                     primaryKeysqlIndex = "create CLUSTER index \"" + schema + "_" + tableName + "_" + sourceFieldName + "_index\" on \"" + schema + "\".\"" + tableName + "\"(\"" + sourceFieldName + copySuffix + "\") ";
                     primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP  Constraint \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\"";
                     primaryKeysql1 = "drop index \"" + schema + "\".\"" + schema + "_" + tableName + "_" + sourceFieldName + "_index\"";
                     PreparedStatement preStatementKeyIndex = con.prepareStatement(primaryKeysqlIndex);
                     preStatementKeyIndex.executeUpdate();
                     preStatementKeyIndex.close();

                     try {
                        PreparedStatement preStatementKey = con.prepareStatement(primaryKeysql);
                        preStatementKey.executeUpdate();
                        preStatementKey.close();
                     } catch (Exception e) {
                        e.printStackTrace();
                     }

                     try {
                        PreparedStatement preStatementKey1 = con.prepareStatement(primaryKeysql1);
                        preStatementKey1.executeUpdate();
                        preStatementKey1.close();
                     } catch (Exception e) {
                        e.printStackTrace();
                     }
                  }
               }
            } else if (!tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               primaryKeysql = "alter table " + schema + "." + tableName + "  drop primary key";
            } else {
               List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(con, schema, tableName);
               StringBuilder primaryKeysqlBuilder = new StringBuilder();
               if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                  for(int i = 0; i < primarykeyInfo.size(); ++i) {
                     primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP CONSTRAINT \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\" ";
                     primaryKeysqlBuilder.append(primaryKeysql);
                  }

                  primaryKeysql = primaryKeysqlBuilder.toString();
               }
            }
         } else {
            String tableName1 = tableName.replace("\"", "");
            if (EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
               primaryKeysql = "alter table " + schema + "." + tableName + "  DROP CONSTRAINT \"" + tableName1 + "_pkey\"";
            } else {
               primaryKeysql = "alter table " + schema + "." + tableName + "  DROP CONSTRAINT \"" + tableName1 + "_pkey\"";
            }
         }

         if (!tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            PreparedStatement preStatementKey = con.prepareStatement(primaryKeysql);
            preStatementKey.executeUpdate();
            preStatementKey.close();
            if (EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
               con.commit();
            }
         }
      }

   }

   private static void replaceTableFieldNameCopy(Connection con, String schema, String tableName, String sourceFieldName, String targetFieldName, String columnType, String columnSize, String primaryKeyFlag, String primary_key_columns, String primary_key_col, String columnNameKey, TCoreDatasystem tCoreDatasystem, List<ColumnInfoVO> allColumns, boolean ispk) throws SQLException {
      String columnSizestr = "";
      if (StringUtils.isNotBlank(columnSize)) {
         if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            columnSizestr = "(" + columnSize + " BYTE)";
         } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
            if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               columnSizestr = "(" + columnSize + ")";
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               columnSizestr = "(" + columnSize + ")";
            } else {
               columnSizestr = "(" + columnSize + ")";
            }
         } else {
            columnSizestr = "(" + columnSize + ")";
         }
      }

      if (null != columnType && columnType.toLowerCase().contains("text")) {
         columnSizestr = "";
      }

      boolean isNullable = true;
      String columnDef = "";
      String remarks = "";

      for(ColumnInfoVO allColumn : allColumns) {
         if (targetFieldName.replaceAll("\"", "").equals(allColumn.getColumnname())) {
            isNullable = "1".equalsIgnoreCase(allColumn.getNullable()) || "yes".equalsIgnoreCase(allColumn.getNullable());
            columnDef = allColumn.getColumndef();
            remarks = allColumn.getRemarks();
            break;
         }
      }

      String nullStr = "";
      nullStr = isNullable ? "NULL" : "NOT NULL";
      List<String> sqlList = new ArrayList();
      if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         sqlList.add("ALTER TABLE " + schema + "." + tableName + "  RENAME COLUMN " + sourceFieldName + " TO " + targetFieldName);
         String sql = "ALTER TABLE " + schema + "." + tableName + "  MODIFY " + targetFieldName + " " + columnType + " " + columnSizestr;
         if (StringUtils.isNotBlank(columnDef)) {
            sql = sql + " DEFAULT " + columnDef + "";
         }

         sqlList.add(sql);
      } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
         if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
            sqlList.add("ALTER TABLE " + schema + "." + tableName + "  RENAME COLUMN " + sourceFieldName + " TO " + targetFieldName);
            if (isNullable) {
               sqlList.add("ALTER TABLE " + schema + "." + tableName + "  alter column " + targetFieldName + " DROP NOT NULL ");
            } else {
               sqlList.add("ALTER TABLE " + schema + "." + tableName + "  alter column " + targetFieldName + " SET NOT NULL ");
            }
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            sqlList.add("EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + sourceFieldName + "]', '" + targetFieldName + "', 'COLUMN'");
            sqlList.add("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + targetFieldName + "] " + columnType + columnSizestr + " " + nullStr);
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            sqlList.add("ALTER TABLE " + schema + "." + tableName + "  alter column " + sourceFieldName + " rename to " + targetFieldName);
            sqlList.add("ALTER TABLE " + schema + "." + tableName + "  modify " + targetFieldName + " " + columnType + columnSizestr + "");
            sqlList.add("ALTER TABLE " + schema + "." + tableName + "  alter column " + targetFieldName + " set " + nullStr + "");
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
            sqlList.add("ALTER TABLE " + schema + "." + tableName + "  RENAME COLUMN " + sourceFieldName + " TO " + targetFieldName + "");
            sqlList.add("ALTER TABLE " + schema + "." + tableName + "  MODIFY " + targetFieldName + nullStr);
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
            sqlList.add("alter table " + schema + "." + tableName + " change " + sourceFieldName + " " + targetFieldName + " " + columnType + columnSizestr);
         } else {
            String sql = "alter table " + schema + "." + tableName + " change column " + sourceFieldName + " " + targetFieldName + " " + columnType + columnSizestr + " " + nullStr;
            if (StringUtils.isNotBlank(columnDef)) {
               sql = sql + " DEFAULT '" + columnDef + "'";
            }

            if (StringUtils.isNotBlank(remarks)) {
               sql = sql + "  COMMENT '" + remarks + "'";
            }

            sqlList.add(sql);
         }
      } else {
         sqlList.add("ALTER TABLE " + schema + "." + tableName + "  RENAME COLUMN " + sourceFieldName + " TO " + targetFieldName);
         if (columnSize.equals("2147483647")) {
            sqlList.add("ALTER TABLE " + schema + "." + tableName + "  ALTER COLUMN " + targetFieldName + " TYPE " + columnType + "");
         } else {
            sqlList.add("ALTER TABLE " + schema + "." + tableName + "  ALTER COLUMN " + targetFieldName + " TYPE " + columnType + columnSizestr + "");
         }

         if (EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
            if ("NOT NULL".equals(nullStr)) {
               sqlList.add("ALTER TABLE " + schema + "." + tableName + "  alter column " + targetFieldName + " set " + nullStr + "");
            }
         } else if (isNullable) {
            sqlList.add("ALTER TABLE " + schema + "." + tableName + "  alter column " + targetFieldName + " DROP NOT NULL ");
         } else {
            sqlList.add("ALTER TABLE " + schema + "." + tableName + "  alter column " + targetFieldName + " SET NOT NULL ");
         }
      }

      if (StringUtils.isNotBlank(columnDef) && !tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
         if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            sqlList.add("ALTER TABLE [" + schema + "].[" + tableName + "] ADD  DEFAULT " + columnDef + " FOR [" + targetFieldName + "]");
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            sqlList.add("alter table " + schema + "." + tableName + " alter column " + targetFieldName + " set default (" + columnDef + ")");
         }
      }

      if (StringUtils.isNotBlank(remarks)) {
         if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            sqlList.add("COMMENT ON COLUMN " + schema + "." + tableName + "." + targetFieldName + " IS '" + remarks + "'");
         } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
            if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               sqlList.add("COMMENT ON COLUMN " + schema + "." + tableName + "." + targetFieldName + " IS '" + remarks + "'");
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               sqlList.add("EXECUTE sp_updateextendedproperty N'MS_Description', N'" + remarks + "', N'SCHEMA', N'" + schema + "', N'TABLE', N'" + tableName + "', N'COLUMN', N'" + targetFieldName + "'");
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               sqlList.add(" comment on column " + schema + "." + tableName + "." + targetFieldName + " is '" + remarks + "'");
            }
         } else {
            sqlList.add("COMMENT ON COLUMN " + schema + "." + tableName + "." + targetFieldName + " IS '" + remarks + "'");
         }
      }

      PreparedStatement preStatement = null;

      for(String s : sqlList) {
         preStatement = con.prepareStatement(s);
         preStatement.executeUpdate();
         if (EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
            con.commit();
         }
      }

      if (preStatement != null) {
         try {
            preStatement.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }
      }

      if (primaryKeyFlag.equals("1") && !ispk && !"".equals(primary_key_columns)) {
         String[] fileds = primary_key_columns.split(",");
         if (fileds.length > 1) {
            String primaryKeysql111 = "";
            StringBuilder primaryKeysql333 = new StringBuilder();
            if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               if (!"".equals(primary_key_col)) {
                  primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_col + ")";
               }
            } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
               if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  if (!"".equals(primary_key_col)) {
                     primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_col + ")";
                  }
               } else if (!tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                     primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                     primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                  } else {
                     primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                  }
               } else {
                  for(ColumnInfoVO allColumn : allColumns) {
                     String substring = primary_key_columns.substring(0, primary_key_columns.length() - 1);
                     String[] split = substring.split(",");

                     for(String col : split) {
                        if (col.equals(allColumn.getColumnname())) {
                           primaryKeysql333.append("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + col + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                        }
                     }
                  }

                  primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
               }
            } else if (!"".equals(primary_key_col)) {
               primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_col + ")";
            }

            if (null != primaryKeysql333 && primaryKeysql333.length() > 0) {
               PreparedStatement preStatementKey333 = con.prepareStatement(primaryKeysql333.toString());
               preStatementKey333.executeUpdate();
               preStatementKey333.close();
            }

            PreparedStatement preStatementKey111 = con.prepareStatement(primaryKeysql111);
            preStatementKey111.executeUpdate();
            preStatementKey111.close();
         } else {
            String primaryKeysql111 = "";
            StringBuilder primaryKeysql333 = new StringBuilder();
            if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (\"" + columnNameKey + "\")";
            } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
               if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (\"" + columnNameKey + "\")";
               } else if (!tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                     primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (\"" + columnNameKey + "\")";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                     primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnNameKey + ")";
                  } else {
                     primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnNameKey + ")";
                  }
               } else {
                  for(ColumnInfoVO allColumn : allColumns) {
                     if (columnNameKey.equals(allColumn.getColumnname())) {
                        primaryKeysql333.append("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + columnNameKey + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                     }
                  }

                  primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnNameKey + ")";
               }
            } else {
               primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (\"" + columnNameKey + "\")";
            }

            if (null != primaryKeysql333 && !"".equals(primaryKeysql333.toString())) {
               PreparedStatement preStatementKey333 = con.prepareStatement(primaryKeysql333.toString());
               preStatementKey333.executeUpdate();
               preStatementKey333.close();
            }

            PreparedStatement preStatementKey111 = con.prepareStatement(primaryKeysql111);
            preStatementKey111.executeUpdate();
            if (EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
               con.commit();
            }

            preStatementKey111.close();
         }
      }

   }

   private static void replaceTableFieldName(Connection con, String schema, String tableName, String sourceFieldName, String targetFieldName, String columnType, String columnSize) throws SQLException {
      String columnSizestr = "";
      if (StringUtils.isNotBlank(columnSize)) {
         columnSizestr = "(" + columnSize + ")";
      }

      if (null != columnType && columnType.toLowerCase().contains("text")) {
         columnSizestr = "";
      }

      String sql = "alter table " + schema + "." + tableName + " change column " + sourceFieldName + " " + targetFieldName + " " + columnType + columnSizestr;
      PreparedStatement preStatement = con.prepareStatement(sql);
      preStatement.executeUpdate();
      preStatement.close();
   }

   private Map<String, Object> doRemoveLoadAllTable(List<LoadingParameterVO> LoadingParameterList) {
      Map<String, Object> resultMap = new HashMap();

      try {
         int taskCount = 0;

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            taskCount += loadingParameterVO.getTableInfo().size();
         }

         int yypp = 0;

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            String projectId = loadingParameterVO.getProjectId();
            String dataSystemId = loadingParameterVO.getDataSystemId();
            Connection connection = loadingParameterVO.getConnection();
            TCoreDatasystem tCoreDatasystem = loadingParameterVO.gettCoreDatasystem();
            String schema = loadingParameterVO.getSchema();

            for(TableInfoVO tableInfoVO : loadingParameterVO.getTableInfo()) {
               EncryptionConfigVO vo = new EncryptionConfigVO();
               vo.setDatasystem_id(dataSystemId);
               vo.setSchema(schema);
               vo.setTable_name(tableInfoVO.getTableName());
               vo.setProjectid(projectId);
               List<ColumnInfoVO> allColumnList = this.encryptionConfigService.queryOriginalList(vo);
               List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("project_id", loadingParameterVO.getProjectId()), Restrictions.eq("datasystem_id", loadingParameterVO.getDataSystemId()), Restrictions.eq("tschema", loadingParameterVO.getSchema()), Restrictions.eq("tname", tableInfoVO.getTableName())});
               if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit(new MongoDBRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
               } else if ("ES".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit(new ElasticSearchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), (List)null, columnPrimaryKeyInfoList, allColumnList, false, "1", (CountDownLatch)null));
               } else if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                  TableRuleInfo hiveStoreInfo = this.tableRuleService.getHiveStoreInfo(projectId, dataSystemId, schema, tableInfoVO.getTableName());
                  if (hiveStoreInfo != null && hiveStoreInfo.getType() == HiveEncDecType.webHdfs) {
                     this.taskExecutor.submit(new HdfsRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
                  } else {
                     this.taskExecutor.submit(new NewRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
                  }
               } else if ("HIVE".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit(new HiveRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
               } else {
                  this.taskExecutor.submit(new NewRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         Iterator var20 = LoadingParameterList.iterator();

         while(true) {
            if (!var20.hasNext()) {
               ;
            } else {
               LoadingParameterVO loadingParameterVO = (LoadingParameterVO)var20.next();
               if (null != loadingParameterVO.getConnection()) {
                  try {
                     loadingParameterVO.getConnection().close();
                  } catch (SQLException e) {
                     e.printStackTrace();
                  }
               }

               if (null != loadingParameterVO.getProjectId() && !loadingParameterVO.getProjectId().equals("")) {
                  TCoreDataProject tCoreDataProject = (TCoreDataProject)this.tCoreDataProjectDao.queryUnique(new Criterion[]{Restrictions.eq("id", loadingParameterVO.getProjectId())});
                  tCoreDataProject.setFlag("0");
                  this.tCoreDataProjectDao.update(tCoreDataProject);
               }
            }
         }
      }

   }

   private Map<String, Object> doRemoveLoadingAllTable(List<LoadingParameterVO> LoadingParameterList) {
      Map<String, Object> resultMap = new HashMap();

      try {
         HashSet<ColumnEncryption> columnSet = null;
         int corePoolSize = 1;
         int cpuCount = Runtime.getRuntime().availableProcessors();
         int maximumPoolSize = Math.round((float)cpuCount);
         long keepAliveTime = 5000L;
         int taskCapacity = 2000;
         int taskCount = 0;
         ThreadPoolExecutor loadingExecutor = null;
         new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(taskCapacity), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            taskCount += loadingParameterVO.getTableInfo().size();
         }

         for(LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            String projectId = loadingParameterVO.getProjectId();
            String dataSystemId = loadingParameterVO.getDataSystemId();
            Connection connection = loadingParameterVO.getConnection();
            TCoreDatasystem tCoreDatasystem = loadingParameterVO.gettCoreDatasystem();
            String schema = loadingParameterVO.getSchema();

            for(TableInfoVO tableInfoVO : loadingParameterVO.getTableInfo()) {
               EncryptionConfigVO vo = new EncryptionConfigVO();
               vo.setDatasystem_id(dataSystemId);
               vo.setSchema(schema);
               vo.setTable_name(tableInfoVO.getTableName());
               vo.setProjectid(projectId);
               List<ColumnInfoVO> allColumnList = this.encryptionConfigService.queryOriginalList(vo);
               List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("project_id", loadingParameterVO.getProjectId()), Restrictions.eq("datasystem_id", loadingParameterVO.getDataSystemId()), Restrictions.eq("tschema", loadingParameterVO.getSchema()), Restrictions.eq("tname", tableInfoVO.getTableName())});
               if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit(new MongoDBRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
               } else if ("ES".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit(new ElasticSearchTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), (List)null, columnPrimaryKeyInfoList, allColumnList, false, "1", (CountDownLatch)null));
               } else if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                  TableRuleInfo hiveStoreInfo = this.tableRuleService.getHiveStoreInfo(projectId, dataSystemId, schema, tableInfoVO.getTableName());
                  if (hiveStoreInfo != null && hiveStoreInfo.getType() == HiveEncDecType.webHdfs) {
                     this.taskExecutor.submit(new HdfsRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
                  } else {
                     this.taskExecutor.submit(new NewRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
                  }
               } else if ("HIVE".equals(tCoreDatasystem.getDbtype())) {
                  this.taskExecutor.submit(new HiveRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
               } else {
                  this.taskExecutor.submit(new NewRemoveLoadingTask(projectId, dataSystemId, tCoreDatasystem, schema, tableInfoVO.getTableName(), tableInfoVO.getPrimaryKeys(), tableInfoVO.getColumnInfo(), columnPrimaryKeyInfoList, allColumnList));
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         for (LoadingParameterVO loadingParameterVO : LoadingParameterList) {
            if (null == loadingParameterVO.getConnection()) continue;
            try {
               loadingParameterVO.getConnection().close();
            }
            catch (SQLException e) {
               e.printStackTrace();
            }
         }
      }

      return resultMap;
   }

   private boolean isTableInSchema(Connection conn, String schema, String table) throws SQLException {
      DatabaseMetaData metaData = conn.getMetaData();
      ResultSet rs = metaData.getTables((String)null, schema, table, new String[]{"TABLE", "VIEW"});
      Throwable var6 = null;

      boolean var7;
      try {
         var7 = rs.next();
      } catch (Throwable var16) {
         var6 = var16;
         throw var16;
      } finally {
         if (rs != null) {
            if (var6 != null) {
               try {
                  rs.close();
               } catch (Throwable var15) {
                  var6.addSuppressed(var15);
               }
            } else {
               rs.close();
            }
         }

      }

      return var7;
   }

   private boolean isColumnInTable(Connection conn, String schema, String table, String column) throws SQLException {
      DatabaseMetaData metaData = conn.getMetaData();
      ResultSet rs = metaData.getColumns((String)null, schema, table, column);
      Throwable var7 = null;

      boolean var8;
      try {
         var8 = rs.next();
      } catch (Throwable var17) {
         var7 = var17;
         throw var17;
      } finally {
         if (rs != null) {
            if (var7 != null) {
               try {
                  rs.close();
               } catch (Throwable var16) {
                  var7.addSuppressed(var16);
               }
            } else {
               rs.close();
            }
         }

      }

      return var8;
   }

   private String getColumnType(Connection conn, String schema, String table, String column) throws SQLException {
      DatabaseMetaData metaData = conn.getMetaData();
      boolean isOracle = metaData.getDatabaseProductName().contains("Oracle");
      String adjustedSchema = isOracle ? schema.toUpperCase() : schema;
      String adjustedTable = isOracle ? table.toUpperCase() : table;
      String adjustedColumn = isOracle ? column.toUpperCase() : column;
      ResultSet rs = metaData.getColumns((String)null, adjustedSchema, adjustedTable, adjustedColumn);
      Throwable var11 = null;

      String var12;
      try {
         if (!rs.next()) {
            return null;
         }

         var12 = rs.getString("TYPE_NAME");
      } catch (Throwable var22) {
         var11 = var22;
         throw var22;
      } finally {
         if (rs != null) {
            if (var11 != null) {
               try {
                  rs.close();
               } catch (Throwable var21) {
                  var11.addSuppressed(var21);
               }
            } else {
               rs.close();
            }
         }

      }

      return var12;
   }

   public boolean hasPrimaryKey(Connection conn, String schema, String table) throws SQLException {
      DatabaseMetaData metaData = conn.getMetaData();
      boolean isOracle = metaData.getDatabaseProductName().contains("Oracle");
      String adjustedSchema = isOracle ? schema.toUpperCase() : schema;
      String adjustedTable = isOracle ? table.toUpperCase() : table;
      ResultSet rs = metaData.getPrimaryKeys((String)null, adjustedSchema, adjustedTable);
      Throwable var9 = null;

      boolean var10;
      try {
         var10 = rs.next();
      } catch (Throwable var19) {
         var9 = var19;
         throw var19;
      } finally {
         if (rs != null) {
            if (var9 != null) {
               try {
                  rs.close();
               } catch (Throwable var18) {
                  var9.addSuppressed(var18);
               }
            } else {
               rs.close();
            }
         }

      }

      return var10;
   }

   @EncryptLog
   @RequestMapping({"/excelFileUpLoad"})
   @ResponseBody
   public Response excelFileUpLoad(@RequestParam("fileUpload") MultipartFile excelFile, @RequestParam("pid") String pid, HttpServletRequest request, HttpServletResponse response) {
      InputStream in = null;
      String fileName = excelFile.getOriginalFilename();
      String username = TokenUtil.getUserId(request.getHeader("token"));

      try {
         in = excelFile.getInputStream();
         Workbook wb = null;

         assert fileName != null;

         String fileType = fileName.substring(fileName.lastIndexOf("."));
         if (".xls".equals(fileType)) {
            wb = new HSSFWorkbook(in);
         } else if (".xlsx".equals(fileType)) {
            try {
               wb = new XSSFWorkbook(OPCPackage.open(in));
            } catch (InvalidFormatException | IOException e) {
               ((Exception)e).printStackTrace();
            }
         } else if (".txt".equals(fileType)) {
            InputStreamReader reader = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(reader);
            String line = "";
            List<String> stringList = new ArrayList();

            while(line != null) {
               line = br.readLine();
               if (line != null) {
                  stringList.add(line);
               }
            }

            if (null == stringList || stringList.size() == 0) {
               return RespHelper.successResp();
            }

            String s = this.importTxt(stringList, pid, request);
            if (s == null) {
               return RespHelper.successResp();
            }

            if (s.equals(ErrCode.DUPLICATE_ENCRYPT_COLUMN.getCode())) {
               return RespHelper.errResp(ErrCode.DUPLICATE_ENCRYPT_COLUMN);
            }

            if (s.equals(ErrCode.DATABASE_NOT_EXIST.getCode())) {
               return RespHelper.errResp(ErrCode.DATABASE_NOT_EXIST);
            }

            if (s.equals(ErrCode.WRONG_TXT.getCode())) {
               return RespHelper.errResp(ErrCode.WRONG_TXT);
            }
         }

         assert wb != null;

         try {
            Sheet sheet1 = wb.getSheetAt(0);
            int rowsNum1 = sheet1.getLastRowNum();
            String pk = "";
            List<JSONObject> jsonObjects = new ArrayList();

            for(int i = 1; i < rowsNum1 + 1; ++i) {
               Row row = sheet1.getRow(i);
               JSONObject jsonObject = new JSONObject();
               Cell cell0 = row.getCell(0);
               if (cell0 == null) {
                  String msg = "有误！ ip 是空！";
                  return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
               }

               String ip = row.getCell(0).toString();
               jsonObject.put("ip", ip);
               Cell cell = row.getCell(1);
               if (cell == null) {
                  String msg = "有误！ port 是空！";
                  return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
               }

               int value = (int)cell.getNumericCellValue();
               jsonObject.put("port", String.valueOf(value));
               Cell cell2 = row.getCell(2);
               if (cell2 == null) {
                  String msg = "有误！ schema 是空！";
                  return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
               }

               jsonObject.put("schema", row.getCell(2).toString());
               Cell cell3 = row.getCell(3);
               if (cell3 == null) {
                  String msg = "有误！ table 是空！";
                  return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
               }

               jsonObject.put("table", row.getCell(3).toString());
               Cell cell4 = row.getCell(4);
               if (cell4 == null) {
                  String msg = "有误！ column 是空！";
                  return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
               }

               jsonObject.put("column", row.getCell(4).toString());
               Cell cell5 = row.getCell(5);
               if (cell5 != null) {
                  pk = row.getCell(5).toString();
                  jsonObject.put("key", row.getCell(5).toString());
               }

               jsonObjects.add(jsonObject);
            }

            if (jsonObjects != null && jsonObjects.size() > 0) {
               List<TCoreProjectDatasource> tCoreProjectDatasources = this.tCoreProjectDatasourceDao.queryAll();
               if (tCoreProjectDatasources != null && tCoreProjectDatasources.size() > 0) {
                  List<String> dataSystemId = new ArrayList();
                  tCoreProjectDatasources.stream().forEach((x) -> dataSystemId.add(x.getSystemsource_id()));
                  Boolean isok = true;
                  int i = 0;

                  while(true) {
                     if (i < jsonObjects.size()) {
                        JSONObject jsonObject = (JSONObject)jsonObjects.get(i);
                        List<TCoreDatasystem> tCoreDatasystems = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.in("id", dataSystemId), Restrictions.eq("dbip", jsonObject.get("ip")), Restrictions.eq("dbport", jsonObject.get("port"))});
                        if (tCoreDatasystems.size() <= 0) {
                           String msg = jsonObject.toString() + "有误！ 关联资产库不存在！";
                           return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
                        }

                        List<TCoreDatasourceSchema> tCoreDatasourceSchemas = this.tCoreDataSourceSchemaDao.queryAll(new Criterion[]{Restrictions.eq("osdsid", ((TCoreDatasystem)tCoreDatasystems.get(0)).getId()), Restrictions.eq("schemaname", jsonObject.get("schema"))});
                        if (tCoreDatasourceSchemas != null && tCoreDatasourceSchemas.size() > 0) {
                           Connection connection = JdbcTool.getConnection((TCoreDatasystem)tCoreDatasystems.get(0));
                           boolean ist = this.isTableInSchema(connection, jsonObject.getString("schema"), jsonObject.getString("table"));
                           if (!ist) {
                              String msg = jsonObject.toString() + "有误！表不在！";
                              return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
                           }

                           boolean isc = this.isColumnInTable(connection, jsonObject.getString("schema"), jsonObject.getString("table"), jsonObject.getString("column"));
                           if (!isc) {
                              String msg = jsonObject.toString() + "有误！ 列不在！";
                              return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
                           }

                           String[] lists = pk.split(",");
                           if (lists != null && lists.length > 0) {
                              Boolean iscc = true;

                              for(String string : lists) {
                                 Boolean isccc = this.isColumnInTable(connection, jsonObject.getString("schema"), jsonObject.getString("table"), string);
                                 if (!isccc) {
                                    iscc = false;
                                 }
                              }

                              isc = iscc;
                           } else {
                              isc = false;
                           }

                           if (!isc) {
                              String msg = jsonObject.toString() + "有误！ 无效数据！";
                              return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
                           }

                           List<TCoreEncryptionTypeField> list = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.in("table_field_id", new Object[]{jsonObject.getString("column")}), Restrictions.in("tschemas", new Object[]{jsonObject.getString("schema")}), Restrictions.in("names", new Object[]{jsonObject.getString("table")})});
                           if (list != null && list.size() > 0) {
                              String msg = jsonObject.toString() + "有误！ 数据以存在！";
                              return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
                           }

                           ++i;
                           continue;
                        }

                        String msg = jsonObject.toString() + "有误！ 无效数据！";
                        return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
                     }

                     for(int inew = 0; inew < jsonObjects.size(); ++inew) {
                        JSONObject jsonObject = (JSONObject)jsonObjects.get(inew);
                        List<TCoreDatasystem> tCoreDatasystems = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.in("id", dataSystemId), Restrictions.eq("dbip", jsonObject.get("ip")), Restrictions.eq("dbport", jsonObject.get("port"))});
                        Connection connection = JdbcTool.getConnection((TCoreDatasystem)tCoreDatasystems.get(0));
                        TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)this.tCoreSecretkeyDao.queryAll().get(0);
                        TCoreEncryption tCoreEncryption = (TCoreEncryption)this.tCoreEncryptionDao.queryAll().get(0);
                        String getColumnType = this.getColumnType(connection, jsonObject.getString("schema"), jsonObject.getString("table"), jsonObject.getString("column"));
                        List<TCoreProjectDatasource> coreProjectDatasources = this.tCoreProjectDatasourceDao.queryAll(new Criterion[]{Restrictions.in("systemsource_id", new Object[]{((TCoreDatasystem)tCoreDatasystems.get(0)).getId()})});
                        TCoreEncryptionTypeField tCoreEncryptionTypeField = new TCoreEncryptionTypeField();
                        if (!this.hasPrimaryKey(connection, jsonObject.getString("schema"), jsonObject.getString("table"))) {
                           ColumnPrimaryKeyInfo columnPrimaryKeyInfo1 = (ColumnPrimaryKeyInfo)this.columnPrimaryKeyInfoDao.queryUnique(new Criterion[]{Restrictions.eq("project_id", ((TCoreProjectDatasource)coreProjectDatasources.get(0)).getProject_id()), Restrictions.eq("datasystem_id", ((TCoreDatasystem)tCoreDatasystems.get(0)).getId()), Restrictions.eq("tschema", jsonObject.getString("schema")), Restrictions.eq("tname", jsonObject.getString("table"))});
                           if (columnPrimaryKeyInfo1 == null) {
                              ColumnPrimaryKeyInfo columnPrimaryKeyInfo = new ColumnPrimaryKeyInfo();
                              columnPrimaryKeyInfo.setTschema(jsonObject.getString("schema"));
                              columnPrimaryKeyInfo.setProject_id(((TCoreProjectDatasource)coreProjectDatasources.get(0)).getProject_id());
                              columnPrimaryKeyInfo.setTname(jsonObject.getString("table"));
                              columnPrimaryKeyInfo.setDatasystem_id(((TCoreDatasystem)tCoreDatasystems.get(0)).getId());
                              columnPrimaryKeyInfo.setPrimary_key_columns(pk);
                              this.columnPrimaryKeyInfoDao.save(columnPrimaryKeyInfo);
                           }
                        }

                        tCoreEncryptionTypeField.setProjectid(((TCoreProjectDatasource)coreProjectDatasources.get(0)).getProject_id());
                        tCoreEncryptionTypeField.setColumn_type(getColumnType);
                        tCoreEncryptionTypeField.setCreateuser(TokenUtil.getUserId(request.getHeader("token")));
                        tCoreEncryptionTypeField.setCreatetime(new Date());
                        tCoreEncryptionTypeField.setFlag("0");
                        tCoreEncryptionTypeField.setTschemas(jsonObject.getString("schema"));
                        tCoreEncryptionTypeField.setTable_field_id(jsonObject.getString("column"));
                        tCoreEncryptionTypeField.setNames(jsonObject.getString("table"));
                        tCoreEncryptionTypeField.setEncryption_secretkey_id(tCoreSecretkey.getId());
                        tCoreEncryptionTypeField.setEncryptiontypename(tCoreEncryption.getEncryption_name());
                        tCoreEncryptionTypeField.setSecretkeyname(tCoreSecretkey.getSecret_key_name());
                        tCoreEncryptionTypeField.setDatasystem_id(((TCoreDatasystem)tCoreDatasystems.get(0)).getId());
                        List<com.chenyang.nse.bussiness.entity.Column> columns = JdbcTool.getAllColumnIn(connection, jsonObject.getString("schema"), jsonObject.getString("table"));
                        List<TCoreTablestructure> columnList = new ArrayList();
                        String size = "0";

                        for(com.chenyang.nse.bussiness.entity.Column column : columns) {
                           TCoreTablestructure t = new TCoreTablestructure();
                           t.setTableorcolumnname(column.getName());
                           t.setColumntype(column.getType());
                           t.setColumnlength(column.getLength());
                           columnList.add(t);
                           if (column.getName().equalsIgnoreCase(jsonObject.getString("column"))) {
                              size = column.getLength();
                           }
                        }

                        tCoreEncryptionTypeField.setColumn_size(size);
                        tCoreEncryptionTypeField.setCombination_id(jsonObject.getString("table") + "." + jsonObject.getString("column"));
                        tCoreEncryptionTypeField.setDatasystemname(((TCoreDatasystem)tCoreDatasystems.get(0)).getSysname());
                        tCoreEncryptionTypeField.setState("0");
                        tCoreEncryptionTypeField.setTwoindex("0");
                        tCoreEncryptionTypeField.setEncdigit("0");
                        tCoreEncryptionTypeField.setKeepfirst("0");
                        tCoreEncryptionTypeField.setIslike("0");
                        tCoreEncryptionTypeField.setRealitycolumnsize(size);
                        this.tCoreEncryptionTypeFieldDao.save(tCoreEncryptionTypeField);
                     }

                     return RespHelper.successResp();
                  }
               } else {
                  return RespHelper.errResp(ErrCode.PROJECT_NULL);
               }
            } else {
               return RespHelper.errResp(ErrCode.PROJECT_NULL);
            }
         } catch (Exception e) {
            e.printStackTrace();
            String msg = "导入EXCEL格式错误！";
            return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
         }
      } catch (ServiceException e) {
         return RespHelper.createResp(false, e.getCode(), e.getDescription());
      } catch (Exception e) {
         e.printStackTrace();
         String msg = "导入EXCEL格式错误！";
         return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
      }
   }

   private String importTxt(List<String> stringList, String pid, HttpServletRequest request) {
      List<TCoreEncryptionTypeField> oldT = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", pid), Restrictions.eq("state", "0")});
      if (oldT != null && oldT.size() != 0) {
         return ErrCode.DUPLICATE_ENCRYPT_COLUMN.getCode();
      } else {
         List<TCoreEncryptionTypeField> deleteT = this.tCoreEncryptionTypeFieldDao.queryFields(pid);
         if (null != deleteT && deleteT.size() > 0) {
            for(TCoreEncryptionTypeField tCoreEncryptionTypeField : deleteT) {
               this.tCoreEncryptionTypeFieldDao.removeById(tCoreEncryptionTypeField.getId());
            }
         }

         Properties props = null;

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         try {
            String key = props.getProperty("is_enc_backupfile_key");
            List<TCoreEncryption> tCoreEncryptionList = new ArrayList();
            String[] tCoreEncryptionStrings = SM4Util.decryptEcb(key, (String)stringList.get(0), "0", (String)null, (String)null, (String)null).split("%_%");

            for(int i = 0; i < tCoreEncryptionStrings.length; ++i) {
               String[] encryptions = tCoreEncryptionStrings[i].split("#_#");
               TCoreEncryption tCoreEncryption = new TCoreEncryption();
               tCoreEncryption.setId(encryptions[0]);
               tCoreEncryption.setCreatetime(StringUtils.isBlank(encryptions[1]) ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(encryptions[1]));
               tCoreEncryption.setCreateuser(encryptions[2]);
               tCoreEncryption.setFlag(encryptions[3]);
               tCoreEncryption.setNote(encryptions[4]);
               tCoreEncryption.setUpdatetime(StringUtils.isBlank(encryptions[5]) ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(encryptions[5]));
               tCoreEncryption.setUpdateuser(encryptions[6]);
               tCoreEncryption.setEncryption_name(encryptions[7]);
               tCoreEncryption.setEncryption_type(encryptions[8]);
               tCoreEncryptionList.add(tCoreEncryption);
            }

            List<TCoreSecretkey> tCoreSecretkeyList = new ArrayList();
            String[] tCoreSecretkeyStrings = SM4Util.decryptEcb(key, (String)stringList.get(1), "0", (String)null, (String)null, (String)null).split("%_%");

            for(int i = 0; i < tCoreSecretkeyStrings.length; ++i) {
               String[] secretkeys = tCoreSecretkeyStrings[i].split("#_#");
               TCoreSecretkey tCoreSecretkey = new TCoreSecretkey();
               tCoreSecretkey.setId(secretkeys[0]);
               tCoreSecretkey.setCreatetime(StringUtils.isBlank(secretkeys[1]) ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(secretkeys[1]));
               tCoreSecretkey.setCreateuser(secretkeys[2]);
               tCoreSecretkey.setFlag(secretkeys[3]);
               tCoreSecretkey.setNote(secretkeys[4]);
               tCoreSecretkey.setUpdatetime(StringUtils.isBlank(secretkeys[5]) ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(secretkeys[5]));
               tCoreSecretkey.setUpdateuser(secretkeys[6]);
               tCoreSecretkey.setPrivatekey(secretkeys[7]);
               tCoreSecretkey.setPublickey(secretkeys[8]);
               tCoreSecretkey.setEncryption_id(secretkeys[9]);
               tCoreSecretkey.setSecret_key_name(secretkeys[10]);
               String sectetKeyValue = secretkeys[11];
               TCoreEncryptionServiceImpl tCoreEncryptionServiceImpl = (TCoreEncryptionServiceImpl)ApplicationContextProvider.getBean(TCoreEncryptionServiceImpl.class);
               String dataKey = tCoreEncryptionServiceImpl.getEncDataKey(sectetKeyValue);
               tCoreSecretkey.setSectet_key_value(dataKey);
               tCoreSecretkeyList.add(tCoreSecretkey);
            }

            List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList = new ArrayList();
            String[] tCoreFieldStrings = SM4Util.decryptEcb(key, (String)stringList.get(2), "0", (String)null, (String)null, (String)null).split("%_%");

            for(int i = 0; i < tCoreFieldStrings.length; ++i) {
               String[] fields = tCoreFieldStrings[i].split("#_#");
               TCoreEncryptionTypeField tCoreEncryptionTypeField = new TCoreEncryptionTypeField();
               tCoreEncryptionTypeField.setId(fields[0]);
               tCoreEncryptionTypeField.setCreatetime(StringUtils.isBlank(fields[1]) ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(fields[1]));
               tCoreEncryptionTypeField.setCreateuser(fields[2]);
               tCoreEncryptionTypeField.setFlag(fields[3]);
               tCoreEncryptionTypeField.setNote(fields[4]);
               tCoreEncryptionTypeField.setUpdatetime(StringUtils.isBlank(fields[5]) ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(fields[5]));
               tCoreEncryptionTypeField.setUpdateuser(fields[6]);
               tCoreEncryptionTypeField.setColumn_size(fields[7]);
               tCoreEncryptionTypeField.setCombination_id(fields[8]);
               tCoreEncryptionTypeField.setDataareaid(fields[9]);
               tCoreEncryptionTypeField.setDatasystem_id(fields[10]);
               tCoreEncryptionTypeField.setDescribe_info(fields[11]);
               tCoreEncryptionTypeField.setEncryption_secretkey_id(fields[12]);
               tCoreEncryptionTypeField.setNames(fields[13]);
               tCoreEncryptionTypeField.setProjectid(fields[14]);
               tCoreEncryptionTypeField.setTable_field_id(fields[15]);
               tCoreEncryptionTypeField.setTschemas(fields[16]);
               tCoreEncryptionTypeField.setDataareaname(fields[17]);
               tCoreEncryptionTypeField.setState(fields[18]);
               tCoreEncryptionTypeField.setColumn_type(fields[19]);
               tCoreEncryptionTypeField.setDatasystemname(fields[20]);
               tCoreEncryptionTypeField.setEncryptiontypename(fields[21]);
               tCoreEncryptionTypeField.setSecretkeyname(fields[22]);
               tCoreEncryptionTypeField.setIslike(fields[23]);
               tCoreEncryptionTypeField.setKeepfirst(fields[24]);
               tCoreEncryptionTypeField.setEncdigit(fields[25]);
               tCoreEncryptionTypeField.setRealitycolumnsize(fields[26]);
               tCoreEncryptionTypeField.setTwoindex(fields[27]);
               tCoreEncryptionTypeFieldList.add(tCoreEncryptionTypeField);
            }

            List<TCoreDatasystem> datasystemList = this.tCoreDatasystemDao.getbyprojectid(pid);
            List<DataBase> dataBases = DataCache.dataList;
            List<DataBase> newdataBaseList = new ArrayList();

            for(TCoreDatasystem datasystem : datasystemList) {
               Optional<DataBase> optionalDataBase = dataBases.stream().filter((d) -> d.getDatasystemid().equals(datasystem.getId())).findFirst();
               if (!optionalDataBase.isPresent()) {
                  return ErrCode.DATABASE_NOT_EXIST.getCode();
               }

               newdataBaseList.add(optionalDataBase.get());
            }

            List<DBEasyCache> dbEasyCaches = new ArrayList();

            for(DataBase dataBase : newdataBaseList) {
               DBEasyCache dbEasyCache = dataBase.easyCache;
               dbEasyCaches.add(dbEasyCache);
            }

            Boolean isExist = this.checkColumnExist(datasystemList, dbEasyCaches, tCoreEncryptionTypeFieldList);
            if (!isExist) {
               return ErrCode.DATABASE_NOT_EXIST.getCode();
            } else {
               for(TCoreEncryption tCoreEncryption : tCoreEncryptionList) {
                  TCoreEncryption oldt = (TCoreEncryption)this.tCoreEncryptionDao.queryUnique(new Criterion[]{Restrictions.eq("encryption_name", tCoreEncryption.getEncryption_name())});
                  String enctid = null;
                  Date date = new Date();
                  String newUsername = TokenUtil.getUserId(request.getHeader("token"));
                  if (null != oldt) {
                     tCoreEncryption.setFlag("0");
                     enctid = oldt.getId();
                  } else {
                     tCoreEncryption.setCreatetime(date);
                     tCoreEncryption.setCreateuser(newUsername);
                     tCoreEncryption.setUpdatetime(date);
                     tCoreEncryption.setUpdateuser(newUsername);
                  }

                  if (tCoreSecretkeyList != null && tCoreSecretkeyList.size() != 0) {
                     List<TCoreSecretkey> secretkeyList = (List)tCoreSecretkeyList.stream().filter((s) -> tCoreEncryption.getId().equals(s.getEncryption_id())).collect(Collectors.toList());
                     if (enctid != null) {
                        tCoreEncryption.setId(enctid);
                     } else {
                        tCoreEncryption.setId(StringTool.getTablePrimaryKey());
                     }

                     if (secretkeyList != null) {
                        for(TCoreSecretkey tCoreSecretkey : secretkeyList) {
                           String sectid = null;
                           tCoreSecretkey.setEncryption_id(tCoreEncryption.getId());
                           tCoreSecretkey.setEncryptionname(tCoreEncryption.getEncryption_name());
                           List<TCoreSecretkey> oldslist = this.tCoreSecretkeyDao.queryAll(new Criterion[]{Restrictions.eq("secret_key_name", tCoreSecretkey.getSecret_key_name())});
                           if (oldslist == null) {
                              tCoreSecretkey.setEncryption_id(tCoreEncryption.getId());
                              tCoreSecretkey.setCreatetime(date);
                              tCoreSecretkey.setCreateuser(newUsername);
                              tCoreSecretkey.setUpdatetime(date);
                              tCoreSecretkey.setUpdateuser(newUsername);
                           } else {
                              boolean flag = false;

                              for(TCoreSecretkey s : oldslist) {
                                 if (s.getSectet_key_value().equals(tCoreSecretkey.getSectet_key_value())) {
                                    flag = true;
                                    tCoreSecretkey.setFlag("0");
                                    sectid = s.getId();
                                    break;
                                 }
                              }

                              if (!flag) {
                                 tCoreSecretkey.setSecret_key_name(tCoreSecretkey.getSecret_key_name() + "_1");
                                 tCoreSecretkey.setCreatetime(date);
                                 tCoreSecretkey.setCreateuser(newUsername);
                                 tCoreSecretkey.setUpdatetime(date);
                                 tCoreSecretkey.setUpdateuser(newUsername);
                              }
                           }

                           if (tCoreEncryptionTypeFieldList != null && tCoreEncryptionTypeFieldList.size() != 0) {
                              List<TCoreEncryptionTypeField> tCoreEncryptionTypeFields = (List)tCoreEncryptionTypeFieldList.stream().filter((f) -> f.getEncryption_secretkey_id().equals(tCoreSecretkey.getId())).collect(Collectors.toList());
                              if (tCoreEncryptionTypeFields != null && tCoreEncryptionTypeFields.size() != 0) {
                                 for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCoreEncryptionTypeFields) {
                                    if (sectid != null) {
                                       tCoreSecretkey.setId(sectid);
                                    } else {
                                       tCoreSecretkey.setId(StringTool.getTablePrimaryKey());
                                    }

                                    tCoreEncryptionTypeField.setId(StringTool.getTablePrimaryKey());
                                    tCoreEncryptionTypeField.setEncryption_secretkey_id(tCoreSecretkey.getId());
                                    tCoreEncryptionTypeField.setProjectid(pid);
                                    tCoreEncryptionTypeField.setEncryptiontypename(tCoreEncryption.getEncryption_name());
                                    tCoreEncryptionTypeField.setSecretkeyname(tCoreSecretkey.getSecret_key_name());
                                    tCoreEncryptionTypeField.setCreatetime(date);
                                    tCoreEncryptionTypeField.setCreateuser(newUsername);
                                    tCoreEncryptionTypeField.setUpdatetime(date);
                                    tCoreEncryptionTypeField.setUpdateuser(newUsername);
                                 }
                              }
                           }
                        }
                     }
                  }
               }

               this.saveProjectEncryptionFields(tCoreEncryptionList, tCoreSecretkeyList, tCoreEncryptionTypeFieldList);
               return null;
            }
         } catch (Exception e) {
            e.printStackTrace();
            return ErrCode.WRONG_TXT.getCode();
         }
      }
   }

   private List<String> processRow(String username, Sheet sheet, Map<String, List<String>> tableNameOut, List<String> outNameList, int i) throws ServiceException {
      Row row = sheet.getRow(i);
      if (row != null) {
         String projectId = row.getCell(0).toString();
         String dataSystemId = row.getCell(1).toString();
         String dataSystemName = row.getCell(2).toString();
         String schema = row.getCell(3).toString();
         String tableName = row.getCell(4).toString();
         String fieldName = row.getCell(5).toString();
         String columnType = row.getCell(6).toString();
         String columnSize = row.getCell(7).toString();
         String remarks = row.getCell(8).toString();
         Cell celldesc = row.getCell(9);
         celldesc.setCellType(1);
         String disc = celldesc.toString();
         String flag = row.getCell(10).toString();
         String keyName = row.getCell(11).toString();
         String sKeyName = row.getCell(12).toString();
         List<String> parameter = new ArrayList();
         List<String> dataEncryptionTypeTidList = new ArrayList();
         if (sheet.getRow(i - 1).getCell(1).toString().equals(sheet.getRow(i).getCell(1).toString()) && sheet.getRow(i - 1).getCell(2).toString().equals(sheet.getRow(i).getCell(2).toString()) && sheet.getRow(i - 1).getCell(3).toString().equals(sheet.getRow(i).getCell(3).toString()) && sheet.getRow(i - 1).getCell(4).toString().equals(sheet.getRow(i).getCell(4).toString())) {
            if (!"已锁定".equals(keyName) && !"已锁定".equals(sKeyName)) {
               if (!"可修改".equals(sKeyName) && !"可修改".equals(keyName) && !"不可修改".equals(sKeyName) && !"不可修改".equals(keyName)) {
                  Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(keyName, sKeyName);
                  if (!ObjectUtil.isEmpty(encryptionInfo.get("msg"))) {
                     throw new ServiceException("POP_00031", "POP_00031", (String)encryptionInfo.get("msg"));
                  }

                  dataEncryptionTypeTidList.add(encryptionInfo.get("secretkeyId"));
               } else if (!"可修改".equals(disc) && ("可修改".equals(sKeyName) || "可修改".equals(keyName) || "不可修改".equals(sKeyName) || "不可修改".equals(keyName))) {
                  dataEncryptionTypeTidList.add("");
               }

               parameter.add(dataSystemId);
               parameter.add(fieldName);
               parameter.add(tableName);
               parameter.add(schema);
               parameter.add("可修改".equals(disc) ? "" : disc);
               parameter.add("已加密".equals(flag) ? "5" : "0");
               parameter.add(projectId);
               parameter.add(username);
               parameter.add("");
               parameter.add("");
               parameter.add(columnType);
               parameter.add(columnSize);

               try {
                  this.encryptionConfigService.saveColumnType(parameter, dataEncryptionTypeTidList);
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }
         } else {
            parameter = new ArrayList();
            dataEncryptionTypeTidList = new ArrayList();
            if (!"已锁定".equals(keyName) && !"已锁定".equals(sKeyName)) {
               if (!"可修改".equals(sKeyName) && !"可修改".equals(keyName) && !"不可修改".equals(sKeyName) && !"不可修改".equals(keyName)) {
                  Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(keyName, sKeyName);
                  if (!ObjectUtil.isEmpty(encryptionInfo.get("msg"))) {
                     throw new ServiceException("POP_00031", "POP_00031", (String)encryptionInfo.get("msg"));
                  }

                  dataEncryptionTypeTidList.add(encryptionInfo.get("secretkeyId"));
                  outNameList.add(fieldName);
                  tableNameOut.put(tableName, outNameList);
               } else if (!"可修改".equals(disc) && ("可修改".equals(sKeyName) || "可修改".equals(keyName) || "不可修改".equals(sKeyName) || "不可修改".equals(keyName))) {
                  dataEncryptionTypeTidList.add("");
                  outNameList.add(fieldName);
                  tableNameOut.put(tableName, outNameList);
               }

               parameter.add(dataSystemId);
               parameter.add(fieldName);
               parameter.add(tableName);
               parameter.add(schema);
               parameter.add("可修改".equals(disc) ? "" : disc);
               parameter.add("已加密".equals(flag) ? "5" : "0");
               parameter.add(projectId);
               parameter.add(username);
               parameter.add("");
               parameter.add("");
               parameter.add(columnType);
               parameter.add(columnSize);

               try {
                  this.encryptionConfigService.saveColumnType(parameter, dataEncryptionTypeTidList);
                  outNameList = new ArrayList();
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }
         }
      }

      return outNameList;
   }

   private Boolean checkColumnExist(List<TCoreDatasystem> datasystemList, List<DBEasyCache> dbEasyCaches, List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList) {
      for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCoreEncryptionTypeFieldList) {
         Column column = null;

         for(DBEasyCache dbEasyCache : dbEasyCaches) {
            column = dbEasyCache.getColumn(tCoreEncryptionTypeField.getTschemas(), tCoreEncryptionTypeField.getNames(), tCoreEncryptionTypeField.getTable_field_id());
            if (column != null) {
               String datasystemid = dbEasyCache.dataBase.getDatasystemid();
               tCoreEncryptionTypeField.setDatasystem_id(datasystemid);
               tCoreEncryptionTypeField.setDatasystemname(((TCoreDatasystem)((List)datasystemList.stream().filter((d) -> d.getId().equals(datasystemid)).collect(Collectors.toList())).stream().findFirst().get()).getSysname());
            }
         }

         if (column == null) {
            return false;
         }
      }

      return true;
   }

   @Transactional
   public void saveProjectEncryptionFields(List<TCoreEncryption> tCoreEncryptionList, List<TCoreSecretkey> tCoreSecretkeyList, List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList) {
      for(TCoreEncryption tCoreEncryption : tCoreEncryptionList) {
         if (!"0".equals(tCoreEncryption.getFlag())) {
            tCoreEncryption.setFlag((String)null);
            this.tCoreEncryptionDao.save(tCoreEncryption);

            for(TCoreSecretkey s : tCoreSecretkeyList.stream().filter((s) -> s.getEncryptionname().equals(tCoreEncryption.getEncryption_name())).collect(Collectors.toList())) {
               s.setEncryption_id(tCoreEncryption.getId());
            }
         }
      }

      for(TCoreSecretkey tCoreSecretkey : tCoreSecretkeyList) {
         if (!"0".equals(tCoreSecretkey.getFlag())) {
            tCoreSecretkey.setFlag((String)null);
            this.tCoreSecretkeyDao.save(tCoreSecretkey);

            for(TCoreEncryptionTypeField t : tCoreEncryptionTypeFieldList.stream().filter((tx) -> tx.getSecretkeyname().equals(tCoreSecretkey.getSecret_key_name())).collect(Collectors.toList())) {
               t.setEncryption_secretkey_id(tCoreSecretkey.getId());
            }
         }
      }

      for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCoreEncryptionTypeFieldList) {
         this.tCoreEncryptionTypeFieldDao.save(tCoreEncryptionTypeField);
      }

   }

   @ResponseBody
   @RequestMapping({"/flushProgress"})
   public Response<Object> flushProgress3(HttpServletRequest request) throws Exception {
      Response<Object> result = new Response<Object>();
      Map<String, Object> map = new HashMap();

      try {
         map.put("percent", request.getSession().getAttribute("percent"));
         result.setMsg("成功");
         result.setData(map);
         result.setCode("200");
      } catch (Exception e) {
         e.printStackTrace();
      }

      return result;
   }

   @ResponseBody
   @RequestMapping({"/getProcesslog"})
   public Response getProcessLog(String projectId, String dataSystemId, String schema, String tableName) {
      String path = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + projectId + File.separator + dataSystemId + File.separator + schema + "." + tableName + ".log";
      String processlog = this.tCoreEncryptionService.getProcesslog(path);
      return RespHelper.successResp(processlog);
   }

   @PassToken
   @ResponseBody
   @GetMapping({"/downloadProcesslog"})
   public void downloadProcesslog(@RequestParam("projectid") String projectId, @RequestParam("datasystemid") String dataSystemId, @RequestParam("schema") String schema, @RequestParam("tablename") String tableName, HttpServletRequest request, HttpServletResponse response) {
      String path = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + projectId + File.separator + dataSystemId + File.separator + schema + "." + tableName + ".log";
      File logFile = new File(path);
      if (!logFile.exists()) {
         throw new RuntimeException("文件" + logFile + "不存在");
      } else {
         String userAgent = request.getHeader("User-Agent");

         try {
            String projectname = ((TCoreDataProject)this.tCoreDataProjectDao.get(projectId)).getProject();
            String datasystemname = ((TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId)).getSysname();
            Date currentTime = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            String dateString = formatter.format(currentTime);
            String fname = projectname + "-" + datasystemname + "-" + schema + "." + tableName + "_" + dateString + ".log";
            if (!userAgent.contains("MSIE") && !userAgent.contains("Trident")) {
               fname = new String(fname.getBytes("UTF-8"), "ISO-8859-1");
            } else {
               fname = URLEncoder.encode(fname, "UTF-8");
            }

            response.setCharacterEncoding("utf-8");
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment;fileName=" + fname);
            InputStream inputStream = new FileInputStream(new File(path));
            OutputStream os = response.getOutputStream();
            byte[] b = new byte[2048];

            int length;
            while((length = inputStream.read(b)) > 0) {
               os.write(b, 0, length);
            }

            os.close();
            inputStream.close();
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   @EncryptLog
   @RequestMapping({"/loadingBatchTableParams"})
   @ResponseBody
   public Response loadingBatchTableParams(@RequestBody Map<String, String> map, HttpServletRequest request) {
      String initialSuffix = PropertyGhcaUtil.initialSuffix;
      String cipherSuffix = PropertyGhcaUtil.cipherSuffix;
      String copySuffix = PropertyGhcaUtil.copySuffix;
      String username = "";
      if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getHeader("token"))) {
         username = TokenUtil.getUserId(request.getHeader("token"));
      }

      List<TCoreEncryptionTypeField> tCorTypeFieldList = new ArrayList();
      String operate = (String)map.get("operate");
      String projectId = (String)map.get("projectid");
      Criterion c = Restrictions.eq("projectid", projectId);
      TCoreDataProject tCoreDataProject = (TCoreDataProject)this.tCoreDataProjectDao.get(projectId);
      TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
      encryptionLog.setOperModule("加密管理");
      encryptionLog.setProjectId((String)map.get("projectid"));
      if (null != operate && "0".equals(operate)) {
         encryptionLog.setCode("DDM_010020");
         encryptionLog.setOperptionMassage("用户[" + username + "]对[" + tCoreDataProject.getProject() + "项目下的表]执行了批量加密操作;");
      } else {
         encryptionLog.setCode("DDM_010021");
         encryptionLog.setOperptionMassage("用户[" + username + "]对[" + tCoreDataProject.getProject() + "项目下的表]执行了批量解密操作;");
      }

      encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
      encryptionLog.setCreatetime(new Date());
      encryptionLog.setOperptionUser(username);
      Date date = encryptionLog.getCreatetime();
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String dateString = sdf.format(date);
      String column_enc = "";

      try {
         column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
      } catch (Exception exception) {
         exception.printStackTrace();
      }

      encryptionLog.setColumn_enc(column_enc);
      this.tCoreEncrypLogDao.save(encryptionLog);
      if (operate.equals("1")) {
         Criterion criterion1 = Restrictions.eq("flag", "5");
         List<TCoreEncryptionTypeField> tCorTypeFieldList1 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion1, c});
         Criterion criterion2 = Restrictions.eq("flag", "44");
         List<TCoreEncryptionTypeField> tCorTypeFieldList2 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion2, c});
         Criterion criterion3 = Restrictions.eq("flag", "-2");
         List<TCoreEncryptionTypeField> tCorTypeFieldList3 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion3, c});
         Criterion criterion4 = Restrictions.eq("flag", "6");
         List<TCoreEncryptionTypeField> tCorTypeFieldList4 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion3, c});
         Criterion criterion5 = Restrictions.eq("flag", "10");
         List<TCoreEncryptionTypeField> tCorTypeFieldList5 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion5, c});
         List<TCoreEncryptionTypeField> tCorTypeFieldList6 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("flag", "11"), c});
         if (null != tCorTypeFieldList1 && tCorTypeFieldList1.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList1);
         }

         if (null != tCorTypeFieldList2 && tCorTypeFieldList2.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList2);
         }

         if (null != tCorTypeFieldList3 && tCorTypeFieldList3.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList3);
         }

         if (null != tCorTypeFieldList4 && tCorTypeFieldList4.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList4);
         }

         if (null != tCorTypeFieldList5 && tCorTypeFieldList5.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList5);
         }

         if (null != tCorTypeFieldList6 && tCorTypeFieldList6.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList6);
         }
      } else {
         Criterion criterion1 = Restrictions.eq("flag", "0");
         List<TCoreEncryptionTypeField> tCorTypeFieldList1 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion1, c});
         Criterion criterion2 = Restrictions.eq("flag", "7");
         List<TCoreEncryptionTypeField> tCorTypeFieldList2 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion2, c});
         Criterion criterion3 = Restrictions.eq("flag", "4");
         List<TCoreEncryptionTypeField> tCorTypeFieldList3 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion3, c});
         Criterion criterion4 = Restrictions.eq("flag", "-1");
         List<TCoreEncryptionTypeField> tCorTypeFieldList4 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion4, c});
         Criterion criterion5 = Restrictions.eq("flag", "9");
         List<TCoreEncryptionTypeField> tCorTypeFieldList5 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion5, c});
         List<TCoreEncryptionTypeField> tCorTypeFieldList6 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("flag", "12"), c});
         if (null != tCorTypeFieldList1 && tCorTypeFieldList1.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList1);
         }

         if (null != tCorTypeFieldList2 && tCorTypeFieldList2.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList2);
         }

         if (null != tCorTypeFieldList3 && tCorTypeFieldList3.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList3);
         }

         if (null != tCorTypeFieldList4 && tCorTypeFieldList4.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList4);
         }

         if (null != tCorTypeFieldList5 && tCorTypeFieldList5.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList5);
         }

         if (null != tCorTypeFieldList6 && tCorTypeFieldList6.size() > 0) {
            tCorTypeFieldList.addAll(tCorTypeFieldList6);
         }

         List<TCoreEncryptionTypeField> schemaFieldList = new ArrayList();
         List<TCoreEncryptionTypeField> schemaFieldList1 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("flag", "5")});
         List<TCoreEncryptionTypeField> schemaFieldList2 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("flag", "7")});
         schemaFieldList.addAll(schemaFieldList1);
         schemaFieldList.addAll(schemaFieldList2);

         for(TCoreEncryptionTypeField tCoreEncryptionTypeField : schemaFieldList) {
            String datasystemid = tCoreEncryptionTypeField.getDatasystem_id();
            String schema = tCoreEncryptionTypeField.getTschemas();
            String table = tCoreEncryptionTypeField.getNames();
            TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", datasystemid)});
            if (!"HIVE_TDH".equals(datasystem.getDbtype()) && !"MONGODB".equals(datasystem.getDbtype()) && !"ES".equals(datasystem.getDbtype())) {
               Connection co = JdbcTool.getConnection(datasystem);
               ResultSet resultSet = JdbcTool.getColumns(co, schema, table);

               try {
                  while(resultSet.next()) {
                     if ((tCoreEncryptionTypeField.getTable_field_id() + copySuffix).equals(resultSet.getString("COLUMN_NAME")) && ("0".equals(tCoreEncryptionTypeField.getFlag()) || "7".equals(tCoreEncryptionTypeField.getFlag()))) {
                        Response columnStrings = RespHelper.errResp(ErrCode.REDUNDANCE_COLUMN);
                        return columnStrings;
                     }
                  }
               } catch (SQLException e) {
                  e.printStackTrace();
               } finally {
                  if (resultSet != null) {
                     try {
                        resultSet.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }
            }

            if ("ES".equals(datasystem.getDbtype())) {
               EsUtil esUtil = new EsUtil();
               Set<String> stringList = null;

               try {
                  stringList = esUtil.getColumns(datasystem, schema, table);
                  stringList = (Set)stringList.stream().map((x) -> {
                     String[] m = x.split(":");
                     return m[0];
                  }).collect(Collectors.toSet());
                  if (stringList.contains(tCoreEncryptionTypeField.getTable_field_id() + copySuffix) && ("0".equals(tCoreEncryptionTypeField.getFlag()) || "7".equals(tCoreEncryptionTypeField.getFlag()))) {
                     return RespHelper.errResp(ErrCode.REDUNDANCE_COLUMN);
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }

            if ("MONGODB".equals(datasystem.getDbtype())) {
               try {
                  MongoClient client = MongodbTool.connect(datasystem.getDbservername(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), true);
                  List<Column> columnList = MongodbTool.findAllColumns(client, schema, table);
                  List<String> columnStrings = (List)columnList.stream().map(Column::getColumnName).collect(Collectors.toList());
                  if (columnStrings.contains(tCoreEncryptionTypeField.getTable_field_id() + copySuffix) && ("0".equals(tCoreEncryptionTypeField.getFlag()) || "7".equals(tCoreEncryptionTypeField.getFlag()))) {
                     return RespHelper.errResp(ErrCode.REDUNDANCE_COLUMN);
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }
         }
      }

      List<Map<String, Object>> LoadingList = new ArrayList();
      tCorTypeFieldList = (List)tCorTypeFieldList.stream().filter((t) -> !ObjectUtils.isEmpty(t.getEncryption_secretkey_id())).filter((t) -> !ObjectUtils.isEmpty(t.getEncryptiontypename())).filter((t) -> !ObjectUtils.isEmpty(t.getSecretkeyname())).collect(Collectors.toList());
      Map<String, List<TCoreEncryptionTypeField>> collect = (Map)tCorTypeFieldList.stream().collect(Collectors.groupingBy((x) -> x.getDatasystem_id() + "." + x.getTschemas()));
      List<LoadingParameterVO> loadingParameterVOList = (List)collect.keySet().stream().map((key) -> {
         LoadingParameterVO vo = new LoadingParameterVO();
         Map<String, List<TCoreEncryptionTypeField>> groupTabelMap = (collect.get(key)).stream().collect(Collectors.groupingBy((x) -> x.getNames()));
         List<TableInfoVO> tableList = (List)groupTabelMap.keySet().stream().map((tkey) -> {
            TableInfoVO tableInfoVo = new TableInfoVO();
            tableInfoVo.setTableName(tkey);
            List<TCoreEncryptionTypeField> tCoreEncryptionTypeFields = (List)groupTabelMap.get(tkey);
            String qqDataSystemId = "";
            String qqSchema = "";
            if (tCoreEncryptionTypeFields.size() > 0) {
               qqDataSystemId = ((TCoreEncryptionTypeField)tCoreEncryptionTypeFields.get(0)).getDatasystem_id();
               qqSchema = ((TCoreEncryptionTypeField)tCoreEncryptionTypeFields.get(0)).getTschemas();
            }

            EncryptionConfigVO proEncryptionConfigVO = new EncryptionConfigVO();
            proEncryptionConfigVO.setDatasystem_id(qqDataSystemId);
            proEncryptionConfigVO.setSchema(qqSchema);
            proEncryptionConfigVO.setTable_name(tkey);
            proEncryptionConfigVO.setProjectId(projectId);
            List<ColumnInfoVO> proColumnInfoVOList = this.encryptionConfigService.queryOriginalList(proEncryptionConfigVO);
            Map<String, List<ColumnInfoVO>> jdbcColumnMap = (Map)proColumnInfoVOList.stream().collect(Collectors.groupingBy((x) -> x.getColumnname()));
            tCoreEncryptionTypeFields = (List)tCoreEncryptionTypeFields.stream().filter((t) -> jdbcColumnMap.containsKey(t.getTable_field_id())).collect(Collectors.toList());
            List<com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO> columnInfoList = (List)tCoreEncryptionTypeFields.stream().map((x) -> {
               com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO columnInfoVO = new com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO();
               String secretKeyId = x.getEncryption_secretkey_id();
               columnInfoVO.setColumnName(x.getTable_field_id());
               Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
               columnInfoVO.setEncryptionType((String)encryptionInfo.get("encryptionType"));
               columnInfoVO.setSecretKey((String)encryptionInfo.get("secretkey"));
               columnInfoVO.setSecretKeyId(secretKeyId);
               columnInfoVO.setDataSystemId(x.getDatasystem_id());
               columnInfoVO.setSchema(x.getTschemas());
               columnInfoVO.setColumnType(x.getColumn_type());
               columnInfoVO.setColumnSize(x.getColumn_size());
               columnInfoVO.setRealitycolumnsize(x.getRealitycolumnsize());
               columnInfoVO.setTcoreencryptionfieldId(x.getId());
               columnInfoVO.setIsLike(x.getIslike());
               columnInfoVO.setKeepfirst(x.getKeepfirst());
               columnInfoVO.setEncdigit(x.getEncdigit());
               columnInfoVO.setTwoindex(x.getTwoindex());
               columnInfoVO.setTcoreencryptionfieldId(x.getId());
               String describeInfo = "";
               if (x.getDescribe_info() != null && !x.getDescribe_info().equals("")) {
                  describeInfo = x.getDescribe_info();
               }

               String tt = x.getTschemas() + "." + x.getNames() + "." + x.getTable_field_id();
               HashMap<String, String> ja = new HashMap();
               ja.put("describe_info", describeInfo);
               ja.put("encryptionSecretKeyId", secretKeyId);
               if (operate.equals("0")) {
                  ja.put("flag", "1");
               } else if (operate.equals("1")) {
                  ja.put("flag", "0");
               } else {
                  ja.put("flag", "6");
               }

               ja.put("columnType", x.getColumn_type());
               ja.put("columnSize", x.getColumn_size());
               HashMap<String, HashMap<String, String>> ttMap = new HashMap();
               ttMap.put(tt, ja);
               HashMap<String, Object> tyMap = new HashMap();
               tyMap.put("datasystemid", x.getDatasystem_id());
               tyMap.put("map", ttMap);
               LoadingList.add(tyMap);
               return columnInfoVO;
            }).collect(Collectors.toList());
            if (null != columnInfoList && columnInfoList.size() > 0) {
               tableInfoVo.setColumnInfo(columnInfoList);
            }

            String primaryKeyColumns = "";

            for(int y = 0; y < proColumnInfoVOList.size(); ++y) {
               String proKey = ((ColumnInfoVO)proColumnInfoVOList.get(y)).getPrimarykey();
               if (null != proKey && proKey.equals("1")) {
                  primaryKeyColumns = primaryKeyColumns + "," + ((ColumnInfoVO)proColumnInfoVOList.get(y)).getColumnname();
               }
            }

            if (primaryKeyColumns != null && !primaryKeyColumns.equals("")) {
               primaryKeyColumns = primaryKeyColumns.substring(1, primaryKeyColumns.length());
               String[] primaryKeys = primaryKeyColumns.split(",");
               tableInfoVo.setPrimaryKeys(primaryKeys);
            }

            return tableInfoVo;
         }).collect(Collectors.toList());
         tableList = (List)tableList.stream().filter((t) -> null != t.getColumnInfo()).collect(Collectors.toList());
         vo.setTableInfo(tableList);
         String dataId = "";
         String sch2 = "";
         if (tableList.size() > 0) {
            TableInfoVO tableIn = (TableInfoVO)tableList.get(0);
            List<com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO> columnInfoVOList = tableIn.getColumnInfo();
            dataId = ((com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO)columnInfoVOList.get(0)).getDataSystemId();
            sch2 = ((com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO)columnInfoVOList.get(0)).getSchema();
         }

         TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataId)});
         vo.setDataSystemId(dataId);
         vo.settCoreDatasystem(tCoreDatasystem);
         vo.setProjectId(projectId);
         vo.setSchema(sch2);
         return vo;
      }).collect(Collectors.toList());
      loadingParameterVOList = (List)loadingParameterVOList.stream().filter((t) -> t.getTableInfo().size() > 0).collect(Collectors.toList());
      if (null != loadingParameterVOList && loadingParameterVOList.size() > 0) {
         if ("0".equals(operate)) {
            this.doLoadingBatchTable(loadingParameterVOList);
         } else {
            this.doRemoveLoadAllBatchTable(loadingParameterVOList);
         }
      }

      return RespHelper.successResp();
   }

   @RequestMapping({"/hasRedundanceColumns"})
   @ResponseBody
   public Response hasRedundanceColumns(@RequestBody Map<String, String> map) {
      String initialSuffix = PropertyGhcaUtil.initialSuffix;
      String cipherSuffix = PropertyGhcaUtil.cipherSuffix;
      String copySuffix = PropertyGhcaUtil.copySuffix;
      String projectid = (String)map.get("projectid");
      String datasystemid = (String)map.get("datasystemid");
      String schema = (String)map.get("schema");
      String table = (String)map.get("table");
      Connection co = null;
      ResultSet resultSet = null;
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", datasystemid)});
      if ("HIVE_TDH".equals(datasystem.getDbtype())) {
         return RespHelper.successResp();
      } else {
         try {
            List<TCoreEncryptionTypeField> schemaFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectid), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table), Restrictions.eq("datasystem_id", datasystemid)});
            co = JdbcTool.getConnection(datasystem);

            for(TCoreEncryptionTypeField tCoreEncryptionTypeField : schemaFieldList) {
               resultSet = JdbcTool.getColumns(co, schema, table);

               while(resultSet.next()) {
                  if ((tCoreEncryptionTypeField.getTable_field_id() + copySuffix).equals(resultSet.getString("COLUMN_NAME")) && ("0".equals(tCoreEncryptionTypeField.getFlag()) || "7".equals(tCoreEncryptionTypeField.getFlag()) || "4".equals(tCoreEncryptionTypeField.getFlag()))) {
                     Response var15 = RespHelper.errResp(ErrCode.REDUNDANCE_COLUMN);
                     return var15;
                  }
               }
            }

            return RespHelper.successResp();
         } catch (Exception e) {
            e.printStackTrace();
            return RespHelper.successResp();
         } finally {
            if (co != null) {
               try {
                  co.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

            if (resultSet != null) {
               try {
                  resultSet.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

         }
      }
   }

   private String checkEncryption(TCoreDatasystem tCoreDatasystem, String schema, String tableName, String columnName, String secretKeyId, String isLike, String keepfirst, String encdigit, String twoindex) {
      ResultSet rsCount = null;
      int checkNum = Integer.valueOf(PropertyGhcaUtil.checkNum);
      int sumNum = 0;
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);

      try {
         Connection conn = JdbcTool.getConnection(tCoreDatasystem);
         Throwable var15 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var17 = null;

            try {
               String copySuffix = PropertyGhcaUtil.copySuffix;
               Boolean bb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  bb = false;
               }

               Boolean bbb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  bbb = false;
               }

               Boolean isgreenplum = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  isgreenplum = false;
               }

               Boolean isHivetdh = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  isHivetdh = false;
               }

               Boolean SQBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  SQBoolean = false;
               }

               Boolean DMBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  DMBoolean = false;
               }

               Boolean KBBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  KBBoolean = false;
               }

               int iCLimitCount = 0;
               ResultSet rsC = null;

               String columnNameN;
               try {
                  if (bb) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (bbb) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL) offset " + iCLimitCount + " limit " + checkNum + " ) t");
                  } else if (isgreenplum) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL) offset " + iCLimitCount + " limit " + checkNum + " ) t");
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " ) t");
                  } else if (SQBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " ) t");
                  } else if (isHivetdh) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " ) t");
                  } else if (DMBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (KBBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " ) t");
                  }

                  int num;
                  for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                  }

                  if (num > 0) {
                     StringBuilder mg = new StringBuilder();
                     mg.append("数据源：");
                     mg.append(schema);
                     mg.append("表：");
                     mg.append(tableName);
                     mg.append("列：");
                     mg.append(columnName);
                     mg.append("加密后的数据为空，加密失败，准备回滚。");
                     columnNameN = mg.toString();
                     return columnNameN;
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  if (rsC != null) {
                     try {
                        rsC.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }

               ResultSet rs1 = null;

               try {
                  if (bb) {
                     rs1 = stmt.executeQuery("select nn.\"" + columnName + "\",nn.\"" + columnName + copySuffix + "\" from (select t.\"" + columnName + "\",t.\"" + columnName + copySuffix + "\",rownum rn from \"" + schema + "\".\"" + tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                  } else if (bbb) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (isgreenplum) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (isHivetdh) {
                     rs1 = stmt.executeQuery("select " + columnName + "," + columnName + copySuffix + " from " + schema + "." + tableName + " LIMIT " + iCLimitCount + " , " + checkNum);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (SQBoolean) {
                     rs1 = stmt.executeQuery("SELECT " + columnName + "," + columnName + copySuffix + ", 0 AS _NAV_ORDER_F_ FROM " + schema + "." + tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                  } else if (KBBoolean) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                  } else if (DMBoolean) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                  } else {
                     rs1 = stmt.executeQuery(this.checkColumn(schema, tableName, columnName, columnName + copySuffix, iCLimitCount, checkNum));
                  }

                  while(rs1.next()) {
                     String copy = rs1.getString(columnName + copySuffix);
                     if (null != copy) {
                        columnNameN = rs1.getString(columnName);
                        Map<String, String> encryptionInfo = tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                        if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType"))) {
                           Boolean isEq = EncUtils.compareStringEq(columnNameN, EncProvider.decryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), copy, isLike, keepfirst, encdigit, twoindex));
                           if (!isEq) {
                              StringBuilder mg111 = new StringBuilder();
                              mg111.append("数据源：");
                              mg111.append(schema);
                              mg111.append("表：");
                              mg111.append(tableName);
                              mg111.append("列：");
                              mg111.append(columnName);
                              mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                              String var34 = mg111.toString();
                              return var34;
                           }
                        }
                     }
                  }

                  return "ok";
               } catch (Exception e) {
                  e.printStackTrace();
                  columnNameN = "e1";
                  return columnNameN;
               } finally {
                  if (rs1 != null) {
                     try {
                        rs1.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }
            } catch (Throwable var135) {
               var17 = var135;
               throw var135;
            } finally {
               if (stmt != null) {
                  if (var17 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var128) {
                        var17.addSuppressed(var128);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var137) {
            var15 = var137;
            throw var137;
         } finally {
            if (conn != null) {
               if (var15 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var127) {
                     var15.addSuppressed(var127);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         e.printStackTrace();
         return "e2";
      }
   }

   private String checkDecryption(TCoreDatasystem tCoreDatasystem, String schema, String tableName, String columnName, String secretKeyId, String isLike, String keepfirst, String encdigit, String twoindex) {
      ResultSet rsCount = null;
      int checkNum = PropertyGhcaUtil.checkNum;
      int sumNum = 0;
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);

      try {
         Connection conn = JdbcTool.getConnection(tCoreDatasystem);
         Throwable var15 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var17 = null;

            try {
               String copySuffix = PropertyGhcaUtil.copySuffix;
               Boolean bb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  bb = false;
               }

               Boolean bbb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  bbb = false;
               }

               Boolean isgreenplum = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  isgreenplum = false;
               }

               Boolean SQBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  SQBoolean = false;
               }

               Boolean DMBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  DMBoolean = false;
               }

               Boolean KBBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  KBBoolean = false;
               }

               Boolean isHivetdh = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  isHivetdh = false;
               }

               int iCLimitCount = 0;
               ResultSet rsC = null;

               String copy;
               try {
                  if (bb) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (bbb) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL  ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (isgreenplum) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL  ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (SQBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL  ) limit " + iCLimitCount + "," + checkNum + " )t");
                  } else if (isHivetdh) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL  ) limit " + iCLimitCount + "," + checkNum + " )t");
                  } else if (DMBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (KBBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                  }

                  int num;
                  for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                  }

                  if (num > 0) {
                     StringBuilder mg = new StringBuilder();
                     mg.append("数据源：");
                     mg.append(schema);
                     mg.append("表：");
                     mg.append(tableName);
                     mg.append("列：");
                     mg.append(columnName);
                     mg.append("解密后的数据为空，解密失败，准备回滚。");
                     copy = mg.toString();
                     return copy;
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  if (rsC != null) {
                     try {
                        rsC.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }

               int LimitCount = 0;
               ResultSet rs1 = null;

               try {
                  String columnNameN;
                  try {
                     if (bb) {
                        rs1 = stmt.executeQuery("select nn.\"" + columnName + "\",nn.\"" + columnName + copySuffix + "\" from (select t.\"" + columnName + "\",t.\"" + columnName + copySuffix + "\",rownum rn from \"" + schema + "\".\"" + tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                     } else if (bbb) {
                        rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                     } else if (isgreenplum) {
                        rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                     } else if (SQBoolean) {
                        rs1 = stmt.executeQuery("SELECT " + columnName + "," + columnName + copySuffix + ", 0 AS _NAV_ORDER_F_ FROM " + schema + "." + tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                     } else if (DMBoolean) {
                        rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                     } else if (KBBoolean) {
                        rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                     } else if (isHivetdh) {
                        rs1 = stmt.executeQuery("select " + columnName + "," + columnName + copySuffix + " from " + schema + "." + tableName + " LIMIT " + iCLimitCount + " , " + checkNum);
                     } else {
                        rs1 = stmt.executeQuery(this.checkColumn(schema, tableName, columnName, columnName + copySuffix, iCLimitCount, checkNum));
                     }

                     while(rs1.next()) {
                        copy = rs1.getString(columnName + copySuffix);
                        if (null != copy) {
                           columnNameN = rs1.getString(columnName);
                           if (!EncUtils.compareStringEq(columnNameN, copy)) {
                              Map<String, String> encryptionInfo = tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                              if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType"))) {
                                 Boolean isEq = EncUtils.compareStringEq(columnNameN, EncProvider.encryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), copy, isLike, keepfirst, encdigit, twoindex));
                                 if (!isEq) {
                                    StringBuilder mg111 = new StringBuilder();
                                    mg111.append("数据源：");
                                    mg111.append(schema);
                                    mg111.append("表：");
                                    mg111.append(tableName);
                                    mg111.append("列：");
                                    mg111.append(columnName);
                                    mg111.append("解密后的数据 做加密校验与原加密数据不一致，准备回滚。");
                                    String var35 = mg111.toString();
                                    return var35;
                                 }
                              }
                           }
                        }
                     }

                     return "ok";
                  } catch (Exception var132) {
                     copy = var132.getMessage();
                     var132.printStackTrace();
                     columnNameN = "e1";
                     return columnNameN;
                  }
               } finally {
                  if (rs1 != null) {
                     try {
                        rs1.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }
            } catch (Throwable var136) {
               var17 = var136;
               throw var136;
            } finally {
               if (stmt != null) {
                  if (var17 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var129) {
                        var17.addSuppressed(var129);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var138) {
            var15 = var138;
            throw var138;
         } finally {
            if (conn != null) {
               if (var15 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var128) {
                     var15.addSuppressed(var128);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         e.printStackTrace();
         return "e2";
      }
   }

   private String checkColumn(String schema, String tableName, String columnName, String checkColumnName, int iCLimitCount, int limitCount) {
      String sql = String.format("SELECT %s,%s FROM %s.%s limit %s,%s", columnName, checkColumnName, schema, tableName, iCLimitCount, limitCount);
      return sql;
   }

   private Response createErrorStateResponse(ErrCode code, String type) {
      Response response = RespHelper.createRespObj(code.getCode(), code.getDesc());
      response.setFlag(true);
      response.setData(type);
      return response;
   }

   private TCoreEncryptionService getTCoreEncryptionServiceFactory() {
      TCoreKeyTypeManagementVO tCoreKeyTypeManagementVO = this.keyManagerService.queryTCoreKeyTypeManageUsed();
      switch (tCoreKeyTypeManagementVO.getTypeid()) {
         case "1":
            return (TCoreEncryptionService)SpringUtil.getBean(TCoreEncryptionServiceImpl.class);
         case "2":
         case "3":
            return (TCoreEncryptionService)SpringUtil.getBean(TCoreEncryptionServiceSdkImpl.class);
         case "4":
            return (TCoreEncryptionService)SpringUtil.getBean(TCoreEncryptionServiceCCoreSDFImpl.class);
         case "5":
            return (TCoreEncryptionService)SpringUtil.getBean(TCoreEncryptionServiceKmsImpl.class);
         case "6":
            return (TCoreEncryptionService)SpringUtil.getBean(TCoreEncryptionServiceThKmsImpl.class);
         default:
            return null;
      }
   }

   public static void closeConnection(Connection connection) {
      if (connection != null) {
         try {
            connection.close();
         } catch (SQLException throwables) {
            throwables.printStackTrace();
         }
      }

   }

   @RequestMapping({"/export"})
   @ResponseBody
   public Response export(HttpServletResponse response) {
      List<TCoreEncryption> encryptionList = this.tCoreEncryptionDao.getExportEncryption();
      List<TCoreSecretkey> secretkeyList = this.tCoreSecretkeyDao.getExportSecretKeys();

      for(int i = 0; i < secretkeyList.size(); ++i) {
         TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)secretkeyList.get(i);
         TCoreEncryptionServiceImpl tCoreEncryptionServiceImpl = (TCoreEncryptionServiceImpl)ApplicationContextProvider.getBean(TCoreEncryptionServiceImpl.class);
         String dataKey = tCoreEncryptionServiceImpl.getDecDataKey(tCoreSecretkey.getSectet_key_value());
         tCoreSecretkey.setSectet_key_value(dataKey);
      }

      HashMap<String, List> map = new HashMap();
      List<Map<String, String>> mapList1 = new ArrayList();
      List<Map<String, String>> mapList2 = new ArrayList();

      for(TCoreEncryption tCoreEncryption : encryptionList) {
         Map<String, String> map1 = new HashMap();
         map1.put("id", tCoreEncryption.getId());
         map1.put("createtime", tCoreEncryption.getCreatetime() == null ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(tCoreEncryption.getCreatetime()));
         map1.put("createuser", tCoreEncryption.getCreateuser());
         map1.put("flag", tCoreEncryption.getFlag());
         map1.put("note", tCoreEncryption.getNote());
         map1.put("updatetime", tCoreEncryption.getUpdatetime() == null ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(tCoreEncryption.getUpdatetime()));
         map1.put("updateuser", tCoreEncryption.getUpdateuser());
         map1.put("encryption_name", tCoreEncryption.getEncryption_name());
         map1.put("encryption_type", tCoreEncryption.getEncryption_type());
         mapList1.add(map1);
      }

      for(TCoreSecretkey tCoreSecretkey : secretkeyList) {
         Map<String, String> map2 = new HashMap();
         map2.put("id", tCoreSecretkey.getId());
         map2.put("createtime", tCoreSecretkey.getCreatetime() == null ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(tCoreSecretkey.getCreatetime()));
         map2.put("createuser", tCoreSecretkey.getCreateuser());
         map2.put("flag", tCoreSecretkey.getFlag());
         map2.put("note", tCoreSecretkey.getNote());
         map2.put("updatetime", tCoreSecretkey.getUpdatetime() == null ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(tCoreSecretkey.getUpdatetime()));
         map2.put("updateuser", tCoreSecretkey.getUpdateuser());
         map2.put("privatekey", tCoreSecretkey.getPrivatekey());
         map2.put("publickey", tCoreSecretkey.getPublickey());
         map2.put("encryption_id", tCoreSecretkey.getEncryption_id());
         map2.put("secret_key_name", tCoreSecretkey.getSecret_key_name());
         map2.put("sectet_key_value", tCoreSecretkey.getSectet_key_value());
         mapList2.add(map2);
      }

      map.put("enc", mapList1);
      map.put("key", mapList2);
      this.encxls("加密规则表", map, response);
      return null;
   }

   @PostMapping({"/importfile"})
   @ResponseBody
   public Response importfile(@RequestParam("fileUpload") MultipartFile excelFile, HttpServletRequest request) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      InputStream in = null;
      String fileName = excelFile.getOriginalFilename();
      String username = TokenUtil.getUserId(request.getHeader("token"));

      try {
         in = excelFile.getInputStream();
         Workbook wb = null;

         assert fileName != null;

         String fileType = fileName.substring(fileName.lastIndexOf("."));
         if (".xls".equals(fileType)) {
            wb = new HSSFWorkbook(in);
         } else if (".xlsx".equals(fileType)) {
            try {
               wb = new XSSFWorkbook(OPCPackage.open(in));
            } catch (InvalidFormatException | IOException e) {
               ((Exception)e).printStackTrace();
            }
         }

         assert wb != null;

         Sheet sheet = wb.getSheetAt(0);
         if ("加密规则表".equals(sheet.getSheetName())) {
            try {
               Sheet sheet1 = wb.getSheetAt(0);
               Sheet sheet2 = wb.getSheetAt(1);
               int rowsNum1 = sheet1.getLastRowNum();
               List<TCoreEncryption> tCoreEncryptionList = new ArrayList();

               for(int i = 1; i < rowsNum1 + 1; ++i) {
                  Row row = sheet1.getRow(i);
                  TCoreEncryption tCoreEncryption = new TCoreEncryption();
                  tCoreEncryption.setId(row.getCell(0).toString());
                  tCoreEncryption.setCreatetime(StringUtils.isBlank(row.getCell(1).toString()) ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(row.getCell(1).toString()));
                  tCoreEncryption.setCreateuser(row.getCell(2).toString());
                  tCoreEncryption.setFlag(row.getCell(3).toString());
                  tCoreEncryption.setNote(row.getCell(4).toString());
                  tCoreEncryption.setUpdatetime(StringUtils.isBlank(row.getCell(5).toString()) ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(row.getCell(5).toString()));
                  tCoreEncryption.setUpdateuser(row.getCell(6).toString());
                  tCoreEncryption.setEncryption_name(row.getCell(7).toString());
                  tCoreEncryption.setEncryption_type(row.getCell(8).toString());
                  tCoreEncryptionList.add(tCoreEncryption);
               }

               int rowsNum2 = sheet2.getLastRowNum();
               List<TCoreSecretkey> tCoreSecretkeyList = new ArrayList();

               for(int i = 1; i < rowsNum2 + 1; ++i) {
                  Row row = sheet2.getRow(i);
                  TCoreSecretkey tCoreSecretkey = new TCoreSecretkey();
                  tCoreSecretkey.setId(row.getCell(0).toString());
                  tCoreSecretkey.setCreatetime(StringUtils.isBlank(row.getCell(1).toString()) ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(row.getCell(1).toString()));
                  tCoreSecretkey.setCreateuser(row.getCell(2).toString());
                  tCoreSecretkey.setFlag(row.getCell(3).toString());
                  tCoreSecretkey.setNote(row.getCell(4).toString());
                  tCoreSecretkey.setUpdatetime(StringUtils.isBlank(row.getCell(5).toString()) ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(row.getCell(5).toString()));
                  tCoreSecretkey.setUpdateuser(row.getCell(6).toString());
                  tCoreSecretkey.setPrivatekey(row.getCell(7).toString());
                  tCoreSecretkey.setPublickey(row.getCell(8).toString());
                  tCoreSecretkey.setEncryption_id(row.getCell(9).toString());
                  tCoreSecretkey.setSecret_key_name(row.getCell(10).toString());
                  String sectetKeyValue = row.getCell(11).toString();
                  TCoreEncryptionServiceImpl tCoreEncryptionServiceImpl = (TCoreEncryptionServiceImpl)ApplicationContextProvider.getBean(TCoreEncryptionServiceImpl.class);
                  String dataKey = tCoreEncryptionServiceImpl.getEncDataKey(sectetKeyValue);
                  tCoreSecretkey.setSectet_key_value(dataKey);
                  tCoreSecretkeyList.add(tCoreSecretkey);
               }

               for(TCoreEncryption tCoreEncryption : tCoreEncryptionList) {
                  TCoreEncryption oldt = (TCoreEncryption)this.tCoreEncryptionDao.queryUnique(new Criterion[]{Restrictions.eq("encryption_name", tCoreEncryption.getEncryption_name())});
                  String enctid = null;
                  Date date = new Date();
                  String newUsername = TokenUtil.getUserId(request.getHeader("token"));
                  if (null != oldt) {
                     tCoreEncryption.setFlag("0");
                     enctid = oldt.getId();
                  } else {
                     tCoreEncryption.setCreatetime(date);
                     tCoreEncryption.setCreateuser(newUsername);
                     tCoreEncryption.setUpdatetime(date);
                     tCoreEncryption.setUpdateuser(newUsername);
                  }

                  if (tCoreSecretkeyList != null && tCoreSecretkeyList.size() != 0) {
                     List<TCoreSecretkey> secretkeyList = (List)tCoreSecretkeyList.stream().filter((sx) -> tCoreEncryption.getId().equals(sx.getEncryption_id())).collect(Collectors.toList());
                     if (enctid != null) {
                        tCoreEncryption.setId(enctid);
                     } else {
                        tCoreEncryption.setId(StringTool.getTablePrimaryKey());
                     }

                     if (secretkeyList != null) {
                        for(TCoreSecretkey tCoreSecretkey : secretkeyList) {
                           String sectid = null;
                           tCoreSecretkey.setEncryption_id(tCoreEncryption.getId());
                           tCoreSecretkey.setEncryptionname(tCoreEncryption.getEncryption_name());
                           List<TCoreSecretkey> oldslist = this.tCoreSecretkeyDao.queryAll(new Criterion[]{Restrictions.eq("secret_key_name", tCoreSecretkey.getSecret_key_name()), Restrictions.eq("encryption_id", tCoreSecretkey.getEncryption_id())});
                           if (oldslist != null && oldslist.size() > 0) {
                              boolean flag = false;

                              for(TCoreSecretkey s : oldslist) {
                                 if (s.getSectet_key_value().equals(tCoreSecretkey.getSectet_key_value())) {
                                    flag = true;
                                    tCoreSecretkey.setFlag("0");
                                    break;
                                 }
                              }

                              if (!flag) {
                                 tCoreSecretkey.setSecret_key_name(tCoreSecretkey.getSecret_key_name() + "_1");
                                 tCoreSecretkey.setCreatetime(date);
                                 tCoreSecretkey.setCreateuser(newUsername);
                                 tCoreSecretkey.setUpdatetime(date);
                                 tCoreSecretkey.setUpdateuser(newUsername);
                              }
                           } else {
                              tCoreSecretkey.setEncryption_id(tCoreEncryption.getId());
                              tCoreSecretkey.setCreatetime(date);
                              tCoreSecretkey.setCreateuser(newUsername);
                              tCoreSecretkey.setUpdatetime(date);
                              tCoreSecretkey.setUpdateuser(newUsername);
                           }
                        }
                     }
                  }
               }

               this.saveProjectEncryptionFields(tCoreEncryptionList, tCoreSecretkeyList);
               return RespHelper.successResp();
            } catch (Exception e) {
               e.printStackTrace();
               String msg = "导入EXCEL格式错误！";
               return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
            }
         } else {
            int rowsNum = sheet.getLastRowNum();
            int num = 0;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            System.out.println("取文件时间：" + sdf.format(new Date()));
            long startTime = System.currentTimeMillis();
            int count = 0;
            Map<String, List<String>> tableNameOut = new HashMap();
            List<String> outNameList = new ArrayList();
            Set<String> datasystemids = new HashSet();

            for(int j = 1; j < rowsNum + 1; ++j) {
               datasystemids.add(sheet.getRow(j).getCell(1).toString());
            }

            ArrayList<Integer> rows = new ArrayList(rowsNum);

            for(int i = 1; i < rowsNum + 1; ++i) {
               rows.add(i);
            }

            rows.parallelStream().forEach((item) -> this.processRow(username, sheet, tableNameOut, outNameList, item));
            long endTime = System.currentTimeMillis();
            System.out.println("excelFileUpLoad 程序运行时间： " + (endTime - startTime) + "ms");
            return RespHelper.successResp();
         }
      } catch (ServiceException e) {
         return RespHelper.createResp(false, e.getCode(), e.getDescription());
      } catch (Exception e) {
         e.printStackTrace();
         String msg = "导入EXCEL格式错误！";
         return new Response(ErrCode.SERVER_EXCEPTION.getCode(), msg);
      }
   }

   public void encxls(String projectname, Map<String, List> data, HttpServletResponse response) {
      Date date = new Date();
      String sdate = (new SimpleDateFormat("yyyyMMdd")).format(date);
      String fileName = projectname + "_encrule_backup_" + sdate + ".xls";
      HSSFWorkbook workbook = new HSSFWorkbook();
      String[] headers1 = new String[]{"id", "createtime", "createuser", "flag", "note", "updatetime", "updateuser", "encryption_name", "encryption_type"};

      try {
         List<Map<String, String>> encryptionList = (List)data.get("enc");
         this.generateSheet(workbook, "加密规则表", headers1, encryptionList);
         List<Map<String, String>> secretKeyList = (List)data.get("key");
         String[] headers2 = new String[]{"id", "createtime", "createuser", "flag", "note", "updatetime", "updateuser", "privatekey", "publickey", "encryption_id", "secret_key_name", "sectet_key_value"};
         this.generateSheet(workbook, "密钥表", headers2, secretKeyList);
         this.getExportedField(workbook, fileName, response);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public void generateSheet(HSSFWorkbook workbook, String sheetname, String[] headers, List<Map<String, String>> datalist) {
      HSSFSheet sheet = null;
      sheet = workbook.createSheet(sheetname);
      HSSFCellStyle columnTopStyle = this.getColumnTopStyle(workbook);
      int columnNum = headers.length;
      HSSFRow headLine = sheet.createRow(0);
      sheet.setDefaultColumnWidth(15);
      if ("密钥表".equals(sheetname)) {
         sheet.setColumnHidden(11, true);
      }

      sheet.setColumnWidth(11, 0);

      for(int n = 0; n < columnNum; ++n) {
         HSSFCell cellRowName = headLine.createCell(n);
         cellRowName.setCellType(1);
         HSSFRichTextString text = new HSSFRichTextString(headers[n]);
         cellRowName.setCellValue(text);
         cellRowName.setCellStyle(columnTopStyle);
      }

      HSSFCellStyle lockstyle = this.getStyle(workbook);
      lockstyle.setAlignment((short)2);
      lockstyle.setVerticalAlignment((short)1);
      lockstyle.setLocked(true);
      HSSFRow dataRow = null;
      int index = 0;

      for(Map mapx : datalist) {
         ++index;
         dataRow = sheet.createRow(index);

         for(int i = 0; i < headers.length; ++i) {
            HSSFCell cell = dataRow.createCell(i);
            String value = (String)mapx.get(headers[i]);
            cell.setCellValue(value);
            cell.setCellStyle(lockstyle);
         }
      }

      sheet.protectSheet("123456");
   }

   public HSSFCellStyle getStyle(HSSFWorkbook workbook) {
      HSSFFont font = workbook.createFont();
      font.setFontHeightInPoints((short)10);
      font.setBoldweight((short)400);
      font.setFontName("微软雅黑");
      HSSFCellStyle style = workbook.createCellStyle();
      style.setBorderBottom((short)1);
      style.setBottomBorderColor((short)8);
      style.setBorderLeft((short)1);
      style.setLeftBorderColor((short)8);
      style.setBorderRight((short)1);
      style.setRightBorderColor((short)8);
      style.setBorderTop((short)1);
      style.setTopBorderColor((short)8);
      style.setFont(font);
      style.setWrapText(false);
      style.setAlignment((short)2);
      style.setVerticalAlignment((short)1);
      return style;
   }

   public HSSFCellStyle getColumnTopStyle(HSSFWorkbook workbook) {
      HSSFFont font = workbook.createFont();
      font.setFontHeightInPoints((short)11);
      font.setBoldweight((short)700);
      font.setFontName("微软雅黑");
      HSSFCellStyle style = workbook.createCellStyle();
      style.setBorderBottom((short)1);
      style.setBottomBorderColor((short)8);
      style.setBorderRight((short)1);
      style.setTopBorderColor((short)8);
      style.setTopBorderColor((short)8);
      style.setFont(font);
      style.setWrapText(false);
      style.setAlignment((short)2);
      style.setVerticalAlignment((short)1);
      return style;
   }

   public void getExportedField(Workbook workbook, String name, HttpServletResponse response) throws Exception {
      BufferedOutputStream fos = null;

      try {
         response.setContentType("application/x-download");
         response.setHeader("Content-Disposition", "attachment;filename=" + new String(name.getBytes(StandardCharsets.UTF_8), "ISO8859-1"));
         fos = new BufferedOutputStream(response.getOutputStream());
         workbook.write(fos);
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         if (fos != null) {
            fos.close();
         }

      }

   }

   @Transactional
   public void saveProjectEncryptionFields(List<TCoreEncryption> tCoreEncryptionList, List<TCoreSecretkey> tCoreSecretkeyList) {
      for(TCoreEncryption tCoreEncryption : tCoreEncryptionList) {
         if (!"0".equals(tCoreEncryption.getFlag())) {
            tCoreEncryption.setFlag((String)null);
            this.tCoreEncryptionDao.save(tCoreEncryption);

            for(TCoreSecretkey s : tCoreSecretkeyList.stream().filter((sx) -> sx.getEncryptionname().equals(tCoreEncryption.getEncryption_name())).collect(Collectors.toList())) {
               s.setEncryption_id(tCoreEncryption.getId());
            }
         }
      }

      for(TCoreSecretkey tCoreSecretkey : tCoreSecretkeyList) {
         if (!"0".equals(tCoreSecretkey.getFlag())) {
            tCoreSecretkey.setFlag((String)null);
            this.tCoreSecretkeyDao.save(tCoreSecretkey);
         }
      }

   }

   @RequestMapping({"/testEnc"})
   @ResponseBody
   public Response testEnc(@RequestParam("encCount") String encCount) {
      try {
         int total = 1048576;
         Map<String, String> result = new HashMap();
         String secretKey = SM4Util.generateKey();
         int threadNum = cpuCores;
         ExecutorService threadPool = Executors.newFixedThreadPool(threadNum);
         if (encCount != null && encCount.length() > 0 && encCount.matches("\\d+")) {
            total = Integer.parseInt(encCount);
            if (total < threadNum) {
               total = threadNum;
            }
         }

         int count = total / threadNum;
         CountDownLatch latch = new CountDownLatch(threadNum);
         long start = System.currentTimeMillis();
         String startTime = this.sdf.format(new Date(start));

         for(int i = 0; i < threadNum; ++i) {
            threadPool.execute(() -> {
               for(int j = 0; j < count; ++j) {
                  try {
                     SM4Util.encryptEcb(secretKey, "随着《数据安全法》和《个人信息保护法》相继推出，以及各行业数据安全标准的不断完善，建立完整的数据安全治理体系已是迫在眉睫。其中，数据安全风险评估作为数据安全建设的基础和前提，在发现数据安全威胁和风险方面意义重大为贯彻落实《数据安全法》关于数据安全风险评估的要求，2023年5月29日，全国信息安全标准化技术委员会发布《网络安全标准实践指南--网络数据安全风险评估实施指引》，该指南共8章内容，附录分为数据安全风险示例、评估报告模板。给出网络数据安全风险评估思路、工作流程和评估内容,可用于指导数据处理者、第三方机构开展数据安全评估，也可为有关主管监管部门组织开展检查评估aaa中华人民共和国数据安全法》已由中华人民共和国第十三届全国人民代表大会常务委员会第二十九次会议于2021年6月10日通过，现予公布q现予法");
                  } catch (Exception e) {
                     e.printStackTrace();
                  }
               }

               latch.countDown();
            });
         }

         latch.await();
         long end = System.currentTimeMillis();
         threadPool.shutdown();
         String endTime = this.sdf.format(new Date(end));
         result.put("data", "随着《数据安全法》和《个人信息保护法》相继推出，以及各行业数据安全标准的不断完善，建立完整的数据安全治理体系已是迫在眉睫。其中，数据安全风险评估作为数据安全建设的基础和前提，在发现数据安全威胁和风险方面意义重大为贯彻落实《数据安全法》关于数据安全风险评估的要求，2023年5月29日，全国信息安全标准化技术委员会发布《网络安全标准实践指南--网络数据安全风险评估实施指引》，该指南共8章内容，附录分为数据安全风险示例、评估报告模板。给出网络数据安全风险评估思路、工作流程和评估内容,可用于指导数据处理者、第三方机构开展数据安全评估，也可为有关主管监管部门组织开展检查评估aaa中华人民共和国数据安全法》已由中华人民共和国第十三届全国人民代表大会常务委员会第二十九次会议于2021年6月10日通过，现予公布q现予法");
         result.put("beginTime", startTime);
         result.put("encData", SM4Util.encryptEcb(secretKey, "随着《数据安全法》和《个人信息保护法》相继推出，以及各行业数据安全标准的不断完善，建立完整的数据安全治理体系已是迫在眉睫。其中，数据安全风险评估作为数据安全建设的基础和前提，在发现数据安全威胁和风险方面意义重大为贯彻落实《数据安全法》关于数据安全风险评估的要求，2023年5月29日，全国信息安全标准化技术委员会发布《网络安全标准实践指南--网络数据安全风险评估实施指引》，该指南共8章内容，附录分为数据安全风险示例、评估报告模板。给出网络数据安全风险评估思路、工作流程和评估内容,可用于指导数据处理者、第三方机构开展数据安全评估，也可为有关主管监管部门组织开展检查评估aaa中华人民共和国数据安全法》已由中华人民共和国第十三届全国人民代表大会常务委员会第二十九次会议于2021年6月10日通过，现予公布q现予法"));
         result.put("endTime", endTime);
         result.put("dataSize", total + "KB");
         long encTime = (end - start) / 1000L;
         result.put("time", encTime + "秒");
         long performance;
         if (encTime > 0L) {
            performance = (long)(total / 1024) / encTime * 8L;
         } else {
            performance = 0L;
         }

         result.put("performance", performance + "Mbps");
         return RespHelper.successResp(result);
      } catch (Throwable ex) {
         ex.printStackTrace();
         throw new RuntimeException(ex.getMessage());
      }


   }
}
