package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiveLevel;
import com.chenyang.nse.bussiness.entity.vo.api.DiscoverApiDirectoryVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.SensitivelevelVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class SensitiveLevelDao extends BaseDao<TCoreSensitiveLevel, String> {
   public int delRelation(SensitivelevelVO scope) {
      String sql = XmlTool.getSql("datascope", "delrelation");
      int i = this.getSession().createNativeQuery(sql).setParameter("id", scope.getTid()).executeUpdate();
      return i;
   }

   public int delrelationByeditionid(String editionid, String type) {
      String sql = XmlTool.getSql("datascope", "delrelationbyeditionid");
      int i = this.getSession().createNativeQuery(sql).setParameter("editionid", editionid).setParameter("type", type).executeUpdate();
      return i;
   }

   public int insertRelation(SensitivelevelVO scope, String rule) {
      String sql = XmlTool.getSql("datascope", "addrelation");
      int i = this.getSession().createNativeQuery(sql).setParameter("id", scope.getTid()).setParameter("edition_id", scope.getEdition_id()).setParameter("rule", rule).setParameter("type", 3).executeUpdate();
      return i;
   }

   public List<SensitivelevelVO> getDataScopeGroup(String edition_id) {
      String sql = XmlTool.getSql("sensitivelevel", "dataScopeGroup");
      List<SensitivelevelVO> vo = this.getSession().createNativeQuery(sql).setParameter("edition_id", edition_id).setResultTransformer(Transformers.aliasToBean(SensitivelevelVO.class)).getResultList();
      return vo;
   }

   public List<DiscoverApiDirectoryVO> getLevelDirectory(String edition_id) {
      String sql = XmlTool.getSql("sensitivelevel", "dataLevelDirectory");
      List<DiscoverApiDirectoryVO> vo = this.getSession().createNativeQuery(sql).setParameter("edition_id", edition_id).setResultTransformer(Transformers.aliasToBean(DiscoverApiDirectoryVO.class)).getResultList();
      return vo;
   }

   public List<SensitivelevelVO> getDataScopeGroupSearch(String editionid, String val, String searchval) {
      String sql = "SELECT id,scope_id as id,scope_name as text,fa_tid,edition_id,open_level,scope_according,level_principle,create_user,create_date,note FROM t_core_sensitive_level WHERE edition_id = '" + editionid + "' and " + val + " like '" + searchval + "'";
      List<SensitivelevelVO> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(SensitivelevelVO.class)).getResultList();
      return vo;
   }

   public List<TCoreSensitiveLevel> getLevelById(String id) {
      String sql = "SELECT * FROM t_core_sensitive_level WHERE id = '" + id + "'";
      List<TCoreSensitiveLevel> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreSensitiveLevel.class)).getResultList();
      return vo;
   }

   public List<TCoreSensitiveLevel> getLevelBetweenSensitiveInfo(String editionid, char start, char end) {
      String sql = "SELECT * FROM t_core_sensitive_level WHERE edition_id = '" + editionid + "' and open_level between '" + start + "' and '" + end + "'";
      List<TCoreSensitiveLevel> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreSensitiveLevel.class)).getResultList();
      return vo;
   }

   public int updateOpenLevelById(String id, char open_level) {
      String sql = "update t_core_sensitive_level set open_level ='" + open_level + "'  where id = '" + id + "'";
      int i = this.getSession().createNativeQuery(sql).executeUpdate();
      return i;
   }

   public int insertAddFa(SensitivelevelVO scope) {
      String sql = XmlTool.getSql("sensitivelevel", "addfa");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("note", scope.getNote()).setParameter("edition_id", scope.getEdition_id()).setParameter("open_level", scope.getOpen_level()).setParameter("scope_according", scope.getScope_according()).setParameter("level_principle", scope.getLevel_principle()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public List<SensitivelevelVO> ishavebro(SensitivelevelVO scope) {
      String sql = XmlTool.getSql("sensitivelevel", "ishavebro");
      List<SensitivelevelVO> vo = this.getSession().createNativeQuery(sql).setParameter("fa_tid", scope.getFa_tid()).setParameter("edition_id", scope.getEdition_id()).setResultTransformer(Transformers.aliasToBean(SensitivelevelVO.class)).getResultList();
      return vo;
   }

   public int havebro(SensitivelevelVO scope) {
      String sql = XmlTool.getSql("sensitivelevel", "havebro");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("fa_tid", scope.getFa_tid()).setParameter("note", scope.getNote()).setParameter("edition_id", scope.getEdition_id()).setParameter("open_level", scope.getOpen_level()).setParameter("scope_according", scope.getScope_according()).setParameter("level_principle", scope.getLevel_principle()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public int nothavebro(SensitivelevelVO scope) {
      String sql = XmlTool.getSql("sensitivelevel", "nothavebro");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("fa_tid", scope.getFa_tid()).setParameter("note", scope.getNote()).setParameter("edition_id", scope.getEdition_id()).setParameter("open_level", scope.getOpen_level()).setParameter("scope_according", scope.getScope_according()).setParameter("level_principle", scope.getLevel_principle()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public int updateScope(SensitivelevelVO scope) {
      String sql = XmlTool.getSql("sensitivelevel", "updatescope");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("note", scope.getNote()).setParameter("edition_id", scope.getEdition_id()).setParameter("open_level", scope.getOpen_level()).setParameter("scope_according", scope.getScope_according()).setParameter("level_principle", scope.getLevel_principle()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public int delselfandson(String scope_id, String edition_id) {
      String sql = XmlTool.getSql("sensitivelevel", "delselfandson");
      int i = this.getSession().createNativeQuery(sql).setParameter("sensitive_id", scope_id).setParameter("edition_id", edition_id).executeUpdate();
      return i;
   }

   public Map<String, Object> getSensitiveInfo(String scope_id) {
      Map<String, Object> map = new HashMap();
      String sql = "select sensitive_name,open_level from t_core_sensitive_level where id ='" + scope_id + "'";
      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      if (vo.size() > 0) {
         map = (Map)vo.get(0);
      }

      return map;
   }

   public List<SensitivelevelVO> findbroandhisson(String scope_id, String fa_id, String edition_id) {
      String sql = XmlTool.getSql("sensitivelevel", "findbroandhisson");
      List<SensitivelevelVO> vo = this.getSession().createNativeQuery(sql).setParameter("fa_id", fa_id).setParameter("sensitive_id", scope_id).setParameter("edition_id", edition_id).setResultTransformer(Transformers.aliasToBean(SensitivelevelVO.class)).getResultList();
      return vo;
   }

   public int updatebro(String id) {
      String sql = XmlTool.getSql("sensitivelevel", "updatebro");
      return this.getSession().createNativeQuery(sql).setParameter("id", id).executeUpdate();
   }

   public int updatebroson(String id, String del_id) {
      String sql = XmlTool.getSql("sensitivelevel", "updatebroson");
      return this.getSession().createNativeQuery(sql).setParameter("id", id).setParameter("del_id", del_id).executeUpdate();
   }

   public int insertAddZero(SensitivelevelVO scope) {
      String sql = XmlTool.getSql("sensitivelevel", "addzero");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("note", scope.getNote()).setParameter("edition_id", scope.getEdition_id()).setParameter("open_level", scope.getOpen_level()).setParameter("scope_according", scope.getScope_according()).setParameter("level_principle", scope.getLevel_principle()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public List<Map<String, Object>> selectSensitiveLevelCount(String id, String edition_id) {
      String sql = "SELECT COUNT(b.id) AS s FROM t_pro_edition_scope a, t_core_sensitive_level b WHERE a.id = b.edition_id AND b.edition_id = '" + edition_id + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT COUNT(b.id) AS \"s\" FROM t_pro_edition_scope a, t_core_sensitive_level b WHERE a.id = b.edition_id AND b.edition_id = '" + edition_id + "'";
      }

      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<Map<String, String>> selectRelation(String id) {
      String sql = "SELECT rule FROM t_type_datafield_relation t  WHERE  t.id = '" + id + "'";
      List<Map<String, String>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public char getMaxOpenLevel(String edition_id) {
      List<Character> list = new ArrayList();
      String sql = "SELECT open_level FROM t_core_sensitive_level where edition_id = '" + edition_id + "' group by open_level";

      List<Map<String, Character>> listNew = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      for(Map<String, Character> map : listNew) {
         Character open_level = (Character)map.get("open_level");
         list.add(open_level);
      }

      if (list.size() > 0) {
         Character max = (Character)Collections.max(list);
         return max;
      } else {
         return '\u0000';
      }
   }

   public char getMaxSunOpenLevel(String edition_id, String fa_tid) {
      List<Character> list = new ArrayList();
      String sql = "SELECT open_level FROM t_core_sensitive_level where fa_tid = '" + fa_tid + "' and edition_id = '" + edition_id + "' group by open_level";

      List<Map<String, Character>> listNew = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      for(Map<String, Character> map : listNew) {
         Character open_level = (Character)map.get("open_level");
         list.add(open_level);
      }

      char max;
      if (list != null && list.size() > 0) {
         max = (Character)Collections.min(list);
      } else {
         max = (char)((new Random()).nextInt(26) + 65);
      }

      return max;
   }

   public int updateOpenLevel(String edition_id, String t_id, char open_level) {
      String sql = "update t_core_sensitive_level set open_level = char(ASCII(open_level)+1)  where edition_id = '" + edition_id + "'  and id <>'" + t_id + "'  and open_level >='" + open_level + "'";
      int i = this.getSession().createNativeQuery(sql).executeUpdate();
      return i;
   }
}
