package com.chenyang.nse.bussiness.engine.infa.basic.webservice;

import com.chenyang.nse.bussiness.commmon.ApplicationConstants;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.Service.Mode;
import org.w3c.dom.Document;

public class GetSessionStatisticsWebService {
   public static SessionBean returnStatus(String sessionId, String domain, String server, String workflowname) throws Exception {
      String ns = ApplicationConstants.webservice_url;
      String wsdlUrl = ApplicationConstants.wsdl_url;
      URL url = new URL(wsdlUrl);
      QName sname = new QName(ns, "DataIntegrationService");
      Service service = Service.create(url, sname);
      Dispatch<SOAPMessage> dispatch = service.createDispatch(new QName(ns, "DataIntegration"), SOAPMessage.class, Mode.MESSAGE);
      SOAPMessage msg = MessageFactory.newInstance("SOAP 1.1 Protocol").createMessage();
      SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
      SOAPHeader head = envelope.getHeader();
      QName hename = new QName(ns, "Context", "ns0");
      SOAPHeaderElement hele = head.addHeaderElement(hename);
      hele.addChildElement("SessionId").setValue(sessionId);
      SOAPBody body = envelope.getBody();
      QName ename = new QName(ns, "GetSessionStatistics", "ns0");
      SOAPBodyElement ele = body.addBodyElement(ename);
      SOAPElement di = ele.addChildElement("DIServiceInfo");
      di.addChildElement("DomainName").setValue(domain);
      di.addChildElement("ServiceName").setValue(server);
      if (workflowname != null) {
         ele.addChildElement("FolderName").setValue(workflowname.replace("wf", "fd"));
         ele.addChildElement("WorkflowName").setValue(workflowname);
         ele.addChildElement("TaskInstancePath").setValue("s_M_" + workflowname.replace("wf", "mp"));
      }

      SOAPMessage response = (SOAPMessage)dispatch.invoke(msg);
      Document doc = response.getSOAPPart().getEnvelope().getBody().extractContentAsDocument();
      SessionBean se = new SessionBean();
      List<SessionBeanDetail> sdetail_list = new ArrayList();

      for(int i = 0; i < doc.getElementsByTagName("WidgetName").getLength(); ++i) {
         SessionBeanDetail sdetail = new SessionBeanDetail();
         sdetail.setApplied_rows(Long.parseLong(doc.getElementsByTagName("NumAppliedRows").item(i).getTextContent()));
         sdetail.setAffected_rows(Long.parseLong(doc.getElementsByTagName("NumAffectedRows").item(i).getTextContent()));
         sdetail.setRejected_rows(Long.parseLong(doc.getElementsByTagName("NumRejectedRows").item(i).getTextContent()));
         sdetail.setError_log(doc.getElementsByTagName("LastErrorMessage").item(i).getTextContent());
         if ("target".equals(doc.getElementsByTagName("WidgetType").item(i).getTextContent())) {
            sdetail.setTabletype("目标");
            sdetail.setTablename(doc.getElementsByTagName("WidgetName").item(i).getTextContent());
         } else {
            sdetail.setTabletype("源");
            sdetail.setTablename(doc.getElementsByTagName("WidgetName").item(i).getTextContent().replace("sq_", ""));
         }

         sdetail_list.add(sdetail);
         System.out.println(sdetail.getTablename());
      }

      se.setSessionBeanDetail(sdetail_list);
      if (doc.getElementsByTagName("TaskRunStatus") == null) {
         se.setStatus("FAIL");
      } else {
         String str = doc.getElementsByTagName("TaskRunStatus").item(0).getTextContent();
         se.setStatus(str);
      }

      if (doc.getElementsByTagName("WorkflowRunId") == null) {
         se.setWf_run_id("FAIL");
      } else {
         String str = doc.getElementsByTagName("WorkflowRunId").item(0).getTextContent();
         se.setWf_run_id(str);
      }

      return se;
   }
}
