package com.chenyang.nse.bussiness.engine.infa.basic.wsclient;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

@WebServiceClient(
   name = "DataIntegrationService",
   targetNamespace = "http://www.informatica.com/wsh",
   wsdlLocation = "http://sdulinux123:7333/wsh/services/BatchServices/DataIntegration?WSDL"
)
public class DataIntegrationService extends Service {
   private static final URL DATAINTEGRATIONSERVICE_WSDL_LOCATION;
   private static final WebServiceException DATAINTEGRATIONSERVICE_EXCEPTION;
   private static final QName DATAINTEGRATIONSERVICE_QNAME = new QName("http://www.informatica.com/wsh", "DataIntegrationService");

   public DataIntegrationService() {
      super(__getWsdlLocation(), DATAINTEGRATIONSERVICE_QNAME);
   }

   public DataIntegrationService(WebServiceFeature... features) {
      super(__getWsdlLocation(), DATAINTEGRATIONSERVICE_QNAME, features);
   }

   public DataIntegrationService(URL wsdlLocation) {
      super(wsdlLocation, DATAINTEGRATIONSERVICE_QNAME);
   }

   public DataIntegrationService(URL wsdlLocation, WebServiceFeature... features) {
      super(wsdlLocation, DATAINTEGRATIONSERVICE_QNAME, features);
   }

   public DataIntegrationService(URL wsdlLocation, QName serviceName) {
      super(wsdlLocation, serviceName);
   }

   public DataIntegrationService(URL wsdlLocation, QName serviceName, WebServiceFeature... features) {
      super(wsdlLocation, serviceName, features);
   }

   @WebEndpoint(
      name = "DataIntegration"
   )
   public DataIntegrationInterface getDataIntegration() {
      return (DataIntegrationInterface)super.getPort(new QName("http://www.informatica.com/wsh", "DataIntegration"), DataIntegrationInterface.class);
   }

   @WebEndpoint(
      name = "DataIntegration"
   )
   public DataIntegrationInterface getDataIntegration(WebServiceFeature... features) {
      return (DataIntegrationInterface)super.getPort(new QName("http://www.informatica.com/wsh", "DataIntegration"), DataIntegrationInterface.class, features);
   }

   private static URL __getWsdlLocation() {
      if (DATAINTEGRATIONSERVICE_EXCEPTION != null) {
         throw DATAINTEGRATIONSERVICE_EXCEPTION;
      } else {
         return DATAINTEGRATIONSERVICE_WSDL_LOCATION;
      }
   }

   static {
      URL url = null;
      WebServiceException e = null;
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "SELECT pv.propertyvalue FROM t_console_engine_propertyvalue pv LEFT JOIN t_console_engine_property p ON pv.enginepropertyid = p.id where pv.engineid= '402881e65a646d5d015a6471edf60000' and p.propertyname = 'webserviceserverurl'";
         ResultSet rSet = statement.executeQuery(sql);

         String weburl;
         for(weburl = ""; rSet.next(); weburl = rSet.getString("propertyvalue")) {
         }

         rSet.close();
         statement.close();
         connection.close();
         url = new URL(weburl);
      } catch (MalformedURLException ex) {
         e = new WebServiceException(ex);
      } catch (IOException e1) {
         e1.printStackTrace();
      } catch (SQLException e1) {
         e1.printStackTrace();
      }

      DATAINTEGRATIONSERVICE_WSDL_LOCATION = url;
      DATAINTEGRATIONSERVICE_EXCEPTION = e;
   }
}
