package com.chenyang.nse.bussiness.engine.infa.powercenter961.maskdata;

import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.SOURCE;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.SOURCEFIELD;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.SourceBean;
import java.util.ArrayList;
import java.util.List;

public class Sourceutil {
   public static SOURCE getSource(SourceBean sou_bean) {
      SOURCE source = new SOURCE();

      try {
         source = getSourceXml(sou_bean.getDatabasetype(), sou_bean.getDbdname(), sou_bean.getSo_name(), sou_bean.getSo_ownname(), sou_bean.getCb().getKeytype(), sou_bean.getCb().getNameList(), sou_bean.getCb().getTypeList(), sou_bean.getCb().getLengthList(), sou_bean.getCb().getScalelist(), sou_bean.getCb().getPrecisionList());
      } catch (Exception e) {
         e.printStackTrace();
      }

      return source;
   }

   public static SOURCE getSourceXml(String dbtype, String dbname, String sourcename, String ownername, List<String> keytype, List<String> nameList, List<String> typeList, List<String> lengthList, List<String> scalelist, List<String> precisionlist) throws Exception {
      SOURCE sourceBean = new SOURCE();
      sourceBean.setBUSINESSNAME("");
      sourceBean.setDATABASETYPE(dbtype);
      sourceBean.setDBDNAME(dbname);
      sourceBean.setDESCRIPTION("");
      sourceBean.setNAME(sourcename);
      sourceBean.setOBJECTVERSION("1");
      sourceBean.setOWNERNAME(ownername);
      sourceBean.setVERSIONNUMBER("1");

      for(SOURCEFIELD sourcefield : getConvertTableInfoToSOURCEFIELD(keytype, nameList, typeList, lengthList, scalelist, precisionlist, dbtype)) {
         sourceBean.getSOURCEFIELD().add(sourcefield);
      }

      return sourceBean;
   }

   public static List<SOURCEFIELD> getConvertTableInfoToSOURCEFIELD(List<String> keytype, List<String> nameList, List<String> typeList, List<String> lengthList, List<String> scalelist, List<String> precisionlist, String dbtype) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;
      if ("DB2".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            SOURCEFIELD sourceField = new SOURCEFIELD();
            sourceField.setBUSINESSNAME("");
            if ("character".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setDATATYPE("char");
            } else {
               sourceField.setDATATYPE((String)typeList.get(i));
            }

            sourceField.setDESCRIPTION("");
            sourceField.setFIELDNUMBER(i + 1 + "");
            sourceField.setFIELDPROPERTY("0");
            sourceField.setFIELDTYPE("ELEMITEM");
            sourceField.setHIDDEN("NO");
            sourceField.setKEYTYPE((String)keytype.get(i));
            if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("10");
               sourceField.setPRECISION("10");
               sourceField.setSCALE("0");
            } else if ("time".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("8");
               sourceField.setPRECISION("8");
               sourceField.setSCALE("0");
            } else if ("timestamp".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("26");
               sourceField.setPRECISION("26");
               sourceField.setSCALE("6");
            } else if ("number".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("26");
               sourceField.setPRECISION("26");
               sourceField.setSCALE("6");
            } else {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
            }

            sourceField.setLEVEL("0");
            sourceField.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               sourceField.setNULLABLE("NOTNULL");
            } else {
               sourceField.setNULLABLE("NULL");
            }

            sourceField.setOCCURS("0");
            offset += preOffset;
            sourceField.setOFFSET(offset + "");
            phyOffset += prePhyOffset;
            sourceField.setPHYSICALOFFSET(phyOffset + "");
            sourceField.setPICTURETEXT("");
            sourceField.setUSAGEFLAGS("");
            sourceFieldList.add(sourceField);
         }
      } else if ("ORACLE".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            SOURCEFIELD sourceField = new SOURCEFIELD();
            sourceField.setBUSINESSNAME("");
            if ("character".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setDATATYPE("char");
            } else if ("number".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setDATATYPE("number(p,s)");
            } else {
               sourceField.setDATATYPE((String)typeList.get(i));
            }

            sourceField.setDESCRIPTION("");
            sourceField.setFIELDNUMBER(i + 1 + "");
            sourceField.setFIELDPROPERTY("0");
            sourceField.setFIELDTYPE("ELEMITEM");
            sourceField.setHIDDEN("NO");
            sourceField.setKEYTYPE((String)keytype.get(i));
            if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setPRECISION("19");
               sourceField.setSCALE("0");
            } else if ("time".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("8");
               sourceField.setPRECISION("8");
               sourceField.setSCALE("0");
            } else if ("timestamp".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("26");
               sourceField.setPRECISION("26");
               sourceField.setSCALE("6");
            } else if ("number".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("26");
               sourceField.setPRECISION("26");
               sourceField.setSCALE("6");
            } else {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
            }

            sourceField.setLEVEL("0");
            sourceField.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               sourceField.setNULLABLE("NOTNULL");
            } else {
               sourceField.setNULLABLE("NULL");
            }

            sourceField.setOCCURS("0");
            offset += preOffset;
            sourceField.setOFFSET(offset + "");
            phyOffset += prePhyOffset;
            sourceField.setPHYSICALOFFSET(phyOffset + "");
            sourceField.setPICTURETEXT("");
            sourceField.setUSAGEFLAGS("");
            sourceFieldList.add(sourceField);
         }
      }

      return sourceFieldList;
   }
}
