package com.chenyang.nse.bussiness.entity.vo.datamap;

import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreDatamapTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreDatamapTablerelation;
import java.util.List;

public class DataMapVO {
   private String tablecount;
   private String fkcount;
   private List<TCoreDatamapTable> nodes;
   private List<TCoreDatamapTablerelation> edges;

   public DataMapVO() {
   }

   public DataMapVO(String tablecount, String fkcount, List<TCoreDatamapTable> nodes, List<TCoreDatamapTablerelation> edges) {
      this.tablecount = tablecount;
      this.fkcount = fkcount;
      this.nodes = nodes;
      this.edges = edges;
   }

   public String getTablecount() {
      return this.tablecount;
   }

   public void setTablecount(String tablecount) {
      this.tablecount = tablecount;
   }

   public String getFkcount() {
      return this.fkcount;
   }

   public void setFkcount(String fkcount) {
      this.fkcount = fkcount;
   }

   public List<TCoreDatamapTable> getNodes() {
      return this.nodes;
   }

   public void setNodes(List<TCoreDatamapTable> nodes) {
      this.nodes = nodes;
   }

   public List<TCoreDatamapTablerelation> getEdges() {
      return this.edges;
   }

   public void setEdges(List<TCoreDatamapTablerelation> edges) {
      this.edges = edges;
   }

   public String toString() {
      return "TableRelationVO [tablecount=" + this.tablecount + ", fkcount=" + this.fkcount + ", nodes=" + this.nodes + ", edges=" + this.edges + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.edges == null ? 0 : this.edges.hashCode());
      result = 31 * result + (this.fkcount == null ? 0 : this.fkcount.hashCode());
      result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
      result = 31 * result + (this.tablecount == null ? 0 : this.tablecount.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         DataMapVO other = (DataMapVO)obj;
         if (this.edges == null) {
            if (other.edges != null) {
               return false;
            }
         } else if (!this.edges.equals(other.edges)) {
            return false;
         }

         if (this.fkcount == null) {
            if (other.fkcount != null) {
               return false;
            }
         } else if (!this.fkcount.equals(other.fkcount)) {
            return false;
         }

         if (this.nodes == null) {
            if (other.nodes != null) {
               return false;
            }
         } else if (!this.nodes.equals(other.nodes)) {
            return false;
         }

         if (this.tablecount == null) {
            if (other.tablecount != null) {
               return false;
            }
         } else if (!this.tablecount.equals(other.tablecount)) {
            return false;
         }

         return true;
      }
   }
}
