package com.chenyang.nse.bussiness.enumeration.file;

public enum DateFormat {
   FORMAT_07("YYYY-MM-DD HH24:MI:SS", "YYYY-MM-DD HH24:MI:SS"),
   FORMAT_08("YYYY-MM-DD", "YYYY-MM-DD"),
   FORMAT_01("mm/dd/yyyy", "mm/dd/yyyy"),
   FORMAT_02("dd-mon-yy", "dd-mon-yy"),
   FORMAT_03("MM/DD/YYYY HH24:MI:SS.MS", "MM/DD/YYYY HH24:MI:SS.MS"),
   FORMAT_04("MM/DD/YYYY HH24:MI:SS.US", "MM/DD/YYYY HH24:MI:SS.US"),
   FORMAT_05("MM/DD/YYYY HH24:MI:SS.NS", "MM/DD/YYYY HH24:MI:SS.NS"),
   FORMAT_06("MM/DD/YYYY HH24:MI:SS", "MM/DD/YYYY HH24:MI:SS");

   private String flag;
   private String name;

   private DateFormat(String flag, String name) {
      this.flag = flag;
      this.name = name;
   }

   public String getFlag() {
      return this.flag;
   }

   public void setFlag(String flag) {
      this.flag = flag;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public static String getFlag(String name) {
      for(CodePage f : CodePage.values()) {
         if (f.getName().equals(name)) {
            return f.getFlag();
         }
      }

      return null;
   }

   public static String getName(String flag) {
      for(CodePage f : CodePage.values()) {
         if (f.getFlag().equals(flag)) {
            return f.getName();
         }
      }

      return null;
   }
}
