package com.chenyang.nse.bussiness.job;

import com.chenyang.nse.bussiness.service.core.SchedulerService;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import com.chenyang.nse.bussiness.service.core.dataproject.ExecuteDiscoverytaskService;
import com.chenyang.nse.bussiness.tools.jdbc.BeanFactory;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@DisallowConcurrentExecution
public class MaskingTaskJob implements Job {
   @Autowired
   private SchedulerService schedulerService;
   @Autowired
   private ExecuteDiscoverytaskService executeDiscoverytaskService;
   @Autowired
   private DiscoverytaskService discoverytaskService;

   public void execute(JobExecutionContext context) throws JobExecutionException {
      SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
      JobDetail jobDetail = context.getJobDetail();
      String schedulerId = jobDetail.getJobDataMap().getString("schedulerId");
      String rulesType = jobDetail.getJobDataMap().getString("rulesType");
      List<String> idList = (List)jobDetail.getJobDataMap().get("idList");
      System.out.println("idList:" + idList);

      for(String id : idList) {
         try {
            System.out.println("执行任务啦");

            for(String item : idList) {
               this.discoverytaskService = (DiscoverytaskService)BeanFactory.getBean(DiscoverytaskService.class);
               this.executeDiscoverytaskService = (ExecuteDiscoverytaskService)BeanFactory.getBean(ExecuteDiscoverytaskService.class);
               String datasystemid = this.discoverytaskService.get(item).getDatasystemid();
               this.executeDiscoverytaskService.execute(item, datasystemid, "", "userid", "username", false, (List)null);
            }

            System.out.println("执行完成啦");
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   }
}
