package com.chenyang.nse.bussiness.kms.model;

public class Kms {
   public static class Credential {
      private String id;
      private String accesskey;
      private String secretkey;
      private String iv;
      private String protocol;
      private String host;
      private Integer port;
      private byte[] ivbytes;
      private static Credential instance = null;
      private static boolean initFlag = false;

      private Credential(String id, String accesskey, String secretkey, String iv, String protocol, String host, Integer port) {
         this.id = id;
         this.accesskey = accesskey;
         this.secretkey = secretkey;
         this.iv = iv;
         this.protocol = protocol;
         this.host = host;
         this.port = port;
         if (iv != null && !iv.isEmpty()) {
            String[] ivArray = iv.split(",");
            this.ivbytes = new byte[ivArray.length];
            int i = 0;

            for(int len = ivArray.length; i < len; ++i) {
               this.ivbytes[i] = Byte.valueOf(ivArray[i].trim());
            }
         }

      }

      public String getTid() {
         return this.id;
      }

      public String getAccesskey() {
         return this.accesskey;
      }

      public String getSecretkey() {
         return this.secretkey;
      }

      public String getIv() {
         return this.iv;
      }

      public String getProtocol() {
         return this.protocol;
      }

      public String getHost() {
         return this.host;
      }

      public Integer getPort() {
         return this.port;
      }

      public byte[] getIvbytes() {
         return this.ivbytes;
      }

      public static synchronized void init(String id, String accesskey, String secretkey, String iv, String protocol, String host, Integer port) {
         if (!initFlag) {
            instance = new Credential(id, accesskey, secretkey, iv, protocol, host, port);
            initFlag = true;
         }
      }

      public static Credential getInstance() {
         return instance;
      }
   }

   public static class MasterKey {
      private String keyid;
      private String keyspec;
      private String keyusage;
      private String origin;
      private String protectionlevel;
      private static MasterKey instance = null;
      private static boolean initFlag = false;

      private MasterKey(String keyid, String keyspec, String keyusage, String origin, String protectionlevel) {
         this.keyid = keyid;
         this.keyspec = keyspec;
         this.keyusage = keyusage;
         this.origin = origin;
         this.protectionlevel = protectionlevel;
      }

      public String getKeyid() {
         return this.keyid;
      }

      public String getKeyspec() {
         return this.keyspec;
      }

      public String getKeyusage() {
         return this.keyusage;
      }

      public String getOrigin() {
         return this.origin;
      }

      public String getProtectionlevel() {
         return this.protectionlevel;
      }

      public static synchronized void init(String keyid, String keyspec, String keyusage, String origin, String protectionlevel) {
         if (!initFlag) {
            instance = new MasterKey(keyid, keyspec, keyusage, origin, protectionlevel);
            initFlag = true;
         }
      }

      public static MasterKey getInstance() {
         return instance;
      }
   }
}
