package com.chenyang.nse.bussiness.mybatis.mapper;

import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceDashBoardSqlAvgBO;
import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceMonitorBase;
import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceMonitorProcess;
import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceMonitorRecord;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface PerformanceMonitorMapper {
   void savePerformanceBase(PerformanceMonitorBase base);

   void savePerformanceProcesses(List<PerformanceMonitorProcess> process);

   List<PerformanceMonitorRecord> getRecordsByPage(@Param("start") int start, @Param("end") int end, @Param("appName") String appName, @Param("sql") String sql, @Param("proxyName") String proxyName, @Param("datasystemName") String datasystemName, @Param("appUser") String appUser, @Param("dbUser") String dbUser, @Param("startTime") String startTime, @Param("endTime") String endTime);

   List<PerformanceMonitorBase> getRecordsForDashBoard(@Param("appName") String appName, @Param("appUser") String appUser, @Param("startTime") String startTime, @Param("endTime") String endTime);

   Integer getTotal(@Param("start") int start, @Param("end") int end, @Param("appName") String appName, @Param("sql") String sql, @Param("proxyName") String proxyName, @Param("datasystemName") String datasystemName, @Param("appUser") String appUser, @Param("dbUser") String dbUser, @Param("startTime") String startTime, @Param("endTime") String endTime);

   List<String> getAppNameQueryParams();

   List<String> getDBProxyNameQueryParams();

   List<String> getDatasystemNameQueryParams();

   List<PerformanceDashBoardSqlAvgBO> getAvgTimeBySql(@Param("appUser") String appUser, @Param("appName") String appName, @Param("startTime") String startTime, @Param("endTime") String endTime);
}
