package com.chenyang.nse.bussiness.odbc;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetector.Level;

public class Service {
   public static void start(int port) {
      EventLoopGroup bossGroup = new NioEventLoopGroup();
      EventLoopGroup workerGroup = new NioEventLoopGroup();

      try {
         ServerBootstrap b = new ServerBootstrap();
         ((ServerBootstrap)b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).childHandler(new Handler()).childOption(ChannelOption.AUTO_READ, true);
         ResourceLeakDetector.setLevel(Level.ADVANCED);
         ChannelFuture future = b.bind(port).sync();
         Channel serverChannel = future.channel();
         serverChannel.closeFuture().sync();
      } catch (InterruptedException e) {
         e.printStackTrace();
      } finally {
         bossGroup.shutdownGracefully();
         workerGroup.shutdownGracefully();
      }

   }
}
