package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.base.TBaseMenuDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleLogDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseMenu;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.vo.encyption.TConsoleLogVo;
import com.chenyang.nse.bussiness.service.console.OperLogService;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.encryption.SM3Utils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class OperLogServiceImpl implements OperLogService {
   @Autowired
   TConsoleLogDao tConsoleLogDao;
   @Autowired
   private TBaseMenuDao menuDao;

   public List<TConsoleLogVo> queryRow(PageInfo pageInfo, String user, String range, String module) {
      Criterion userCon = null;
      SimpleExpression var15;
      if (user != null && !"".equals(user)) {
         var15 = Restrictions.eq("operationUser", user);
      } else {
         var15 = Restrictions.like("operationUser", "%%");
      }

      Criterion moduleCon;
      if (module != null && !"".equals(module)) {
         List<TBaseMenu> menuList = this.menuDao.queryMenus();
         String[] menuIds = module.split("-");
         String moduleMenuName = null;

         for(String menuId : menuIds) {
            List<TBaseMenu> menus = (List)menuList.stream().filter((item) -> item.getId().equals(menuId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(menus)) {
               moduleMenuName = module;
               break;
            }

            if (moduleMenuName == null) {
               moduleMenuName = ((TBaseMenu)menus.get(0)).getMenuname();
            } else {
               moduleMenuName = moduleMenuName + "-" + ((TBaseMenu)menus.get(0)).getMenuname();
            }
         }

         moduleCon = Restrictions.eq("module", moduleMenuName);
      } else {
         moduleCon = Restrictions.like("module", "%%");
      }

      Date today = new Date();
      List<TConsoleLog> logList;
      if (range != null && !"".equals(range)) {
         if (!"0".equals(range)) {
            if (!"全部".equals(range)) {
               Criterion timeCon = Restrictions.between("operationtime", DateTimeTool.beforeDays(today, Integer.valueOf(range)), today);
               logList = this.tConsoleLogDao.queryByPageInfo(pageInfo, Order.desc("operationtime"), new Criterion[]{var15, timeCon, moduleCon});
            } else {
               logList = this.tConsoleLogDao.queryByPageInfo(pageInfo, Order.desc("operationtime"), new Criterion[]{var15, moduleCon});
            }
         } else {
            Criterion timeCon = Restrictions.ge("operationtime", DateTimeTool.dayOfStart(today));
            logList = this.tConsoleLogDao.queryByPageInfo(pageInfo, Order.desc("operationtime"), new Criterion[]{var15, timeCon, moduleCon});
         }
      } else {
         logList = this.tConsoleLogDao.queryByPageInfo(pageInfo, Order.desc("operationtime"), new Criterion[]{var15, moduleCon});
      }

      List<TConsoleLogVo> list = new ArrayList();
      if (!ObjectUtils.isEmpty(logList)) {
         logList.forEach((item) -> {
            TConsoleLogVo tConsolelogVo = new TConsoleLogVo();
            BeanUtils.copyProperties(item, tConsolelogVo);
            tConsolelogVo.setCode(item.getOperationObject());
            tConsolelogVo.setUser(item.getOperationUser());
            list.add(tConsolelogVo);
         });
      }

      return list;
   }

   public List<Map<String, Object>> queryList(String user, String range, String module) {
      Criterion userCon = null;
      SimpleExpression var14;
      if (user != null && !"".equals(user)) {
         var14 = Restrictions.eq("operationUser", user);
      } else {
         var14 = Restrictions.like("operationUser", "%%");
      }

      Criterion moduleCon;
      if (module != null && !"".equals(module)) {
         List<TBaseMenu> menuList = this.menuDao.queryMenus();
         String[] menuIds = module.split("-");
         String moduleMenuName = null;

         for(String menuId : menuIds) {
            List<TBaseMenu> menus = (List)menuList.stream().filter((item) -> item.getId().equals(menuId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(menus)) {
               moduleMenuName = module;
               break;
            }

            if (moduleMenuName == null) {
               moduleMenuName = ((TBaseMenu)menus.get(0)).getMenuname();
            } else {
               moduleMenuName = moduleMenuName + "-" + ((TBaseMenu)menus.get(0)).getMenuname();
            }
         }

         moduleCon = Restrictions.eq("module", moduleMenuName);
      } else {
         moduleCon = Restrictions.like("module", "%%");
      }

      Date today = new Date();
      List<TConsoleLog> logList;
      if (range != null && !"".equals(range)) {
         if (!"0".equals(range)) {
            if (!"全部".equals(range)) {
               Criterion timeCon = Restrictions.between("operationtime", DateTimeTool.beforeDays(today, Integer.valueOf(range)), today);
               logList = this.tConsoleLogDao.queryAll(Order.desc("operationtime"), new Criterion[]{var14, timeCon, moduleCon});
            } else {
               logList = this.tConsoleLogDao.queryAll(Order.desc("operationtime"), new Criterion[]{var14, moduleCon});
            }
         } else {
            Criterion timeCon = Restrictions.ge("operationtime", DateTimeTool.dayOfStart(today));
            logList = this.tConsoleLogDao.queryAll(Order.desc("operationtime"), new Criterion[]{var14, timeCon, moduleCon});
         }
      } else {
         logList = this.tConsoleLogDao.queryAll(Order.desc("operationtime"), new Criterion[]{var14, moduleCon});
      }

      List<Map<String, Object>> mapList = new ArrayList();

      for(TConsoleLog tConsoleLog : logList) {
         Map<String, Object> resultMap = new HashMap();
         resultMap.put("用户", tConsoleLog.getOperationUser());
         resultMap.put("时间", tConsoleLog.getOperationtime());
         resultMap.put("操作代码", tConsoleLog.getOperationObject());
         resultMap.put("操作模块", tConsoleLog.getModule());
         resultMap.put("操作信息", tConsoleLog.getLogmessage());
         mapList.add(resultMap);
      }

      return mapList;
   }

   public boolean checkEnc(String user, String range, String module) {
      Criterion userCon = null;
      SimpleExpression var16;
      if (user != null && !"".equals(user)) {
         var16 = Restrictions.eq("operationUser", user);
      } else {
         var16 = Restrictions.like("operationUser", "%%");
      }

      Criterion moduleCon;
      if (module != null && !"".equals(module)) {
         List<TBaseMenu> menuList = this.menuDao.queryMenus();
         String[] menuIds = module.split("-");
         String moduleMenuName = null;

         for(String menuId : menuIds) {
            List<TBaseMenu> menus = (List)menuList.stream().filter((item) -> item.getId().equals(menuId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(menus)) {
               moduleMenuName = module;
               break;
            }

            if (moduleMenuName == null) {
               moduleMenuName = ((TBaseMenu)menus.get(0)).getMenuname();
            } else {
               moduleMenuName = moduleMenuName + "-" + ((TBaseMenu)menus.get(0)).getMenuname();
            }
         }

         moduleCon = Restrictions.eq("module", moduleMenuName);
      } else {
         moduleCon = Restrictions.like("module", "%%");
      }

      Date today = new Date();
      List<TConsoleLog> logList;
      if (range != null && !"".equals(range)) {
         if (!"0".equals(range)) {
            if (!"全部".equals(range)) {
               Criterion timeCon = Restrictions.between("operationtime", DateTimeTool.beforeDays(today, Integer.valueOf(range)), today);
               logList = this.tConsoleLogDao.queryAll(Order.desc("operationtime"), new Criterion[]{var16, timeCon, moduleCon});
            } else {
               logList = this.tConsoleLogDao.queryAll(Order.desc("operationtime"), new Criterion[]{var16, moduleCon});
            }
         } else {
            Criterion timeCon = Restrictions.ge("operationtime", DateTimeTool.dayOfStart(today));
            logList = this.tConsoleLogDao.queryAll(Order.desc("operationtime"), new Criterion[]{var16, timeCon, moduleCon});
         }
      } else {
         logList = this.tConsoleLogDao.queryAll(Order.desc("operationtime"), new Criterion[]{var16, moduleCon});
      }

      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

      for(TConsoleLog operlog : logList) {
         Date date = operlog.getOperationtime();
         String dateString = sdf.format(date);

         try {
            if (!SM3Utils.encrypt(operlog.getOperationUser() + dateString + operlog.getLogmessage()).equals(operlog.getColumn_enc())) {
               return false;
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return true;
   }
}
