package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivegroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiverelation;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivesearchlog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivetablelog;
import com.chenyang.nse.bussiness.entity.vo.Releasecolumn;
import com.chenyang.nse.bussiness.entity.vo.SenstiveColumnRelationVO;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface SensitiveColumnService {
   List<TCoreSensitivecolumn> queryAllSensitiveColumns();

   List<TCoreSensitivecolumn> queryAllSensitiveColumns(String groupid, String time);

   void remove(String sensitivecolumnid);

   void save(String groupId, String datasystemid, String schema, String tableName, List<TCoreSensitivecolumn> newRecords, Map<String, TCoreSensitivecolumn> newRecordMap);

   List<TCoreSensitivecolumn> queryValidSensitiveColumns();

   List<TCoreSensitivecolumn> queryValidSensitiveColumns(PageInfo pageInfo);

   List<TCoreSensitivecolumn> queryAllSensitiveColumns(PageInfo pageInfo);

   void saveChecked(List<TCoreSensitivecolumn> newRecords);

   List<TCoreSensitivecolumn> queryCheckedSensitiveColumns(String groupId);

   TCoreSensitivecolumn querySensitiveColumn(String groupId, String dataSourceId, String schema, String tableName, String columnName);

   List<SenstiveColumnRelationVO> querySensitiveColumns(String groupId, String sensitiveColumnId, String regexType);

   Boolean saveSensitiveRelation(String sourceColumnId, List<String> targetColumnIds, List<String> deletedColumnIds);

   List<TCoreSensitiverelation> querySensitiveColumnRelations(String groupId);

   List<TCoreSensitivegroup> querySensitiveGroup();

   String saveSensitiveGroup(String groupName);

   List<TCoreSensitivegroup> querySensitiveGroup(String dataSourceId, List<String> schemas);

   List<TCoreSensitivegroup> querySensitiveGroup(String dataSourceId);

   List<TCoreSensitivecolumn> querySensitiveColumnsByGroupId(String groupId);

   List<TCoreSensitivecolumn> querySensitiveColumnsByGroupIdNew(String groupId);

   List<TCoreSensitivecolumn> querySensitiveColumnsByGroupId(String groupId, Date createtime);

   List<TCoreSensitivecolumn> querySensitiveColumnsByGroupIdByTime(String groupId, Date createtime);

   void saveSensitiveParamter(List<TCoreSensitivesearchlog> tcoreSensitivesearchlog, String groupId);

   List<TCoreSensitivesearchlog> querySensitivesearchlogByGroupId(String groupId);

   Date getMaxDate(String tablename, String schema, String rowname);

   int updateflag(String groupid);

   List<TCoreSensitivegroup> queryAllSensitiveGroupPage(PageInfo pageInfo);

   List<TCoreSensitivecolumn> queryAllSensitiveTimeByGroupid(String groupId);

   int removeSensitivecolumn(String groupid);

   int removeSensitivecolumn(String groupid, String time);

   List<TCoreSensitivecolumn> getSensitiveByIdBySchema(String datasystemid, String schema);

   List<TCoreSensitivecolumn> getSensitiveByStructureId(String datasystemid);

   List<TCoreSensitivecolumn> getSensitiveByIdBySchema(String datasystemid, String schema, String table);

   List<TCoreSensitivegroup> queryAllSensitiveGroup();

   List<TCoreSensitivecolumn> querySensitiveColumnsByGroupIdByTable(String groupId, String table);

   void savealltable(String groupId, String datasystemid, String schema, String tableName, List<TCoreSensitivetablelog> newRecords);

   void delTCoreSensitivetablelog(String groupId);

   List<TCoreSensitivetablelog> queryTCoreSensitivetablelog(String groupid, String state);

   void updSensitiveGroupByID(String groupId, String groupName);

   String getGroupNameByID(String groupId);

   List<Releasecolumn> queryTcoreReleasecolumn(List<String> schemas, String projectid, String table);

   void deleReleasecolumnByProductId(String productid, String table);

   void saveReleasecolumn(StringBuilder sql);

   void removeReleasecolumn(List<Releasecolumn> removeReleasecolumn, String table);
}
