package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserproject;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasourceSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectAllrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectDatasource;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFindrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreWatermarkKeyInfo;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataProjectVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.DatasystemProjectdatasourceVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataProjectVO;
import java.util.List;
import java.util.Map;

public interface TdataProjectService {
   List<TCoreMaskingRuleinfo> selectDataAreaMaskingRules(TCoreProjectFindrule obj, String searchstr);

   List<DatasystemProjectdatasourceVO> queryDatasourceByProjectId(String projectid);

   List<DatasystemProjectdatasourceVO> queryDataSystemByProjectIdAndDataSystemId(String projectid, String datasystemid);

   List<DatasystemProjectdatasourceVO> queryDatasourceById(String projectid);

   List<DatasystemProjectdatasourceVO> queryDatasystemByProId(String projectid);

   void saveDataProject(TCoreDataProject obj);

   Map<String, String> deleteDataProject(String id);

   void deleteRelationdata(String id);

   List<TCoreDataProject> selectDataProject(String proName, String note);

   List<TCoreDataProject> selectDataProject();

   List<TCoreDataProject> selectMyDataProject(String userid, String proName, String note);

   TCoreDataProject selectOneDataProject(String id);

   void saveProDataSource(TCoreProjectDatasource obj);

   boolean deleteProDataSource(TCoreProjectDatasource obj);

   TCoreDatasystem selectOneProDataSource(String id);

   List<ComboboxVO> selectProDataSource(String systemstyle);

   List<TCoreDatasystem> selectCheckProDataSource(String projectid, String systemstyle, String searchval);

   void saveDataArea(TCoreProjectFindrule obj);

   void deleteDataArea(TCoreProjectFindrule obj);

   List<TCoreDataArea> selectDataArea();

   List<TCoreDataArea> selectDataAreaHasFindRule();

   List<Map<String, Object>> selectCheckDataArea(String project_id);

   void editDataProject(TCoreDataProject obj);

   List<ComboboxVO> selectProDataSourceDet(String string, String dbtype);

   List<TCoreProjectAllrule> selectDataAreaFindRule(TCoreProjectFindrule obj);

   List<TConsoleSearchregex> selectDataAreaFindRule(String dataAreaId);

   void defaultRow(String id, String project_id, String dataarea_id, String rulestyle);

   void resetDefault(String id);

   List<Map<String, Object>> selectDataAreaHas(String id);

   void deleteTable(String project_id, String dataarea_id);

   List<Map<String, Object>> selectSource(String id, String userid);

   List<Map<String, Object>> selectArea(String id);

   List<Map<String, Object>> querySensitiveRuleList(String projectid);

   List<ComboboxVO> selectProDataSource1(String systemstyle);

   List<ComboboxVO> selectProDataSourceDet1(String string, String dbtype, String versionname);

   List<Map<String, Object>> querySensitiveRuleList();

   List<Map<String, Object>> queryDbSensitiveRuleList(String dataSystemId);

   List<TCoreProjectAllrule> selectDataAreaMaskingRule(TCoreProjectFindrule obj, String searchstr);

   List<TCoreMaskingRule> queryMaskingRule(String projectid);

   List<ComboboxVO> queryProjectList(String projectids);

   List<Map<String, Object>> selectFind(String id);

   List<Map<String, Object>> selectMasking(String id);

   List<Map<String, Object>> selectCodatabaseDataCount(String id);

   void saveAllFind(String project_id, String dataarea_id, String defaultid);

   void saveAllMasking(String project_id, String dataarea_id, String defaultid, String rulestyle);

   void deleteAllDataArea(String project_id, String dataarea_id);

   void saveAll(String project_id);

   void deleteAll(String project_id);

   String isAll(String project_id);

   String changeDefault(TCoreProjectFindrule obj);

   List<DatasystemProjectdatasourceVO> queryByEditSort(String flag, String dbtype, String projectid, String userid);

   List<DatasystemProjectdatasourceVO> queryByEditSort(String dbtype, String flag, String userid);

   void saveAllProDataSource(String dbtype, String flag, String projectid, String userid);

   void deleteAllProDataSource(String dbtype, String flag, String projectid, String userid);

   String isChooseAll(String dbtype, String flag, String projectid, String searchval, String userid);

   List<Map<String, Object>> selectdispatch(String id);

   List<Map<String, Object>> selectMonitorCount(String id);

   List<TBaseUserproject> queryuserprobyuserid(String userid);

   List<TBaseUserproject> queryuserprobyuseridproid(String userid, String proid);

   List<DataProjectVO> queryDataprojectCrudByUserid(List<String> userid);

   List<Map<String, Object>> selectDataAreaHasEM();

   List<Map<String, Object>> selectDataScopeCount(String id, String edition_id);

   List<Map<String, Object>> selectSensitiveLevelCount(String id, String edition_id);

   List<Map<String, Object>> selectComplianceDirCount(String id);

   default List<Map<String, Object>> selectComplianceDirCount1() {
      return this.selectComplianceDirCount1();
   }

   List<Map<String, Object>> selectComplianceDirCount1(String edition_id);

   List<Map<String, Object>> selectImgTaskCount(String id);

   List<TCoreWatermarkKeyInfo> selectWatermarkKey();

   List<Map<String, Object>> selectSelfMonitorCount(String id);

   List<ComboboxVO> queryTaskList(String taskids, String projectid);

   void addDataProject(TCoreDataProject projectObj, List<TCoreProjectDatasource> dataSourceList, List<TCoreProjectFindrule> areaAndRuleList, List<TCoreDatasourceSchema> schemalist);

   TCoreDataProjectVO getDataProjectDetail(String projectId);

   void updateDataProject(TCoreDataProjectVO vo);

   String queryEdtionIdByProId(String projectid);

   List<Map<String, Object>> selectFindRuleById(String projectid);

   boolean checkDatasystemName(String name, String projectId);
}
