package com.chenyang.nse.bussiness.service.core.dataproject.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.TCoreFieldSensitiveMemoryDao;
import com.chenyang.nse.bussiness.dao.table.core.TcoreDiscoveryConditionDao;
import com.chenyang.nse.bussiness.dao.table.core.TcoreDiscoverySensitivecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.TcoreDiscoverySensitivecolumnExportDao;
import com.chenyang.nse.bussiness.dao.table.core.TcoreDiscoveryVersrionDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDiscoverytaskDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectFileDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreTaskFindruleDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TcoreDiscoveryColumnDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TcoreDiscoveryDataResultDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryColumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumnExport;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.vo.DiscoveryMonitorVO;
import com.chenyang.nse.bussiness.entity.vo.DiscoverytaskVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDiscoveryTaskVO;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DiscoverytaskServiceImpl implements DiscoverytaskService {
   @Autowired
   private TCoreDiscoverytaskDao tCoreDiscoverytaskDao;
   @Autowired
   private TcoreDiscoverySensitivecolumnExportDao tcoreDiscoverySensitivecolumnExportDao;
   @Autowired
   private TCoreFieldSensitiveMemoryDao tCoreFieldSensitiveMemoryDao;
   @Autowired
   private TcoreDiscoveryVersrionDao tcoreDiscoveryVersrionDao;
   @Autowired
   private TcoreDiscoveryConditionDao tcoreDiscoveryConditionDao;
   @Autowired
   private TcoreDiscoverySensitivecolumnDao tcoreDiscoverySensitivecolumnDao;
   @Autowired
   private TCoreTaskFindruleDao tCoreTaskFindruleDao;
   @Autowired
   private TcoreDiscoveryColumnDao tcoreDiscoveryColumnDao;
   @Autowired
   private TcoreDiscoveryDataResultDao tcoreDiscoveryDataResultDao;
   @Autowired
   private TCoreProjectFileDao tCoreProjectFileDao;

   public List<DiscoverytaskVO> queryDiscoverytaskVO(PageInfo pageInfo, HashMap<String, String> map) {
      List<DiscoverytaskVO> list = this.tCoreDiscoverytaskDao.queryAllDiscoverytask(pageInfo, map);
      return list;
   }

   public void updateisrelease(String id) {
      new TcoreDiscoveryTask();
      TcoreDiscoveryTask t = (TcoreDiscoveryTask)this.tCoreDiscoverytaskDao.get(id);
      t.setIsrelease("1");
      this.tCoreDiscoverytaskDao.update(t);
   }

   public void deleteDiscoverytask(String id, String resultid) {
      this.tCoreDiscoverytaskDao.removeById(id);
      this.tCoreTaskFindruleDao.remove(new Criterion[]{Restrictions.eq("taskid", id)});
      this.tcoreDiscoveryColumnDao.remove(new Criterion[]{Restrictions.eq("taskid", id)});
      this.tCoreProjectFileDao.remove(new Criterion[]{Restrictions.eq("taskid", id)});
      StringBuilder sqlstr = new StringBuilder("DROP TABLE " + resultid);
      this.tCoreDiscoverytaskDao.createsqlstr(sqlstr);
      this.tcoreDiscoveryDataResultDao.remove(new Criterion[]{Restrictions.eq("taskid", id)});
   }

   public List<TcoreDiscoverySensitivecolumnExport> queryTcoreDiscoverySensitivecolumnExport(String groupid) {
      new ArrayList();
      List<TcoreDiscoverySensitivecolumnExport> tcoreDiscoverySensitivecolumnExport = this.tcoreDiscoverySensitivecolumnExportDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupid), Restrictions.eq("flag", "0")});
      return tcoreDiscoverySensitivecolumnExport;
   }

   public TcoreDiscoveryTask get(String taskid) {
      return (TcoreDiscoveryTask)this.tCoreDiscoverytaskDao.get(taskid);
   }

   public void save(TcoreDiscoveryTask discoverytask) {
      this.tCoreDiscoverytaskDao.save(discoverytask);
   }

   public String updatetask(String groupId, String groupName) {
      new TcoreDiscoveryTask();
      TcoreDiscoveryTask task = (TcoreDiscoveryTask)this.tCoreDiscoverytaskDao.get(groupId);
      task.setUpdatetime(new Date());
      task.setCurversion(String.valueOf(Integer.valueOf(task.getCurversion()) + 1));
      this.tCoreDiscoverytaskDao.save(task);
      return task.getCurversion();
   }

   public String savediscoverytask(String groupName) {
      TcoreDiscoveryTask task = new TcoreDiscoveryTask();
      task.setCreatetime(new Date());
      task.setCurversion("1");
      task.setIsrelease("0");
      task.setTname(groupName);
      task.setUpdatetime(new Date());
      this.tCoreDiscoverytaskDao.save(task);
      return task.getId();
   }

   public String isTaskNameExistsCheck(String groupName) {
      String existFlg = "0";
      List<TcoreDiscoveryTask> discoveryTaskList = this.tCoreDiscoverytaskDao.queryAll(new Criterion[]{Restrictions.eq("tname", groupName), Restrictions.ne("deleteflg", "1")});
      if (null != discoveryTaskList && discoveryTaskList.size() > 0) {
         existFlg = "1";
      }

      return existFlg;
   }

   public void saveExcel(TcoreDiscoverySensitivecolumnExport tcoreDiscoverySensitivecolumnExport) {
      this.tcoreDiscoverySensitivecolumnExportDao.save(tcoreDiscoverySensitivecolumnExport);
   }

   public int deleteDiscoverytaskByGroupid(String groupid) {
      return this.tcoreDiscoverySensitivecolumnExportDao.deleteDiscoverytaskByGroupid(groupid);
   }

   public void saveTCoreFieldSensitiveMemory(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory) {
      this.tCoreFieldSensitiveMemoryDao.saveOrUpdate(tCoreFieldSensitiveMemory);
   }

   public List<TCoreFieldSensitiveMemory> queryTCoreFieldSensitiveMemory(String table, String tschema) {
      new ArrayList();
      List<TCoreFieldSensitiveMemory> tCoreFieldSensitiveMemorylist = this.tCoreFieldSensitiveMemoryDao.queryAll(new Criterion[]{Restrictions.eq("tablename", table), Restrictions.eq("tschema", tschema)});
      return tCoreFieldSensitiveMemorylist;
   }

   public List<TcoreDiscoveryTask> queryDiscoverytasklist(PageInfo pageInfo) {
      List<TcoreDiscoveryTask> list = this.tCoreDiscoverytaskDao.queryByPageInfo(pageInfo, Order.desc("updatetime"));
      return list;
   }

   public List<TcoreDiscoveryTask> querytasklistById(String dataSystemId) {
      List<TcoreDiscoveryTask> list = this.tCoreDiscoverytaskDao.queryAll(Order.desc("updatetime"), new Criterion[]{Restrictions.eq("datasystemid", dataSystemId)});
      return list;
   }

   public List<DiscoverytaskVO> discoveryTaskList(String datasourceid) {
      List<DiscoverytaskVO> list = this.tCoreDiscoverytaskDao.discoveryTaskList(datasourceid);
      return list;
   }

   public List<TcoreDiscoverySensitivecolumn> discoveryDataAreaList(String findtaskId) {
      List<TcoreDiscoverySensitivecolumn> list = this.tcoreDiscoverySensitivecolumnDao.discoveryDataAreaList(findtaskId);
      return list;
   }

   public long queryTableCount(String projectid, String taskid) {
      return this.tcoreDiscoveryColumnDao.count(new Criterion[]{Restrictions.eq("projectid", projectid), Restrictions.eq("taskid", taskid)});
   }

   public List<DiscoveryMonitorVO> queryDiscoveryTaskForMonitor(String projectid) {
      return this.tCoreDiscoverytaskDao.selectTaskByProjectid(projectid);
   }

   public List<TCoreDiscoveryTaskVO> queryDiscoveryTaskDetailforDB(String taskid) {
      return this.tCoreDiscoverytaskDao.selectDiscoveryTaskforDB(taskid);
   }

   public List<TCoreDiscoveryTaskVO> queryDiscoveryTaskDetailforTxt(String taskid) {
      return this.tCoreDiscoverytaskDao.selectDiscoveryTaskforTxt(taskid);
   }

   public List<TCoreDiscoveryTaskVO> queryDiscoveryTaskDetailforDmp(String taskid) {
      List<TCoreDiscoveryTaskVO> list = new ArrayList();
      new TCoreDiscoveryTaskVO();
      TCoreDiscoveryTaskVO tCoreDiscoveryTaskVO = (TCoreDiscoveryTaskVO)this.tCoreDiscoverytaskDao.selectDiscoveryTaskforDmp(taskid).get(0);
      String tables = tCoreDiscoveryTaskVO.getDmptables();
      BigInteger bigInteger = BigInteger.valueOf((long)tables.split(",").length);
      tCoreDiscoveryTaskVO.setTableCount(bigInteger);
      list.add(tCoreDiscoveryTaskVO);
      return list;
   }

   public List<TcoreDiscoveryTask> queryDiscoverytasklist(PageInfo pageInfo, String projectid, String taskname) {
      Criterion criterion2 = Restrictions.like("tname", taskname, MatchMode.ANYWHERE).ignoreCase();
      List<TcoreDiscoveryTask> list = this.tCoreDiscoverytaskDao.queryByPageInfo(pageInfo, Order.desc("updatetime"), new Criterion[]{Restrictions.eq("projectid", projectid), criterion2});
      return list;
   }

   public TcoreDiscoveryColumn queryTaskAndProjectBySchemaName(String datasystemid, String schema) {
      List<TcoreDiscoveryColumn> tcoreDiscoveryColumns = this.tcoreDiscoveryColumnDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("datasourceid", datasystemid), Restrictions.eq("tschema", schema)});
      return CollectionUtil.isNotEmpty(tcoreDiscoveryColumns) ? (TcoreDiscoveryColumn)tcoreDiscoveryColumns.get(0) : null;
   }
}
