package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.TCoreDatadisDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatadis;
import com.chenyang.nse.bussiness.service.core.DataDisService;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataDisServiceImpl implements DataDisService {
   @Autowired
   private TCoreDatadisDao tCoreDatadisDao;

   public List<TCoreDatadis> queryDistByType(String dicttype) {
      if (StringUtils.isBlank(dicttype)) {
         dicttype = "notexist";
      }

      Conjunction conjunction = Restrictions.conjunction();
      conjunction.add(Restrictions.eq("dicttype", dicttype));
      List<TCoreDatadis> list = this.tCoreDatadisDao.queryAll(Order.desc("createtime"), new Criterion[]{conjunction});
      return list;
   }
}
