package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.ImportMaskingExecuteDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationMonitorDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtaskDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LoginWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LogoutWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionLogWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionStatisticsWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionTimeWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetWorkflowLogWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBean;
import com.chenyang.nse.bussiness.entity.orm.table.core.ImportMaskingExecute;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitor;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.DesensitizationtaskSerialService;
import com.chenyang.nse.bussiness.service.core.DesensitizationtaskService;
import com.chenyang.nse.bussiness.service.core.DmpDesensitizationMonitorService;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;

@Service
@Transactional
public class DmpDesensitizationMonitorServiceImpl implements DmpDesensitizationMonitorService {
   private static Properties props = new Properties();
   @Autowired
   private DesensitizationtaskService desensitizationtaskService;
   @Autowired
   private DesensitizationtaskSerialService desensitizationtaskSerialService;
   @Autowired
   private DesensitizationMonitorDao desensitizationMonitorDao;
   @Autowired
   private DesensitizationtaskDao desensitizationtaskDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private ImportMaskingExecuteDao importMaskingExecuteDao;

   public List queryTaskVersionList(String taskId) {
      List list = this.desensitizationMonitorDao.queryGroup(Order.desc("groupid"), "groupid", new Criterion[]{Restrictions.eq("taskid", taskId)});
      return list;
   }

   public List<DesensitizationMonitor> queryTaskMonitor(String taskid, String groupid, PageInfo pageInfo, int indexrow) {
      Desensitizationtask task = (Desensitizationtask)this.desensitizationtaskDao.get(taskid);
      String realName = task.getTasknamereal();
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(props.getProperty("engineid"));
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<DesensitizationMonitor> list = this.desensitizationMonitorDao.queryByPageInfo1(pageInfo, Order.desc("groupid"), Order.asc("note"), new Criterion[]{Restrictions.eq("groupid", Long.parseLong(groupid))});
      List<DesensitizationMonitor> rtnList = new ArrayList();
      if (indexrow == 0) {
         try {
            String sessionID = LoginWebService.returnStatus(info);

            for(DesensitizationMonitor desensitizationMonitor : list) {
               if (desensitizationMonitor.getRunstatus() == 1) {
                  String status = MultiGetSessionStatisticsWebService.returnStatusOnly(sessionID, info, "wf_" + realName + "_" + desensitizationMonitor.getSourcename(), "mp_" + realName + "_" + desensitizationMonitor.getSourcename(), task.getFoldername());
                  if ("SUCCEEDED".equals(status)) {
                     desensitizationMonitor.setFlag("1");
                  } else if ("FAILED".equals(status)) {
                     desensitizationMonitor.setFlag("2");
                  } else if ("STOPPED".equals(status)) {
                     desensitizationMonitor.setFlag("3");
                  } else {
                     desensitizationMonitor.setFlag("4");
                  }
               }

               rtnList.add(desensitizationMonitor);
            }

            LogoutWebService.returnStatus(sessionID, info);
         } catch (Exception e) {
            e.printStackTrace();
            return list;
         }
      } else {
         rtnList = list;
      }

      return rtnList;
   }

   public List<DesensitizationMonitor> queryImportTaskMonitor(String taskid, String groupid, PageInfo pageInfo, int indexrow) {
      ImportMaskingExecute task = (ImportMaskingExecute)this.importMaskingExecuteDao.get(taskid);
      String realName = task.getTaskname();
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(props.getProperty("engineid"));
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<DesensitizationMonitor> list = this.desensitizationMonitorDao.queryByPageInfo1(pageInfo, Order.desc("groupid"), Order.asc("note"), new Criterion[]{Restrictions.eq("groupid", Long.parseLong(groupid))});
      List<DesensitizationMonitor> rtnList = new ArrayList();
      if (indexrow == 0) {
         try {
            String sessionID = LoginWebService.returnStatus(info);

            for(DesensitizationMonitor desensitizationMonitor : list) {
               if (desensitizationMonitor.getRunstatus() == 1) {
                  String status = MultiGetSessionStatisticsWebService.returnStatusOnly(sessionID, info, realName, realName.replace("wf_", "mp_"), task.getFoldername());
                  if ("SUCCEEDED".equals(status)) {
                     desensitizationMonitor.setFlag("1");
                  } else if ("FAILED".equals(status)) {
                     desensitizationMonitor.setFlag("2");
                  } else if ("STOPPED".equals(status)) {
                     desensitizationMonitor.setFlag("3");
                  } else {
                     desensitizationMonitor.setFlag("4");
                  }
               }

               rtnList.add(desensitizationMonitor);
            }

            LogoutWebService.returnStatus(sessionID, info);
         } catch (Exception e) {
            e.printStackTrace();
            return list;
         }
      } else {
         rtnList = list;
      }

      return rtnList;
   }

   public DesensitizationMonitor getMonitorById(String id) {
      return (DesensitizationMonitor)this.desensitizationMonitorDao.get(id);
   }

   public SessionBean getLogForTaskMapping(String folderName, InfoProperty engine, String name, Jedis jedis) throws Exception {
      SessionBean se = new SessionBean();
      String sessionID = "";

      try {
         sessionID = LoginWebService.returnStatus(engine);
         String schemaName = name.substring(0, name.lastIndexOf("-"));
         String tableName = name.substring(name.lastIndexOf("-") + 1, name.length());
         name = schemaName + "_" + tableName;
         String dataCountStr = jedis.get("dataCount:" + name);
         if ("".equals(dataCountStr) || dataCountStr == null) {
            dataCountStr = "0";
         }

         long dataCount = Long.parseLong(dataCountStr);
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, folderName, dataCount);
         SessionBean sb1 = MultiGetSessionTimeWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, folderName);
         se.setStart_time(sb1.getStart_time());
         se.setEnd_time(sb1.getEnd_time());
         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception e) {
         se.setStatus("SUCCEED");
         LogoutWebService.returnStatus(sessionID, engine);
         e.printStackTrace();
      }

      return se;
   }

   public SessionBean getLogForMappingByInstantFile(String folderName, InfoProperty engine, String name, Long countdata) throws Exception {
      SessionBean se = new SessionBean();
      String sessionID = "";

      try {
         sessionID = LoginWebService.returnStatus(engine);
         if (countdata == null) {
            countdata = new Long(0L);
         }

         long dataCount = countdata;
         se = MultiGetSessionStatisticsWebService.returnStatusByDataCount(sessionID, engine, "wf_" + name, "mp_" + name, folderName, dataCount);
         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception e) {
         se.setStatus("SUCCEED");
         LogoutWebService.returnStatus(sessionID, engine);
         e.printStackTrace();
      }

      return se;
   }

   public List<DesensitizationMonitor> queryDesensitizationMonitorList(String taskid) {
      List<DesensitizationMonitor> list = this.desensitizationMonitorDao.queryAll(Order.desc("groupid"), new Criterion[]{Restrictions.eq("taskid", taskid)});
      return list;
   }

   public void update(DesensitizationMonitor desensitizationMonitor) {
      this.desensitizationMonitorDao.saveOrUpdate(desensitizationMonitor);
   }

   public SessionBean getSessionLog(String folderName, String wfname, InfoProperty engine) {
      SessionBean se = new SessionBean();

      try {
         String sessionID = LoginWebService.returnStatus(engine);
         String selog = MultiGetSessionLogWebService.returnStatus(sessionID, engine, "wf_" + wfname, "mp_" + wfname, folderName);
         se.setSe_log(selog);
         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception e) {
         se.setStatus("SUCCEED");
         e.printStackTrace();
      }

      return se;
   }

   public String stopWorkflow(InfoProperty engine, String name, String folderName) {
      String stopWorkflow = "FAIL";

      try {
         String sessionID = LoginWebService.returnStatus(engine);
         new SessionBean();
         SessionBean se = MultiGetSessionStatisticsWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, folderName);
         stopWorkflow = MultiGetWorkflowLogWebService.stopWorkflow(sessionID, engine, "wf_" + name, folderName, se.getWf_run_id(), "mp_" + name);
         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return stopWorkflow;
   }

   public String recoverWorkflow(InfoProperty engine, String name, String folderName) {
      String recoverWorkflow = "FAIL";

      try {
         String sessionID = LoginWebService.returnStatus(engine);
         new SessionBean();
         SessionBean se = MultiGetSessionStatisticsWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, folderName);
         recoverWorkflow = MultiGetWorkflowLogWebService.recoverWorkflow(engine, folderName, "wf_" + name, se.getWf_run_id(), sessionID);
         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return recoverWorkflow;
   }

   static {
      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

   }
}
